/*
 * Decompiled with CFR 0.152.
 */
package Game.Screen;

import Game.ExtraClass.MapData;
import Game.ExtraClass.Point;
import Game.ExtraClass.SoundPlayer;
import Game.ExtraClass.globalVariable;
import Game.Screen.AbstractScreen;
import Game.Screen.GameScreen;
import Game.Screen.MapAreaScreen;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class LocationSprite
extends Sprite {
    int id;
    Point pReal;
    Point pBackground;
    int width;
    int height;
    AbstractScreen parent;
    MapData mapData;
    long previousTime;

    public LocationSprite(AbstractScreen parent, MapData mapData, Image image, int width, int height) {
        super(image, width, height);
        this.id = mapData.getId();
        this.width = width;
        this.height = height;
        this.mapData = mapData;
        this.pReal = new Point(mapData.getCoordinate());
        this.pBackground = new Point(0, 0);
        this.setRefPixelPosition(this.pReal.x + this.pBackground.x, this.pReal.y + this.pBackground.y);
        this.parent = parent;
    }

    public int getid() {
        return this.id;
    }

    public int getState() {
        return this.mapData.getState();
    }

    public void SetBackgroundPosition(Point p) {
        this.pBackground = p;
        this.setRefPixelPosition(this.pReal.x + this.pBackground.x, this.pReal.y + this.pBackground.y);
    }

    public boolean check(int x, int y) {
        if (this.mapData.getState() == 0) {
            return false;
        }
        return x >= this.getRefPixelX() && x <= this.getRefPixelX() + this.width && y >= this.getRefPixelY() && y <= this.getRefPixelY() + this.height;
    }

    public void update(long time) {
        if (time - this.previousTime >= 100L) {
            this.nextFrame();
            this.previousTime = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer() {
        Thread th;
        LocationSprite locationSprite = this;
        synchronized (locationSprite) {
            th = new Thread(){

                public void run() {
                    if (LocationSprite.this.id >= 100) {
                        GameScreen gameScreen = new GameScreen(LocationSprite.this.id);
                        gameScreen.start(true);
                        globalVariable.screenManager.getScreens().addElement(gameScreen);
                        globalVariable.screenManager.setIndex(globalVariable.screenManager.getScreens().size() - 1);
                        LocationSprite.this.parent.stop(false);
                        if (SoundPlayer.getPlayer()[0].getState() == 400) {
                            SoundPlayer.stopSong(0);
                        }
                    } else {
                        for (int i = 0; i < globalVariable.screenManager.getScreens().size(); ++i) {
                            if (!(globalVariable.screenManager.getScreens().elementAt(i) instanceof MapAreaScreen)) continue;
                            MapAreaScreen mapAreaScreen = (MapAreaScreen)globalVariable.screenManager.getScreens().elementAt(i);
                            if (LocationSprite.this.id != mapAreaScreen.id) continue;
                            mapAreaScreen.start(false);
                            globalVariable.screenManager.setIndex(i);
                            LocationSprite.this.parent.stop(false);
                            return;
                        }
                    }
                }
            };
        }
        th.start();
    }
}

