/*
 * Decompiled with CFR 0.152.
 */
package Game.Screen;

import Game.ExtraClass.ButtonListenner;
import Game.ExtraClass.Point;
import Game.Screen.AbstractScreen;
import Game.Screen.GameManager;
import Game.Screen.MessagePause;
import javax.microedition.lcdui.Graphics;

public class GameScreen
extends AbstractScreen
implements ButtonListenner {
    int id;
    Point pDragged;
    Point pPressed;
    Point pReleased;
    private long mDelay = 40L;
    private long framePerSec;
    GameManager gameManager;

    public GameScreen(int idScreen) {
        this.id = idScreen;
        this.pPressed = new Point();
        this.pReleased = new Point();
        this.pDragged = new Point();
        this.framePerSec = 1000L / this.mDelay;
    }

    public void init() {
        this.gameManager = new GameManager(this.id, this, this.framePerSec);
        this.iBackground = this.gameManager.getBackground();
    }

    public void start(boolean isInit) {
        if (isInit) {
            this.init();
        }
    }

    public void stop(boolean isDestroy) {
    }

    public void run(Graphics g, long time) {
        this.drawScreen(g);
        if (this.gameManager != null) {
            this.gameManager.advance(time);
        }
    }

    protected void pointerPressed(int x, int y) {
        this.pPressed.x = x;
        this.pPressed.y = y;
        if (this.gameManager != null) {
            this.gameManager.pointerPressed(x, y);
        }
    }

    protected void pointerDragged(int x, int y) {
        this.pDragged.x = x;
        this.pDragged.y = y;
        if (this.gameManager != null) {
            this.gameManager.pointerDragged(x, y);
        }
    }

    protected void pointerReleased(int x, int y) {
        this.pReleased.x = x;
        this.pReleased.y = y;
        if (this.gameManager != null) {
            this.gameManager.pointerReleased(x, y);
        }
    }

    private void drawScreen(Graphics g) {
        if (this.gameManager != null) {
            g.drawImage(this.iBackground, this.gameManager.getPointBackground().x, this.gameManager.getPointBackground().y, 20);
            this.gameManager.paint(g);
        }
    }

    public void resume() {
        if (this.gameManager != null) {
            this.gameManager.timeOld = System.currentTimeMillis();
            if (this.gameManager.message == null || !this.gameManager.message.isActive) {
                this.gameManager.message = new MessagePause(this);
            }
        }
    }

    public void buttonClick(String btName) {
        if (this.gameManager != null) {
            this.gameManager.buttonClick(btName);
        }
    }
}

