/*
 * Decompiled with CFR 0.152.
 */
package Game.Item;

import Game.ExtraClass.Point;
import Game.ExtraClass.mMath;
import Game.Screen.GameManager;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public abstract class Item
extends Sprite {
    int id;
    public Point pReal;
    public Point pBackground;
    int donay;
    int domasat;
    boolean flagDrag = false;
    int rotate;
    int cost;

    public Item(Image image, int x, int y, int rotate) {
        super(image, image.getWidth(), image.getHeight());
        this.setRefPixelPosition(x, y);
        this.pBackground = new Point(0, 0);
        this.pReal = new Point(x, y);
        this.rotate = rotate;
    }

    public abstract void advance(long var1);

    public abstract boolean pointerPressed(int var1, int var2);

    public abstract boolean pointerDragged(int var1, int var2);

    public abstract boolean pointerReleased(int[][] var1, int var2, int var3);

    public void setPosinMapBlock(int[][] mapBlock) {
        int width = this.getWidth() / GameManager.sizeBlock + this.pReal.x / GameManager.sizeBlock;
        int heigh = this.getHeight() / GameManager.sizeBlock + this.pReal.y / GameManager.sizeBlock;
        for (int i = this.pReal.x / GameManager.sizeBlock; i < width; ++i) {
            for (int j = this.pReal.y / GameManager.sizeBlock; j < heigh; ++j) {
                mapBlock[i][j] = this.id;
            }
        }
    }

    public void removePosinMapBlock(int[][] mapBlock) {
        int width = this.getWidth() / GameManager.sizeBlock + this.pReal.x / GameManager.sizeBlock;
        int heigh = this.getHeight() / GameManager.sizeBlock + this.pReal.y / GameManager.sizeBlock;
        for (int i = this.pReal.x / GameManager.sizeBlock; i < width; ++i) {
            for (int j = this.pReal.y / GameManager.sizeBlock; j < heigh; ++j) {
                mapBlock[i][j] = -1;
            }
        }
    }

    public int getDoNay() {
        return this.donay;
    }

    public int getDoMaSat() {
        return this.domasat;
    }

    public void setDoNay(int donay) {
        this.donay = donay;
    }

    public void setDoMaSat(int domasat) {
        this.domasat = domasat;
    }

    public int getid() {
        return this.id;
    }

    public boolean CheckPoint(int x, int y) {
        return x >= this.getRefPixelX() && x <= this.getRefPixelX() + this.getWidth() && y >= this.getRefPixelY() && y <= this.getRefPixelY() + this.getHeight();
    }

    public void SetPositionScreen(int x, int y) {
        this.setRefPixelPosition(x, y);
        this.pReal.x = x - this.pBackground.x;
        this.pReal.y = y - this.pBackground.y;
    }

    public void SetPositionBackground(int x, int y) {
        this.pBackground = new Point(x, y);
        this.setRefPixelPosition(this.pReal.x + this.pBackground.x, this.pReal.y + this.pBackground.y);
    }

    public boolean checkFreeLocation(int[][] mapBlock) {
        int x = this.pReal.x / GameManager.sizeBlock;
        int y = this.pReal.y / GameManager.sizeBlock;
        int width = mMath.round(this.pReal.x + this.getWidth(), GameManager.sizeBlock) / GameManager.sizeBlock - 1;
        int height = mMath.round(this.pReal.y + this.getHeight(), GameManager.sizeBlock) / GameManager.sizeBlock - 1;
        int mapWidth = mapBlock.length - 1;
        int mapHeight = mapBlock[0].length - 1;
        int itemx = this.getWidth() / GameManager.sizeBlock;
        int itemy = this.getHeight() / GameManager.sizeBlock;
        int duX = 0;
        int duY = 0;
        if (width > mapWidth) {
            duX = (width - mapWidth) * GameManager.sizeBlock;
            width = mapWidth;
            x = width - this.getWidth() / GameManager.sizeBlock;
        }
        if (height > mapHeight) {
            duY = (height - mapHeight) * GameManager.sizeBlock;
            height = mapHeight;
            y = height - this.getHeight() / GameManager.sizeBlock;
        }
        this.SetPositionScreen(this.getRefPixelX() - duX, this.getRefPixelY() - duY);
        for (int i = x; i <= width; ++i) {
            for (int j = y; j <= height; ++j) {
                if (mapBlock[i][j] == -1) continue;
                return true;
            }
        }
        return false;
    }

    public void DrawtoMap(int[][] mapData) {
    }

    public void cleartoMap(int[][] mapData) {
    }

    public void setRotate(int rotate) {
        this.rotate = rotate;
    }

    public int getCost() {
        return this.cost;
    }

    public void UpdateState() {
        this.setTransform(this.rotate);
        if (this.rotate == 5) {
            int lech = this.getWidth();
            this.pReal.x += lech;
            this.setRefPixelPosition(this.getRefPixelX() + lech, this.getRefPixelY());
        }
    }
}

