/*
 * Decompiled with CFR 0.152.
 */
package kiwi.database.newsprite;

import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import kiwi.database.imagecontent.ImageContent;
import kiwi.database.newsprite.NewSprite;
import kiwi.database.newsprite.SpriteElement;

public class NewSpriteElement
extends SpriteElement {
    public byte imageid;
    public short cutid;

    public NewSpriteElement(DataInputStream dis) {
        this.readData(dis);
    }

    public void readData(DataInputStream dis) {
        try {
            this.imageid = dis.readByte();
            this.cutid = dis.readShort();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics g, NewSprite ns, NewSprite refns, int dx, int dy, int posx, int posy, int type, int transform) {
        ImageContent ic = ns.model_imagecontent[this.imageid];
        short width = ns.width;
        short height = ns.height;
        int cdx = 0;
        int cdy = 0;
        int cdw = 0;
        int cdh = 0;
        if (ic.image != null) {
            cdx = ic.getX(this.cutid);
            cdy = ic.getY(this.cutid);
            cdw = ic.getWidth(this.cutid);
            cdh = ic.getHeight(this.cutid);
        } else {
            cdw = ic.getImage(this.cutid).getWidth();
            cdh = ic.getImage(this.cutid).getHeight();
        }
        int tt = NewSpriteElement.getTrans(transform, type);
        int w = cdw;
        int h = cdh;
        if (this.isTranChange(tt)) {
            w = cdh;
            h = cdw;
        }
        int x = dx + posx;
        int y = dy + posy;
        switch (type) {
            case 5: {
                x = dx + height - posy - w;
                y = dy + posx;
                break;
            }
            case 3: {
                x = dx + width - posx - w;
                y = dy + height - posy - h;
                break;
            }
            case 6: {
                x = dx + posy;
                y = dy + width - posx - h;
                break;
            }
            case 2: {
                x = dx + width - posx - w;
                break;
            }
            case 7: {
                x = dx + height - posy - w;
                y = dy + width - posx - h;
                break;
            }
            case 1: {
                x = dx + posx;
                y = dy + height - posy - h;
                break;
            }
            case 4: {
                x = dx + posy;
                y = dy + posx;
            }
        }
        if (this.isTranChange(tt)) {
            if (this.isRegion(g, x, y, cdh, cdw)) {
                g.drawRegion(ic.getImage(this.cutid), cdx, cdy, cdw, cdh, tt, x, y, 0);
            }
        } else if (this.isRegion(g, x, y, cdw, cdh)) {
            g.drawRegion(ic.getImage(this.cutid), cdx, cdy, cdw, cdh, tt, x, y, 0);
        }
    }

    boolean isTranChange(int transform) {
        return transform == 4 || transform == 7 || transform == 6 || transform == 5;
    }

    boolean isRegion(Graphics g, int x, int y, int w, int h) {
        return x >= g.getClipX() - w && x < g.getClipX() + g.getClipWidth() && y >= g.getClipY() - h && y < g.getClipY() + g.getClipHeight();
    }
}

