/*
 * Decompiled with CFR 0.152.
 */
package kiwi.database.map;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import kiwi.database.imagecontent.FileCombo;
import kiwi.database.map.Event;
import kiwi.database.map.MapLayer;
import kiwi.database.newsprite.Colide;
import kiwi.database.newsprite.NewSprite;
import kiwi.database.newsprite.NewSpriteFrame;

public class Map {
    public static final byte UP = 0;
    public static final byte DOWN = 1;
    public static final byte LEFT = 2;
    public static final byte RIGHT = 3;
    public MapLayer[] maplayers;
    public MapLayer basiclayer;
    public Event[] eventlayer;
    public int offx;
    public int offy;
    static /* synthetic */ Class class$kiwi$database$newsprite$NewSprite;
    static /* synthetic */ Class class$kiwi$database$imagecontent$ImageContent;

    public Map(DataInputStream dis, String path, int screenwidth, int screenheight, boolean iscombine) {
        this.readData(dis, path, screenwidth, screenheight, iscombine);
    }

    public void readData(DataInputStream dis, String path, int screenwidth, int screenheight, boolean iscombine) {
        try {
            Hashtable v = new Hashtable();
            int layers = dis.readByte();
            this.maplayers = new MapLayer[layers];
            for (int i = 0; i < layers; ++i) {
                this.maplayers[i] = new MapLayer(dis, path, v, iscombine);
            }
            this.basiclayer = this.maplayers[dis.readByte()];
            v = null;
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics g, int offx, int offy, long time) {
        this.offx = offx;
        this.offy = offy;
        for (int i = this.maplayers.length - 1; i >= 0; --i) {
            this.maplayers[i].draw(g, offx, offy, time);
        }
    }

    public void setPosition(int x, int y) {
        for (int i = this.maplayers.length - 1; i >= 0; --i) {
            this.maplayers[i].layer.setPosition(x, y);
        }
    }

    public void move(int x, int y) {
        for (int i = this.maplayers.length - 1; i >= 0; --i) {
            this.maplayers[i].layer.move(x, y);
        }
    }

    public int getX() {
        return this.basiclayer.layer.getX();
    }

    public int getY() {
        return this.basiclayer.layer.getY();
    }

    public int getWidth() {
        return this.basiclayer.getWidth();
    }

    public int getHeight() {
        return this.basiclayer.getHeight();
    }

    public Event getEvent(Graphics g, int x, int y, int w, int h) {
        if (this.eventlayer == null) {
            return null;
        }
        for (int i = 0; i < this.eventlayer.length; ++i) {
            Event e = this.eventlayer[i];
            if (!this.isRegion(g, x, y, w, h) || !e.isColide(x, y, w, h)) continue;
            return e;
        }
        return null;
    }

    public Event getColideEvent(Graphics g, NewSprite ns) {
        if (this.eventlayer == null) {
            return null;
        }
        NewSpriteFrame nsf = ns.getNewSpriteFrame();
        if (nsf.colides == null) {
            return null;
        }
        for (int i = 0; i < this.eventlayer.length; ++i) {
            Event e = this.eventlayer[i];
            if (!this.isRegion(g, e.x, e.y, e.w, e.h)) continue;
            for (int j = 0; j < nsf.colides.length; ++j) {
                Colide c = nsf.colides[j];
                if (!e.isColide(ns.getX() + c.x, ns.getY() + c.y, c.w, c.h)) continue;
                return e;
            }
        }
        return null;
    }

    public int getColideType(Graphics g, NewSprite ns) {
        if (this.eventlayer == null) {
            return -1;
        }
        NewSpriteFrame nsf = ns.getNewSpriteFrame();
        if (nsf.colides == null) {
            return -1;
        }
        for (int i = 0; i < this.eventlayer.length; ++i) {
            Event e = this.eventlayer[i];
            if (!this.isRegion(g, e.x, e.y, e.w, e.h)) continue;
            for (int j = 0; j < nsf.colides.length; ++j) {
                Colide c = nsf.colides[j];
                if (!e.isColide(ns.getX() + c.x, ns.getY() + c.y, c.w, c.h)) continue;
                return c.type;
            }
        }
        return -1;
    }

    boolean isRegion(Graphics g, int x, int y, int w, int h) {
        return (x += this.offx) >= g.getClipX() - w && x < g.getClipX() + g.getClipWidth() && (y += this.offy) >= g.getClipY() - h && y < g.getClipY() + g.getClipHeight();
    }

    public static Map getMap(String name, String path, int screenwidth, int screenheight) {
        InputStream is = (class$kiwi$database$newsprite$NewSprite == null ? (class$kiwi$database$newsprite$NewSprite = Map.class$("kiwi.database.newsprite.NewSprite")) : class$kiwi$database$newsprite$NewSprite).getResourceAsStream(path + name);
        if (is != null) {
            DataInputStream dis = new DataInputStream(is);
            Map w = new Map(dis, path, screenwidth, screenheight, false);
            try {
                dis.close();
                dis = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return w;
        }
        System.out.println("newsprite error " + name);
        return null;
    }

    public static Map getCMap(String name, String path, int screenwidth, int screenheight) {
        try {
            InputStream is = (class$kiwi$database$imagecontent$ImageContent == null ? (class$kiwi$database$imagecontent$ImageContent = Map.class$("kiwi.database.imagecontent.ImageContent")) : class$kiwi$database$imagecontent$ImageContent).getResourceAsStream(path + "cf.bin");
            if (is != null) {
                FileCombo fc = new FileCombo(new DataInputStream(is), name);
                Map w = new Map(fc.dis, path, screenwidth, screenheight, true);
                fc.close();
                return w;
            }
            System.out.println("newsprite error " + name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void paint2(Graphics g, int offx, int offy, long time, int laynum) {
        this.offx = offx;
        this.offy = offy;
        this.maplayers[laynum].draw(g, offx, offy, time);
    }

    public int getMaplayersCount() {
        return this.maplayers.length;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

