/*
 * Decompiled with CFR 0.152.
 */
package kiwi.database.newsprite;

import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import kiwi.database.newsprite.NewSprite;
import kiwi.database.newsprite.SpriteElement;

public class NewSpriteRefElement
extends SpriteElement {
    byte ns_index;
    short frame;

    public NewSpriteRefElement(DataInputStream dis) {
        this.readData(dis);
    }

    public void readData(DataInputStream dis) {
        try {
            this.ns_index = dis.readByte();
            this.frame = dis.readShort();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics g, NewSprite ns, NewSprite refns, int dx, int dy, int posx, int posy, int type, int transform) {
        if (ns == null || refns == null || this.frame < 0) {
            return;
        }
        short width = ns.width;
        short height = ns.height;
        short w = refns.width;
        short h = refns.height;
        int x = dx + posx;
        int y = dy + posy;
        switch (type) {
            case 5: {
                x = dx + height - posy - w;
                y = dy + posx;
                break;
            }
            case 3: {
                x = dx + width - posx - w;
                y = dy + height - posy - h;
                break;
            }
            case 6: {
                x = dx + posy;
                y = dy + width - posx - h;
                break;
            }
            case 2: {
                x = dx + width - posx - w;
                break;
            }
            case 7: {
                x = dx + height - posy - w;
                y = dy + width - posx - h;
                break;
            }
            case 1: {
                x = dx + posx;
                y = dy + height - posy - h;
                break;
            }
            case 4: {
                x = dx + posy;
                y = dy + posx;
            }
        }
        refns.setFrame(this.frame);
        int t = NewSpriteRefElement.getTrans(transform, type);
        refns.setTransform(t);
        refns.paint(g, x, y);
    }
}

