/*
 * Decompiled with CFR 0.152.
 */
package com.auer.title.sound_util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.ToneControl;
import javax.microedition.media.control.VolumeControl;

public class SoundObj {
    private Vector stmPool;
    private Player tempPlayer;
    private Player playerObj;
    private InputStream tempStream;
    private VolumeControl vol_Control;
    private ToneControl tone_Control;
    private short volume = 0;
    private boolean repeat = false;
    public static final String TONE = "audio/x-tone-seq";
    public static final String WAV = "audio/x-wav";
    public static final String AMR = "audio/amr";
    public static final String MIDI = "audio/midi";
    public static final String MP3 = "audio/mpeg";

    public SoundObj() {
        this.stmPool = new Vector();
    }

    public SoundObj(String fileName, String mediaKind) {
        if (mediaKind == TONE) {
            System.out.println("SoundObj Error !!");
        } else {
            try {
                this.tempStream = this.getClass().getResourceAsStream(fileName);
                this.tempPlayer = Manager.createPlayer((InputStream)this.tempStream, (String)mediaKind);
                this.tempPlayer.prefetch();
                this.tone_Control = null;
            }
            catch (IOException ioError) {
                System.out.println("Loading Media files failed ! I/O");
            }
            catch (MediaException mediaError) {
                System.out.println("Loading Media files failed ! mediaError");
            }
            this.playerObj = this.tempPlayer;
            this.vol_Control = (VolumeControl)this.playerObj.getControl("javax.microedition.media.control.VolumeControl");
        }
    }

    public SoundObj(byte[] sequence, String mediaKind) {
        if (mediaKind != TONE) {
            System.out.println("SoundObj Error !!");
        } else {
            try {
                this.tempStream = null;
                this.vol_Control = null;
                this.tempPlayer = Manager.createPlayer((String)"device://tone");
                this.tempPlayer.realize();
                this.tone_Control = (ToneControl)this.tempPlayer.getControl("ToneControl");
                this.tone_Control.setSequence(sequence);
            }
            catch (IOException ioError) {
                System.out.println("Loading Tone files failed ! I/O");
            }
            catch (MediaException mediaError) {
                System.out.println("Loading Tone files failed ! mediaError");
            }
            this.playerObj = this.tempPlayer;
        }
    }

    public void setStream(SndStm stm) {
        if (stm == null) {
            return;
        }
        try {
            if (this.playerObj != null && this.playerObj.getState() != 0) {
                this.playerObj.stop();
                if (this.tempStream != null) {
                    this.tempStream.close();
                    this.tempStream = null;
                }
                this.playerObj.close();
            }
            this.playerObj = null;
            this.tempPlayer = null;
            this.tone_Control = null;
            this.vol_Control = null;
            this.tempPlayer = Manager.createPlayer((InputStream)stm.getSndStream(), (String)stm.type);
            this.tempPlayer.getState();
            this.tempPlayer.realize();
            this.tempPlayer.prefetch();
        }
        catch (IOException ioError) {
            System.out.println("Loading Media files failed ! I/O");
        }
        catch (MediaException mediaError) {
            System.out.println("Loading Media files failed ! mediaError");
        }
        this.playerObj = this.tempPlayer;
        this.vol_Control = (VolumeControl)this.playerObj.getControl("javax.microedition.media.control.VolumeControl");
        this.setVolume(this.volume);
        this.set_IsRepeat(this.repeat);
        System.gc();
    }

    public void setStream(String fileName, String mediaKind) {
        try {
            if (this.playerObj != null && this.playerObj.getState() != 0) {
                this.playerObj.stop();
                if (this.tempStream != null) {
                    this.tempStream.close();
                    this.tempStream = null;
                }
                this.playerObj.close();
            }
            this.playerObj = null;
            this.tempPlayer = null;
            this.tone_Control = null;
            this.vol_Control = null;
            this.tempStream = this.getClass().getResourceAsStream(fileName);
            this.tempPlayer = Manager.createPlayer((InputStream)this.tempStream, (String)mediaKind);
            this.tempPlayer.realize();
            this.tempPlayer.prefetch();
        }
        catch (IOException ioError) {
            System.out.println("Loading Media files failed ! I/O");
        }
        catch (MediaException mediaError) {
            System.out.println("Loading Media files failed ! mediaError");
        }
        this.playerObj = this.tempPlayer;
        this.vol_Control = (VolumeControl)this.playerObj.getControl("javax.microedition.media.control.VolumeControl");
        this.setVolume(this.volume);
        this.set_IsRepeat(this.repeat);
        System.gc();
    }

    public void setStream(byte[] sequence) {
        try {
            if (this.playerObj != null && this.playerObj.getState() != 0) {
                this.playerObj.stop();
                if (this.tempStream != null) {
                    this.tempStream.close();
                    this.tempStream = null;
                }
            }
            this.vol_Control = null;
            if (this.playerObj.getContentType().equals(TONE)) {
                this.playerObj.deallocate();
                this.playerObj.realize();
                this.tone_Control.setSequence(sequence);
            } else {
                this.playerObj.close();
                this.playerObj = null;
                this.tempPlayer = null;
                this.tone_Control = null;
                this.tempPlayer = Manager.createPlayer((String)"device://tone");
                this.tempPlayer.realize();
                this.tone_Control = (ToneControl)this.tempPlayer.getControl("ToneControl");
                this.tone_Control.setSequence(sequence);
                this.playerObj = this.tempPlayer;
            }
        }
        catch (IOException ioError) {
            System.out.println("Loading Tone files failed ! I/O");
        }
        catch (MediaException mediaError) {
            System.out.println("Loading Tone files failed ! mediaError");
        }
        System.gc();
    }

    public boolean playSound(int checkCode) {
        try {
            if (this.playerObj.getState() != 400) {
                this.playerObj.start();
            }
        }
        catch (MediaException mediaError) {
            System.out.println("Playing media files failed !" + checkCode);
        }
        return true;
    }

    public boolean restartPlaySound(int checkCode) {
        try {
            if (this.playerObj.getState() != 400) {
                if (!this.playerObj.getContentType().equals(TONE)) {
                    this.playerObj.setMediaTime(0L);
                }
                this.playerObj.start();
            } else if (!this.playerObj.getContentType().equals(TONE)) {
                this.playerObj.setMediaTime(0L);
            }
        }
        catch (MediaException mediaError) {
            System.out.println("Playing media files failed !" + checkCode);
        }
        return true;
    }

    public boolean stop() {
        if (this.playerObj != null) {
            try {
                this.playerObj.stop();
                if (!this.playerObj.getContentType().equals(TONE)) {
                    this.playerObj.setMediaTime(0L);
                }
            }
            catch (MediaException mediaError) {
                System.out.println("Stopping media files failed !");
            }
            return true;
        }
        return false;
    }

    public boolean close() {
        if (this.playerObj != null && this.playerObj.getState() != 0) {
            try {
                this.playerObj.stop();
                this.playerObj.close();
                if (this.tempStream != null) {
                    this.tempStream.close();
                }
            }
            catch (MediaException mediaError) {
                System.out.println("Stopping media files failed !");
                return false;
            }
            catch (IOException ioError) {
                System.out.println("Loading Media files failed !");
            }
        }
        return true;
    }

    public void set_LoopCount(int data) {
        if (data < 1) {
            return;
        }
        if (this.playerObj != null) {
            if (this.playerObj.getState() != 400) {
                this.playerObj.setLoopCount(data);
            } else {
                try {
                    this.playerObj.stop();
                    this.playerObj.setMediaTime(0L);
                }
                catch (MediaException mediaError) {
                    System.out.println("Stopping media files failed !");
                }
                this.playerObj.setLoopCount(data);
            }
        }
    }

    public void set_IsRepeat(boolean data) {
        this.repeat = data;
        if (this.playerObj != null && !this.playerObj.getContentType().equals(TONE)) {
            if (this.playerObj.getState() != 400) {
                if (this.repeat) {
                    this.playerObj.setLoopCount(-1);
                } else {
                    this.playerObj.setLoopCount(1);
                }
            } else {
                try {
                    this.playerObj.stop();
                    this.playerObj.setMediaTime(0L);
                }
                catch (MediaException mediaError) {
                    System.out.println("Stopping media files failed !");
                }
                if (this.repeat) {
                    this.playerObj.setLoopCount(-1);
                } else {
                    this.playerObj.setLoopCount(1);
                }
            }
        }
    }

    public boolean get_IsRepeat() {
        return this.repeat;
    }

    public boolean setVolume(int vol) {
        if (this.playerObj != null && !this.playerObj.getContentType().equals(TONE) && vol >= 0 && vol <= 100) {
            this.volume = (short)vol;
            if (this.vol_Control != null) {
                this.vol_Control.setLevel((int)this.volume);
                return true;
            }
            this.vol_Control = (VolumeControl)this.playerObj.getControl("javax.microedition.media.control.VolumeControl");
            this.vol_Control.setLevel((int)this.volume);
            return true;
        }
        return false;
    }

    public int getVolume() {
        if (this.playerObj != null && !this.playerObj.getContentType().equals(TONE)) {
            if (this.vol_Control != null) {
                return this.volume;
            }
            this.vol_Control = (VolumeControl)this.playerObj.getControl("javax.microedition.media.control.VolumeControl");
            this.volume = (short)this.vol_Control.getLevel();
            return this.volume;
        }
        return 0;
    }

    public int getPlayerState() {
        if (this.playerObj != null) {
            return this.playerObj.getState();
        }
        return -1;
    }

    public SndStm addStm(String filename, String type) {
        SndStm tempStm = new SndStm(filename, type);
        this.stmPool.addElement(tempStm);
        return tempStm;
    }

    public SndStm findStm(String filename) {
        if (this.stmPool != null) {
            for (int i = 0; i < this.stmPool.size(); ++i) {
                SndStm tempStm = (SndStm)this.stmPool.elementAt(i);
                if (!tempStm.filename.equals(filename)) continue;
                return tempStm;
            }
        }
        return null;
    }

    public void delStm(String filename) {
        if (this.stmPool != null) {
            for (int i = 0; i < this.stmPool.size(); ++i) {
                SndStm tempStm = (SndStm)this.stmPool.elementAt(i);
                if (!tempStm.filename.equals(filename)) continue;
                tempStm.close();
                this.stmPool.removeElement(tempStm);
                break;
            }
        }
    }

    class SndStm {
        public String filename;
        public String type;
        public byte[] sndStreamByte;

        public SndStm(String fname, String typeStr) {
            this.filename = fname;
            this.type = typeStr;
            this.setSndStm2ByteArray();
        }

        public void setSndStm2ByteArray() {
            if (this.filename != null && this.type != null) {
                try {
                    InputStream tempStream2 = this.getClass().getResourceAsStream(this.filename);
                    this.sndStreamByte = new byte[tempStream2.available()];
                    tempStream2.read(this.sndStreamByte);
                    tempStream2.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.filename.length() == 0) {
                System.out.println("filename set error !");
            } else if (this.type.length() == 0) {
                System.out.println("type set error !");
            } else {
                System.out.println("unknow error !");
            }
        }

        public InputStream getSndStream() {
            if (this.sndStreamByte != null) {
                ByteArrayInputStream tempStream2 = null;
                try {
                    tempStream2 = new ByteArrayInputStream(this.sndStreamByte);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return tempStream2;
            }
            return null;
        }

        public void close() {
            this.filename = null;
            this.type = null;
            this.sndStreamByte = null;
        }
    }
}

