/*
 * Decompiled with CFR 0.152.
 */
package com.auer.game;

import com.auer.game.Heroman;
import com.auer.game.HittenEffect;
import com.auer.game.Talk;
import com.auer.title.KeyCodePerformer;
import com.auer.title.sound_util.SoundObj;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import kiwi.database.newsprite.NewSprite;

public class Enemy {
    Random RM = new Random();
    KeyCodePerformer kcp;
    private int bgX;
    private int bgY;
    public boolean isEnemyDead;
    public int enemyType;
    public int enemyHp;
    public int enemyHpTemp;
    public int enemyMp;
    public int attackType;
    public int attackPoint;
    public int defensePoint;
    public int defenseSuccessPoint;
    public int hideChance1;
    public int hideChance2;
    public int hideChance3;
    public int hideChance4;
    public int defenceChance;
    public int attackChance;
    public int bigHitChance;
    public int playerRehitEnemyDefenceChance;
    public int attackBackMove;
    public boolean isMyRound;
    public boolean isPlayerPressHide;
    public boolean isPlayerPaintHide;
    public NewSprite enemySpr;
    public final int normalStandBy;
    public final int attack1;
    public final int attack1Before;
    public final int attack2;
    public final int attack2Before;
    public final int attack3;
    public final int attack3Before;
    public final int hideR;
    public final int hideL;
    public final int death;
    public final int hurt;
    public final int defenceBreak;
    public final int weakStandBy;
    public final int weakAttack1Before;
    public final int weakAttack1;
    public final int weakAttack2Before;
    public final int weakAttack2;
    public final int weakHideR;
    public final int weakHideL;
    public final int weakDefenceBreak;
    public final int specialLook;
    public final int specialDefenceBreak;
    public final int specialHideL;
    public final int specialHideR;
    public final int specialWeakDefenceBreak;
    public final int specialWeakHideL;
    public final int specialWeakHideR;
    public int enemyState;
    public int normalCountDownTime;
    public int normalEndCountDownTime;
    public int attackBeforeCountDownTime;
    public int attackBeforeEndCountDownTime1;
    public int attackBeforeEndCountDownTime2;
    public boolean isAttackBefore;
    public boolean isAttack;
    public int playerAttackEnemyState;
    public int enemyTalkStartTime;
    public int enemyTalkEndTime;
    public int enemyTalkChance;
    public boolean isPlayerRehitEnemy;
    public int playerRehitEnemyCount;
    public int playerRehitEnemyChance;
    public int playerRehitEnemyTime;
    public int enemyHpActTime;
    public Sprite enemyHpSpr;
    public Sprite enemyHpLightSpr;
    public Sprite enemyHighHpSpr;
    public Sprite enemyHpBackSpr;
    public Sprite enemyHeadSpr;
    public Sprite enemyNameSpr;
    public Sprite enemyMpSpr;
    public Vector hittenEffectV = new Vector();
    public Vector talkV = new Vector();
    public boolean isTalk;
    public Vector soundWordV = new Vector();
    public Vector speedLineV = new Vector();
    public int enemySpecialMoveStartTime;
    public int enemySpecialMoveEndTime;
    public boolean isEnemySpecialMove;
    public boolean isSkillOn;
    public SoundObj[] effectMusicPlayer = new SoundObj[7];

    public Enemy(int type, NewSprite ns) {
        this.normalStandBy = 0;
        this.attack1 = 5;
        this.attack1Before = 4;
        this.attack2 = 7;
        this.attack2Before = 6;
        this.attack3 = 999;
        this.attack3Before = 1000;
        this.hideR = 9;
        this.hideL = 8;
        this.death = 11;
        this.hurt = 3;
        this.defenceBreak = 10;
        this.weakStandBy = 2;
        this.weakAttack1Before = 12;
        this.weakAttack1 = 13;
        this.weakAttack2Before = 14;
        this.weakAttack2 = 15;
        this.weakHideR = 17;
        this.weakHideL = 16;
        this.weakDefenceBreak = 18;
        this.specialLook = 1;
        this.specialDefenceBreak = 21;
        this.specialHideL = 22;
        this.specialHideR = 23;
        this.specialWeakDefenceBreak = 26;
        this.specialWeakHideL = 27;
        this.specialWeakHideR = 28;
        System.out.println("in enemy load");
        if (KeyCodePerformer.DEFAULT_WIDTH >= 240) {
            this.Screen240();
        } else if (KeyCodePerformer.DEFAULT_WIDTH <= 176) {
            this.Screen176();
        }
        if (this.effectMusicPlayer != null) {
            this.effectMusicPlayer = null;
            System.gc();
            System.out.println("enemy cancel music");
        }
        this.effectMusicPlayer = new SoundObj[7];
        this.closeEffectMusic();
        for (int i = 0; i < this.effectMusicPlayer.length; ++i) {
            this.makEffectMusicPlayer(i);
        }
        this.dataLoad(type, ns);
        this.enemyHpBackSprLoad();
        this.enemyHpLightSprLoad();
        this.enemyHighHpSprLoad();
        this.enemyHpSprLoad();
        this.enemyHeadSprLoad(type);
        this.enemyNameSprLoad(type);
        this.enemyMpSprLoad();
    }

    private void dataLoad(int type, NewSprite ns) {
        this.enemyType = type;
        this.checkNewSprNull(this.enemySpr);
        this.enemySpr = new NewSprite(ns);
        if (type == 0) {
            if (this.talkV.size() > 0) {
                this.talkV.removeAllElements();
                this.talkV = null;
                System.gc();
            }
            this.talkV = new Vector();
            for (int i = 0; i < 5; ++i) {
                this.talkV.addElement(new Talk(i, type));
            }
            this.hittenEffectVLoad();
            this.enemyHp = 0;
            this.enemyHpTemp = 0;
            this.enemyMp = 0;
            this.attackPoint = 7;
            this.defensePoint = 5;
            this.defenseSuccessPoint = 3;
            this.hideChance1 = 40;
            this.hideChance2 = 30;
            this.hideChance3 = 0;
            this.hideChance4 = 20;
            this.defenceChance = 40;
            this.attackChance = 50;
            this.bigHitChance = 30;
            this.isMyRound = false;
            this.enemyState = 0;
            this.enemyTalkChance = 2;
            this.enemyTalkStartTime = 0;
            this.enemyTalkEndTime = 40;
            this.normalEndCountDownTime = 20;
            this.attackBeforeEndCountDownTime1 = 15;
            this.attackBeforeEndCountDownTime2 = 25;
            this.playerRehitEnemyChance = 100;
            this.playerRehitEnemyDefenceChance = 30;
            this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
            this.enemySpecialMoveEndTime = 20;
        } else if (type == 1) {
            if (this.talkV.size() > 0) {
                this.talkV.removeAllElements();
                this.talkV = null;
                System.gc();
            }
            for (int i = 0; i < 5; ++i) {
                this.talkV.addElement(new Talk(i, type));
            }
            this.hittenEffectVLoad();
            this.enemyHp = 0;
            this.enemyHpTemp = 0;
            this.enemyMp = 0;
            this.attackPoint = 9;
            this.defensePoint = 5;
            this.defenseSuccessPoint = 3;
            this.hideChance1 = 80;
            this.hideChance2 = 90;
            this.hideChance3 = 0;
            this.hideChance4 = 30;
            this.defenceChance = 10;
            this.attackChance = 80;
            this.bigHitChance = 30;
            this.isMyRound = false;
            this.enemyState = 0;
            this.enemyTalkChance = 2;
            this.enemyTalkStartTime = 0;
            this.enemyTalkEndTime = 40;
            this.normalEndCountDownTime = 7;
            this.attackBeforeEndCountDownTime1 = 5;
            this.attackBeforeEndCountDownTime2 = 10;
            this.playerRehitEnemyChance = 100;
            this.playerRehitEnemyDefenceChance = 30;
            this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
            this.enemySpecialMoveEndTime = 40;
        } else if (type == 2) {
            if (this.talkV.size() > 0) {
                this.talkV.removeAllElements();
                this.talkV = null;
                System.gc();
            }
            for (int i = 0; i < 5; ++i) {
                this.talkV.addElement(new Talk(i, type));
            }
            this.hittenEffectVLoad();
            this.enemyHp = 0;
            this.enemyHpTemp = 0;
            this.enemyMp = 0;
            this.attackPoint = 12;
            this.defensePoint = 7;
            this.defenseSuccessPoint = 3;
            this.hideChance1 = 0;
            this.hideChance2 = 0;
            this.hideChance3 = 0;
            this.hideChance4 = 0;
            this.defenceChance = 65;
            this.attackChance = 70;
            this.bigHitChance = 20;
            this.isMyRound = false;
            this.enemyState = 0;
            this.enemyTalkChance = 2;
            this.enemyTalkStartTime = 0;
            this.enemyTalkEndTime = 40;
            this.normalEndCountDownTime = 20;
            this.attackBeforeEndCountDownTime1 = 20;
            this.attackBeforeEndCountDownTime2 = 10;
            this.playerRehitEnemyChance = 100;
            this.playerRehitEnemyDefenceChance = 40;
            this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
            this.enemySpecialMoveEndTime = 40;
        } else if (type == 3) {
            if (this.talkV.size() > 0) {
                this.talkV.removeAllElements();
                this.talkV = null;
                System.gc();
            }
            for (int i = 0; i < 5; ++i) {
                this.talkV.addElement(new Talk(i, type));
            }
            this.hittenEffectVLoad();
            this.enemyHp = 0;
            this.enemyHpTemp = 0;
            this.enemyMp = 0;
            this.attackPoint = 17;
            this.defensePoint = 7;
            this.defenseSuccessPoint = 3;
            this.hideChance1 = 90;
            this.hideChance2 = 80;
            this.hideChance3 = 0;
            this.hideChance4 = 40;
            this.defenceChance = 20;
            this.attackChance = 60;
            this.bigHitChance = 20;
            this.isMyRound = false;
            this.enemyState = 0;
            this.enemyTalkChance = 2;
            this.enemyTalkStartTime = 0;
            this.enemyTalkEndTime = 40;
            this.normalEndCountDownTime = 5;
            this.attackBeforeEndCountDownTime1 = 5;
            this.attackBeforeEndCountDownTime2 = 10;
            this.playerRehitEnemyChance = 100;
            this.playerRehitEnemyDefenceChance = 20;
            this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
            this.enemySpecialMoveEndTime = 30;
        }
        this.enemyState = 0;
        this.enemySpr.setFrameSequenceData(0);
    }

    private void enemySkillAct(Graphics g) {
        if (this.enemyType == 0) {
            if (this.enemyState == 4 && this.isSkillOn) {
                if (this.attackBeforeCountDownTime < this.attackBeforeEndCountDownTime1 - 3) {
                    if (this.attackBeforeCountDownTime % 2 == 0) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                        this.enemySpr.paint(g);
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 - this.attackBeforeCountDownTime * 15);
                        this.enemySpr.paint(g);
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 + this.attackBeforeCountDownTime * 15);
                        this.enemySpr.paint(g);
                    }
                } else {
                    int tempa = this.RM.nextInt(3);
                    if (tempa == 0) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 + this.enemySpr.getHeight());
                        this.enemySpr.paint(g);
                    } else if (tempa == 1) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 - this.enemySpr.getHeight());
                        this.enemySpr.paint(g);
                    } else if (tempa == 2) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                        this.enemySpr.paint(g);
                    }
                }
            } else if (this.enemyState == 4 && !this.isSkillOn) {
                this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                this.enemySpr.paint(g);
            } else if (this.enemyState == 6 && this.isSkillOn) {
                if (this.attackBeforeCountDownTime < this.attackBeforeEndCountDownTime2 - 3) {
                    if (this.attackBeforeCountDownTime % 2 == 0) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                        this.enemySpr.paint(g);
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 - this.attackBeforeCountDownTime * 10);
                        this.enemySpr.paint(g);
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 + this.attackBeforeCountDownTime * 10);
                        this.enemySpr.paint(g);
                    }
                } else {
                    int tempa = this.RM.nextInt(3);
                    if (tempa == 0) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 + this.enemySpr.getHeight());
                        this.enemySpr.paint(g);
                    } else if (tempa == 1) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 - this.enemySpr.getHeight());
                        this.enemySpr.paint(g);
                    } else if (tempa == 2) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                        this.enemySpr.paint(g);
                    }
                }
            } else if (this.enemyState == 6 && !this.isSkillOn) {
                this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                this.enemySpr.paint(g);
            } else if (this.enemyState == 12 && this.isSkillOn) {
                if (this.attackBeforeCountDownTime < this.attackBeforeEndCountDownTime1 - 2) {
                    if (this.attackBeforeCountDownTime % 2 == 0) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 - this.attackBeforeCountDownTime * 10);
                        this.enemySpr.paint(g);
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 + this.attackBeforeCountDownTime * 10);
                        this.enemySpr.paint(g);
                    }
                } else {
                    int tempa = this.RM.nextInt(2);
                    if (tempa == 0) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 + this.enemySpr.getHeight());
                        this.enemySpr.paint(g);
                    } else if (tempa == 1) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 - this.enemySpr.getHeight());
                        this.enemySpr.paint(g);
                    }
                }
            } else if (this.enemyState == 12 && !this.isSkillOn) {
                this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                this.enemySpr.paint(g);
            } else if (this.enemyState == 14 && this.isSkillOn) {
                if (this.attackBeforeCountDownTime < this.attackBeforeEndCountDownTime2 - 2) {
                    if (this.attackBeforeCountDownTime % 2 == 0) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 - this.attackBeforeCountDownTime * 10);
                        this.enemySpr.paint(g);
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 + this.attackBeforeCountDownTime * 10);
                        this.enemySpr.paint(g);
                    }
                } else {
                    int tempa = this.RM.nextInt(2);
                    if (tempa == 0) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 + this.enemySpr.getHeight());
                        this.enemySpr.paint(g);
                    } else if (tempa == 1) {
                        this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 - this.enemySpr.getHeight());
                        this.enemySpr.paint(g);
                    }
                }
            } else if (this.enemyState == 14 && !this.isSkillOn) {
                this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                this.enemySpr.paint(g);
            } else {
                this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                this.enemySpr.paint(g);
            }
        } else if (this.enemyType == 1) {
            if (this.enemyState == 5 && this.isSkillOn) {
                if (this.enemySpr.getFrame() >= this.enemySpr.getFrameCount() - 3) {
                    this.enemySpr.setVisible(true);
                } else {
                    this.enemySpr.setVisible(false);
                }
            } else if (this.enemyState == 4 && this.isSkillOn) {
                if (this.attackBeforeCountDownTime == 1) {
                    this.enemySpr.setVisible(false);
                } else if (this.attackBeforeCountDownTime == 2) {
                    this.enemySpr.setVisible(true);
                } else if (this.attackBeforeCountDownTime == 3) {
                    this.enemySpr.setVisible(false);
                } else if (this.attackBeforeCountDownTime == 4) {
                    this.enemySpr.setVisible(true);
                } else {
                    this.enemySpr.setVisible(false);
                }
            } else if (this.enemyState == 7 && this.isSkillOn) {
                if (this.enemySpr.getFrame() >= this.enemySpr.getFrameCount() - 3) {
                    this.enemySpr.setVisible(true);
                } else {
                    this.enemySpr.setVisible(false);
                }
            } else if (this.enemyState == 6 && this.isSkillOn) {
                if (this.attackBeforeCountDownTime == 1) {
                    this.enemySpr.setVisible(false);
                } else if (this.attackBeforeCountDownTime == 2) {
                    this.enemySpr.setVisible(true);
                } else if (this.attackBeforeCountDownTime == 3) {
                    this.enemySpr.setVisible(false);
                } else if (this.attackBeforeCountDownTime == 4) {
                    this.enemySpr.setVisible(true);
                } else {
                    this.enemySpr.setVisible(false);
                }
            } else if (this.enemyState == 15 && this.isSkillOn) {
                if (this.enemySpr.getFrame() >= this.enemySpr.getFrameCount() - 3) {
                    this.enemySpr.setVisible(true);
                } else {
                    this.enemySpr.setVisible(false);
                }
            } else if (this.enemyState == 14 && this.isSkillOn) {
                if (this.attackBeforeCountDownTime == 1) {
                    this.enemySpr.setVisible(false);
                } else if (this.attackBeforeCountDownTime == 2) {
                    this.enemySpr.setVisible(true);
                } else if (this.attackBeforeCountDownTime == 3) {
                    this.enemySpr.setVisible(false);
                } else if (this.attackBeforeCountDownTime == 4) {
                    this.enemySpr.setVisible(true);
                } else {
                    this.enemySpr.setVisible(false);
                }
            } else if (this.enemyState == 13 && this.isSkillOn) {
                if (this.enemySpr.getFrame() >= this.enemySpr.getFrameCount() - 3) {
                    this.enemySpr.setVisible(true);
                } else {
                    this.enemySpr.setVisible(false);
                }
            } else if (this.enemyState == 12 && this.isSkillOn) {
                if (this.attackBeforeCountDownTime == 1) {
                    this.enemySpr.setVisible(false);
                } else if (this.attackBeforeCountDownTime == 2) {
                    this.enemySpr.setVisible(true);
                } else if (this.attackBeforeCountDownTime == 3) {
                    this.enemySpr.setVisible(false);
                } else if (this.attackBeforeCountDownTime == 4) {
                    this.enemySpr.setVisible(true);
                } else {
                    this.enemySpr.setVisible(false);
                }
            } else {
                this.enemySpr.setVisible(true);
            }
            this.enemySpr.paint(g);
        } else if (this.enemyType == 2) {
            if (this.enemyState == 7 && this.isSkillOn) {
                if (this.enemySpr.getFrame() == 1 || this.enemySpr.getFrame() == 2) {
                    this.enemySpr.setPosition(this.bgX + 0 + 100, this.bgY + 300);
                } else {
                    this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                }
            } else if (this.enemyState == 15 && this.isSkillOn) {
                if (this.enemySpr.getFrame() == 1 || this.enemySpr.getFrame() == 2) {
                    this.enemySpr.setPosition(this.bgX + 0 + 100, this.bgY + 300);
                } else {
                    this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                }
            } else {
                this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
            }
            this.enemySpr.paint(g);
        } else if (this.enemyType == 3) {
            if (this.enemyState == 12) {
                int tempa = this.RM.nextInt(3);
                if (tempa == 0) {
                    this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                    this.enemySpr.paint(g);
                } else if (tempa == 1) {
                    this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 + this.enemySpr.getHeight() + 50);
                    this.enemySpr.paint(g);
                } else if (tempa == 2) {
                    this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300 - this.enemySpr.getHeight() - 50);
                    this.enemySpr.paint(g);
                }
            } else if (this.enemyState == 14) {
                if (this.attackBeforeCountDownTime >= this.attackBeforeEndCountDownTime2 - 2) {
                    this.enemySpr.setVisible(true);
                } else if (this.attackBeforeCountDownTime == this.attackBeforeEndCountDownTime2 - this.attackBeforeEndCountDownTime2 - 2) {
                    this.enemySpr.setVisible(true);
                } else if (this.attackBeforeCountDownTime == this.attackBeforeEndCountDownTime2 - this.attackBeforeEndCountDownTime2 - 3) {
                    this.enemySpr.setVisible(false);
                } else if (this.attackBeforeCountDownTime == this.attackBeforeEndCountDownTime2 - this.attackBeforeEndCountDownTime2 - 4) {
                    this.enemySpr.setVisible(true);
                } else if (this.attackBeforeCountDownTime == this.attackBeforeEndCountDownTime2 - this.attackBeforeEndCountDownTime2 - 5) {
                    this.enemySpr.setVisible(false);
                }
            } else {
                this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
                this.enemySpr.paint(g);
            }
        } else {
            this.enemySpr.setPosition(this.bgX + 0, this.bgY + 300);
            this.enemySpr.paint(g);
        }
    }

    private void hittenEffectVLoad() {
        if (this.hittenEffectV.size() > 0) {
            this.hittenEffectV.removeAllElements();
            this.hittenEffectV = null;
            System.gc();
        }
        this.hittenEffectV = new Vector();
        for (int i = 0; i < 3; ++i) {
            this.hittenEffectV.addElement(new HittenEffect(i));
        }
    }

    private void hittenEffectVAct() {
        for (int i = 0; i < this.hittenEffectV.size(); ++i) {
            HittenEffect he = (HittenEffect)this.hittenEffectV.elementAt(i);
            he.hittenEffectAct();
        }
    }

    private void hittenEffectVPaint(Graphics g) {
        for (int i = 0; i < this.hittenEffectV.size(); ++i) {
            HittenEffect he = (HittenEffect)this.hittenEffectV.elementAt(i);
            he.hittenEffectPaint(g);
        }
    }

    private void enemyHighHpSprLoad() {
        this.checkSprNull(this.enemyHighHpSpr);
        try {
            Image temp = Image.createImage((String)"/images/ga_hp040.png");
            this.enemyHighHpSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 203);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void enemyHpLightSprLoad() {
        this.checkSprNull(this.enemyHpLightSpr);
        try {
            Image temp = Image.createImage((String)"/images/ga_hp04light.png");
            this.enemyHpLightSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 203);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void enemyHpSprLoad() {
        this.checkSprNull(this.enemyHpSpr);
        try {
            Image temp = Image.createImage((String)"/images/ga_hp04.png");
            this.enemyHpSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 203);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void enemyHpBackSprLoad() {
        this.checkSprNull(this.enemyHpBackSpr);
        try {
            Image temp = Image.createImage((String)"/images/ga_hp03.png");
            this.enemyHpBackSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
    }

    private void enemyHeadSprLoad(int num) {
        this.checkSprNull(this.enemyHeadSpr);
        if (num == 0) {
            try {
                Image temp = Image.createImage((String)"/images/ma01.png");
                this.enemyHeadSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
            }
            catch (IOException e) {}
        } else if (num == 1) {
            try {
                Image temp = Image.createImage((String)"/images/ma02.png");
                this.enemyHeadSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
            }
            catch (IOException e) {}
        } else if (num == 2) {
            try {
                Image temp = Image.createImage((String)"/images/ma03.png");
                this.enemyHeadSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
            }
            catch (IOException e) {}
        } else if (num == 3) {
            try {
                Image temp = Image.createImage((String)"/images/ma04.png");
                this.enemyHeadSpr = new Sprite(temp, temp.getWidth(), temp.getHeight());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.enemyHeadSpr.setPosition(this.bgX + 307, this.bgY + 573);
    }

    private void enemyHeadSprAct() {
        if (this.enemyState == 3 || this.enemyState == 10 || this.enemyState == 18) {
            this.enemyHeadSpr.move(this.RM.nextInt(5) - 2, this.RM.nextInt(5) - 2);
            if (this.enemyHeadSpr.getY() > this.bgY + 575) {
                this.enemyHeadSpr.setPosition(this.bgX + 307, this.bgY + 573);
            } else if (this.enemyHeadSpr.getY() < this.bgY + 571) {
                this.enemyHeadSpr.setPosition(this.bgX + 307, this.bgY + 573);
            } else if (this.enemyHeadSpr.getX() > this.bgX + 309) {
                this.enemyHeadSpr.setPosition(this.bgX + 307, this.bgY + 573);
            } else if (this.enemyHeadSpr.getX() < this.bgX + 305) {
                this.enemyHeadSpr.setPosition(this.bgX + 307, this.bgY + 573);
            }
        } else {
            this.enemyHeadSpr.setPosition(this.bgX + 307, this.bgY + 573);
        }
    }

    private void enemyNameSprLoad(int num) {
        this.checkSprNull(this.enemyNameSpr);
        try {
            Image temp = Image.createImage((String)"/images/mane.png");
            this.enemyNameSpr = new Sprite(temp, temp.getWidth() / 5, temp.getHeight());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (num == 0) {
            this.enemyNameSpr.setFrame(3);
        } else if (num == 1) {
            this.enemyNameSpr.setFrame(2);
        } else if (num == 2) {
            this.enemyNameSpr.setFrame(1);
        } else if (num == 3) {
            this.enemyNameSpr.setFrame(0);
        }
        this.enemyNameSpr.setPosition(this.bgX + 295, this.bgY + 495);
        this.enemyNameSpr.setVisible(false);
    }

    private void enemyNameSprAct() {
        if (this.enemyState == 3 || this.enemyState == 10 || this.enemyState == 18) {
            this.enemyNameSpr.move(this.RM.nextInt(10) - 5, this.RM.nextInt(10) - 5);
            if (this.enemyNameSpr.getY() > this.bgY + 495 + 5) {
                this.enemyNameSpr.setPosition(this.bgX + 295, this.bgY + 495);
            } else if (this.enemyNameSpr.getY() < this.bgY + 495 - 5) {
                this.enemyNameSpr.setPosition(this.bgX + 295, this.bgY + 495);
            } else if (this.enemyNameSpr.getX() > this.bgX + 295 + 5) {
                this.enemyNameSpr.setPosition(this.bgX + 295, this.bgY + 495);
            } else if (this.enemyNameSpr.getX() < this.bgX + 295 - 5) {
                this.enemyNameSpr.setPosition(this.bgX + 295, this.bgY + 495);
            }
        } else {
            this.enemyNameSpr.setPosition(this.bgX + 295, this.bgY + 495);
        }
    }

    private void enemyHpSprPaint(Graphics g) {
        if (this.enemyHp >= 101 && this.enemyHp <= 200) {
            int tempa;
            boolean showtype = false;
            int temphp = this.enemyHpTemp - this.enemyHp;
            if (this.enemyHpTemp > this.enemyHp) {
                tempa = 1;
                if (tempa < temphp) {
                    this.enemyHpTemp -= tempa;
                    showtype = true;
                } else {
                    this.enemyHpTemp = this.enemyHp;
                    showtype = false;
                }
            } else if (this.enemyHpTemp <= this.enemyHp) {
                this.enemyHpTemp = this.enemyHp;
                showtype = false;
            }
            if (!showtype) {
                tempa = (this.enemyHpTemp - 100) * (this.enemyHighHpSpr.getRawFrameCount() / 100);
                if (tempa >= this.enemyHighHpSpr.getRawFrameCount()) {
                    tempa = this.enemyHighHpSpr.getRawFrameCount() - 1;
                }
                if (this.enemyState == 3 || this.enemyState == 10 || this.enemyState == 18) {
                    int i;
                    int tempx = this.RM.nextInt(10) - 5;
                    int tempy = this.RM.nextInt(10) - 5;
                    for (i = 0; i < 200; ++i) {
                        this.enemyHpSpr.setFrame(i);
                        this.enemyHpSpr.setPosition(this.bgX + 321 + tempx, this.bgY + 373 + i + tempy);
                        if (this.enemyHpSpr.getX() > this.bgX + 321 + 5 || this.enemyHpSpr.getX() < this.bgX + 321 - 5) {
                            this.enemyHpSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        } else if (this.enemyHpSpr.getY() > this.bgY + 373 + i + 5 || this.enemyHpSpr.getY() < this.bgY + 373 + i - 5) {
                            this.enemyHpSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        }
                        this.enemyHpSpr.paint(g);
                    }
                    for (i = 0; i < tempa; ++i) {
                        this.enemyHighHpSpr.setFrame(i);
                        this.enemyHighHpSpr.setPosition(this.bgX + 321 + tempx, this.bgY + 373 + i + tempy);
                        if (this.enemyHighHpSpr.getX() > this.bgX + 321 + 5 || this.enemyHighHpSpr.getX() < this.bgX + 321 - 5) {
                            this.enemyHighHpSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        } else if (this.enemyHighHpSpr.getY() > this.bgY + 373 + i + 5 || this.enemyHighHpSpr.getY() < this.bgY + 373 + i - 5) {
                            this.enemyHighHpSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        }
                        this.enemyHighHpSpr.paint(g);
                    }
                    this.enemyHpBackSpr.setPosition(this.bgX + 303 + tempx, this.bgY + 365 + tempy);
                    if (this.enemyHpBackSpr.getX() > this.bgX + 303 + 5 || this.enemyHpBackSpr.getX() < this.bgX + 303 - 5) {
                        this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
                    } else if (this.enemyHpBackSpr.getY() > this.bgY + 365 + 5 || this.enemyHpBackSpr.getY() < this.bgY + 365 - 5) {
                        this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
                    }
                } else {
                    int i;
                    for (i = 0; i < 200; ++i) {
                        this.enemyHpSpr.setFrame(i);
                        this.enemyHpSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        this.enemyHpSpr.paint(g);
                    }
                    for (i = 0; i < tempa; ++i) {
                        this.enemyHighHpSpr.setFrame(i);
                        this.enemyHighHpSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        this.enemyHighHpSpr.paint(g);
                    }
                    this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
                }
            } else if (showtype) {
                tempa = (this.enemyHpTemp - 100) * (this.enemyHpLightSpr.getRawFrameCount() / 100);
                if (tempa >= this.enemyHpLightSpr.getRawFrameCount()) {
                    tempa = this.enemyHpLightSpr.getRawFrameCount() - 1;
                }
                if (this.enemyState == 3 || this.enemyState == 10 || this.enemyState == 18) {
                    int i;
                    int tempx = this.RM.nextInt(10) - 5;
                    int tempy = this.RM.nextInt(10) - 5;
                    for (i = 0; i < 200; ++i) {
                        this.enemyHpSpr.setFrame(i);
                        this.enemyHpSpr.setPosition(this.bgX + 321 + tempx, this.bgY + 373 + i + tempy);
                        if (this.enemyHpSpr.getX() > this.bgX + 321 + 5 || this.enemyHpSpr.getX() < this.bgX + 321 - 5) {
                            this.enemyHpSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        } else if (this.enemyHpSpr.getY() > this.bgY + 373 + i + 5 || this.enemyHpSpr.getY() < this.bgY + 373 + i - 5) {
                            this.enemyHpSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        }
                        this.enemyHpSpr.paint(g);
                    }
                    for (i = 0; i < tempa; ++i) {
                        this.enemyHpLightSpr.setFrame(i);
                        this.enemyHpLightSpr.setPosition(this.bgX + 321 + tempx, this.bgY + 373 + i + tempy);
                        if (this.enemyHpLightSpr.getX() > this.bgX + 321 + 5 || this.enemyHpLightSpr.getX() < this.bgX + 321 - 5) {
                            this.enemyHpLightSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        } else if (this.enemyHpLightSpr.getY() > this.bgY + 373 + i + 5 || this.enemyHpLightSpr.getY() < this.bgY + 373 + i - 5) {
                            this.enemyHpLightSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        }
                        this.enemyHpLightSpr.paint(g);
                    }
                    this.enemyHpBackSpr.setPosition(this.bgX + 303 + tempx, this.bgY + 365 + tempy);
                    if (this.enemyHpBackSpr.getX() > this.bgX + 303 + 5 || this.enemyHpBackSpr.getX() < this.bgX + 303 - 5) {
                        this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
                    } else if (this.enemyHpBackSpr.getY() > this.bgY + 365 + 5 || this.enemyHpBackSpr.getY() < this.bgY + 365 - 5) {
                        this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
                    }
                } else {
                    int i;
                    for (i = 0; i < 200; ++i) {
                        this.enemyHpSpr.setFrame(i);
                        this.enemyHpSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        this.enemyHpSpr.paint(g);
                    }
                    for (i = 0; i < tempa; ++i) {
                        this.enemyHpLightSpr.setFrame(i);
                        this.enemyHpLightSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        this.enemyHpLightSpr.paint(g);
                    }
                    this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
                }
            }
        } else if (this.enemyHp >= 0 && this.enemyHp <= 100) {
            int tempa;
            boolean showtype = false;
            int temphp = this.enemyHpTemp - this.enemyHp;
            if (this.enemyHpTemp > this.enemyHp) {
                tempa = this.RM.nextInt(2) + 1;
                if (tempa < temphp) {
                    this.enemyHpTemp -= tempa;
                    showtype = true;
                } else {
                    this.enemyHpTemp = this.enemyHp;
                    showtype = false;
                }
            } else if (this.enemyHpTemp <= this.enemyHp) {
                this.enemyHpTemp = this.enemyHp;
                showtype = false;
            }
            if (this.enemyHp < 30) {
                ++this.enemyHpActTime;
                if (this.enemyHpActTime >= 0 && this.enemyHpActTime <= 2) {
                    showtype = true;
                } else if (this.enemyHpActTime >= 3 && this.enemyHpActTime <= 5) {
                    showtype = false;
                } else if (this.enemyHpActTime >= 6) {
                    this.enemyHpActTime = 0;
                }
            }
            if (!showtype) {
                tempa = this.enemyHpTemp * (this.enemyHpSpr.getRawFrameCount() / 100);
                if (tempa >= this.enemyHpSpr.getRawFrameCount()) {
                    tempa = this.enemyHpSpr.getRawFrameCount() - 1;
                }
                if (this.enemyState == 3 || this.enemyState == 10 || this.enemyState == 18) {
                    int tempx = this.RM.nextInt(10) - 5;
                    int tempy = this.RM.nextInt(10) - 5;
                    for (int i = 0; i < tempa; ++i) {
                        this.enemyHpSpr.setFrame(i);
                        this.enemyHpSpr.setPosition(this.bgX + 321 + tempx, this.bgY + 373 + i + tempy);
                        if (this.enemyHpSpr.getX() > this.bgX + 321 + 5 || this.enemyHpSpr.getX() < this.bgX + 321 - 5) {
                            this.enemyHpSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        } else if (this.enemyHpSpr.getY() > this.bgY + 373 + i + 5 || this.enemyHpSpr.getY() < this.bgY + 373 + i - 5) {
                            this.enemyHpSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        }
                        this.enemyHpSpr.paint(g);
                    }
                    this.enemyHpBackSpr.setPosition(this.bgX + 303 + tempx, this.bgY + 365 + tempy);
                    if (this.enemyHpBackSpr.getX() > this.bgX + 303 + 5 || this.enemyHpBackSpr.getX() < this.bgX + 303 - 5) {
                        this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
                    } else if (this.enemyHpBackSpr.getY() > this.bgY + 365 + 5 || this.enemyHpBackSpr.getY() < this.bgY + 365 - 5) {
                        this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
                    }
                } else {
                    for (int i = 0; i < tempa; ++i) {
                        this.enemyHpSpr.setFrame(i);
                        this.enemyHpSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        this.enemyHpSpr.paint(g);
                    }
                    this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
                }
            } else if (showtype) {
                tempa = this.enemyHpTemp * (this.enemyHpLightSpr.getRawFrameCount() / 100);
                if (tempa >= this.enemyHpLightSpr.getRawFrameCount()) {
                    tempa = this.enemyHpLightSpr.getRawFrameCount() - 1;
                }
                if (this.enemyState == 3 || this.enemyState == 10 || this.enemyState == 18) {
                    int tempx = this.RM.nextInt(10) - 5;
                    int tempy = this.RM.nextInt(10) - 5;
                    for (int i = 0; i < tempa; ++i) {
                        this.enemyHpLightSpr.setFrame(i);
                        this.enemyHpLightSpr.setPosition(this.bgX + 321 + tempx, this.bgY + 373 + i + tempy);
                        if (this.enemyHpLightSpr.getX() > this.bgX + 321 + 5 || this.enemyHpLightSpr.getX() < this.bgX + 321 - 5) {
                            this.enemyHpLightSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        } else if (this.enemyHpLightSpr.getY() > this.bgY + 373 + i + 5 || this.enemyHpLightSpr.getY() < this.bgY + 373 + i - 5) {
                            this.enemyHpLightSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        }
                        this.enemyHpLightSpr.paint(g);
                    }
                    this.enemyHpBackSpr.setPosition(this.bgX + 303 + tempx, this.bgY + 365 + tempy);
                    if (this.enemyHpBackSpr.getX() > this.bgX + 303 + 5 || this.enemyHpBackSpr.getX() < this.bgX + 303 - 5) {
                        this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
                    } else if (this.enemyHpBackSpr.getY() > this.bgY + 365 + 5 || this.enemyHpBackSpr.getY() < this.bgY + 365 - 5) {
                        this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
                    }
                } else {
                    for (int i = 0; i < tempa; ++i) {
                        this.enemyHpLightSpr.setFrame(i);
                        this.enemyHpLightSpr.setPosition(this.bgX + 321, this.bgY + 373 + i);
                        this.enemyHpLightSpr.paint(g);
                    }
                    this.enemyHpBackSpr.setPosition(this.bgX + 303, this.bgY + 365);
                }
            }
        }
    }

    public void enemyMpSprLoad() {
        this.checkSprNull(this.enemyMpSpr);
        try {
            Image temp = Image.createImage((String)"/images/mp.png");
            this.enemyMpSpr = new Sprite(temp, temp.getWidth(), temp.getHeight() / 215);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void enemySetState(int enemystate) {
        if (enemystate != this.enemyState) {
            this.enemyState = enemystate;
            switch (this.enemyState) {
                case 0: {
                    this.enemySpr.setFrameSequenceData(0);
                    break;
                }
                case 5: {
                    this.enemySpr.setFrameSequenceData(5);
                    break;
                }
                case 4: {
                    this.enemySpr.setFrameSequenceData(4);
                    break;
                }
                case 7: {
                    this.enemySpr.setFrameSequenceData(7);
                    if (this.enemyType != 2) break;
                    if (this.isSkillOn) {
                        this.enemySpr.setFrame(0);
                        break;
                    }
                    this.enemySpr.setFrame(2);
                    break;
                }
                case 6: {
                    this.enemySpr.setFrameSequenceData(6);
                    break;
                }
                case 999: {
                    this.enemySpr.setFrameSequenceData(999);
                    break;
                }
                case 1000: {
                    this.enemySpr.setFrameSequenceData(6);
                    break;
                }
                case 9: {
                    this.enemySpr.setFrameSequenceData(9);
                    break;
                }
                case 8: {
                    this.enemySpr.setFrameSequenceData(8);
                    break;
                }
                case 3: {
                    this.enemySpr.setFrameSequenceData(3);
                    break;
                }
                case 11: {
                    this.enemySpr.setFrameSequenceData(11);
                    break;
                }
                case 10: {
                    this.enemySpr.setFrameSequenceData(10);
                    break;
                }
                case 2: {
                    this.enemySpr.setFrameSequenceData(2);
                    break;
                }
                case 12: {
                    this.enemySpr.setFrameSequenceData(12);
                    break;
                }
                case 13: {
                    this.enemySpr.setFrameSequenceData(13);
                    break;
                }
                case 14: {
                    this.enemySpr.setFrameSequenceData(14);
                    break;
                }
                case 15: {
                    this.enemySpr.setFrameSequenceData(15);
                    if (this.enemyType != 2) break;
                    if (this.isSkillOn) {
                        this.enemySpr.setFrame(0);
                        break;
                    }
                    this.enemySpr.setFrame(2);
                    break;
                }
                case 16: {
                    this.enemySpr.setFrameSequenceData(16);
                    break;
                }
                case 17: {
                    this.enemySpr.setFrameSequenceData(17);
                    break;
                }
                case 18: {
                    this.enemySpr.setFrameSequenceData(18);
                    break;
                }
                case 1: {
                    this.enemySpr.setFrameSequenceData(1);
                    break;
                }
                case 21: {
                    this.enemySpr.setFrameSequenceData(10);
                    break;
                }
                case 22: {
                    this.enemySpr.setFrameSequenceData(8);
                    break;
                }
                case 23: {
                    this.enemySpr.setFrameSequenceData(9);
                    break;
                }
                case 26: {
                    this.enemySpr.setFrameSequenceData(18);
                    break;
                }
                case 27: {
                    this.enemySpr.setFrameSequenceData(16);
                    break;
                }
                case 28: {
                    this.enemySpr.setFrameSequenceData(17);
                }
            }
        }
    }

    public int enemyPreAction(Heroman hm) {
        if (this.enemyState == 0) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(0);
                return 0;
            }
        } else if (this.enemyState == 2) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(2);
                return 2;
            }
        } else if (this.enemyState == 3) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(3);
                return 3;
            }
        } else if (this.enemyState == 5) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(5);
                return 5;
            }
        } else if (this.enemyState == 4) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(4);
                return 4;
            }
        } else if (this.enemyState == 7) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(7);
                return 7;
            }
        } else if (this.enemyState == 6) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(6);
                return 6;
            }
        } else if (this.enemyState == 999) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(999);
                return 999;
            }
        } else if (this.enemyState == 1000) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(3);
                return 1000;
            }
        } else if (this.enemyState == 9) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(9);
                return 9;
            }
        } else if (this.enemyState == 8) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(8);
                return 8;
            }
        } else if (this.enemyState == 10) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(10);
                return 10;
            }
        } else if (this.enemyState == 11) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(11);
                return 11;
            }
        } else if (this.enemyState == 12) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(12);
                return 12;
            }
        } else if (this.enemyState == 13) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(13);
                return 13;
            }
        } else if (this.enemyState == 14) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(14);
                return 14;
            }
        } else if (this.enemyState == 15) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(15);
                return 15;
            }
        } else if (this.enemyState == 16) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(16);
                return 16;
            }
        } else if (this.enemyState == 17) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(17);
                return 17;
            }
        } else if (this.enemyState == 18) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(18);
                return 18;
            }
        } else if (this.enemyState == 1) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(1);
                return 1;
            }
        } else if (this.enemyState == 22) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(8);
                return 22;
            }
        } else if (this.enemyState == 23) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(9);
                return 23;
            }
        } else if (this.enemyState == 21) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(10);
                return 21;
            }
        } else if (this.enemyState == 27) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(16);
                return 22;
            }
        } else if (this.enemyState == 28) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(17);
                return 23;
            }
        } else if (this.enemyState == 26 && this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
            this.enemySpr.setFrameSequenceData(18);
            return 21;
        }
        if (this.enemyState == 1 || this.enemyState == 23 || this.enemyState == 22 || this.enemyState == 21 || this.enemyState == 28 || this.enemyState == 27 || this.enemyState == 26) {
            if (this.enemyState == 1 || this.enemyState == 21 || this.enemyState == 26) {
                this.enemySpr.nextFrame(this.enemySpr.getWaitTime() / 10);
            } else {
                this.enemySpr.nextFrame(this.enemySpr.getWaitTime());
            }
        } else {
            this.enemySpr.nextFrame(this.enemySpr.getWaitTime());
        }
        return 100;
    }

    /*
     * Unable to fully structure code
     */
    public int enemyAction(Heroman hm) {
        block282: {
            block280: {
                block288: {
                    block286: {
                        block287: {
                            block284: {
                                block285: {
                                    block281: {
                                        block283: {
                                            if (!this.isMyRound) break block280;
                                            if (this.enemyState == 0) {
                                                ++this.normalCountDownTime;
                                                if (this.normalCountDownTime >= this.normalEndCountDownTime) {
                                                    tempa = this.RM.nextInt(100);
                                                    if (tempa < this.attackChance) {
                                                        this.enemySetState(4);
                                                        if (this.enemyType == 0) {
                                                            tempb = this.RM.nextInt(2);
                                                            this.isSkillOn = tempb == 0;
                                                        } else if (this.enemyType == 1) {
                                                            tempb = this.RM.nextInt(2);
                                                            this.isSkillOn = tempb == 0;
                                                        }
                                                    } else {
                                                        this.enemySetState(6);
                                                        if (this.enemyType == 0) {
                                                            tempb = this.RM.nextInt(2);
                                                            this.isSkillOn = tempb == 0;
                                                        } else if (this.enemyType == 1) {
                                                            tempb = this.RM.nextInt(2);
                                                            this.isSkillOn = tempb == 0;
                                                        } else if (this.enemyType == 2) {
                                                            tempb = this.RM.nextInt(2);
                                                            this.isSkillOn = tempb == 0;
                                                        }
                                                    }
                                                    this.isAttackBefore = true;
                                                    this.normalCountDownTime = 0;
                                                }
                                            } else if (this.enemyState == 2) {
                                                ++this.normalCountDownTime;
                                                if (this.normalCountDownTime >= this.normalEndCountDownTime) {
                                                    tempa = this.RM.nextInt(100);
                                                    if (tempa < this.attackChance) {
                                                        this.enemySetState(12);
                                                        if (this.enemyType == 0) {
                                                            tempb = this.RM.nextInt(2);
                                                            this.isSkillOn = tempb == 0;
                                                        } else if (this.enemyType == 1) {
                                                            tempb = this.RM.nextInt(2);
                                                            this.isSkillOn = tempb == 0;
                                                        }
                                                    } else {
                                                        this.enemySetState(14);
                                                        if (this.enemyType == 0) {
                                                            tempb = this.RM.nextInt(2);
                                                            this.isSkillOn = tempb == 0;
                                                        } else if (this.enemyType == 1) {
                                                            tempb = this.RM.nextInt(2);
                                                            this.isSkillOn = tempb == 0;
                                                        } else if (this.enemyType == 2) {
                                                            tempb = this.RM.nextInt(2);
                                                            this.isSkillOn = tempb == 0;
                                                        }
                                                    }
                                                    this.isAttackBefore = true;
                                                    this.normalCountDownTime = 0;
                                                }
                                            }
                                            if (this.enemyState != 4) break block281;
                                            if (this.enemyHp < 30) break block282;
                                            ++this.attackBeforeCountDownTime;
                                            if (this.attackBeforeCountDownTime < this.attackBeforeEndCountDownTime1) break block282;
                                            tempb = this.RM.nextInt(5);
                                            if (tempb != 0 || this.enemyType != 1 && this.enemyType != 3) break block283;
                                            this.enemySetState(0);
                                            this.normalCountDownTime = this.normalEndCountDownTime;
                                            this.attackBeforeCountDownTime = 0;
                                            break block282;
                                        }
                                        this.enemySetState(5);
                                        v0 = hm.heromanGetState();
                                        hm.getClass();
                                        if (v0 == 5) ** GOTO lbl-1000
                                        v1 = hm.heromanGetState();
                                        hm.getClass();
                                        if (v1 == 6) lbl-1000:
                                        // 2 sources

                                        {
                                            ++hm.hideCount;
                                            hm.playerDefenceEnemyState = 3;
                                            tempa = this.RM.nextInt(100);
                                            if (tempa < this.playerRehitEnemyChance) {
                                                this.isPlayerRehitEnemy = true;
                                            }
                                        } else {
                                            v2 = hm.heromanGetState();
                                            hm.getClass();
                                            if (v2 == 7) {
                                                ++hm.defenceCount;
                                                hm.heromanHp -= this.attackPoint / this.defenseSuccessPoint - hm.defensePoint;
                                                if (hm.heromanHp <= 0) {
                                                    hm.heromanHp = 0;
                                                }
                                                hm.heromanMp += this.attackPoint - hm.defensePoint;
                                                if (hm.heromanMp >= 100) {
                                                    hm.heromanMp = 100;
                                                }
                                                if (hm.heromanHp <= 0) {
                                                    hm.playeffectMusicPlayer(4);
                                                } else {
                                                    hm.playeffectMusicPlayer(2);
                                                }
                                                hm.getClass();
                                                hm.heromanSetState(8);
                                            } else {
                                                v3 = hm.heromanGetState();
                                                hm.getClass();
                                                if (v3 == 0) {
                                                    ++hm.hurtCount;
                                                    hm.heromanHp -= this.attackPoint - hm.defensePoint;
                                                    if (hm.heromanHp <= 0) {
                                                        hm.heromanHp = 0;
                                                    }
                                                    hm.heromanMp += this.attackPoint - hm.defensePoint;
                                                    if (hm.heromanMp >= 100) {
                                                        hm.heromanMp = 100;
                                                    }
                                                    if (hm.heromanHp <= 0) {
                                                        hm.playeffectMusicPlayer(4);
                                                    } else {
                                                        hm.playeffectMusicPlayer(0);
                                                    }
                                                    System.out.println("\u73a9\u5bb6\u88ab\u8f15\u62f3\u6253\u4e2d");
                                                    hm.getClass();
                                                    hm.heromanSetState(1);
                                                }
                                            }
                                        }
                                        if (this.enemyType == 3) {
                                            tempc = this.RM.nextInt(5);
                                            if (tempc == 0) {
                                                this.normalCountDownTime = this.normalEndCountDownTime;
                                                this.attackBeforeCountDownTime = 0;
                                            } else {
                                                this.attackBeforeCountDownTime = 0;
                                            }
                                        } else {
                                            this.attackBeforeCountDownTime = 0;
                                        }
                                        break block282;
                                    }
                                    if (this.enemyState != 6) break block284;
                                    if (this.enemyHp <= 30) break block282;
                                    ++this.attackBeforeCountDownTime;
                                    if (this.attackBeforeCountDownTime < this.attackBeforeEndCountDownTime2) break block282;
                                    tempb = this.RM.nextInt(5);
                                    if (tempb != 0 || this.enemyType != 1 && this.enemyType != 3) break block285;
                                    this.enemySetState(0);
                                    this.normalCountDownTime = this.normalEndCountDownTime;
                                    this.attackBeforeCountDownTime = 0;
                                    break block282;
                                }
                                this.enemySetState(7);
                                v4 = hm.heromanGetState();
                                hm.getClass();
                                if (v4 == 5) ** GOTO lbl-1000
                                v5 = hm.heromanGetState();
                                hm.getClass();
                                if (v5 == 6) lbl-1000:
                                // 2 sources

                                {
                                    ++hm.hideCount;
                                    hm.playerDefenceEnemyState = 3;
                                    tempa = this.RM.nextInt(100);
                                    if (tempa < this.playerRehitEnemyChance) {
                                        this.isPlayerRehitEnemy = true;
                                    }
                                } else {
                                    v6 = hm.heromanGetState();
                                    hm.getClass();
                                    if (v6 == 7) {
                                        ++hm.defenceCount;
                                        hm.heromanHp -= this.attackPoint * 2 / this.defenseSuccessPoint - hm.defensePoint;
                                        if (hm.heromanHp <= 0) {
                                            hm.heromanHp = 0;
                                        }
                                        hm.heromanMp += this.attackPoint * 2 - hm.defensePoint;
                                        if (hm.heromanMp >= 100) {
                                            hm.heromanMp = 100;
                                        }
                                        if (hm.heromanHp <= 0) {
                                            hm.playeffectMusicPlayer(4);
                                        } else {
                                            hm.playeffectMusicPlayer(2);
                                        }
                                        hm.getClass();
                                        hm.heromanSetState(8);
                                    } else {
                                        v7 = hm.heromanGetState();
                                        hm.getClass();
                                        if (v7 == 0) {
                                            ++hm.hurtCount;
                                            hm.heromanHp -= this.attackPoint * 2 - hm.defensePoint;
                                            if (hm.heromanHp <= 0) {
                                                hm.heromanHp = 0;
                                            }
                                            hm.heromanMp += this.attackPoint * 2 - hm.defensePoint;
                                            if (hm.heromanMp >= 100) {
                                                hm.heromanMp = 100;
                                            }
                                            if (hm.heromanHp <= 0) {
                                                hm.playeffectMusicPlayer(4);
                                            } else {
                                                hm.playeffectMusicPlayer(1);
                                            }
                                            System.out.println("\u73a9\u5bb6\u88ab\u91cd\u64ca\u6253\u4e2d");
                                            hm.getClass();
                                            hm.heromanSetState(1);
                                        }
                                    }
                                }
                                if (this.enemyType == 3) {
                                    tempc = this.RM.nextInt(5);
                                    if (tempc == 0) {
                                        this.normalCountDownTime = this.normalEndCountDownTime;
                                        this.attackBeforeCountDownTime = 0;
                                    } else {
                                        this.attackBeforeCountDownTime = 0;
                                    }
                                } else {
                                    this.attackBeforeCountDownTime = 0;
                                }
                                break block282;
                            }
                            if (this.enemyState != 12) break block286;
                            if (this.enemyHp >= 30) break block282;
                            ++this.attackBeforeCountDownTime;
                            if (this.enemyType == 0) {
                                this.attackBeforeEndCountDownTime1 = this.attackBeforeEndCountDownTime1;
                            } else if (this.enemyType == 1) {
                                this.attackBeforeEndCountDownTime1 = 10;
                            } else if (this.enemyType == 2) {
                                this.attackBeforeEndCountDownTime1 = 15;
                            } else if (this.enemyType == 3) {
                                this.attackBeforeEndCountDownTime1 = this.RM.nextInt(11) + 5;
                            }
                            if (this.attackBeforeCountDownTime < this.attackBeforeEndCountDownTime1) break block282;
                            tempb = this.RM.nextInt(3);
                            if (tempb != 0 || this.enemyType != 1 && this.enemyType != 3) break block287;
                            this.enemySetState(2);
                            this.attackBeforeCountDownTime = 0;
                            this.normalCountDownTime = this.normalEndCountDownTime;
                            break block282;
                        }
                        this.enemySetState(13);
                        v8 = hm.heromanGetState();
                        hm.getClass();
                        if (v8 == 5) ** GOTO lbl-1000
                        v9 = hm.heromanGetState();
                        hm.getClass();
                        if (v9 == 6) lbl-1000:
                        // 2 sources

                        {
                            ++hm.hideCount;
                            hm.playerDefenceEnemyState = 3;
                            tempa = this.RM.nextInt(100);
                            if (tempa < this.playerRehitEnemyChance) {
                                this.isPlayerRehitEnemy = true;
                            }
                        } else {
                            v10 = hm.heromanGetState();
                            hm.getClass();
                            if (v10 == 7) {
                                ++hm.defenceCount;
                                hm.heromanHp -= this.attackPoint / this.defenseSuccessPoint - hm.defensePoint;
                                if (hm.heromanHp <= 0) {
                                    hm.heromanHp = 0;
                                }
                                hm.heromanMp += this.attackPoint - hm.defensePoint;
                                if (hm.heromanMp >= 100) {
                                    hm.heromanMp = 100;
                                }
                                if (hm.heromanHp <= 0) {
                                    hm.playeffectMusicPlayer(4);
                                } else {
                                    hm.playeffectMusicPlayer(2);
                                }
                                hm.getClass();
                                hm.heromanSetState(8);
                            } else {
                                v11 = hm.heromanGetState();
                                hm.getClass();
                                if (v11 == 0) {
                                    ++hm.hurtCount;
                                    hm.heromanHp -= this.attackPoint - hm.defensePoint;
                                    if (hm.heromanHp <= 0) {
                                        hm.heromanHp = 0;
                                    }
                                    hm.heromanMp += this.attackPoint - hm.defensePoint;
                                    if (hm.heromanMp >= 100) {
                                        hm.heromanMp = 100;
                                    }
                                    if (hm.heromanHp <= 0) {
                                        hm.playeffectMusicPlayer(4);
                                    } else {
                                        hm.playeffectMusicPlayer(0);
                                    }
                                    hm.getClass();
                                    hm.heromanSetState(1);
                                }
                            }
                        }
                        if (this.enemyType == 3) {
                            tempc = this.RM.nextInt(5);
                            if (tempc == 0) {
                                this.normalCountDownTime = this.normalEndCountDownTime;
                                this.attackBeforeCountDownTime = 0;
                            } else {
                                this.attackBeforeCountDownTime = 0;
                            }
                        } else {
                            this.attackBeforeCountDownTime = 0;
                        }
                        break block282;
                    }
                    if (this.enemyState != 14 || this.enemyHp >= 30) break block282;
                    ++this.attackBeforeCountDownTime;
                    if (this.enemyType == 0) {
                        this.attackBeforeEndCountDownTime2 = this.attackBeforeEndCountDownTime2;
                    } else if (this.enemyType == 1) {
                        this.attackBeforeEndCountDownTime2 = 15;
                    } else if (this.enemyType == 2) {
                        this.attackBeforeEndCountDownTime2 = 10;
                    } else if (this.enemyType == 3) {
                        this.attackBeforeEndCountDownTime2 = this.RM.nextInt(16) + 10;
                    }
                    if (this.attackBeforeCountDownTime < this.attackBeforeEndCountDownTime2) break block282;
                    tempb = this.RM.nextInt(3);
                    if (tempb != 0 || this.enemyType != 1 && this.enemyType != 3) break block288;
                    this.enemySetState(2);
                    this.attackBeforeCountDownTime = 0;
                    this.normalCountDownTime = this.normalEndCountDownTime;
                    break block282;
                }
                this.enemySetState(15);
                v12 = hm.heromanGetState();
                hm.getClass();
                if (v12 == 5) ** GOTO lbl-1000
                v13 = hm.heromanGetState();
                hm.getClass();
                if (v13 == 6) lbl-1000:
                // 2 sources

                {
                    ++hm.hideCount;
                    hm.playerDefenceEnemyState = 3;
                    tempa = this.RM.nextInt(100);
                    if (tempa < this.playerRehitEnemyChance) {
                        this.isPlayerRehitEnemy = true;
                    }
                } else {
                    v14 = hm.heromanGetState();
                    hm.getClass();
                    if (v14 == 7) {
                        ++hm.defenceCount;
                        hm.heromanHp -= this.attackPoint * 2 / this.defenseSuccessPoint - hm.defensePoint;
                        if (hm.heromanHp <= 0) {
                            hm.heromanHp = 0;
                        }
                        hm.heromanMp += this.attackPoint * 2 - hm.defensePoint;
                        if (hm.heromanMp >= 100) {
                            hm.heromanMp = 100;
                        }
                        if (hm.heromanHp <= 0) {
                            hm.playeffectMusicPlayer(4);
                        } else {
                            hm.playeffectMusicPlayer(2);
                        }
                        hm.getClass();
                        hm.heromanSetState(8);
                    } else {
                        v15 = hm.heromanGetState();
                        hm.getClass();
                        if (v15 == 0) {
                            ++hm.hurtCount;
                            hm.heromanHp -= this.attackPoint * 2 - hm.defensePoint;
                            if (hm.heromanHp <= 0) {
                                hm.heromanHp = 0;
                            }
                            hm.heromanMp += this.attackPoint * 2 - hm.defensePoint;
                            if (hm.heromanMp >= 100) {
                                hm.heromanMp = 100;
                            }
                            if (hm.heromanHp <= 0) {
                                hm.playeffectMusicPlayer(4);
                            } else {
                                hm.playeffectMusicPlayer(1);
                            }
                            hm.getClass();
                            hm.heromanSetState(1);
                        }
                    }
                }
                if (this.enemyType == 3) {
                    tempc = this.RM.nextInt(5);
                    if (tempc == 0) {
                        this.normalCountDownTime = this.normalEndCountDownTime;
                        this.attackBeforeCountDownTime = 0;
                    } else {
                        this.attackBeforeCountDownTime = 0;
                    }
                } else {
                    this.attackBeforeCountDownTime = 0;
                }
                break block282;
            }
            v16 = hm.heromanState;
            hm.getClass();
            if (v16 == 0) {
                ++this.enemySpecialMoveStartTime;
                if (this.enemySpecialMoveStartTime >= this.enemySpecialMoveEndTime) {
                    this.enemySpecialMoveStartTime = 0;
                    ismove = this.RM.nextInt(20);
                    if (ismove < 20) {
                        this.isEnemySpecialMove = true;
                        if (this.enemyHp < 30) {
                            moveselect = this.RM.nextInt(4);
                            if (moveselect == 0) {
                                this.enemySetState(26);
                            } else if (moveselect == 1) {
                                this.enemySetState(26);
                            } else if (moveselect == 2) {
                                this.enemySetState(27);
                            } else if (moveselect == 3) {
                                this.enemySetState(28);
                            }
                        } else {
                            moveselect = this.RM.nextInt(6);
                            if (moveselect == 0) {
                                this.enemySetState(1);
                            } else if (moveselect == 1) {
                                this.enemySetState(1);
                            } else if (moveselect == 2) {
                                this.enemySetState(21);
                            } else if (moveselect == 3) {
                                this.enemySetState(21);
                            } else if (moveselect == 4) {
                                this.enemySetState(23);
                            } else if (moveselect == 5) {
                                this.enemySetState(22);
                            }
                        }
                    } else {
                        this.isEnemySpecialMove = false;
                    }
                }
            } else {
                this.enemySpecialMoveStartTime = 0;
                this.isEnemySpecialMove = false;
            }
        }
        this.enemyHeadSprAct();
        this.enemyNameSprAct();
        this.talkVAct();
        if (this.enemyState == 0 || this.enemyState == 21 || this.enemyState == 23 || this.enemyState == 22 || this.enemyState == 1) {
            ++this.enemyTalkStartTime;
            if (this.enemyTalkStartTime >= this.enemyTalkEndTime) {
                this.enemyTalkStartTime = 0;
                tempa = this.RM.nextInt(this.enemyTalkChance);
                if (tempa == 0) {
                    tempb = this.RM.nextInt(2);
                    if (tempb == 0) {
                        for (i = 0; i < this.talkV.size(); ++i) {
                            tk = (Talk)this.talkV.elementAt(i);
                            if (tk.talkType != 0) {
                                tk.isAct = false;
                                continue;
                            }
                            if (tk.isAct) continue;
                            tk.talkSpr.setVisible(true);
                            tk.talkBackRSpr.setVisible(true);
                            tk.talkBackLSpr.setVisible(true);
                            tk.actStartX = this.enemySpr.getX();
                            tk.actStartY = this.enemySpr.getY();
                            tk.actRL = this.RM.nextInt(2);
                            if (tk.actRL == 0) {
                                tk.talkSpr.setPosition(tk.talkBackRSpr.getX() + 17, tk.talkBackRSpr.getY() + 28);
                            } else {
                                tk.talkSpr.setPosition(tk.talkBackLSpr.getX() + 17, tk.talkBackLSpr.getY() + 13);
                            }
                            tk.isAct = true;
                        }
                    } else {
                        for (i = 0; i < this.talkV.size(); ++i) {
                            tk = (Talk)this.talkV.elementAt(i);
                            if (tk.talkType != 1) {
                                tk.isAct = false;
                                continue;
                            }
                            if (tk.isAct) continue;
                            tk.talkSpr.setVisible(true);
                            tk.talkBackRSpr.setVisible(true);
                            tk.talkBackLSpr.setVisible(true);
                            tk.actStartX = this.enemySpr.getX();
                            tk.actStartY = this.enemySpr.getY();
                            tk.actRL = this.RM.nextInt(2);
                            if (tk.actRL == 0) {
                                tk.talkSpr.setPosition(tk.talkBackRSpr.getX() + 17, tk.talkBackRSpr.getY() + 28);
                            } else {
                                tk.talkSpr.setPosition(tk.talkBackLSpr.getX() + 17, tk.talkBackLSpr.getY() + 13);
                            }
                            tk.isAct = true;
                        }
                    }
                }
            }
        } else if (this.enemyState == 2 || this.enemyState == 21 || this.enemyState == 27 || this.enemyState == 28) {
            ++this.enemyTalkStartTime;
            if (this.enemyTalkStartTime >= this.enemyTalkEndTime) {
                this.enemyTalkStartTime = 0;
                tempa = this.RM.nextInt(this.enemyTalkChance);
                if (tempa == 0 && (tempb = this.RM.nextInt(2)) == 0) {
                    for (i = 0; i < this.talkV.size(); ++i) {
                        tk = (Talk)this.talkV.elementAt(i);
                        if (tk.talkType != 2) {
                            tk.isAct = false;
                            continue;
                        }
                        if (tk.isAct) continue;
                        tk.talkSpr.setVisible(true);
                        tk.talkBackRSpr.setVisible(true);
                        tk.talkBackLSpr.setVisible(true);
                        tk.actStartX = this.enemySpr.getX();
                        tk.actStartY = this.enemySpr.getY();
                        tk.actRL = this.RM.nextInt(2);
                        if (tk.actRL == 0) {
                            tk.talkSpr.setPosition(tk.talkBackRSpr.getX() + 17, tk.talkBackRSpr.getY() + 28);
                        } else {
                            tk.talkSpr.setPosition(tk.talkBackLSpr.getX() + 17, tk.talkBackLSpr.getY() + 13);
                        }
                        tk.isAct = true;
                    }
                }
            }
        } else if (this.enemyState == 9 || this.enemyState == 8 || this.enemyState == 17 || this.enemyState == 16) {
            this.enemyTalkStartTime = 0;
            if (this.enemyHp < 30 && this.enemySpr.getFrame() == 1) {
                tempa = this.RM.nextInt(this.enemyTalkChance);
                if (tempa == 0 && (tempb = this.RM.nextInt(2)) == 0) {
                    for (i = 0; i < this.talkV.size(); ++i) {
                        tk = (Talk)this.talkV.elementAt(i);
                        if (tk.talkType != 4) {
                            tk.isAct = false;
                            continue;
                        }
                        if (tk.isAct) continue;
                        tk.talkSpr.setVisible(true);
                        tk.talkBackRSpr.setVisible(true);
                        tk.talkBackLSpr.setVisible(true);
                        tk.actStartX = this.enemySpr.getX();
                        tk.actStartY = this.enemySpr.getY();
                        tk.actRL = this.RM.nextInt(2);
                        if (tk.actRL == 0) {
                            tk.talkSpr.setPosition(tk.talkBackRSpr.getX() + 17, tk.talkBackRSpr.getY() + 28);
                        } else {
                            tk.talkSpr.setPosition(tk.talkBackLSpr.getX() + 17, tk.talkBackLSpr.getY() + 13);
                        }
                        tk.isAct = true;
                    }
                }
            } else if (this.enemySpr.getFrame() == 1 && (tempa = this.RM.nextInt(this.enemyTalkChance)) == 0 && (tempb = this.RM.nextInt(2)) == 0) {
                for (i = 0; i < this.talkV.size(); ++i) {
                    tk = (Talk)this.talkV.elementAt(i);
                    if (tk.talkType != 3) {
                        tk.isAct = false;
                        continue;
                    }
                    if (tk.isAct) continue;
                    tk.talkSpr.setVisible(true);
                    tk.talkBackRSpr.setVisible(true);
                    tk.talkBackLSpr.setVisible(true);
                    tk.actStartX = this.enemySpr.getX();
                    tk.actStartY = this.enemySpr.getY();
                    tk.actRL = this.RM.nextInt(2);
                    if (tk.actRL == 0) {
                        tk.talkSpr.setPosition(tk.talkBackRSpr.getX() + 17, tk.talkBackRSpr.getY() + 28);
                    } else {
                        tk.talkSpr.setPosition(tk.talkBackLSpr.getX() + 17, tk.talkBackLSpr.getY() + 13);
                    }
                    tk.isAct = true;
                }
            }
        } else if (this.enemyState == 5 || this.enemyState == 7 || this.enemyState == 999 || this.enemyState == 13 || this.enemyState == 15) {
            // empty if block
        }
        this.hittenEffectVAct();
        if (this.enemyState == 5 || this.enemyState == 7 || this.enemyState == 999 || this.enemyState == 13 || this.enemyState == 15) {
            v17 = hm.heromanState;
            hm.getClass();
            if (v17 == 1) {
                if (this.enemyState != 5 && this.enemyState != 13) {
                    if (this.enemyState == 7 || this.enemyState == 15) {
                        for (i = 0; i < this.hittenEffectV.size(); ++i) {
                            he = (HittenEffect)this.hittenEffectV.elementAt(i);
                            if (he.hittenEffectType != 0) {
                                he.isAct = false;
                                continue;
                            }
                            if (he.isAct) continue;
                            he.hittenEffectSpr.setVisible(true);
                            he.actStartX = hm.heromanSpr.getX();
                            he.actStartY = hm.heromanSpr.getY();
                            he.isAct = true;
                        }
                    } else if (this.enemyState == 999) {
                        for (i = 0; i < this.hittenEffectV.size(); ++i) {
                            he = (HittenEffect)this.hittenEffectV.elementAt(i);
                            if (he.hittenEffectType != 1) {
                                he.isAct = false;
                                continue;
                            }
                            if (he.isAct) continue;
                            he.hittenEffectSpr.setVisible(true);
                            he.actStartX = hm.heromanSpr.getX();
                            he.actStartY = hm.heromanSpr.getY();
                            he.isAct = true;
                        }
                    }
                }
            } else {
                v18 = hm.heromanState;
                hm.getClass();
                if (v18 == 8) {
                    for (i = 0; i < this.hittenEffectV.size(); ++i) {
                        he = (HittenEffect)this.hittenEffectV.elementAt(i);
                        if (he.hittenEffectType != 2) {
                            he.isAct = false;
                            continue;
                        }
                        if (he.isAct) continue;
                        he.hittenEffectSpr.setVisible(true);
                        he.actStartX = hm.heromanSpr.getX();
                        he.actStartY = hm.heromanSpr.getY();
                        he.isAct = true;
                    }
                }
            }
        }
        if (this.enemyState == 0) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(0);
                return 0;
            }
        } else if (this.enemyState == 2) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(2);
                return 2;
            }
        } else if (this.enemyState == 3) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(3);
                return 3;
            }
        } else if (this.enemyState == 5) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(5);
                return 5;
            }
        } else if (this.enemyState == 4) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(4);
                return 4;
            }
        } else if (this.enemyState == 7) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(7);
                return 7;
            }
        } else if (this.enemyState == 6) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(6);
                return 6;
            }
        } else if (this.enemyState == 999) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(999);
                return 999;
            }
        } else if (this.enemyState == 1000) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(3);
                return 1000;
            }
        } else if (this.enemyState == 9) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(9);
                return 9;
            }
        } else if (this.enemyState == 8) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(8);
                return 8;
            }
        } else if (this.enemyState == 10) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(10);
                return 10;
            }
        } else if (this.enemyState == 11) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(11);
                return 11;
            }
        } else if (this.enemyState == 12) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(12);
                return 12;
            }
        } else if (this.enemyState == 13) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(13);
                return 13;
            }
        } else if (this.enemyState == 14) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(14);
                return 14;
            }
        } else if (this.enemyState == 15) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(15);
                return 15;
            }
        } else if (this.enemyState == 16) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(16);
                return 16;
            }
        } else if (this.enemyState == 17) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(17);
                return 17;
            }
        } else if (this.enemyState == 18) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(18);
                return 18;
            }
        } else if (this.enemyState == 1) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(1);
                return 1;
            }
        } else if (this.enemyState == 22) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(8);
                return 22;
            }
        } else if (this.enemyState == 23) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(9);
                return 23;
            }
        } else if (this.enemyState == 21) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(10);
                return 21;
            }
        } else if (this.enemyState == 27) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(16);
                return 22;
            }
        } else if (this.enemyState == 28) {
            if (this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
                this.enemySpr.setFrameSequenceData(17);
                return 23;
            }
        } else if (this.enemyState == 26 && this.enemySpr.getFrame() == this.enemySpr.getFrameCount() - 1) {
            this.enemySpr.setFrameSequenceData(18);
            return 21;
        }
        if (this.enemyState == 1 || this.enemyState == 23 || this.enemyState == 22 || this.enemyState == 21 || this.enemyState == 28 || this.enemyState == 27 || this.enemyState == 26) {
            if (this.enemyState == 1 || this.enemyState == 21 || this.enemyState == 26) {
                this.enemySpr.nextFrame();
            } else {
                this.enemySpr.nextFrame();
            }
        } else if (this.enemyState == 6 && this.enemyType == 2) {
            if (this.isSkillOn) {
                this.enemySpr.nextFrame();
            } else {
                this.enemySpr.setFrame(0);
            }
        } else if (this.enemyState == 14 && this.enemyType == 2) {
            if (this.isSkillOn) {
                this.enemySpr.nextFrame();
            } else {
                this.enemySpr.setFrame(0);
            }
        } else if (this.enemyState == 2 || this.enemyState == 18 || this.enemyState == 13 || this.enemyState == 15 || this.enemyState == 17 || this.enemyState == 16) {
            this.enemySpr.nextFrame();
        } else {
            this.enemySpr.nextFrame();
        }
        return 100;
    }

    public void enemySprPaint(Graphics g) {
        this.enemySpr.paint(g);
    }

    public void enemyPaint(Graphics g) {
        this.enemySkillAct(g);
        this.enemyHpBackSpr.paint(g);
        this.enemyNameSpr.paint(g);
        this.enemyHeadSpr.paint(g);
        this.enemyHpSprPaint(g);
        this.talkVPaint(g);
        this.hittenEffectVPaint(g);
    }

    public int enemyGetState() {
        return this.enemyState;
    }

    private void talkVAct() {
        for (int i = 0; i < this.talkV.size(); ++i) {
            Talk tk = (Talk)this.talkV.elementAt(i);
            tk.talkAct();
        }
    }

    private void talkVPaint(Graphics g) {
        for (int i = 0; i < this.talkV.size(); ++i) {
            Talk tk = (Talk)this.talkV.elementAt(i);
            tk.talkPaint(g);
        }
    }

    public void makEffectMusicPlayer(int type) {
        if (type == 0) {
            this.effectMusicPlayer[0] = new SoundObj("/sounds/effect/npclighthit.wav", "audio/x-wav");
            this.effectMusicPlayer[0].set_IsRepeat(false);
            Enemy enemy = this;
            this.effectMusicPlayer[0].setVolume(enemy.kcp.getVolume());
        } else if (type == 1) {
            this.effectMusicPlayer[1] = new SoundObj("/sounds/effect/npcheavyhit.wav", "audio/x-wav");
            this.effectMusicPlayer[1].set_IsRepeat(false);
            Enemy enemy = this;
            this.effectMusicPlayer[1].setVolume(enemy.kcp.getVolume());
        } else if (type == 2) {
            this.effectMusicPlayer[2] = new SoundObj("/sounds/effect/npcgreathit.wav", "audio/x-wav");
            this.effectMusicPlayer[2].set_IsRepeat(false);
            Enemy enemy = this;
            this.effectMusicPlayer[2].setVolume(enemy.kcp.getVolume());
        } else if (type == 3) {
            this.effectMusicPlayer[3] = new SoundObj("/sounds/effect/npcdeadhit.wav", "audio/x-wav");
            this.effectMusicPlayer[3].set_IsRepeat(false);
            Enemy enemy = this;
            this.effectMusicPlayer[3].setVolume(enemy.kcp.getVolume());
        } else if (type == 4) {
            this.effectMusicPlayer[4] = new SoundObj("/sounds/effect/defence.wav", "audio/x-wav");
            this.effectMusicPlayer[4].set_IsRepeat(false);
            Enemy enemy = this;
            this.effectMusicPlayer[4].setVolume(enemy.kcp.getVolume());
        } else if (type == 5) {
            this.effectMusicPlayer[5] = new SoundObj("/sounds/effect/hide.wav", "audio/x-wav");
            this.effectMusicPlayer[5].set_IsRepeat(false);
            Enemy enemy = this;
            this.effectMusicPlayer[5].setVolume(enemy.kcp.getVolume());
        } else if (type == 6) {
            this.effectMusicPlayer[6] = new SoundObj("/sounds/effect/npclasthit.wav", "audio/x-wav");
            this.effectMusicPlayer[6].set_IsRepeat(false);
            Enemy enemy = this;
            this.effectMusicPlayer[6].setVolume(enemy.kcp.getVolume());
        }
    }

    private void closeEffectMusic() {
        for (int i = 0; i < this.effectMusicPlayer.length; ++i) {
            if (this.effectMusicPlayer[i] == null) continue;
            System.out.println("enemy\u522a\u9664\u97f3\u6548\u524d");
            this.effectMusicPlayer[i].close();
            this.effectMusicPlayer[i] = null;
            System.out.println("enemy\u522a\u9664\u97f3\u6548\u5f8c");
            System.gc();
        }
    }

    public void playeffectMusicPlayer(int type) {
        if (type == type && this.effectMusicPlayer[type] != null) {
            this.effectMusicPlayer[type].playSound(1);
        }
    }

    private void Screen240() {
        this.bgX = KeyCodePerformer.screenX;
        this.bgY = KeyCodePerformer.screenY;
    }

    private void Screen176() {
        this.bgX = KeyCodePerformer.screenX;
        this.bgY = KeyCodePerformer.screenY;
    }

    private void checkSprNull(Sprite spr) {
        if (spr != null) {
            spr = null;
            System.gc();
        }
    }

    private void checkNewSprNull(NewSprite nspr) {
        if (nspr != null) {
            nspr = null;
            System.gc();
        }
    }
}

