/*
 * Decompiled with CFR 0.152.
 */
public class HVS {
    int MAX;
    int Red;
    int Green;
    int Blue;
    int Hue;
    int Saturation;
    int Value;

    void SetRGBToHsv(int R, int G, int B) {
        this.Red = R;
        this.Green = G;
        this.Blue = B;
        this.ToHsv();
    }

    void ToHsv() {
        int fMn;
        this.MAX = 1000;
        int fRed = this.Red * this.MAX / 255;
        int fGreen = this.Green * this.MAX / 255;
        int fBlue = this.Blue * this.MAX / 255;
        int fMx = fRed;
        if (fGreen > fMx) {
            fMx = fGreen;
        }
        if (fBlue > fMx) {
            fMx = fBlue;
        }
        if (fGreen < (fMn = fRed)) {
            fMn = fGreen;
        }
        if (fBlue < fMn) {
            fMn = fBlue;
        }
        int fVa = fMx;
        int fSa = fMx > 0 ? (fMx - fMn) * this.MAX / fMx : 0;
        if (fSa == 0) {
            this.Hue = 0;
        } else {
            int fRc = (fMx - fRed) * this.MAX / (fMx - fMn);
            int fGc = (fMx - fGreen) * this.MAX / (fMx - fMn);
            int fBc = (fMx - fBlue) * this.MAX / (fMx - fMn);
            if (fMx == fRed) {
                this.Hue = fBc - fGc;
            } else if (fMx == fGreen) {
                this.Hue = 2 * this.MAX + fRc - fBc;
            } else if (fMx == fBlue) {
                this.Hue = 4 * this.MAX + fGc - fRc;
            }
            this.Hue = this.Hue / (this.MAX / 10) * 6;
            if (this.Hue < 0) {
                this.Hue += 360;
            }
        }
        this.Saturation = fSa / (this.MAX / 100);
        this.Value = fVa / (this.MAX / 100);
    }

    void ToRgb() {
        int fRed = 0;
        int fGreen = 0;
        int fBlue = 0;
        int fSaturation = this.Saturation * (this.MAX / 100);
        int fValue = this.Value * (this.MAX / 100);
        if (this.Saturation == 0) {
            fRed = fValue;
            fGreen = fValue;
            fBlue = fValue;
        } else {
            int fHue;
            int t = fHue = this.Hue / 60;
            int nI = fHue * this.MAX;
            fHue = fHue == 6 ? 0 : this.Hue * this.MAX / 60;
            int fF = fHue - nI;
            int fP = fValue * (1 * this.MAX - fSaturation) / this.MAX;
            int fQ = fValue * (1 * this.MAX - fSaturation * fF / this.MAX) / this.MAX;
            int fT = fValue * (1 * this.MAX - fSaturation * (1 * this.MAX - fF) / this.MAX) / this.MAX;
            switch (t) {
                case 0: {
                    fRed = fValue;
                    fGreen = fT;
                    fBlue = fP;
                    break;
                }
                case 1: {
                    fRed = fQ;
                    fGreen = fValue;
                    fBlue = fP;
                    break;
                }
                case 2: {
                    fRed = fP;
                    fGreen = fValue;
                    fBlue = fT;
                    break;
                }
                case 3: {
                    fRed = fP;
                    fGreen = fQ;
                    fBlue = fValue;
                    break;
                }
                case 4: {
                    fRed = fT;
                    fGreen = fP;
                    fBlue = fValue;
                    break;
                }
                case 5: {
                    fRed = fValue;
                    fGreen = fP;
                    fBlue = fQ;
                }
            }
        }
        this.Red = 25599 * fRed / this.MAX;
        this.Red /= 100;
        this.Green = 25599 * fGreen / this.MAX;
        this.Green /= 100;
        this.Blue = 25599 * fBlue / this.MAX;
        this.Blue /= 100;
    }
}

