/*
 * Decompiled with CFR 0.152.
 */
package menu;

import containers.Localizaton;
import framework.AppState;
import framework.MainGameCanvas;
import framework.graphics.SimpleSprite;
import framework.graphics.TextRenderer;
import framework.menu.MenuForm;
import framework.sound.Music;
import framework.utils.rms.RMSUtils;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import menu.MainMenu;
import menu.RMSSettings;
import menu.RMSTournament;
import root.GoolGlobals;

public class TournamentState
extends AppState {
    private Image background;
    public static int[] teams = new int[GoolGlobals.TEAM_NUMBER];
    public static int[] teamsPhaze2 = new int[GoolGlobals.TEAM_NUMBER / 2];
    public static int[] teamsPhaze3 = new int[GoolGlobals.TEAM_NUMBER / 4];
    public static int[] teamsOut = new int[GoolGlobals.TEAM_NUMBER];
    public static int[] teamsOut2 = new int[GoolGlobals.TEAM_NUMBER / 2];
    public static int[] teamsOut3 = new int[GoolGlobals.TEAM_NUMBER / 4];
    public int outIndex = 0;
    public Random rand = new Random();
    public Vector availbleTeams = new Vector();
    public SimpleSprite[] teamAvat;
    public SimpleSprite kreski;
    public SimpleSprite kreski2;
    public SimpleSprite kreski3;
    public Image gap;
    public Image obfuscator;
    public SimpleSprite tmpObfuscator;
    public Image titleBG;
    public int[] rgb;
    public MenuForm tableMenu;
    public MenuForm mainMenu;
    public int arrowFrame = 0;
    public long startBlink = 0L;
    public long blinkTime = 300L;
    public long menuMoveStart = 0L;
    public long menuMoveSpeed = 50L;
    private int menuWidth;
    private int menuHeight;
    private long currentTime;
    private boolean upPressed = false;
    private boolean downPressed = false;
    private boolean leftPressed = false;
    private boolean rightPressed = false;
    private int[] phaze1ID = new int[GoolGlobals.TEAM_NUMBER];
    private int[] kreski1ID = new int[GoolGlobals.TEAM_NUMBER / 2];
    private int[] phaze2ID = new int[GoolGlobals.TEAM_NUMBER / 2];
    private int[] kreski2ID = new int[GoolGlobals.TEAM_NUMBER / 2 - 2];
    private int[] phaze3ID = new int[GoolGlobals.TEAM_NUMBER / 4];
    private int phaze4ID;
    private static int currentPhaze = 0;
    private int kreski3ID;
    private int selectTeamTextX;
    private StringBuffer selectBuffer = Localizaton.TITLE_TOURNAMENT;
    private int selectedID;
    private static int nextOpponent;
    private int continueID;
    private TextRenderer renderer = TextRenderer.getInstance();
    public static RMSTournament tourRecord;
    public static RMSSettings settingsRecord;

    public TournamentState(String stateName, MainGameCanvas mainGameCanvas) {
        super(stateName, mainGameCanvas);
    }

    public void startTournament() {
        int i = 0;
        int chosen = 0;
        GoolGlobals.tournamentStarted = true;
        for (i = 0; i < GoolGlobals.TEAM_NUMBER; ++i) {
            this.availbleTeams.addElement(new Integer(i));
        }
        for (i = 0; i < GoolGlobals.TEAM_NUMBER; ++i) {
            chosen = Math.abs(this.rand.nextInt()) % this.availbleTeams.size();
            TournamentState.teams[i] = (Integer)this.availbleTeams.elementAt(chosen);
            this.availbleTeams.removeElementAt(chosen);
        }
        for (i = 0; i < GoolGlobals.TEAM_NUMBER; i += 2) {
            if (teams[i] == GoolGlobals.currentPlayerTeam) {
                nextOpponent = teams[i + 1];
                continue;
            }
            if (teams[i + 1] != GoolGlobals.currentPlayerTeam) continue;
            nextOpponent = teams[i];
        }
        currentPhaze = 0;
    }

    public static void createSave() {
        RMSUtils.createRecordStore("tour");
        RMSUtils.storeRecord("tour", tourRecord);
    }

    public static void saveSettings() {
        try {
            Vector tourVector;
            RecordStore.openRecordStore((String)"sett", (boolean)false);
            try {
                tourVector = RMSUtils.loadRecords("sett", Class.forName("menu.RMSSettings"));
            }
            catch (ClassNotFoundException exc) {
                throw new RuntimeException("Impossible!");
            }
            settingsRecord = (RMSSettings)tourVector.elementAt(0);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public static void saveGame() {
        int i;
        TournamentState.saveSettings();
        RMSSettings.save = 1;
        RMSUtils.updateRecord("sett", settingsRecord);
        MainMenu.createMenu();
        for (i = 0; i < 8; ++i) {
            RMSTournament.team[i] = (byte)teams[i];
        }
        for (i = 0; i < 8; ++i) {
            RMSTournament.teamsOut[i] = (byte)teamsOut[i];
        }
        RMSTournament.winGame = 0;
        RMSTournament.goalEnemy = 0;
        RMSTournament.goalPlayer = 0;
        RMSTournament.currentPhase = (byte)currentPhaze;
        RMSTournament.nextOpponent = (byte)nextOpponent;
        RMSTournament.currentTeam = (byte)GoolGlobals.currentPlayerTeam;
        GoolGlobals.goalPlayer = 0;
        GoolGlobals.goalEnemy = 0;
        GoolGlobals.score = 0;
        GoolGlobals.winGame = 0;
        RMSUtils.updateRecord("tour", tourRecord);
    }

    public static void saveNextGame() {
        int i;
        for (i = 0; i < 8; ++i) {
            RMSTournament.team[i] = (byte)teams[i];
            RMSTournament.teamsOut[i] = (byte)teamsOut[i];
        }
        for (i = 0; i < 4; ++i) {
            RMSTournament.teamsPhaze2[i] = (byte)teamsPhaze2[i];
            RMSTournament.teamsOut2[i] = (byte)teamsOut2[i];
        }
        for (i = 0; i < 2; ++i) {
            RMSTournament.teamsPhaze3[i] = (byte)teamsPhaze3[i];
            RMSTournament.teamsOut3[i] = (byte)teamsOut3[i];
        }
        RMSTournament.currentPhase = (byte)currentPhaze;
        RMSTournament.nextOpponent = (byte)nextOpponent;
        RMSTournament.winGame = (byte)GoolGlobals.winGame;
        RMSTournament.goalEnemy = (byte)GoolGlobals.goalEnemy;
        RMSTournament.goalPlayer = (byte)GoolGlobals.goalPlayer;
        RMSUtils.updateRecord("tour", tourRecord);
    }

    public static void loadGame() {
        int i;
        for (i = 0; i < 8; ++i) {
            TournamentState.teams[i] = RMSTournament.team[i];
            TournamentState.teamsOut[i] = RMSTournament.teamsOut[i];
        }
        nextOpponent = RMSTournament.nextOpponent;
        currentPhaze = RMSTournament.currentPhase;
        for (i = 0; i < 4; ++i) {
            TournamentState.teamsPhaze2[i] = RMSTournament.teamsPhaze2[i];
            TournamentState.teamsOut2[i] = RMSTournament.teamsOut2[i];
        }
        for (i = 0; i < 2; ++i) {
            TournamentState.teamsPhaze3[i] = RMSTournament.teamsPhaze3[i];
            TournamentState.teamsOut3[i] = RMSTournament.teamsOut3[i];
        }
    }

    public boolean initialize(Object param) {
        GoolGlobals.clearMenuImages();
        this.loadImages();
        try {
            Vector tourVector;
            RecordStore.openRecordStore((String)"tour", (boolean)false);
            try {
                tourVector = RMSUtils.loadRecords("tour", Class.forName("menu.RMSTournament"));
            }
            catch (ClassNotFoundException exc) {
                throw new RuntimeException("Impossible!");
            }
            tourRecord = (RMSTournament)tourVector.elementAt(0);
            TournamentState.loadGame();
        }
        catch (RecordStoreException ex) {
            tourRecord = new RMSTournament(0, 0, 0, 0);
            TournamentState.createSave();
        }
        if (!GoolGlobals.tournamentStarted) {
            this.startTournament();
            for (int i = 0; i < 8; ++i) {
                TournamentState.teamsOut[i] = teams[i];
            }
            GoolGlobals.endTournament = false;
            TournamentState.saveGame();
            this.createTableMenu();
        } else if (GoolGlobals.nextPhaze) {
            if (this.tableMenu == null) {
                this.createTableMenu();
            }
            this.createPhazeResults();
            if (currentPhaze == 1) {
                for (int i = 0; i < 4; ++i) {
                    TournamentState.teamsOut2[i] = teamsPhaze2[i];
                    System.out.println(teamsOut2[i]);
                }
            } else if (currentPhaze == 2) {
                for (int i = 0; i < 2; ++i) {
                    TournamentState.teamsOut3[i] = teamsPhaze3[i];
                }
            }
            if (currentPhaze == 3) {
                TournamentState.saveSettings();
                RMSSettings.save = 0;
                RMSUtils.updateRecord("sett", settingsRecord);
            }
            TournamentState.saveNextGame();
            GoolGlobals.nextPhaze = false;
        } else {
            GoolGlobals.winGame = RMSTournament.winGame;
            GoolGlobals.goalEnemy = RMSTournament.goalEnemy;
            GoolGlobals.goalPlayer = RMSTournament.goalPlayer;
        }
        GoolGlobals.currentPlayerTeam = RMSTournament.currentTeam;
        if (this.tableMenu == null) {
            this.createTableMenu();
        }
        this.createMainMenu();
        if (currentPhaze == 0) {
            for (int i = 0; i < teams.length; ++i) {
                if (GoolGlobals.currentPlayerTeam != teams[i]) continue;
                this.selectedID = this.phaze1ID[i];
            }
        } else if (currentPhaze == 1) {
            for (int i = 0; i < teamsPhaze2.length; ++i) {
                if (GoolGlobals.currentPlayerTeam != teamsPhaze2[i]) continue;
                this.selectedID = this.phaze2ID[i];
            }
        } else if (currentPhaze == 2) {
            for (int i = 0; i < teamsPhaze3.length; ++i) {
                if (GoolGlobals.currentPlayerTeam != teamsPhaze3[i]) continue;
                this.selectedID = this.phaze3ID[i];
            }
        } else if (GoolGlobals.playerWon) {
            this.selectedID = this.phaze4ID;
        }
        this.mainMenu.controls[this.continueID].isVisible = GoolGlobals.playerWon || currentPhaze == 0 || GoolGlobals.tournamentStarted;
        return true;
    }

    public void update(int deltaTime) {
        this.currentTime = System.currentTimeMillis();
        if (this.startBlink == 0L) {
            this.startBlink = this.currentTime;
        } else if (this.currentTime - this.startBlink > this.blinkTime) {
            this.arrowFrame = this.arrowFrame == 0 ? ++this.arrowFrame : --this.arrowFrame;
            this.startBlink = this.currentTime;
        }
        if (this.leftPressed || this.rightPressed || this.upPressed || this.downPressed) {
            if (this.menuMoveStart == 0L) {
                this.menuMoveStart = this.currentTime;
            } else if (this.currentTime - this.menuMoveStart > this.menuMoveSpeed) {
                if (this.leftPressed && this.tableMenu.absoluteX < 0) {
                    this.changeMenuOffset(-8, 0, this.tableMenu);
                }
                if (this.rightPressed && this.tableMenu.absoluteX > -(this.menuWidth - 240)) {
                    this.changeMenuOffset(8, 0, this.tableMenu);
                }
                if (this.upPressed && this.tableMenu.absoluteY < 0) {
                    this.changeMenuOffset(0, -8, this.tableMenu);
                }
                if (this.downPressed && this.tableMenu.absoluteY > -this.menuHeight) {
                    this.changeMenuOffset(0, 8, this.tableMenu);
                }
                this.menuMoveStart = this.currentTime;
            }
        } else {
            this.menuMoveStart = 0L;
        }
    }

    public void keyPressed(int keyCode) {
        block27: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                if (keyCode == -2) break block18;
                                                if (keyCode != 56) break block19;
                                            }
                                            this.downPressed = true;
                                        }
                                        if (keyCode == -1) break block20;
                                        if (keyCode != 50) break block21;
                                    }
                                    this.upPressed = true;
                                }
                                if (keyCode == -3) break block22;
                                if (keyCode != 52) break block23;
                            }
                            this.leftPressed = true;
                        }
                        if (keyCode == -4) break block24;
                        if (keyCode != 54) break block25;
                    }
                    this.rightPressed = true;
                }
                if (keyCode == 42) {
                    GoolGlobals.playerWon = true;
                    this.initialize(null);
                }
                if (keyCode == -7) {
                    GoolGlobals.continueTheGame = false;
                    TournamentState.saveSettings();
                    RMSSettings.continueGame = 0;
                    RMSUtils.updateRecord("sett", settingsRecord);
                    this.mainGameCanvas.requestAppStateChange("Menu");
                }
                if (keyCode == -6) break block26;
                if (keyCode == -5) break block26;
                if (keyCode != 53) break block27;
            }
            if ((GoolGlobals.playerWon || currentPhaze == 0 || GoolGlobals.tournamentStarted) && !GoolGlobals.endTournament) {
                this.mainGameCanvas.requestAppStateChange("Game");
            }
        }
    }

    public void keyReleased(int keyCode) {
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        if (keyCode == -2) break block8;
                                        if (keyCode != 56) break block9;
                                    }
                                    this.downPressed = false;
                                }
                                if (keyCode == -1) break block10;
                                if (keyCode != 50) break block11;
                            }
                            this.upPressed = false;
                        }
                        if (keyCode == -3) break block12;
                        if (keyCode != 52) break block13;
                    }
                    this.leftPressed = false;
                }
                if (keyCode == -4) break block14;
                if (keyCode != 54) break block15;
            }
            this.rightPressed = false;
        }
    }

    public void render(Graphics g) {
        g.drawImage(this.background, 0, 0, 0);
        this.tableMenu.drawMenu(g);
        int i = 0;
        if (currentPhaze > 0) {
            for (i = 0; i < this.phaze1ID.length; ++i) {
                if (teams[i] != -1) continue;
                g.drawImage(this.obfuscator, this.tableMenu.controls[this.phaze1ID[i]].pozX, this.tableMenu.controls[this.phaze1ID[i]].pozY, 2 | 1);
            }
        }
        if (currentPhaze > 1) {
            for (i = 0; i < this.phaze2ID.length; ++i) {
                if (teamsPhaze2[i] != -1) continue;
                g.drawImage(this.obfuscator, this.tableMenu.controls[this.phaze2ID[i]].pozX, this.tableMenu.controls[this.phaze2ID[i]].pozY, 2 | 1);
            }
        }
        if (currentPhaze > 2) {
            for (i = 0; i < this.phaze3ID.length; ++i) {
                if (teamsPhaze3[i] != -1) continue;
                g.drawImage(this.obfuscator, this.tableMenu.controls[this.phaze3ID[i]].pozX, this.tableMenu.controls[this.phaze3ID[i]].pozY, 2 | 1);
            }
        }
        g.drawImage(this.gap, this.tableMenu.controls[this.selectedID].pozX, this.tableMenu.controls[this.selectedID].pozY, 2 | 1);
        if (this.tableMenu.absoluteY < 0) {
            GoolGlobals.smUpArrow.paintWithAnchor(g, 120, this.titleBG.getHeight() + 2, this.arrowFrame, 0x10 | 1);
        }
        if (this.tableMenu.absoluteX < 0) {
            GoolGlobals.smUpArrow.paintWithAnchor(g, 0, 160, this.arrowFrame, 6, 2 | 4);
        }
        if (this.tableMenu.absoluteY > -this.menuHeight) {
            GoolGlobals.smDownArrow.paintWithAnchor(g, 120, 320, this.arrowFrame, 0x20 | 1);
        }
        if (this.tableMenu.absoluteX > -(this.menuWidth - 240)) {
            GoolGlobals.smDownArrow.paintWithAnchor(g, 240, 160, this.arrowFrame, 6, 2 | 8);
        }
        this.mainMenu.drawMenu(g);
        int titleCount = 240 / this.titleBG.getWidth();
        ++titleCount;
        for (int ii = 0; ii < titleCount; ++ii) {
            g.drawImage(this.titleBG, ii * this.titleBG.getWidth(), 0, 0x10 | 4);
        }
        this.renderer.renderText(g, this.selectTeamTextX, 0, Localizaton.TITLE_TOURNAMENT);
    }

    public void deinitialize() {
        this.background = null;
        this.teamAvat = null;
        this.gap = null;
        this.kreski = null;
        this.kreski2 = null;
        this.kreski3 = null;
        this.rgb = null;
        this.obfuscator = null;
        this.titleBG = null;
        this.tmpObfuscator = null;
        GoolGlobals.currentTournamentPhaze = currentPhaze;
        GoolGlobals.currentOpponentTeam = nextOpponent;
        if (GoolGlobals.playerWon || currentPhaze > 0) {
            // empty if block
        }
        GoolGlobals.playerWon = false;
        System.gc();
    }

    private void loadImages() {
        try {
            Image temp;
            this.background = Image.createImage((String)"/background2.jpg");
            this.teamAvat = new SimpleSprite[GoolGlobals.TEAM_NUMBER];
            for (int i = 0; i < GoolGlobals.TEAM_NUMBER; ++i) {
                temp = Image.createImage((String)("/teams/0" + i + "_avatar.png"));
                this.teamAvat[i] = new SimpleSprite(temp, 1);
            }
            this.gap = Image.createImage((String)"/teams/selected.png");
            temp = Image.createImage((String)"/kreski.png");
            this.kreski = new SimpleSprite(temp, 3);
            temp = Image.createImage((String)"/kreski2.png");
            this.kreski2 = new SimpleSprite(temp, 3);
            temp = Image.createImage((String)"/kreski3.png");
            this.kreski3 = new SimpleSprite(temp, 3);
            this.obfuscator = Image.createImage((String)"/panel.png");
            this.titleBG = Image.createImage((String)"/teams/title_bg.png");
            this.selectTeamTextX = 120 - this.renderer.getStringWidth(Localizaton.TITLE_TOURNAMENT.length()) / 2;
        }
        catch (Exception e) {
            System.out.println("blad podczas wczytywania tej calej masy obrazkow");
            e.printStackTrace();
        }
        this.rgb = new int[this.teamAvat[0].frameWidth * this.teamAvat[0].frameHeight];
        for (int a = 0; a < this.rgb.length; ++a) {
            this.rgb[a] = Integer.MIN_VALUE;
        }
        this.tmpObfuscator = new SimpleSprite(this.obfuscator, 1);
        this.obfuscator = Image.createRGBImage((int[])this.rgb, (int)this.teamAvat[0].frameWidth, (int)this.teamAvat[0].frameHeight, (boolean)true);
    }

    private void createTableMenu() {
        int upBorder = 20;
        this.menuWidth = 240 + this.kreski.frameWidth + this.teamAvat[0].frameWidth;
        int[] cols = new int[]{-1, this.teamAvat[0].frameWidth, this.kreski.frameWidth, this.teamAvat[0].frameWidth, this.kreski.frameWidth, this.teamAvat[0].frameWidth, this.kreski.frameWidth, this.teamAvat[0].frameWidth, -1};
        int[] rows = new int[]{this.titleBG.getHeight() * 2, this.teamAvat[0].frameHeight, upBorder, this.teamAvat[0].frameHeight, upBorder, this.teamAvat[0].frameHeight, upBorder, this.teamAvat[0].frameHeight, upBorder, this.teamAvat[0].frameHeight, upBorder, this.teamAvat[0].frameHeight, upBorder, this.teamAvat[0].frameHeight, upBorder, this.teamAvat[0].frameHeight, -1};
        this.menuHeight = this.teamAvat[0].frameHeight * 9 + this.titleBG.getHeight() * 2 + upBorder * 7 - 320;
        this.tableMenu = MenuForm.createMenuForm(22, rows, cols, this.menuWidth, 640, (byte)1, (byte)0);
        this.phaze1ID[0] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 1, 1, 18, this.teamAvat[teamsOut[0]]);
        this.phaze1ID[1] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 3, 1, 18, this.teamAvat[teamsOut[1]]);
        this.phaze1ID[2] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 5, 1, 18, this.teamAvat[teamsOut[2]]);
        this.phaze1ID[3] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 7, 1, 18, this.teamAvat[teamsOut[3]]);
        this.phaze1ID[4] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 9, 1, 18, this.teamAvat[teamsOut[4]]);
        this.phaze1ID[5] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 11, 1, 18, this.teamAvat[teamsOut[5]]);
        this.phaze1ID[6] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 13, 1, 18, this.teamAvat[teamsOut[6]]);
        this.phaze1ID[7] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 15, 1, 18, this.teamAvat[teamsOut[7]]);
        this.kreski1ID[0] = this.tableMenu.createImage(this.kreski.frameWidth, this.kreski.frameHeight, 2, 2, 18, this.kreski);
        this.kreski1ID[1] = this.tableMenu.createImage(this.kreski.frameWidth, this.kreski.frameHeight, 6, 2, 18, this.kreski);
        this.kreski1ID[2] = this.tableMenu.createImage(this.kreski.frameWidth, this.kreski.frameHeight, 10, 2, 18, this.kreski);
        this.kreski1ID[3] = this.tableMenu.createImage(this.kreski.frameWidth, this.kreski.frameHeight, 14, 2, 18, this.kreski);
        if (currentPhaze < 1) {
            this.phaze2ID[0] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 2, 3, 18, this.tmpObfuscator);
            this.phaze2ID[1] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 6, 3, 18, this.tmpObfuscator);
            this.phaze2ID[2] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 10, 3, 18, this.tmpObfuscator);
            this.phaze2ID[3] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 14, 3, 18, this.tmpObfuscator);
        } else {
            this.phaze2ID[0] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 2, 3, 18, this.teamAvat[teamsOut2[0]]);
            this.phaze2ID[1] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 6, 3, 18, this.teamAvat[teamsOut2[1]]);
            this.phaze2ID[2] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 10, 3, 18, this.teamAvat[teamsOut2[2]]);
            this.phaze2ID[3] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 14, 3, 18, this.teamAvat[teamsOut2[3]]);
        }
        this.kreski2ID[0] = this.tableMenu.createImage(this.kreski.frameWidth, this.kreski.frameHeight, 4, 4, 18, this.kreski2);
        this.kreski2ID[1] = this.tableMenu.createImage(this.kreski.frameWidth, this.kreski.frameHeight, 12, 4, 18, this.kreski2);
        if (currentPhaze < 2) {
            this.phaze3ID[0] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 4, 5, 18, this.tmpObfuscator);
            this.phaze3ID[1] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 12, 5, 18, this.tmpObfuscator);
        } else {
            this.phaze3ID[0] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 4, 5, 18, this.teamAvat[teamsOut3[0]]);
            this.phaze3ID[1] = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 12, 5, 18, this.teamAvat[teamsOut3[1]]);
        }
        this.kreski3ID = this.tableMenu.createImage(this.kreski.frameWidth, this.kreski.frameHeight, 8, 6, 18, this.kreski3);
        this.phaze4ID = this.tableMenu.createImage(this.teamAvat[0].frameWidth, this.teamAvat[0].frameHeight, 8, 7, 18, this.tmpObfuscator);
        System.out.println("end");
    }

    private void createMainMenu() {
        int[] rows = new int[]{-1};
        int[] cols = new int[]{-1};
        this.mainMenu = MenuForm.createMenuForm(2, rows, cols, 240, 320, (byte)1, (byte)1);
        if (!GoolGlobals.endTournament) {
            this.continueID = this.mainMenu.createControl(2, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 0, 0, 33, 18, GoolGlobals.button, Localizaton.PLAY, 0, 0);
            this.mainMenu.setRendererFonts(this.continueID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        } else {
            this.continueID = this.mainMenu.createControl(2, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 0, 0, 33, 18, null, Localizaton.EMPTY, 0, 0);
        }
        int tempID = this.mainMenu.createControl(2, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 0, 0, 36, 18, GoolGlobals.button, Localizaton.BACK, 0, 0);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
    }

    public void clearTeam(int[] table, int team) {
        for (int i = 0; i < table.length; ++i) {
            if (table[i] != team) continue;
            table[i] = -1;
        }
    }

    public void createPhazeResults() {
        int i = 0;
        if (currentPhaze == 0) {
            for (i = 0; i < teams.length; i += 2) {
                if (GoolGlobals.currentPlayerTeam == teams[i] || GoolGlobals.currentPlayerTeam == teams[i + 1]) {
                    if (GoolGlobals.playerWon) {
                        TournamentState.teamsPhaze2[i / 2] = GoolGlobals.currentPlayerTeam;
                        if (GoolGlobals.currentPlayerTeam == teams[i]) {
                            TournamentState.teams[i + 1] = -1;
                            this.tableMenu.controls[this.kreski1ID[i / 2]].state = 1;
                            this.tableMenu.controls[this.phaze2ID[i / 2]].image = this.teamAvat[teams[i]];
                            continue;
                        }
                        TournamentState.teams[i] = -1;
                        this.tableMenu.controls[this.kreski1ID[i / 2]].state = 2;
                        this.tableMenu.controls[this.phaze2ID[i / 2]].image = this.teamAvat[teams[i + 1]];
                        continue;
                    }
                    TournamentState.teamsPhaze2[i / 2] = GoolGlobals.currentOpponentTeam;
                    if (GoolGlobals.currentPlayerTeam == teams[i]) {
                        TournamentState.teams[i] = -1;
                        this.tableMenu.controls[this.kreski1ID[i / 2]].state = 2;
                        this.tableMenu.controls[this.phaze2ID[i / 2]].image = this.teamAvat[teams[i + 1]];
                        continue;
                    }
                    TournamentState.teams[i + 1] = -1;
                    this.tableMenu.controls[this.kreski1ID[i / 2]].state = 1;
                    this.tableMenu.controls[this.phaze2ID[i / 2]].image = this.teamAvat[teams[i]];
                    continue;
                }
                if (this.rand.nextInt() % 2 == 0) {
                    TournamentState.teamsPhaze2[i / 2] = teams[i + 1];
                    TournamentState.teams[i] = -1;
                    this.tableMenu.controls[this.kreski1ID[i / 2]].state = 2;
                    this.tableMenu.controls[this.phaze2ID[i / 2]].image = this.teamAvat[teams[i + 1]];
                    continue;
                }
                TournamentState.teamsPhaze2[i / 2] = teams[i];
                TournamentState.teams[i + 1] = -1;
                this.tableMenu.controls[this.kreski1ID[i / 2]].state = 1;
                this.tableMenu.controls[this.phaze2ID[i / 2]].image = this.teamAvat[teams[i]];
            }
            for (i = 0; i < teamsPhaze2.length; i += 2) {
                if (teamsPhaze2[i] == GoolGlobals.currentPlayerTeam) {
                    nextOpponent = teamsPhaze2[i + 1];
                    continue;
                }
                if (teamsPhaze2[i + 1] != GoolGlobals.currentPlayerTeam) continue;
                nextOpponent = teamsPhaze2[i];
            }
        } else if (currentPhaze == 1) {
            for (i = 0; i < teamsPhaze2.length; i += 2) {
                if (GoolGlobals.currentPlayerTeam == teamsPhaze2[i] || GoolGlobals.currentPlayerTeam == teamsPhaze2[i + 1]) {
                    if (GoolGlobals.playerWon) {
                        TournamentState.teamsPhaze3[i / 2] = GoolGlobals.currentPlayerTeam;
                        if (GoolGlobals.currentPlayerTeam == teamsPhaze2[i]) {
                            this.clearTeam(teams, teamsPhaze2[i + 1]);
                            TournamentState.teamsPhaze2[i + 1] = -1;
                            this.tableMenu.controls[this.kreski2ID[i / 2]].state = 1;
                            this.tableMenu.controls[this.phaze3ID[i / 2]].image = this.teamAvat[teamsPhaze2[i]];
                            continue;
                        }
                        this.clearTeam(teams, teamsPhaze2[i]);
                        TournamentState.teamsPhaze2[i] = -1;
                        this.tableMenu.controls[this.kreski2ID[i / 2]].state = 2;
                        this.tableMenu.controls[this.phaze3ID[i / 2]].image = this.teamAvat[teamsPhaze2[i + 1]];
                        continue;
                    }
                    TournamentState.teamsPhaze3[i / 2] = GoolGlobals.currentOpponentTeam;
                    if (GoolGlobals.currentPlayerTeam == teamsPhaze2[i]) {
                        this.clearTeam(teams, teamsPhaze2[i]);
                        TournamentState.teamsPhaze2[i] = -1;
                        this.tableMenu.controls[this.kreski2ID[i / 2]].state = 2;
                        this.tableMenu.controls[this.phaze3ID[i / 2]].image = this.teamAvat[teamsPhaze2[i + 1]];
                        continue;
                    }
                    this.clearTeam(teams, teamsPhaze2[i + 1]);
                    TournamentState.teamsPhaze2[i + 1] = -1;
                    this.tableMenu.controls[this.kreski2ID[i / 2]].state = 1;
                    this.tableMenu.controls[this.phaze3ID[i / 2]].image = this.teamAvat[teamsPhaze2[i]];
                    continue;
                }
                if (this.rand.nextInt() % 2 == 0) {
                    TournamentState.teamsPhaze3[i / 2] = teamsPhaze2[i];
                    this.clearTeam(teams, teamsPhaze2[i + 1]);
                    TournamentState.teamsPhaze2[i + 1] = -1;
                    this.tableMenu.controls[this.kreski2ID[i / 2]].state = 1;
                    this.tableMenu.controls[this.phaze3ID[i / 2]].image = this.teamAvat[teamsPhaze2[i]];
                    continue;
                }
                TournamentState.teamsPhaze3[i / 2] = teamsPhaze2[i + 1];
                this.clearTeam(teams, teamsPhaze2[i]);
                TournamentState.teamsPhaze2[i] = -1;
                this.tableMenu.controls[this.kreski2ID[i / 2]].state = 2;
                this.tableMenu.controls[this.phaze3ID[i / 2]].image = this.teamAvat[teamsPhaze2[i + 1]];
            }
            for (i = 0; i < teamsPhaze3.length; i += 2) {
                if (teamsPhaze3[i] == GoolGlobals.currentPlayerTeam) {
                    nextOpponent = teamsPhaze3[i + 1];
                    continue;
                }
                if (teamsPhaze3[i + 1] != GoolGlobals.currentPlayerTeam) continue;
                nextOpponent = teamsPhaze3[i];
            }
        } else if (currentPhaze == 2) {
            if (GoolGlobals.playerWon) {
                if (teamsPhaze3[0] == GoolGlobals.currentPlayerTeam) {
                    this.tableMenu.controls[this.phaze4ID].image = this.teamAvat[teamsPhaze3[0]];
                    this.tableMenu.controls[this.kreski3ID].state = 1;
                    this.clearTeam(teamsPhaze2, teamsPhaze3[1]);
                    TournamentState.teamsPhaze3[1] = -1;
                } else {
                    this.tableMenu.controls[this.phaze4ID].image = this.teamAvat[teamsPhaze3[1]];
                    this.clearTeam(teamsPhaze2, teamsPhaze3[0]);
                    TournamentState.teamsPhaze3[0] = -1;
                    this.tableMenu.controls[this.kreski3ID].state = 2;
                }
            } else if (teamsPhaze3[0] == GoolGlobals.currentPlayerTeam) {
                this.tableMenu.controls[this.phaze4ID].image = this.teamAvat[teamsPhaze3[1]];
                this.clearTeam(teamsPhaze2, teamsPhaze3[0]);
                TournamentState.teamsPhaze3[0] = -1;
                this.tableMenu.controls[this.kreski3ID].state = 2;
            } else {
                this.tableMenu.controls[this.phaze4ID].image = this.teamAvat[teamsPhaze3[0]];
                this.clearTeam(teamsPhaze2, teamsPhaze3[1]);
                TournamentState.teamsPhaze3[1] = -1;
                this.tableMenu.controls[this.kreski3ID].state = 1;
            }
        }
        ++currentPhaze;
    }

    public void changeMenuOffset(int xOffset, int yOffset, MenuForm menu) {
        for (int i = 0; i < menu.controls.length; ++i) {
            menu.controls[i].textPozX -= xOffset;
            menu.controls[i].pozX -= xOffset;
            menu.controls[i].textPozY -= yOffset;
            menu.controls[i].pozY -= yOffset;
        }
        menu.absoluteX -= xOffset;
        menu.absoluteY -= yOffset;
    }

    public void pauseStateChanged(boolean paused) {
        super.pauseStateChanged(paused);
        if (GoolGlobals.playMusic) {
            if (paused) {
                Music.stopMusic();
            } else {
                Music.playMusic(GoolGlobals.menuMusicId);
            }
        }
    }
}

