/*
 * Decompiled with CFR 0.152.
 */
package framework.utils.cheatmode;

public class CheatSequence {
    protected int[] sequence;
    private StringBuffer result = new StringBuffer();

    public CheatSequence() {
        this.sequence = new int[0];
    }

    public CheatSequence(int[] keys) {
        this.sequence = new int[keys.length];
        System.arraycopy(keys, 0, this.sequence, 0, keys.length);
    }

    public CheatSequence(int key) {
        this.sequence = new int[1];
        this.sequence[0] = key;
    }

    public CheatSequence(int key1, int key2) {
        this.sequence = new int[2];
        this.sequence[0] = key1;
        this.sequence[1] = key2;
    }

    public CheatSequence(int key1, int key2, int key3) {
        this.sequence = new int[3];
        this.sequence[0] = key1;
        this.sequence[1] = key2;
        this.sequence[2] = key3;
    }

    public void clear(int keyCode) {
        for (int i = 0; i < this.sequence.length; ++i) {
            this.sequence[i] = keyCode;
        }
    }

    public void shiftLeft() {
        for (int i = 0; i < this.sequence.length - 1; ++i) {
            this.sequence[i] = this.sequence[i + 1];
        }
    }

    public void write(int index, int keyCode) {
        if (index < 0 || index >= this.sequence.length) {
            throw new RuntimeException("Invalid key sequence index.");
        }
        this.sequence[index] = keyCode;
    }

    public int read(int index) {
        if (index < 0 || index >= this.sequence.length) {
            throw new RuntimeException("Invalid key sequence index.");
        }
        return this.sequence[index];
    }

    public StringBuffer toStringBuffer() {
        this.result.setLength(0);
        for (int i = 0; i < this.sequence.length; ++i) {
            this.result.append(this.sequence[i]);
            this.result.append(' ');
        }
        return this.result;
    }

    public int getLength() {
        return this.sequence.length;
    }

    public boolean equals(Object obj) {
        int pos;
        CheatSequence cheatSequence = null;
        try {
            cheatSequence = (CheatSequence)obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (this.getLength() != cheatSequence.getLength()) {
            return false;
        }
        for (pos = 0; pos < this.getLength() && this.sequence[pos] == cheatSequence.sequence[pos]; ++pos) {
        }
        return pos == this.getLength();
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.sequence.length; ++i) {
            hash += this.sequence[i];
        }
        return hash;
    }
}

