/*
 * Decompiled with CFR 0.152.
 */
package framework.menu;

import framework.graphics.SimpleSprite;
import framework.graphics.TextRenderer;
import framework.menu.IMenuFormListener;
import framework.menu.MenuControl;
import javax.microedition.lcdui.Graphics;

public final class MenuForm {
    public static final byte KEYS_UPDOWN = 0;
    public static final byte KEYS_LEFTRIGHT = 1;
    public static final byte PIXEL_SPACING = 1;
    public static final byte PERCENTAGE_SPACING = 0;
    public static final byte AUTO_SPACING = -1;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 4;
    public static final int TOP = 8;
    public static final int MIDDLE = 16;
    public static final int BOTTOM = 32;
    public static final int STATE_CONTROL_IDLE = 0;
    public static final int STATE_CONTROL_FOCUS = 1;
    public static final int STATE_CONTROL_PUSHED = 2;
    public static byte nextId = (byte)-1;
    public MenuControl[] controls;
    public int absoluteX = 0;
    public int absoluteY = 0;
    public IMenuFormListener listener;
    public byte id;
    private byte lastAddedControl = (byte)-1;
    private int[] columnX;
    private int[] rowY;
    public int focusedID = -1;
    private byte activeControlKeys;
    private TextRenderer renderer;
    private int canvasWidth;
    private int canvasHeight;
    public int keyDelay = 200;
    public int fireDelay = 300;
    private int keyDelayTimer = 0;
    private int fireDelayTimer = 0;
    private int visibleRowCount;
    private int fpRC = 0;
    private int allRowCount;

    private MenuForm(byte ID, int controlCount, int[] rowSpacing, int[] columnSpacing, int canvasWidth, int canvasHeight, byte settingsFlag, byte activeControlKeys, int visibleRowCount) {
        int i = 0;
        int partSum = 0;
        int tempSum = 0;
        int defaultCount = 0;
        int defaultSize = 0;
        this.canvasHeight = canvasHeight;
        this.canvasWidth = canvasWidth;
        this.renderer = TextRenderer.getInstance();
        this.id = ID;
        this.controls = new MenuControl[controlCount];
        this.rowY = new int[rowSpacing.length];
        this.columnX = new int[columnSpacing.length];
        this.activeControlKeys = activeControlKeys;
        this.visibleRowCount = visibleRowCount;
        this.allRowCount = controlCount - 2;
        for (i = 0; i < rowSpacing.length; ++i) {
            if (settingsFlag == 0 && rowSpacing[i] > 100) {
                throw new RuntimeException("Bad percent: " + rowSpacing[i]);
            }
            if (rowSpacing[i] > 0) {
                this.rowY[i] = settingsFlag == 0 ? canvasHeight * rowSpacing[i] / 100 : rowSpacing[i];
                partSum += this.rowY[i];
                continue;
            }
            ++defaultCount;
        }
        if (defaultCount > 0) {
            defaultSize = (canvasHeight - partSum) / defaultCount;
        }
        partSum = 0;
        for (i = 0; i < rowSpacing.length; ++i) {
            if (rowSpacing[i] > 0) {
                tempSum = this.rowY[i];
                this.rowY[i] = partSum;
                partSum += tempSum;
                continue;
            }
            this.rowY[i] = partSum;
            partSum += defaultSize;
        }
        defaultCount = canvasHeight - partSum;
        int n = this.rowY.length - 1;
        this.rowY[n] = this.rowY[n] + defaultCount;
        partSum = 0;
        defaultCount = 0;
        defaultSize = 0;
        tempSum = 0;
        for (i = 0; i < columnSpacing.length; ++i) {
            if (settingsFlag == 0 && columnSpacing[i] > 100) {
                throw new RuntimeException("Bad percent: " + columnSpacing[i]);
            }
            if (columnSpacing[i] > 0) {
                this.columnX[i] = settingsFlag == 0 ? canvasWidth * columnSpacing[i] / 100 : columnSpacing[i];
                partSum += this.columnX[i];
                continue;
            }
            ++defaultCount;
        }
        if (defaultCount > 0) {
            defaultSize = (canvasWidth - partSum) / defaultCount;
        }
        partSum = 0;
        tempSum = 0;
        for (i = 0; i < columnSpacing.length; ++i) {
            if (columnSpacing[i] > 0) {
                tempSum = this.columnX[i];
                this.columnX[i] = partSum;
                partSum += tempSum;
                continue;
            }
            this.columnX[i] = partSum;
            partSum += defaultSize;
        }
        defaultCount = canvasWidth - partSum;
        int n2 = this.columnX.length - 1;
        this.columnX[n2] = this.columnX[n2] + defaultCount;
    }

    public static MenuForm createMenuForm(int controlCount, int[] rowSpacing, int[] columnsSpacing, int canvasWidth, int canvasHeight, byte settingsFlag, byte activeControlKeys) {
        nextId = (byte)(nextId + 1);
        return new MenuForm(nextId, controlCount, rowSpacing, columnsSpacing, canvasWidth, canvasHeight, settingsFlag, activeControlKeys, 0);
    }

    public static MenuForm createMenuForm(int controlCount, int[] rowSpacing, int[] columnsSpacing, int canvasWidth, int canvasHeight, byte settingsFlag, byte activeControlKeys, int visibleRowCount) {
        nextId = (byte)(nextId + 1);
        return new MenuForm(nextId, controlCount, rowSpacing, columnsSpacing, canvasWidth, canvasHeight, settingsFlag, activeControlKeys, visibleRowCount);
    }

    public int createControl(int type, int width, int height, int tabOrder, int row, int column, int cellAlignment, int textAlignment, SimpleSprite images, StringBuffer text, int textPadding, int cellPadding) {
        this.lastAddedControl = (byte)(this.lastAddedControl + 1);
        if (this.lastAddedControl >= this.controls.length) {
            throw new RuntimeException("More controls added the declared!!");
        }
        MenuControl newControl = new MenuControl();
        newControl.type = type;
        newControl.tabOrder = tabOrder;
        newControl.textAlignment = textAlignment;
        newControl.image = images;
        newControl.text = text;
        newControl.isVisible = true;
        newControl.state = 0;
        newControl.textPadding = textPadding;
        newControl.width = width;
        newControl.height = height;
        newControl.anchor = 0;
        if ((cellAlignment & 8) != 0) {
            newControl.relativeY = this.rowY[row] + cellPadding;
            newControl.anchor |= 0x10;
        } else if ((cellAlignment & 0x10) != 0) {
            newControl.relativeY = row < this.rowY.length - 1 ? this.rowY[row] + (this.rowY[row + 1] - this.rowY[row]) / 2 : this.rowY[row] + (this.canvasHeight - this.rowY[row]) / 2;
            newControl.anchor |= 2;
        } else if ((cellAlignment & 0x20) != 0) {
            newControl.relativeY = row < this.rowY.length - 1 ? this.rowY[row] + (this.rowY[row + 1] - this.rowY[row]) - cellPadding : this.rowY[row] + (this.canvasHeight - this.rowY[row]) - cellPadding;
            newControl.anchor |= 0x20;
        }
        if ((cellAlignment & 1) != 0) {
            newControl.relativeX = this.columnX[column] + cellPadding;
            newControl.anchor |= 4;
        } else if ((cellAlignment & 2) != 0) {
            newControl.relativeX = column < this.columnX.length - 1 ? this.columnX[column] + (this.columnX[column + 1] - this.columnX[column] >> 1) : this.columnX[column] + (this.canvasWidth - this.columnX[column] >> 1);
            newControl.anchor |= 1;
        } else if ((cellAlignment & 4) != 0) {
            newControl.relativeX = column < this.columnX.length - 1 ? this.columnX[column] + (this.columnX[column + 1] - this.columnX[column]) - cellPadding : this.canvasWidth - cellPadding;
            newControl.anchor |= 8;
        }
        if (type != 6 && type != 1) {
            newControl.calculatePositions(this.absoluteX, this.absoluteY, this.renderer);
        }
        this.controls[this.lastAddedControl] = newControl;
        if (tabOrder == 0 && this.focusedID < 0) {
            this.focusedID = this.lastAddedControl;
            this.controls[this.lastAddedControl].state = 1;
        }
        this.setRendererFonts(this.lastAddedControl, "FONT_NORMAL", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED_2");
        return this.lastAddedControl;
    }

    public MenuControl getControlByID(int ID) {
        if (ID >= 0 && ID < this.controls.length) {
            return this.controls[ID];
        }
        return null;
    }

    public void update(int deltaTime) {
        this.keyDelayTimer -= deltaTime;
        if (this.keyDelayTimer < 0) {
            this.keyDelayTimer = 0;
        }
        this.fireDelayTimer -= deltaTime;
        if (this.fireDelayTimer < 0) {
            this.fireDelayTimer = 0;
        }
    }

    public void handleInput(int keyStates) {
        int index = -1;
        if ((keyStates & 0x100) != 0) {
            if (this.fireDelayTimer <= 0) {
                if (this.focusedID >= 0) {
                    this.controls[this.focusedID].state = 2;
                }
                if (this.listener != null) {
                    this.listener.notifyKeypressed(this.id, this.focusedID);
                }
                this.fireDelayTimer = this.fireDelay;
            }
        } else {
            if (this.activeControlKeys == 0) {
                if ((keyStates & 0x40) != 0) {
                    if (this.keyDelayTimer <= 0) {
                        index = this.getNextInOrder(this.focusedID, true);
                        this.keyDelayTimer = this.keyDelay;
                    }
                } else if ((keyStates & 2) != 0 && this.keyDelayTimer <= 0) {
                    index = this.getNextInOrder(this.focusedID, false);
                    this.keyDelayTimer = this.keyDelay;
                }
            } else if ((keyStates & 4) != 0) {
                if (this.keyDelayTimer <= 0) {
                    index = this.getNextInOrder(this.focusedID, false);
                    this.keyDelayTimer = this.keyDelay;
                }
            } else if ((keyStates & 0x20) != 0 && this.keyDelayTimer <= 0) {
                index = this.getNextInOrder(this.focusedID, true);
                this.keyDelayTimer = this.keyDelay;
            }
            if (index >= 0) {
                if (this.focusedID >= 0) {
                    this.controls[this.focusedID].state = 0;
                }
                this.controls[index].state = 1;
                this.focusedID = index;
            }
        }
    }

    public void keyPressed(int keyCode) {
        int index = -1;
        if (keyCode == -6) {
            if (this.focusedID >= 0) {
                this.controls[this.focusedID].state = 2;
            }
            if (this.listener != null) {
                this.listener.notifyKeypressed(this.id, this.focusedID);
            }
        }
    }

    private int getNextInOrder(int focused, boolean direction) {
        int search = 0;
        int minTab = 100;
        int maxTab = 0;
        int maxID = 0;
        int minID = 0;
        int i = 0;
        search = focused >= 0 && focused < this.controls.length ? this.controls[focused].tabOrder : -1;
        for (i = 0; i < this.controls.length; ++i) {
            if (this.controls[i].tabOrder > maxTab) {
                maxTab = this.controls[i].tabOrder;
                maxID = i;
            }
            if (this.controls[i].tabOrder != -1 && this.controls[i].tabOrder < minTab) {
                minTab = this.controls[i].tabOrder;
                minID = i;
            }
            if (direction && this.controls[i].tabOrder == search + 1 && search >= 0) {
                return i;
            }
            if (direction || search == 0 || this.controls[i].tabOrder != search - 1 || search < 0) continue;
            return i;
        }
        if (this.focusedID < 0 && search < 0) {
            return -1;
        }
        if (this.focusedID < 0 || search < 0) {
            return minID;
        }
        if (!direction && search == 0) {
            if (this.visibleRowCount != 0) {
                return this.focusedID;
            }
            return maxID;
        }
        if (direction && search == maxTab) {
            if (this.visibleRowCount != 0) {
                return this.focusedID;
            }
            return minID;
        }
        return minID;
    }

    public int createControl(int type, int tabOrder, int row, int column, SimpleSprite images, StringBuffer text) {
        return this.createControl(type, 0, 0, tabOrder, row, column, 18, 18, images, text, 0, 0);
    }

    public int createTextBox(int width, int height, int tabOrder, int row, int column, int cellAlignment, int textAlignment, StringBuffer text, int textPadding) {
        int newID = this.createControl(1, width, height, tabOrder, row, column, cellAlignment, textAlignment, null, text, 0, textPadding);
        int lines = 1;
        try {
            lines = this.renderer.getWordBreakLinesCount(width, height, text, (textAlignment & 2) != 0);
        }
        catch (Exception e) {
            System.out.println("TextBox area is to small to render text!" + e.toString());
        }
        if (lines < 1) {
            lines = 1;
        }
        this.controls[newID].lineCount = lines;
        this.controls[newID].calculatePositions(this.absoluteX, this.absoluteY, this.renderer);
        return newID;
    }

    public int createImage(int width, int height, int row, int column, int cellAlignment, SimpleSprite images) {
        return this.createControl(5, width, height, -1, row, column, cellAlignment, 18, images, null, 0, 0);
    }

    public int createScrollBox(int width, int height, int tabOrder, int row, int column, int cellAlignment, int textAlignment, StringBuffer text, int textPadding) {
        int newID = this.createControl(6, width, height, tabOrder, row, column, cellAlignment, textAlignment, null, text, 0, textPadding);
        int lines = 1;
        try {
            lines = this.renderer.getWordBreakLinesCount(width, height, text, (textAlignment & 2) != 0);
        }
        catch (Exception e) {
            System.out.println("ScrollBox area is to small to render text!" + e.toString());
        }
        if (lines < 1) {
            lines = 1;
        }
        this.controls[newID].lineCount = lines;
        this.controls[newID].visibleLines = height / this.renderer.getLineSpacing();
        this.controls[newID].currentLine = 0;
        this.controls[newID].calculatePositions(this.absoluteX, this.absoluteY, this.renderer);
        return newID;
    }

    public void recalculateScrollBox(int id) {
        if (this.controls[id].type == 6) {
            int lines = 1;
            try {
                lines = this.renderer.getWordBreakLinesCount(this.controls[id].width, this.controls[id].height, this.controls[id].text, (this.controls[id].textAlignment & 2) != 0);
            }
            catch (Exception e) {
                System.out.println("ScrollBox area is to small to render text!" + e.toString());
            }
            if (lines < 1) {
                lines = 1;
            }
            this.controls[id].lineCount = lines;
            this.controls[id].visibleLines = this.controls[id].height / this.renderer.getLineSpacing();
            this.controls[id].currentLine = 0;
            this.controls[id].calculatePositions(this.absoluteX, this.absoluteY, this.renderer);
        }
    }

    public void drawMenu(Graphics graphics) {
        int i2 = 0;
        for (int i = 0; i < this.controls.length; ++i) {
            if (this.controls[i] != null) {
                int tempPosY = -1;
                if (this.visibleRowCount != 0 && i < this.allRowCount) {
                    if (this.focusedID < this.fpRC) {
                        this.fpRC = 0;
                    } else if (this.focusedID - this.fpRC >= this.visibleRowCount - 1 && this.fpRC + this.visibleRowCount != this.allRowCount - 1) {
                        ++this.fpRC;
                    } else if (this.focusedID == this.fpRC && this.fpRC > 0) {
                        --this.fpRC;
                    }
                    if (i < this.fpRC || i >= this.fpRC + this.visibleRowCount) continue;
                    tempPosY = this.controls[i].textPozY;
                    this.controls[i].textPozY = this.controls[i2].textPozY;
                    ++i2;
                }
                this.controls[i].draw(graphics, this.renderer);
                if (tempPosY == -1) continue;
                this.controls[i].textPozY = tempPosY;
                continue;
            }
            throw new RuntimeException("More controls declared than added! Added: " + i + ", declared: " + this.controls.length);
        }
    }

    public void setRendererFonts(int controlID, String normal, String highLighted, String highLighted2) {
        if (controlID >= this.controls.length || controlID < 0 || this.controls[controlID] == null) {
            throw new RuntimeException("There is no control with ID " + controlID);
        }
        this.controls[controlID].fontNormal = this.renderer.getFont(normal);
        this.controls[controlID].fontHighLighted = this.renderer.getFont(highLighted);
        this.controls[controlID].fontHighLighted2 = this.renderer.getFont(highLighted2);
        TextRenderer.getInstance().setCurrentFont(this.controls[controlID].fontNormal);
        this.controls[controlID].calculatePositions(this.absoluteX, this.absoluteY, this.renderer);
    }
}

