/*
 * Decompiled with CFR 0.152.
 */
package framework.graphics;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class SimpleSprite {
    public int frameID;
    public Image image;
    public int frameWidth;
    public int frameHeight;
    public int framesCount;
    public int frameTimeElapsed;
    public int frameDuration;
    private int[][] framePos;
    private boolean animationFinished;
    private boolean loopAnimation;

    public SimpleSprite(Image image, int frameWidth, int frameHeight) {
        this.image = image;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.framesCount = image.getWidth() / frameWidth * (image.getHeight() / frameHeight);
        this.framePos = new int[this.framesCount][2];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.framesCount; ++i) {
            this.framePos[i][0] = x;
            this.framePos[i][1] = y;
            if ((x += frameWidth) < image.getWidth()) continue;
            x = 0;
            y += frameHeight;
        }
        this.animationFinished = false;
        this.loopAnimation = true;
    }

    public SimpleSprite(Image image, int framesCount) {
        this(image, image.getWidth() / framesCount, image.getHeight());
    }

    public final void setFrame(int frameNumber) {
        if (frameNumber < this.framesCount && frameNumber >= 0) {
            this.frameID = frameNumber;
        }
    }

    public final void nextFrame() {
        ++this.frameID;
        if (this.frameID == this.framesCount) {
            this.frameID = 0;
        }
    }

    public final void paint(Graphics graphics, int x, int y) {
        graphics.drawRegion(this.image, this.framePos[this.frameID][0], this.framePos[this.frameID][1], this.frameWidth, this.frameHeight, 0, x, y, 0);
    }

    public final void paintWithAnchor(Graphics graphics, int x, int y, int anchor) {
        graphics.drawRegion(this.image, this.framePos[this.frameID][0], this.framePos[this.frameID][1], this.frameWidth, this.frameHeight, 0, x, y, anchor);
    }

    public final void paint(Graphics graphics, int x, int y, int frame, int transform) {
        graphics.drawRegion(this.image, this.framePos[frame][0], this.framePos[frame][1], this.frameWidth, this.frameHeight, transform, x, y, 0);
    }

    public final void paint(Graphics graphics, int x, int y, int frame) {
        graphics.drawRegion(this.image, this.framePos[frame][0], this.framePos[frame][1], this.frameWidth, this.frameHeight, 0, x, y, 0);
    }

    public final void paintWithAnchor(Graphics graphics, int x, int y, int frame, int anchor) {
        if (this.framesCount <= frame) {
            frame = 0;
        }
        graphics.drawRegion(this.image, this.framePos[frame][0], this.framePos[frame][1], this.frameWidth, this.frameHeight, 0, x, y, anchor);
    }

    public final void paintWithAnchor(Graphics graphics, int x, int y, int frame, int transform, int anchor) {
        if (this.framesCount <= frame) {
            frame = 0;
        }
        graphics.drawRegion(this.image, this.framePos[frame][0], this.framePos[frame][1], this.frameWidth, this.frameHeight, transform, x, y, anchor);
    }

    public final void update(int timeDelta) {
        if (!this.animationFinished) {
            this.frameTimeElapsed += timeDelta;
            if (this.frameTimeElapsed > this.frameDuration) {
                this.frameTimeElapsed -= this.frameDuration;
                ++this.frameID;
                if (this.frameID == this.framesCount) {
                    if (this.loopAnimation) {
                        this.frameID = 0;
                    } else {
                        this.frameID = this.framesCount - 1;
                        this.animationFinished = true;
                    }
                }
            }
        }
    }

    public final void startAnimation() {
        this.animationFinished = false;
        this.frameTimeElapsed = 0;
    }

    public final void stopAnimation() {
        this.animationFinished = true;
    }

    public final void setPlayback(int frameDuration, boolean looping) {
        this.frameDuration = frameDuration;
        this.loopAnimation = looping;
    }

    public final boolean isAnimationFinished() {
        return this.animationFinished;
    }
}

