/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.AppState;
import framework.math.FP;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import root.GoolMidlet;

public class MainGameCanvas
extends GameCanvas
implements Runnable {
    public static GoolMidlet midlet;
    public static final int SOFTKEY_LEFT = -6;
    public static final int SOFTKEY_RIGHT = -7;
    public static final int KEY_FIRE = -5;
    public static final int KEY_UP_ARROW = -1;
    public static final int KEY_DOWN_ARROW = -2;
    public static final int KEY_RIGHT_ARROW = -4;
    public static final int KEY_LEFT_ARROW = -3;
    public static final int KEY_STATE_UP = 2;
    public static final int KEY_STATE_DOWN = 64;
    public static final int KEY_STATE_RIGHT = 32;
    public static final int KEY_STATE_LEFT = 4;
    public static final int KEY_STATE_FIRE = 256;
    public long totalTime;
    public long framesCount;
    private Thread gameThread;
    private boolean finishApp;
    private boolean finished;
    private boolean paused;
    private long lastTime;
    private int deltaTime;
    private Hashtable statesMap;
    private AppState currentAppState;
    private AppState requestedAppState;
    private Object requestedAppStateParam;
    private Graphics g;
    private Thread appThread;
    private static final int FADE_RGB_SQUARE_SIZE = 40;
    private int[] fadeRgbData = null;
    public static final int limitFps = 16;
    private long thinkTime = 0L;
    public static int frameTick;
    long endThink = 0L;

    public MainGameCanvas() {
        super(false);
        this.setFullScreenMode(true);
        this.statesMap = new Hashtable();
    }

    public void beginMainLoop() {
        if (this.finished || this.gameThread == null) {
            this.gameThread = new Thread(this);
            this.gameThread.start();
        }
        this.finishApp = false;
        this.paused = false;
    }

    public void endMainLoop() {
        this.finishApp = true;
        if (!Thread.currentThread().equals(this.appThread)) {
            while (!this.finished) {
                this.sleep(50);
            }
        }
    }

    public void registerAppState(AppState state) {
        if (this.statesMap.containsKey(state.getName())) {
            throw new RuntimeException(":: State with name " + state.getName() + " has already been registered.");
        }
        this.statesMap.put(state.getName(), state);
    }

    public void requestAppStateChange(String stateName, Object param) {
        if (!this.statesMap.containsKey(stateName)) {
            this.requestAppStateChange("ErrorAppState", "Error: There's no such\nstate as " + stateName + ".");
            return;
        }
        this.requestedAppState = (AppState)this.statesMap.get(stateName);
        this.requestedAppStateParam = param;
        if (this.currentAppState == null) {
            this.changeAppState(this.requestedAppState, param);
        }
    }

    public void requestAppStateChange(String stateName) {
        this.requestAppStateChange(stateName, null);
    }

    public void run() {
        this.appThread = Thread.currentThread();
        this.finished = false;
        this.g = this.getGraphics();
        while (!this.finishApp) {
            if (this.requestedAppState != null) {
                do {
                    this.changeAppState(this.requestedAppState, this.requestedAppStateParam);
                } while (this.requestedAppState != null);
            }
            if (!this.paused) {
                long currentTime = System.currentTimeMillis();
                if (this.lastTime == -1L) {
                    this.lastTime = currentTime;
                    continue;
                }
                this.deltaTime = (int)(currentTime - this.lastTime);
                this.totalTime += (long)this.deltaTime;
                this.lastTime = currentTime;
                this.currentAppState.handleInput();
                this.currentAppState.update(this.deltaTime);
                this.currentAppState.render(this.g);
                ++this.framesCount;
                try {
                    this.flushGraphics();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sleep(5);
                continue;
            }
            this.sleep(50);
        }
        this.finished = true;
    }

    void setPaused(boolean value) {
        this.paused = value;
        if (value) {
            this.lastTime = -1L;
        }
    }

    private void changeAppState(AppState gameState, Object param) {
        if (this.currentAppState != null) {
            this.currentAppState.deinitialize();
        }
        this.requestedAppState = null;
        this.requestedAppStateParam = null;
        this.currentAppState = gameState;
        if (!this.currentAppState.initialize(param) && this.requestedAppState == null) {
            this.requestAppStateChange("ErrorAppState", "Unknown error.\nHave you forgotten\nto request error state\nafter failed initialization?");
        }
        this.lastTime = -1L;
    }

    protected void keyPressed(int keyCode) {
        this.currentAppState.keyPressed(keyCode);
    }

    protected void keyReleased(int keyCode) {
        this.currentAppState.keyReleased(keyCode);
    }

    protected void showNotify() {
        if (this.paused) {
            this.currentAppState.pauseStateChanged(false);
        }
        this.g = this.getGraphics();
    }

    protected void hideNotify() {
        this.currentAppState.pauseStateChanged(true);
    }

    public String getCurrentAppStateName() {
        if (this.currentAppState != null) {
            return this.currentAppState.name;
        }
        return null;
    }

    private void sleep(int interval) {
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void prepareFadeRgbData(int color) {
        if (this.fadeRgbData == null) {
            this.fadeRgbData = new int[1600];
        }
        for (int i = 0; i < this.fadeRgbData.length; ++i) {
            this.fadeRgbData[i] = color;
        }
    }

    private void recomputeFadeRgbData(int color, int fadeTimer) {
        int opacity = (fadeTimer << FP.SHIFT << FP.SHIFT) / (AppState.FADE_DURATION << FP.SHIFT) * (255 << FP.SHIFT) >> FP.SHIFT >> FP.SHIFT;
        if (opacity > 255) {
            opacity = 255;
        } else if (opacity < 0) {
            opacity = 0;
        }
        for (int i = 0; i < this.fadeRgbData.length; ++i) {
            this.fadeRgbData[i] = opacity << 24 | color;
        }
    }

    private void renderFadeRgbData() {
        int colsCount = 7;
        int rowsCount = 9;
        for (int col = 0; col < colsCount; ++col) {
            for (int row = 0; row < rowsCount; ++row) {
                this.g.drawRGB(this.fadeRgbData, 0, 40, col * 40, row * 40, 40, 40, true);
            }
        }
    }

    private void fadeOut(int color) {
        long time;
        int fadeTimer = 0;
        this.prepareFadeRgbData(color);
        do {
            time = System.currentTimeMillis();
            this.recomputeFadeRgbData(color, fadeTimer);
            this.renderFadeRgbData();
            this.flushGraphics();
        } while ((fadeTimer = (int)((long)fadeTimer + (System.currentTimeMillis() - time))) <= AppState.FADE_DURATION);
    }
}

