/*
 * Decompiled with CFR 0.152.
 */
package root;

import framework.graphics.SimpleSprite;
import framework.math.FP;
import framework.math.Vector2D;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import root.Game;
import root.GoolGlobals;
import root.Player;
import root.StaticSet;

public class StaticBall {
    public int fp_x;
    public int fp_y;
    public int shadeHeight = 2;
    public StaticSet set;
    public Player playerRef;
    public int fp_radius = GoolGlobals.PLAYER_RADIUS;
    public int fp_mass = GoolGlobals.PLAYER_MASS;
    public SimpleSprite ballImage;
    public Image ballShade;
    public int[] afterCollision = new int[2];
    public boolean visible = true;
    public boolean cards = false;
    public long outTime;
    public int maxOutTime = GoolGlobals.MAX_OUT_TIME;
    private Vector2D distance = new Vector2D(0, 0);
    private Vector2D distance2 = new Vector2D(0, 0);
    private Vector2D normal = new Vector2D(0, 0);
    private boolean hit = false;
    private int hitCounter = 0;
    private final int ANIMATION_TIME;
    private Vector2D normal2 = new Vector2D(0, 0);

    public StaticBall(Player player, StaticSet set) {
        this.ANIMATION_TIME = 6;
        this.ballImage = player.ballImage;
        this.playerRef = player;
        this.set = set;
        try {
            this.ballShade = Image.createImage((String)"/zawodnicy_cien.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public boolean wallCollide() {
        this.afterCollision[0] = this.fp_x < this.set.fp_leftBound ? this.set.fp_leftBound - this.fp_x : (this.fp_x > this.set.fp_rightBound ? this.set.fp_rightBound - this.fp_x : 0);
        this.afterCollision[1] = this.fp_y < this.set.fp_upBound ? this.set.fp_upBound - this.fp_y : (this.fp_y > this.set.fp_downBound ? this.set.fp_downBound - this.fp_y : 0);
        return this.afterCollision[0] != 0 || this.afterCollision[1] != 0;
    }

    public void draw(Graphics g) {
        g.drawImage(this.ballShade, (this.fp_x >> FP.SHIFT) + 2, (this.fp_y >> FP.SHIFT) + this.shadeHeight, 2 | 1);
        if (this.hit) {
            this.ballImage.paintWithAnchor(g, this.fp_x >> FP.SHIFT, this.fp_y >> FP.SHIFT, 1, 2 | 1);
        } else {
            this.ballImage.paintWithAnchor(g, this.fp_x >> FP.SHIFT, this.fp_y >> FP.SHIFT, 2 | 1);
        }
    }

    public void resolveCollision() {
        int a1 = 0;
        int a2 = 0;
        int fp_result = 0;
        this.normal.fp_x = Game.ball.fp_x - this.fp_x;
        this.normal.fp_y = Game.ball.fp_y - this.fp_y;
        this.distance.fp_x = this.set.playerRef.xMoovingSpeed;
        this.distance.fp_y = this.set.playerRef.yMoovingSpeed;
        a1 = this.distance.dotProduct(this.normal);
        this.distance.fp_x = Game.ball.velocityVector.fp_x * Game.ball.fp_scalarVelocity >> FP.SHIFT;
        this.distance.fp_y = Game.ball.velocityVector.fp_y * Game.ball.fp_scalarVelocity >> FP.SHIFT;
        a2 = this.distance.dotProduct(this.normal);
        fp_result = (2 * (a1 - a2) << FP.SHIFT) / (GoolGlobals.PLAYER_MASS + GoolGlobals.BALL_MASS);
        this.normal.mul(fp_result * (GoolGlobals.PLAYER_MASS >> GoolGlobals.MASS_SCALE) >> FP.SHIFT);
        this.distance.add(this.normal);
        Game.ball.fp_scalarVelocity = this.playerRef.ai ? this.distance.getLengthApprox2() * 3 : this.distance.getLengthApprox2();
        this.distance.normalizeApprox2();
        Game.ball.velocityVector.fp_x = this.distance.fp_x;
        Game.ball.velocityVector.fp_y = this.distance.fp_y;
        if (Game.ball.fp_scalarVelocity > Game.ball.fp_maxScalarVelocity) {
            Game.ball.fp_scalarVelocity = Game.ball.fp_maxScalarVelocity;
        } else if (Game.ball.fp_scalarVelocity < -Game.ball.fp_maxScalarVelocity) {
            Game.ball.fp_scalarVelocity = -Game.ball.fp_maxScalarVelocity;
        }
        this.set.playerRef.yMoovingSpeed = 0;
        this.set.playerRef.xMoovingSpeed = 0;
        if (Game.ball.shadeHeight > 1 && this.shadeHeight < 3) {
            this.shadeHeight += Math.min(Game.ball.shadeHeight, 4);
        }
        Game.ball.shadeHeight = Math.max(4 + (Game.ball.fp_scalarVelocity >> FP.SHIFT), 1);
        this.hit = true;
        this.hitCounter = 6;
    }

    public byte behindBall() {
        if (Game.ball.fp_x + GoolGlobals.BALL_RADIUS > this.fp_x - GoolGlobals.PLAYER_RADIUS && Game.ball.fp_x - GoolGlobals.BALL_RADIUS < this.fp_x + GoolGlobals.PLAYER_RADIUS) {
            if (this.fp_y > Game.ball.fp_y) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public int ballInRange() {
        this.distance.fp_x = this.fp_x + this.set.playerRef.xMoovingSpeed - Game.ball.fp_x;
        this.distance.fp_y = this.fp_y + this.set.playerRef.yMoovingSpeed - Game.ball.fp_y;
        int dist = this.distance.getLengthApprox2();
        if (dist < GoolGlobals.BALL_RADIUS + GoolGlobals.PLAYER_RADIUS) {
            return GoolGlobals.BALL_RADIUS + GoolGlobals.PLAYER_RADIUS - dist;
        }
        return 0;
    }

    public int ballCollides() {
        this.distance.fp_x = this.fp_x - Game.ball.fp_x;
        this.distance.fp_y = this.fp_y - Game.ball.fp_y;
        int dist = this.distance.getLengthApprox2();
        if (dist < 2 * (GoolGlobals.BALL_RADIUS + GoolGlobals.PLAYER_RADIUS) && (dist = this.distance.getLength()) < GoolGlobals.BALL_RADIUS + GoolGlobals.PLAYER_RADIUS) {
            return GoolGlobals.BALL_RADIUS + GoolGlobals.PLAYER_RADIUS - dist;
        }
        return 0;
    }

    public void kickMe() {
        this.visible = false;
        this.outTime = System.currentTimeMillis();
    }

    public void update() {
        if (this.shadeHeight > 2) {
            --this.shadeHeight;
        }
        if (this.hitCounter > 0) {
            --this.hitCounter;
        } else {
            this.hit = false;
        }
    }
}

