/*
 * Decompiled with CFR 0.152.
 */
package menu;

import containers.Localizaton;
import framework.MainGameCanvas;
import framework.graphics.SimpleSprite;
import framework.graphics.TextRenderer;
import framework.menu.MenuForm;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import menu.GoolMenu;
import root.GoolGlobals;

public class WinLoseState
extends GoolMenu {
    Image background;
    Image bowl;
    Image winner;
    SimpleSprite confetti;
    SimpleSprite button;
    Random rand = new Random();
    public int[] particleVars;
    private int mode;
    private MenuForm mainMenu;
    private int particleCount = 200;
    private int maxLiveTime = 40;
    private int activePaticles = 0;
    private long lastSpawned = 0L;
    private long spawnTime = 400L;
    private long moveTime = 50L;
    private long startMove = 0L;
    private long currentTime;
    private int maxParticleSpeed = 4;
    private int fallBorder = 240;
    private int bowlPosition = 0;
    private int winerPosition = 0;
    private int continue2ID;
    private int music2ID;
    private int exit2ID;
    int state = -1;

    public WinLoseState(String stateName, MainGameCanvas mainGameCanvas) {
        super(stateName, mainGameCanvas);
    }

    public boolean initialize(Object param) {
        super.initialize(param);
        this.showZeppelin = false;
        this.showMenu_bg = false;
        int state = 0;
        GoolGlobals.score += GoolGlobals.goalPlayer * GoolGlobals.sensitivity - GoolGlobals.goalEnemy * GoolGlobals.sensitivity + GoolGlobals.winGame * GoolGlobals.sensitivity * 2;
        if (param != null) {
            this.state = state = ((Integer)param).intValue();
            this.mode = state;
        }
        try {
            if (GoolGlobals.button2 == null) {
                this.bowl = Image.createImage((String)"/button2.png");
                this.button = new SimpleSprite(this.bowl, 1);
            } else {
                this.button = GoolGlobals.button2;
            }
            if (state == 0) {
                if (GoolGlobals.tournamentStarted) {
                    this.createMainMenu3();
                } else {
                    this.createMainMenu();
                }
            } else {
                this.createMainMenu();
                this.winner = Image.createImage((String)"/puchar.png");
            }
            if (state == 2) {
                this.createMainMenu2();
                if (this.mode != 3) {
                    this.bowl = Image.createImage((String)"/winer_particles.png");
                    this.confetti = new SimpleSprite(this.bowl, 24);
                    if (GoolGlobals.bowl != null) {
                        this.bowl = GoolGlobals.bowl;
                    }
                    this.particleVars = new int[5 * this.particleCount];
                    this.bowlPosition = 214;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void update(int deltaTime) {
        super.update(deltaTime);
        int i = 0;
        int j = 0;
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 2) {
            this.currentTime = System.currentTimeMillis();
            if (this.activePaticles < this.particleCount) {
                if (this.lastSpawned == 0L) {
                    this.lastSpawned = this.currentTime;
                } else if (this.currentTime - this.lastSpawned > this.spawnTime) {
                    for (i = j = this.activePaticles * 5; i < j + 25; i += 5) {
                        this.spawnParticle(i);
                        ++this.activePaticles;
                    }
                    this.lastSpawned = this.currentTime;
                }
            }
            if (this.startMove == 0L) {
                this.startMove = this.currentTime;
            } else if (this.currentTime - this.startMove > this.moveTime) {
                this.startMove = this.currentTime;
                for (i = 0; i < this.activePaticles * 5; i += 5) {
                    if (this.particleVars[i + 4] > 0) {
                        int n = i + 1;
                        this.particleVars[n] = this.particleVars[n] + this.particleVars[i + 4];
                        if (this.particleVars[i + 1] <= this.fallBorder || Math.abs(this.rand.nextInt()) % Math.max(1, 320 - this.particleVars[i + 1]) != 0) continue;
                        this.particleVars[i + 4] = 0;
                        continue;
                    }
                    int n = i + 3;
                    this.particleVars[n] = this.particleVars[n] + 1;
                    if (this.particleVars[i + 3] <= this.maxLiveTime) continue;
                    this.spawnParticle(i);
                }
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -6) {
            if (GoolGlobals.tournamentStarted && GoolGlobals.currentTournamentPhaze != 2 && this.state == 1) {
                this.mainGameCanvas.requestAppStateChange("Statistic");
                GoolGlobals.nextPhaze = true;
            } else if (GoolGlobals.tournamentStarted && (GoolGlobals.currentTournamentPhaze == 2 || this.state == 0)) {
                this.mainGameCanvas.requestAppStateChange("Statistic");
            } else {
                this.mainGameCanvas.requestAppStateChange("Statistic");
            }
        }
    }

    public void keyReleased(int keyCode) {
        super.keyReleased(keyCode);
    }

    private void createMainMenu() {
        int fontSize = TextRenderer.getInstance().getStringHeight(1);
        int[] cols = new int[]{GoolGlobals.MAINMENU_MARGIN, GoolGlobals.menuBackground.getWidth() - GoolGlobals.MAINMENU_MARGIN, -1};
        int[] rows = new int[]{GoolGlobals.MAINMENU_BG_Y, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, 2 * fontSize, 2 * fontSize, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, -1};
        this.mainMenu = MenuForm.createMenuForm(4, rows, cols, 240, 320, (byte)1, (byte)0);
        this.continue2ID = this.mainMenu.createScrollBox(240 - 4 * fontSize, TextRenderer.getInstance().getStringHeight(10), -1, 2, 1, 10, 10, Localizaton.EMPTY, 0);
        this.exit2ID = this.mainMenu.createControl(4, 1, 3, 1, null, Localizaton.EMPTY);
        int tempID = this.mainMenu.createControl(4, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 0, 33, 18, GoolGlobals.button, Localizaton.MENU_NEXT, 0, 0);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        tempID = this.mainMenu.createControl(4, -1, 5, 0, null, Localizaton.EMPTY);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
    }

    private void createMainMenu2() {
        int fontSize = TextRenderer.getInstance().getStringHeight(1);
        int[] cols = new int[]{GoolGlobals.MAINMENU_MARGIN, GoolGlobals.menuBackground.getWidth() - GoolGlobals.MAINMENU_MARGIN, -1};
        int[] rows = new int[]{GoolGlobals.MAINMENU_BG_Y + 4 * fontSize, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, 2 * fontSize, 2 * fontSize, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, -1};
        this.mainMenu = MenuForm.createMenuForm(4, rows, cols, 240, 320, (byte)1, (byte)0);
        this.continue2ID = this.mainMenu.createScrollBox(240 - 4 * fontSize, TextRenderer.getInstance().getStringHeight(10), -1, 0, 1, 18, 18, Localizaton.WIN_TOUR, 0);
        this.exit2ID = this.mainMenu.createControl(4, 1, 3, 1, null, Localizaton.EMPTY);
        int tempID = this.mainMenu.createControl(4, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 0, 33, 18, GoolGlobals.button, Localizaton.MENU_NEXT, 0, 0);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        tempID = this.mainMenu.createControl(4, -1, 5, 0, null, Localizaton.EMPTY);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
    }

    private void createMainMenu3() {
        int fontSize = TextRenderer.getInstance().getStringHeight(1);
        int[] cols = new int[]{GoolGlobals.MAINMENU_MARGIN, GoolGlobals.menuBackground.getWidth() - GoolGlobals.MAINMENU_MARGIN, -1};
        int[] rows = new int[]{GoolGlobals.MAINMENU_BG_Y, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, 2 * fontSize, 2 * fontSize, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, -1};
        this.mainMenu = MenuForm.createMenuForm(4, rows, cols, 240, 320, (byte)1, (byte)0);
        this.continue2ID = this.mainMenu.createScrollBox(240 - 4 * fontSize, TextRenderer.getInstance().getStringHeight(10), -1, 2, 1, 10, 10, Localizaton.LOST, 0);
        this.exit2ID = this.mainMenu.createControl(4, 1, 3, 1, null, Localizaton.EMPTY);
        int tempID = this.mainMenu.createControl(4, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 0, 33, 18, GoolGlobals.button, Localizaton.MENU_NEXT, 0, 0);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        tempID = this.mainMenu.createControl(4, -1, 5, 0, null, Localizaton.EMPTY);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
    }

    public void render(Graphics g) {
        super.render(g);
        if (this.winner != null) {
            g.drawImage(this.winner, 240 - this.winner.getWidth() - this.winner.getWidth() / 4, 320 - this.winner.getHeight() - this.winner.getHeight() / 5, 0);
        }
        if (this.mode != 3) {
            for (int i = 0; i < this.activePaticles * 5; i += 5) {
                this.confetti.paintWithAnchor(g, this.particleVars[i], this.particleVars[i + 1], this.particleVars[i + 2], 2 | 1);
            }
        }
        this.mainMenu.drawMenu(g);
    }

    public void deinitialize() {
        this.background = null;
        this.bowl = null;
        this.confetti = null;
        this.button = null;
        this.particleVars = null;
        this.winner = null;
        System.gc();
    }

    private void spawnParticle(int i) {
        this.particleVars[i] = Math.abs(this.rand.nextInt()) % 240;
        this.particleVars[i + 1] = 0;
        this.particleVars[i + 2] = Math.abs(this.rand.nextInt()) % this.confetti.framesCount;
        this.particleVars[i + 3] = 0;
        this.particleVars[i + 4] = 1 + Math.abs(this.rand.nextInt()) % this.maxParticleSpeed;
    }
}

