/*
 * Decompiled with CFR 0.152.
 */
package menu;

import containers.Localizaton;
import framework.AppState;
import framework.MainGameCanvas;
import framework.graphics.SimpleSprite;
import framework.graphics.TextRenderer;
import framework.menu.MenuForm;
import framework.sound.Music;
import framework.utils.rms.RMSUtils;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import menu.HighscoresAppState;
import menu.RMSHighscore;
import root.GoolGlobals;

public class StatisticTournament
extends AppState {
    Image background;
    Image bowl;
    Image winner;
    SimpleSprite confetti;
    SimpleSprite button;
    Random rand = new Random();
    public int[] particleVars;
    private int mode;
    private MenuForm mainMenu;
    private MenuForm mainMenu2;
    private int particleCount = 200;
    private int maxLiveTime = 40;
    private int activePaticles = 0;
    private long lastSpawned = 0L;
    private long spawnTime = 400L;
    private long moveTime = 50L;
    private long startMove = 0L;
    private long currentTime;
    private int maxParticleSpeed = 4;
    private int fallBorder = 240;
    private int bowlPosition = 0;
    private int winerPosition = 0;
    private int continue2ID;
    private int music2ID;
    private int exit2ID;
    private Vector highscoresRecordsScores;
    private boolean nextHighscore = false;
    int state = -1;
    int menuMargin = 20;

    public StatisticTournament(String stateName, MainGameCanvas mainGameCanvas) {
        super(stateName, mainGameCanvas);
    }

    public boolean initialize(Object param) {
        int state = 0;
        if (param != null) {
            this.state = state = ((Integer)param).intValue();
            this.mode = state;
        }
        try {
            this.createMainMenu();
            this.createMainMenu2();
            this.background = Image.createImage((String)"/background2.jpg");
            try {
                this.highscoresRecordsScores = RMSUtils.loadRecords("highs", Class.forName("menu.RMSHighscore"));
            }
            catch (ClassNotFoundException exc) {
                throw new RuntimeException("Impossible!");
            }
            HighscoresAppState.highscoresInsertionSortScores(this.highscoresRecordsScores);
            this.nextHighscore = ((RMSHighscore)this.highscoresRecordsScores.lastElement()).scores < GoolGlobals.score || this.highscoresRecordsScores.size() < 5;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void update(int deltaTime) {
        int i = 0;
        int j = 0;
        if (this.mode == 2) {
            this.currentTime = System.currentTimeMillis();
            if (this.activePaticles < this.particleCount) {
                if (this.lastSpawned == 0L) {
                    this.lastSpawned = this.currentTime;
                } else if (this.currentTime - this.lastSpawned > this.spawnTime) {
                    for (i = j = this.activePaticles * 5; i < j + 25; i += 5) {
                        this.spawnParticle(i);
                        ++this.activePaticles;
                    }
                    this.lastSpawned = this.currentTime;
                }
            }
            if (this.startMove == 0L) {
                this.startMove = this.currentTime;
            } else if (this.currentTime - this.startMove > this.moveTime) {
                this.startMove = this.currentTime;
                for (i = 0; i < this.activePaticles * 5; i += 5) {
                    if (this.particleVars[i + 4] > 0) {
                        int n = i + 1;
                        this.particleVars[n] = this.particleVars[n] + this.particleVars[i + 4];
                        if (this.particleVars[i + 1] <= this.fallBorder || Math.abs(this.rand.nextInt()) % Math.max(1, 320 - this.particleVars[i + 1]) != 0) continue;
                        this.particleVars[i + 4] = 0;
                        continue;
                    }
                    int n = i + 3;
                    this.particleVars[n] = this.particleVars[n] + 1;
                    if (this.particleVars[i + 3] <= this.maxLiveTime) continue;
                    this.spawnParticle(i);
                }
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -6) {
            if (GoolGlobals.tournamentStarted && GoolGlobals.currentTournamentPhaze != 2 && this.state == 1) {
                this.mainGameCanvas.requestAppStateChange("Tournament");
                GoolGlobals.nextPhaze = true;
            } else if (GoolGlobals.tournamentStarted && (GoolGlobals.currentTournamentPhaze == 2 || this.state == 0)) {
                if (this.nextHighscore) {
                    this.mainGameCanvas.requestAppStateChange("Highscore");
                } else {
                    this.mainGameCanvas.requestAppStateChange("Tournament");
                    GoolGlobals.nextPhaze = true;
                }
            } else {
                this.mainGameCanvas.requestAppStateChange("Tournament");
                GoolGlobals.nextPhaze = true;
            }
        }
    }

    public void keyReleased(int keyCode) {
        super.keyReleased(keyCode);
    }

    private void createMainMenu() {
        int fontSize = TextRenderer.getInstance().getStringHeight(1);
        int[] cols = new int[]{this.menuMargin, GoolGlobals.menuBackground.getWidth() - GoolGlobals.MAINMENU_MARGIN, -1};
        int[] rows = new int[]{GoolGlobals.menuBackground.getHeight() / 2 - fontSize + 45, 2 * fontSize, fontSize + fontSize / 2, 2 * fontSize + fontSize / 2, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, -1};
        this.mainMenu = MenuForm.createMenuForm(6, rows, cols, 240, 320, (byte)1, (byte)0);
        this.continue2ID = this.mainMenu.createScrollBox(240 - 4 * fontSize, TextRenderer.getInstance().getStringHeight(10), -1, 2, 1, 9, 9, Localizaton.MATCHES_WON, 0);
        String str = "" + GoolGlobals.winGame;
        this.continue2ID = this.mainMenu.createScrollBox(240 - 7 * fontSize, TextRenderer.getInstance().getStringHeight(10), -1, 3, 1, 9, 9, Localizaton.ADVANTAGE, 0);
        this.continue2ID = this.mainMenu.createScrollBox(240 - 4 * fontSize, TextRenderer.getInstance().getStringHeight(10), -1, 4, 1, 9, 9, Localizaton.TOTAL, 0);
        this.exit2ID = this.mainMenu.createControl(4, 1, 3, 1, null, Localizaton.EMPTY);
        int tempID = this.mainMenu.createControl(4, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 0, 33, 18, GoolGlobals.button, Localizaton.MENU_NEXT, 0, 0);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        tempID = this.mainMenu.createControl(4, -1, 5, 0, null, Localizaton.EMPTY);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
    }

    private void createMainMenu2() {
        int fontSize = TextRenderer.getInstance().getStringHeight(1);
        int[] cols = new int[]{this.menuMargin, 170, -1, 60};
        int[] rows = new int[]{GoolGlobals.menuBackground.getHeight() / 2 - fontSize + 45, 2 * fontSize, 2 * fontSize, 2 * fontSize, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, -1};
        this.mainMenu2 = MenuForm.createMenuForm(6, rows, cols, 240, 320, (byte)1, (byte)0);
        int intHelp = GoolGlobals.winGame;
        String str = "" + intHelp;
        StringBuffer strHelp = new StringBuffer(str);
        this.continue2ID = this.mainMenu2.createScrollBox(240 - 4 * fontSize, TextRenderer.getInstance().getStringHeight(10), -1, 2, 2, 9, 9, strHelp, 0);
        intHelp = GoolGlobals.goalPlayer - GoolGlobals.goalEnemy;
        str = "" + intHelp;
        strHelp = new StringBuffer(str);
        this.continue2ID = this.mainMenu2.createScrollBox(240 - 4 * fontSize, TextRenderer.getInstance().getStringHeight(10), -1, 3, 2, 9, 9, strHelp, 0);
        intHelp = GoolGlobals.score;
        str = "" + intHelp;
        strHelp = new StringBuffer(str);
        this.continue2ID = this.mainMenu2.createScrollBox(240 - 4 * fontSize, TextRenderer.getInstance().getStringHeight(10), -1, 4, 2, 9, 9, strHelp, 0);
        this.exit2ID = this.mainMenu2.createControl(4, 1, 3, 1, null, Localizaton.EMPTY);
        int tempID = this.mainMenu2.createControl(4, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 0, 33, 48, null, Localizaton.EMPTY, 0, 0);
        this.mainMenu2.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        tempID = this.mainMenu2.createControl(4, -1, 5, 0, null, Localizaton.EMPTY);
        this.mainMenu2.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
    }

    public void render(Graphics g) {
        g.drawImage(this.background, 0, 0, 0);
        g.drawImage(GoolGlobals.menuBackground, 0, 160 - GoolGlobals.menuBackground.getHeight() / 2, 0);
        this.mainMenu.drawMenu(g);
        this.mainMenu2.drawMenu(g);
    }

    public void deinitialize() {
        this.background = null;
        this.bowl = null;
        this.confetti = null;
        this.winner = null;
        this.button = null;
        this.particleVars = null;
        System.gc();
    }

    private void spawnParticle(int i) {
        this.particleVars[i] = Math.abs(this.rand.nextInt()) % 240;
        this.particleVars[i + 1] = 0;
        this.particleVars[i + 2] = Math.abs(this.rand.nextInt()) % this.confetti.framesCount;
        this.particleVars[i + 3] = 0;
        this.particleVars[i + 4] = 1 + Math.abs(this.rand.nextInt()) % this.maxParticleSpeed;
    }

    public void pauseStateChanged(boolean paused) {
        super.pauseStateChanged(paused);
        if (GoolGlobals.playMusic) {
            if (paused) {
                Music.stopMusic();
            } else {
                Music.playMusic(GoolGlobals.menuMusicId);
            }
        }
    }
}

