/*
 * Decompiled with CFR 0.152.
 */
package menu;

import framework.utils.rms.IRMSRecord;
import framework.utils.rms.RMSUtils;

public final class RMSSettings
implements IRMSRecord {
    public static final int MULTIPLE_VOLUME = 20;
    public static final int DEFAULT_VOLUME = 3;
    public int recordId;
    private byte byte1 = 0;
    private byte byte2 = 0;
    private byte music = 0;
    private byte gameFinished = 0;
    private byte lastPlayedLevel = 0;
    private byte[] nick = new byte[7];
    public byte firstTime;
    public boolean vibration;
    public static byte sound;
    public static byte language;
    public static byte speed;
    public static byte time;
    public static byte save;
    public static byte continueGame;

    public RMSSettings() {
    }

    public RMSSettings(byte byte1, byte byte2, byte music, byte gameFinished) {
        this.byte1 = byte1;
        this.byte2 = byte2;
        this.music = music;
        for (int i = 0; i < this.nick.length; ++i) {
            this.nick[i] = 0;
        }
        this.gameFinished = gameFinished;
        this.lastPlayedLevel = 0;
        this.vibration = false;
        sound = 1;
        this.firstTime = 1;
        time = (byte)3;
        language = 0;
        continueGame = 0;
    }

    public void setLastPlayedLevel(byte level) {
        this.lastPlayedLevel = level;
        RMSUtils.updateRecord("sett", this);
    }

    public byte getlastPlayedlevel() {
        return this.lastPlayedLevel;
    }

    public void setNick(byte[] nick) {
        for (int i = 0; i < nick.length; ++i) {
            this.nick[i] = nick[i];
        }
    }

    public void getNick(byte[] nick) {
        for (int i = 0; i < nick.length; ++i) {
            nick[i] = this.nick[i];
        }
    }

    public void setGameFinished(boolean flag) {
        this.gameFinished = (byte)(flag ? 1 : 0);
    }

    public boolean isGameFinished() {
        return this.gameFinished != 0;
    }

    public void setPowerUpNames(byte flag) {
        this.byte1 = (byte)(this.byte1 & 0xFFFFFF7F);
        this.byte1 = (byte)(this.byte1 | flag << 7);
        this.vibration = flag != 0;
    }

    public byte getPowerUpNames() {
        return (byte)((this.byte1 & 0x80) >> 7);
    }

    public void setHighlighting(byte flag) {
        this.byte1 = (byte)(this.byte1 & 0xFFFFFFDF);
        this.byte1 = (byte)(this.byte1 | flag << 5);
    }

    public byte getHighlighting() {
        return (byte)((this.byte1 & 0x20) >> 5);
    }

    public void setOrientation(byte flag) {
        this.byte1 = (byte)(this.byte1 & 0xFFFFFFEF);
        this.byte1 = (byte)(this.byte1 | flag << 4);
    }

    public byte getOrientation() {
        return (byte)((this.byte1 & 0x10) >> 4);
    }

    public void setDifficuly(byte diffLevel) {
        this.byte1 = (byte)(this.byte1 & 0xFFFFFFF3);
        this.byte1 = (byte)(this.byte1 | diffLevel << 2);
    }

    public byte getDifficulty() {
        return (byte)((this.byte1 & 0xC) >> 2);
    }

    public void setShip(int shipNumber) {
        this.byte1 = (byte)(this.byte1 & 0xFFFFFFFC);
        this.byte1 = (byte)(this.byte1 | shipNumber);
    }

    public byte getShip() {
        return (byte)(this.byte1 & 3);
    }

    public void setLastDiscoveredLevel(byte level) {
        this.byte2 = level;
        RMSUtils.updateRecord("sett", this);
    }

    public byte getLastDiscoveredLevel() {
        return this.byte2;
    }

    public byte isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTimeFalse() {
        this.firstTime = 0;
    }

    public IRMSRecord initializeFromByteArray(byte[] byteArray) {
        this.byte1 = byteArray[0];
        this.byte2 = byteArray[1];
        this.music = byteArray[2];
        sound = byteArray[3];
        speed = byteArray[4];
        this.firstTime = byteArray[5];
        language = byteArray[6];
        time = byteArray[7];
        save = byteArray[8];
        for (int i = 0; i < this.nick.length; ++i) {
            this.nick[i] = byteArray[i + 9];
        }
        continueGame = byteArray[16];
        return null;
    }

    public byte[] toByteArray() {
        byte[] record = new byte[]{this.byte1, this.byte2, this.music, sound, speed, this.firstTime, language, time, save, this.nick[0], this.nick[1], this.nick[2], this.nick[3], this.nick[4], this.nick[5], this.nick[6], continueGame};
        return record;
    }

    public void setId(int id) {
        this.recordId = id;
    }

    public int getId() {
        return this.recordId;
    }

    static {
        speed = 1;
        time = (byte)3;
        save = 0;
        continueGame = 0;
    }
}

