/*
 * Decompiled with CFR 0.152.
 */
package menu;

import framework.utils.rms.IRMSRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;

public final class RMSHighscore
implements IRMSRecord {
    public static final int NO_LEVEL = -1;
    public int recordId;
    public int level;
    public String nick;
    public int scores;

    public RMSHighscore() {
    }

    public RMSHighscore(int level, String nick, int scores) {
        this.nick = nick;
        this.scores = scores;
        this.level = level;
    }

    public IRMSRecord initializeFromByteArray(byte[] byteArray) {
        try {
            ByteArrayInputStream streamBytes = new ByteArrayInputStream(byteArray);
            DataInputStream streamData = new DataInputStream(streamBytes);
            this.level = streamData.readInt();
            this.nick = streamData.readUTF();
            this.scores = streamData.readInt();
            streamBytes.close();
            streamData.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Record initialising failed");
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] record;
        try {
            ByteArrayOutputStream streamBytes = new ByteArrayOutputStream();
            DataOutputStream streamData = new DataOutputStream(streamBytes);
            streamData.writeInt(this.level);
            streamData.writeUTF(this.nick);
            streamData.writeInt(this.scores);
            record = streamBytes.toByteArray();
            streamBytes.close();
            streamData.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Creating byte array from record failed");
        }
        return record;
    }

    public int getId() {
        return this.recordId;
    }

    public void setId(int id) {
        this.recordId = id;
    }

    public static StringBuffer createStringFromRecords(Vector records, int numOfCharsInLine, boolean timeHighscore) {
        StringBuffer result = new StringBuffer();
        StringBuffer time = new StringBuffer();
        int scoresLength = 0;
        int numOfSpaces = 0;
        String scores = null;
        String level = null;
        int levelLength = 0;
        for (int i = 0; i < records.size(); ++i) {
            int j;
            RMSHighscore record = (RMSHighscore)records.elementAt(i);
            if (record.level != -1) {
                level = Integer.toString(record.level);
                levelLength = level.length();
                if (levelLength == 2) {
                    result.append(level);
                } else if (levelLength == 1) {
                    result.append("0");
                    result.append(level);
                    ++levelLength;
                }
            } else {
                if (i < 9) {
                    result.append("0");
                }
                result.append(i + 1);
                levelLength = 2;
            }
            result.append("  ");
            levelLength += 2;
            if (timeHighscore) {
                int minutes = record.scores / 60;
                int seconds = record.scores - minutes * 60;
                scores = Integer.toString(minutes) + "." + Integer.toString(seconds);
            } else {
                scores = Integer.toString(record.scores);
            }
            scoresLength = scores.length();
            numOfSpaces = numOfCharsInLine - record.nick.length() - scoresLength - levelLength;
            StringBuffer spaces = new StringBuffer();
            for (j = 0; j < numOfSpaces; ++j) {
                spaces.append(" ");
            }
            for (j = 0; record.nick.charAt(j) == ' ' && j < record.nick.length() - 1; ++j) {
                spaces.append(" ");
            }
            result.append(record.nick.substring(j));
            result.append((Object)spaces);
            result.append(scores);
            result.append("\n");
        }
        return result;
    }
}

