/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class ParseMIDI {
    public static byte[] midiArray;
    public static int midiStyle;
    public static int trackCnt;
    public static long DNtickNum;
    public static long DNPeriod;
    public static int molecule;
    public static int denominator;
    public static int playTrack;
    public static int playTrack_1;
    public static String[] track_Name;
    public static long[][] track_rhythm;
    public static byte[][] track_velocity;
    public static byte[][] track_note;
    public static long[] rhythm;
    public static byte[] velocity;
    public static byte[] note;

    public static void parse(String fileName) {
        try {
            int byteRead;
            InputStream is = null;
            is = fileName.getClass().getResourceAsStream(fileName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((byteRead = is.read()) != -1) {
                baos.write(byteRead);
            }
            midiArray = baos.toByteArray();
            baos.close();
            is.close();
            Scene.error = "fenXi   01";
            ParseMIDI.getMidiHead();
            Scene.error = "fenXi   02";
            ParseMIDI.getMusicRhythm();
            Scene.error = "fenXi   03";
            playTrack = 0;
            int j = 0;
            while (j < trackCnt) {
                if (track_Name[j].equals("melody")) {
                    playTrack = j;
                }
                ++j;
            }
            playTrack_1 = 0;
            j = 0;
            while (j < trackCnt) {
                if (track_Name[j].equals("kala")) {
                    playTrack_1 = j;
                }
                ++j;
            }
            Scene.error = "fenXi   04";
            ParseMIDI.combineRhythm();
            Scene.error = "fenXi   05";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void getMidiHead() throws Exception {
        int arrayIdx = 8;
        midiStyle = midiArray[arrayIdx] << 8 & 0xFF00 | midiArray[arrayIdx + 1] & 0xFF;
        arrayIdx = 10;
        trackCnt = midiArray[arrayIdx] << 8 & 0xFF00 | midiArray[arrayIdx + 1] & 0xFF;
        track_Name = new String[trackCnt];
        track_rhythm = new long[trackCnt][];
        track_velocity = new byte[trackCnt][];
        track_note = new byte[trackCnt][];
        arrayIdx = 12;
        DNtickNum = midiArray[arrayIdx] << 8 & 0xFF00 | midiArray[arrayIdx + 1] & 0xFF;
    }

    public static boolean isValidMidi(byte[] midiArray) {
        if (midiArray == null) {
            return false;
        }
        if (midiArray.length < 15) {
            return false;
        }
        int arrayIdx = 0;
        if (midiArray[arrayIdx] != 77 || midiArray[arrayIdx + 1] != 84 || midiArray[arrayIdx + 2] != 104 || midiArray[arrayIdx + 3] != 100) {
            return false;
        }
        arrayIdx = 10;
        int trackCnt = midiArray[arrayIdx] << 8 & 0xFF00 | midiArray[arrayIdx + 1] & 0xFF;
        if (trackCnt < 1) {
            return false;
        }
        arrayIdx = 14;
        int i = 0;
        while (i < trackCnt) {
            if (midiArray[arrayIdx] != 77 || midiArray[arrayIdx + 1] != 84 || midiArray[arrayIdx + 2] != 114 || midiArray[arrayIdx + 3] != 107) {
                return false;
            }
            int trackLen = midiArray[arrayIdx += 4] << 24 & 0xFF000000 | midiArray[arrayIdx + 1] << 16 & 0xFF0000 | midiArray[arrayIdx + 2] << 8 & 0xFF00 | midiArray[arrayIdx + 3] & 0xFF;
            arrayIdx += 4;
            if ((arrayIdx += trackLen) > midiArray.length) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static void getMusicRhythm() throws Exception {
        int arrayIdx = 14;
        int i = 0;
        while (i < trackCnt) {
            int trackLen = midiArray[arrayIdx += 4] << 24 & 0xFF000000 | midiArray[arrayIdx + 1] << 16 & 0xFF0000 | midiArray[arrayIdx + 2] << 8 & 0xFF00 | midiArray[arrayIdx + 3] & 0xFF;
            ParseMIDI.parseTrackInfo(midiArray, arrayIdx += 4, trackLen, i);
            arrayIdx += trackLen;
            ++i;
        }
    }

    protected static void parseTrackInfo(byte[] data, int index, int len, int trackIdx) throws Exception {
        long tickCount = 0L;
        int startIdx = index;
        int endIdx = index + len - 1;
        block15: while (startIdx < endIdx) {
            int interval = 0;
            while ((data[startIdx] & 0x80) != 0) {
                interval = interval * 128 + (data[startIdx] & 0x7F);
                ++startIdx;
            }
            interval = interval * 128 + (data[startIdx] & 0x7F);
            long tmpTime = (tickCount += (long)interval) * DNPeriod / DNtickNum;
            block0 : switch (data[++startIdx] & 0xF0) {
                case 128: {
                    startIdx += 3;
                    break;
                }
                case 144: {
                    if (track_rhythm[trackIdx] == null || track_rhythm[trackIdx] != null && tmpTime > track_rhythm[trackIdx][track_rhythm[trackIdx].length - 1]) {
                        ParseMIDI.track_rhythm[trackIdx] = ParseMIDI.addToArray(tmpTime, track_rhythm[trackIdx]);
                        ParseMIDI.track_velocity[trackIdx] = ParseMIDI.addToArray(data[startIdx + 2], track_velocity[trackIdx]);
                        ParseMIDI.track_note[trackIdx] = ParseMIDI.addToArray((byte)((data[startIdx + 1] + 12) / 12 - 2), track_note[trackIdx]);
                    }
                    startIdx += 3;
                    break;
                }
                case 160: {
                    startIdx += 3;
                    break;
                }
                case 176: {
                    startIdx += 3;
                    break;
                }
                case 192: {
                    startIdx += 2;
                    break;
                }
                case 208: {
                    startIdx += 2;
                    break;
                }
                case 224: {
                    startIdx += 3;
                    break;
                }
                case 240: {
                    int tmpLen;
                    if ((data[startIdx] & 0xFF) == 240) {
                        ++startIdx;
                        int sysLen = 0;
                        while ((data[startIdx] & 0x80) != 0) {
                            sysLen = sysLen * 128 + (data[startIdx] & 0x7F);
                            ++startIdx;
                        }
                        sysLen = sysLen * 128 + (data[startIdx] & 0x7F);
                        ++startIdx;
                        startIdx += sysLen;
                        break;
                    }
                    if ((data[startIdx] & 0xFF) != 255) continue block15;
                    switch (data[++startIdx] & 0xFF) {
                        case 3: {
                            ++startIdx;
                            tmpLen = 0;
                            while ((data[startIdx] & 0x80) != 0) {
                                tmpLen = tmpLen * 128 + (data[startIdx] & 0x7F);
                                ++startIdx;
                            }
                            tmpLen = tmpLen * 128 + (data[startIdx] & 0x7F);
                            ParseMIDI.track_Name[trackIdx] = new String(data, ++startIdx, tmpLen).toLowerCase();
                            startIdx += tmpLen;
                            break block0;
                        }
                        case 81: {
                            DNPeriod = (data[startIdx + 2] << 16 & 0xFF0000 | data[startIdx + 3] << 8 & 0xFF00 | data[startIdx + 4] & 0xFF) / 1000;
                            startIdx += 5;
                            break block0;
                        }
                        case 88: {
                            molecule = data[startIdx + 2];
                            denominator = 1 << data[startIdx + 3];
                            startIdx += 6;
                            break block0;
                        }
                    }
                    ++startIdx;
                    tmpLen = 0;
                    while ((data[startIdx] & 0x80) != 0) {
                        tmpLen = tmpLen * 128 + (data[startIdx] & 0x7F);
                        ++startIdx;
                    }
                    tmpLen = tmpLen * 128 + (data[startIdx] & 0x7F);
                    ++startIdx;
                    startIdx += tmpLen;
                    break;
                }
                default: {
                    if (data[startIdx + 1] != 0 && (track_rhythm[trackIdx] == null || track_rhythm[trackIdx] != null && tmpTime > track_rhythm[trackIdx][track_rhythm[trackIdx].length - 1])) {
                        ParseMIDI.track_rhythm[trackIdx] = ParseMIDI.addToArray(tmpTime, track_rhythm[trackIdx]);
                        ParseMIDI.track_velocity[trackIdx] = ParseMIDI.addToArray(data[startIdx + 1], track_velocity[trackIdx]);
                        ParseMIDI.track_note[trackIdx] = ParseMIDI.addToArray((byte)((data[startIdx] + 12) / 12 - 2), track_note[trackIdx]);
                    }
                    startIdx += 2;
                }
            }
        }
    }

    protected static long[] addToArray(long val, long[] arry) {
        long[] rtn = null;
        if (arry == null) {
            rtn = new long[]{val};
        } else {
            int len = arry.length;
            rtn = new long[len + 1];
            int i = 0;
            while (i < len) {
                rtn[i] = arry[i];
                ++i;
            }
            rtn[len] = val;
        }
        arry = null;
        return rtn;
    }

    protected static byte[] addToArray(byte val, byte[] arry) {
        byte[] rtn = null;
        if (arry == null) {
            rtn = new byte[]{val};
        } else {
            int len = arry.length;
            rtn = new byte[len + 1];
            int i = 0;
            while (i < len) {
                rtn[i] = arry[i];
                ++i;
            }
            rtn[len] = val;
        }
        arry = null;
        return rtn;
    }

    protected static void combineRhythm() throws Exception {
        rhythm = null;
        velocity = null;
        note = null;
        int j = 0;
        while (j < track_rhythm[playTrack_1].length) {
            if (track_rhythm[playTrack_1][j] < track_rhythm[playTrack][0]) {
                rhythm = ParseMIDI.addToArray(track_rhythm[playTrack_1][j], rhythm);
                velocity = ParseMIDI.addToArray(track_velocity[playTrack_1][j], velocity);
                note = ParseMIDI.addToArray(track_note[playTrack_1][j], note);
            }
            ++j;
        }
        int i = 0;
        while (i < track_rhythm[playTrack].length - 1) {
            rhythm = ParseMIDI.addToArray(track_rhythm[playTrack][i], rhythm);
            velocity = ParseMIDI.addToArray(track_velocity[playTrack][i], velocity);
            note = ParseMIDI.addToArray(track_note[playTrack][i], note);
            if (track_rhythm[playTrack][i + 1] - track_rhythm[playTrack][i] > 5000L) {
                int j2 = 0;
                while (j2 < track_rhythm[playTrack_1].length) {
                    if (track_rhythm[playTrack_1][j2] > track_rhythm[playTrack][i] && track_rhythm[playTrack_1][j2] < track_rhythm[playTrack][i + 1]) {
                        rhythm = ParseMIDI.addToArray(track_rhythm[playTrack_1][j2], rhythm);
                        velocity = ParseMIDI.addToArray(track_velocity[playTrack_1][j2], velocity);
                        note = ParseMIDI.addToArray(track_note[playTrack_1][j2], note);
                    }
                    ++j2;
                }
            }
            ++i;
        }
        j = 0;
        while (j < track_rhythm[playTrack_1].length) {
            if (track_rhythm[playTrack_1][j] > track_rhythm[playTrack][track_rhythm[playTrack].length - 1]) {
                rhythm = ParseMIDI.addToArray(track_rhythm[playTrack_1][j], rhythm);
                velocity = ParseMIDI.addToArray(track_velocity[playTrack_1][j], velocity);
                note = ParseMIDI.addToArray(track_note[playTrack_1][j], note);
            }
            ++j;
        }
        ParseMIDI.track_rhythm[ParseMIDI.playTrack] = rhythm;
        ParseMIDI.track_velocity[ParseMIDI.playTrack] = velocity;
        ParseMIDI.track_note[ParseMIDI.playTrack] = note;
        int rhythmCnt = track_rhythm[playTrack].length;
        int i2 = 0;
        while (i2 < rhythmCnt - 1) {
            int j3 = 0;
            while (j3 < rhythmCnt - 1 - i2) {
                if (track_rhythm[playTrack][j3] > track_rhythm[playTrack][j3 + 1]) {
                    long m = track_rhythm[playTrack][j3];
                    ParseMIDI.track_rhythm[ParseMIDI.playTrack][j3] = track_rhythm[playTrack][j3 + 1];
                    ParseMIDI.track_rhythm[ParseMIDI.playTrack][j3 + 1] = m;
                    byte n = track_velocity[playTrack][j3];
                    ParseMIDI.track_velocity[ParseMIDI.playTrack][j3] = track_velocity[playTrack][j3 + 1];
                    ParseMIDI.track_velocity[ParseMIDI.playTrack][j3 + 1] = n;
                    n = track_note[playTrack][j3];
                    ParseMIDI.track_note[ParseMIDI.playTrack][j3] = track_note[playTrack][j3 + 1];
                    ParseMIDI.track_note[ParseMIDI.playTrack][j3 + 1] = n;
                }
                ++j3;
            }
            ++i2;
        }
    }
}

