/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.Random;

public class YTMath {
    private static Random ran = new Random();
    public static final int[] sin = new int[]{0, 17, 35, 52, 70, 87, 105, 122, 139, 156, 174, 191, 208, 225, 242, 259, 276, 292, 309, 326, 342, 358, 375, 391, 407, 423, 438, 454, 469, 485, 500, 515, 530, 545, 559, 574, 588, 602, 616, 629, 643, 656, 669, 682, 695, 707, 719, 731, 743, 755, 766, 777, 788, 799, 809, 819, 829, 839, 848, 857, 866, 875, 883, 891, 899, 906, 914, 921, 927, 934, 940, 946, 951, 956, 961, 966, 970, 974, 978, 982, 985, 988, 990, 993, 995, 996, 998, 999, 999, 1000, 1000};
    public static final int[] tan = new int[]{0, 17, 35, 52, 70, 87, 105, 123, 141, 158, 176, 194, 213, 231, 249, 268, 287, 306, 325, 344, 364, 384, 404, 424, 445, 466, 488, 510, 532, 554, 577, 601, 625, 649, 675, 700, 727, 754, 781, 810, 839, 869, 900, 933, 966, 1000, 1036, 1072, 1111, 1150, 1192, 1235, 1280, 1327, 1376, 1428, 1483, 1540, 1600, 1664, 1732, 1804, 1881, 1963, 2050, 2145, 2246, 2356, 2475, 2605, 2747, 2904, 3078, 3271, 3487, 3732, 4011, 4331, 4705, 5145, 5671, 6314, 7115, 8144, 9514, 11430, 14301, 19081, 28636, 57289, 0};

    public static final int toFixInt(int _value) {
        return _value << 16;
    }

    public static final int toNormalInt(int _value) {
        return _value >> 16;
    }

    public static final int getRandom(int min, int max) {
        try {
            if (max == min) {
                return min;
            }
            if (max < min) {
                int temp1 = min;
                min = max;
                max = temp1;
            }
            int temp = max - min + 1;
            temp = Math.abs(ran.nextInt() % temp);
            return temp += min;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static final int getRandom(int max) {
        return YTMath.getRandom(0, max - 1);
    }

    public static final int INT_TO_Q16(int x) {
        return x << 16;
    }

    public static final int Fmul(int a, int b) {
        return (int)((long)a * (long)b >> 16);
    }

    public static final int Fdiv(int a, int b) {
        return (int)(((long)a << 16) / (long)b);
    }

    public static final boolean randRatio(int ratio) {
        return YTMath.getRandom(100) < ratio;
    }

    public static final int getAbs(int _in) {
        return _in < 0 ? -_in : _in;
    }

    public static final boolean IsEvenNumber(int in) {
        return in == 0 || in % 2 == 0;
    }

    public static final int getSign(int _in) {
        return _in > 0 ? 1 : (_in < 0 ? -1 : 0);
    }

    public static final int getDiv(int _nValue, int _nDivisor) {
        return _nValue / _nDivisor;
    }

    public static final int getModInt(int _nValue, int _nDivisor) {
        return _nValue % _nDivisor;
    }

    public static final int getDistance(int x1, int y1, int x2, int y2) {
        int x = Math.abs(x2 - x1);
        int y = Math.abs(y2 - y1);
        int mn = Math.min(x, y);
        return x + y - (mn >> 1) - (mn >> 2) + (mn >> 3);
    }

    public static final int getRadiusX(int angle, int radius) {
        if (radius == 0) {
            return 0;
        }
        int x = (angle = (angle + 360) % 360) <= 90 ? YTMath.getDiv(radius * sin[90 - angle] + 500, 1000) : (angle <= 180 ? YTMath.getDiv(-(radius * sin[90 - (180 - angle)] + 500), 1000) : (angle <= 270 ? YTMath.getDiv(-(radius * sin[90 - (angle - 180)] + 500), 1000) : YTMath.getDiv(radius * sin[90 - (360 - angle)] + 500, 1000)));
        return x;
    }

    public static final int getRadiusY(int angle, int radius) {
        if (radius == 0) {
            return 0;
        }
        int y = (angle = (angle + 360) % 360) <= 90 ? YTMath.getDiv(-(radius * sin[angle] + 500), 1000) : (angle <= 180 ? YTMath.getDiv(-(radius * sin[180 - angle] + 500), 1000) : (angle <= 270 ? YTMath.getDiv(radius * sin[angle - 180] + 500, 1000) : YTMath.getDiv(radius * sin[360 - angle] + 500, 1000)));
        return y;
    }

    public static final int getAngleByTan(int slope) {
        for (int i = 0; i < 89; ++i) {
            if (slope < tan[i] || slope >= tan[i + 1]) continue;
            return i;
        }
        return 90;
    }

    public static final int getAngle(int x1, int y1, int x2, int y2) {
        int angle = 0;
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx > 0) {
            if (dy < 0) {
                int slope = YTMath.getDiv(-1000 * dy, dx);
                angle = YTMath.getAngleByTan(slope);
            } else if (dy > 0) {
                int slope = YTMath.getDiv(1000 * dy, dx);
                angle = 360 - YTMath.getAngleByTan(slope);
            } else if (dy == 0) {
                angle = 0;
            }
        } else if (dx == 0) {
            angle = dy >= 0 ? 270 : 90;
        } else if (dy < 0) {
            int slope = YTMath.getDiv(1000 * dy, dx);
            angle = 180 - YTMath.getAngleByTan(slope);
        } else if (dy > 0) {
            int slope = YTMath.getDiv(-1000 * dy, dx);
            angle = 180 + YTMath.getAngleByTan(slope);
        } else if (dy == 0) {
            angle = 180;
        }
        return angle;
    }

    public static final short byteToShort(byte[] src, int offset) {
        return (short)((src[offset + 1] & 0xFF) << 8 | src[offset] & 0xFF);
    }

    public static final int ByteToInt(byte b) {
        return b & 0xFF;
    }

    public static final int byteSToInt(byte[] src, int offset) {
        return (src[offset + 3] & 0xFF) << 24 | (src[offset + 2] & 0xFF) << 16 | (src[offset + 1] & 0xFF) << 8 | src[offset] & 0xFF;
    }

    public static final byte[] shortToBytes(short value) {
        byte[] data = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8)};
        return data;
    }

    public static final byte[] intToBytes(int value) {
        byte[] data = new byte[4];
        data[3] = (byte)((value & 0xFF000000) >> 24);
        data[2] = (byte)((value & 0xFF0000) >> 16);
        data[1] = (byte)((value & 0xFF00) >> 8);
        data[0] = (byte)(value & 0xFF);
        return data;
    }

    public static void PaoSort(int[][] values, int compareLine) {
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values.length - i - 1; ++j) {
                if (values[j][compareLine] <= values[j + 1][compareLine]) continue;
                for (int k = 0; k < values[j].length; ++k) {
                    int temp = values[j][k];
                    values[j][k] = values[j + 1][k];
                    values[j + 1][k] = temp;
                }
            }
        }
    }

    public static void PaoSort(int[] values) {
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values.length - i - 1; ++j) {
                if (values[j] <= values[j + 1]) continue;
                int temp = values[j];
                values[j] = values[j + 1];
                values[j + 1] = temp;
            }
        }
    }

    private static void swap(int[][] array, int in, int i, int j) {
        int len = array.length;
        for (int k = 0; k < len; ++k) {
            int tmp = array[k][i];
            array[k][i] = array[k][j];
            array[k][j] = tmp;
        }
    }

    private static int partition(int[][] array, int in, int begin, int end) {
        int index = YTMath.getRandom(begin, end);
        int pivot = array[in][index];
        YTMath.swap(array, in, index, end);
        for (int i = index = begin; i < end; ++i) {
            if (array[in][i] > pivot) continue;
            YTMath.swap(array, in, index++, i);
        }
        YTMath.swap(array, in, index, end);
        return index;
    }

    private static void qsort(int[][] array, int in, int begin, int end) {
        if (end > begin) {
            int index = YTMath.partition(array, in, begin, end);
            YTMath.qsort(array, in, begin, index - 1);
            YTMath.qsort(array, in, index + 1, end);
        }
    }

    public static void sort(int[][] array, int in) {
        YTMath.qsort(array, in, 0, array[in].length - 1);
    }
}

