/*
 * Decompiled with CFR 0.152.
 */
package utils;

import utils.YTGraphics;
import utils.YTImage;

public class YTClock {
    private int m_currentTime = 0;
    int ms = 0;
    int h = 0;
    int m = 0;
    int s = 0;
    private boolean showHour = false;
    private boolean showMilliseconds = false;
    private boolean add = true;
    private boolean stop = false;
    private boolean over = false;
    private int limit = 0;

    public YTClock(int _second, boolean _add, boolean _showhour, boolean _showmilliseconds) {
        this.add = _add;
        this.showHour = _showhour;
        this.showMilliseconds = _showmilliseconds;
        this.limit = _second;
        if (this.add) {
            this.m_currentTime = 0;
        } else {
            this.m_currentTime = this.limit * 1000;
            this.ms = this.m_currentTime % 1000 / 100;
            int tmp = this.m_currentTime / 1000;
            this.h = tmp / 3600;
            this.m = tmp % 3600 / 60;
            this.s = tmp - this.h * 3600 - this.m * 60;
        }
        this.stop = true;
        this.over = false;
    }

    public void start() {
        this.stop = false;
    }

    public void stop() {
        this.stop = true;
    }

    public boolean over() {
        return this.over;
    }

    public void update(int timeStep) {
        if (!this.stop && !this.over) {
            this.m_currentTime = this.add ? (this.m_currentTime += timeStep) : (this.m_currentTime -= timeStep);
            this.ms = this.m_currentTime % 1000 / 100;
            int tmp = this.m_currentTime / 1000;
            this.h = tmp / 3600;
            this.m = tmp % 3600 / 60;
            this.s = tmp - this.h * 3600 - this.m * 60;
            if (this.add) {
                if (tmp >= this.limit) {
                    this.over = true;
                    this.m_currentTime = this.limit * 1000;
                }
            } else if (tmp <= 0) {
                this.over = true;
                this.m_currentTime = 0;
            }
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public int getRemainTime() {
        if (this.add) {
            return this.limit - this.m_currentTime / 1000;
        }
        return this.m_currentTime / 1000;
    }

    public int getSpendTime() {
        if (this.add) {
            return this.m_currentTime / 1000;
        }
        return this.limit - this.m_currentTime / 1000;
    }

    public void lengthenTime(int _seconds) {
        if (_seconds <= 0 || this.over) {
            return;
        }
        if (this.add) {
            this.limit += _seconds;
        } else {
            this.m_currentTime += _seconds * 1000;
        }
    }

    public void shortenTime(int _seconds) {
        if (_seconds <= 0 || this.over) {
            return;
        }
        if (this.add) {
            this.m_currentTime += _seconds * 1000;
        } else {
            this.m_currentTime -= _seconds * 1000;
            if (this.m_currentTime < 0) {
                this.m_currentTime = 0;
            }
        }
    }

    public String trans2String() {
        StringBuffer output = new StringBuffer(16);
        output.setLength(0);
        if (this.over) {
            if (this.add) {
                this.h = this.limit / 3600;
                this.m = this.limit % 3600 / 60;
                this.s = this.limit - this.h * 3600 - this.m * 60;
                this.ms = 0;
            } else {
                this.h = 0;
                this.m = 0;
                this.s = 0;
                this.ms = 0;
            }
        }
        if (this.showHour) {
            if (this.h < 10) {
                output.append("0");
            }
            output.append(Integer.toString(this.h));
            output.append(":");
        }
        if (this.m < 10) {
            output.append("0");
        }
        output.append(Integer.toString(this.m));
        output.append(":");
        if (this.s < 10) {
            output.append("0");
        }
        output.append(Integer.toString(this.s));
        if (this.showMilliseconds) {
            output.append(":");
            output.append(Integer.toString(this.ms));
        }
        return output.toString();
    }

    public void drawTime(YTGraphics render, int _x, int _y, int _anchor, YTImage _numImage) {
        render.drawNumber(this.trans2String(), _x, _y, _anchor, _numImage);
    }
}

