/*
 * Decompiled with CFR 0.152.
 */
package utils;

import main.YTCanvas;
import utils.YTGraphics;

public class YTDialog {
    private final int FRAME_TIME;
    private int m_currentFrameTime = 0;
    private int frame_speed = 0;
    private int frame_x = 0;
    public int y = 0;
    private int content_x = 0;
    private int content_y = 0;
    private int content_w = 0;
    private int content_h = 0;
    private int FrameHeight = 0;
    private final int range_size;
    private final int range_dis;
    private int m_count = 0;
    private int m_charnum = 0;
    private YTCanvas m_canvas = null;
    private String[] m_msg = null;
    private int m_length = 0;
    private boolean needKey = false;
    public boolean dialog_complete = false;

    public YTDialog(YTCanvas _canvas) {
        this.FRAME_TIME = 100;
        this.range_size = 5;
        this.range_dis = 4;
        this.m_canvas = _canvas;
        this.frame_speed = 60;
        this.FrameHeight = (this.m_canvas.m_font.getLineHeight() << 1) + 10 + 8;
        this.content_x = 9;
        this.content_y = 320 - this.FrameHeight + 5 + 4;
        this.content_w = 222;
        this.content_h = this.FrameHeight - 18;
        this.frame_x = -240;
        this.y = 320 - this.FrameHeight;
        this.m_charnum = this.content_w / this.m_canvas.m_font.getCharacterWidth('\u9e45');
    }

    public void init(String _content, boolean restart) {
        this.needKey = false;
        if (restart) {
            this.frame_x = -240;
        }
        this.m_currentFrameTime = 0;
        this.m_length = _content.length();
        int msg_length = 0;
        msg_length = this.m_length % this.m_charnum == 0 ? this.m_length / this.m_charnum : this.m_length / this.m_charnum + 1;
        this.m_count = 0;
        this.m_msg = new String[msg_length];
        for (int i = 0; i < msg_length - 1; ++i) {
            this.m_msg[i] = _content.substring(i * this.m_charnum, (i + 1) * this.m_charnum);
        }
        this.m_msg[msg_length - 1] = _content.substring((msg_length - 1) * this.m_charnum, _content.length());
        this.dialog_complete = false;
    }

    public void update(int _timeStep) {
        if (this.frame_x < 0) {
            this.frame_x += this.frame_speed;
            if (this.frame_x >= 0) {
                this.frame_x = 0;
            }
            return;
        }
        this.m_canvas.animan_arrow_down.updateAnim(_timeStep);
        if (this.frame_x == 0) {
            this.processKeyEvent();
            if (!this.needKey) {
                this.m_currentFrameTime += _timeStep;
                if (this.m_currentFrameTime >= 100) {
                    if (this.m_count < this.m_length) {
                        ++this.m_count;
                    }
                    if (this.m_count >= this.m_length) {
                        this.needKey = true;
                    } else if (this.m_count > this.m_charnum && this.m_count % this.m_charnum == this.m_charnum - 1) {
                        this.needKey = true;
                    }
                    this.m_currentFrameTime = 0;
                }
            }
        }
    }

    public void draw(YTGraphics _painter) {
        if (this.dialog_complete) {
            return;
        }
        _painter.fillRect(39423, this.frame_x, this.y, 240, this.FrameHeight);
        _painter.fillRect(14283263, this.frame_x + 5, this.y + 5, 230, this.FrameHeight - 10);
        if (this.frame_x == 0) {
            if (this.m_count > this.m_charnum) {
                int line = this.m_count / this.m_charnum;
                int length = this.m_count % this.m_charnum;
                this.m_canvas.m_font.drawSingleLine(_painter, this.m_msg[line - 1], this.content_x, this.content_y, 20, 0, -1);
                if (length >= this.m_msg[line].length()) {
                    this.m_canvas.m_font.drawSingleLine(_painter, this.m_msg[line].substring(0, this.m_msg[line].length()), this.content_x, this.content_y + this.m_canvas.m_font.getLineHeight(), 20, 0, -1);
                } else {
                    this.m_canvas.m_font.drawSingleLine(_painter, this.m_msg[line].substring(0, length + 1), this.content_x, this.content_y + this.m_canvas.m_font.getLineHeight(), 20, 0, -1);
                }
            } else if (this.m_count > this.m_msg[0].length()) {
                this.m_canvas.m_font.drawSingleLine(_painter, this.m_msg[0].substring(0, this.m_msg[0].length()), this.content_x, this.content_y, 20, 0, -1);
            } else {
                this.m_canvas.m_font.drawSingleLine(_painter, this.m_msg[0].substring(0, this.m_count), this.content_x, this.content_y, 20, 0, -1);
            }
            this.m_canvas.animan_arrow_down.draw(_painter, 229, 305, false, false);
        }
    }

    public void processKeyEvent() {
        if (this.dialog_complete) {
            return;
        }
        if (this.needKey) {
            if (this.m_canvas.keypressFIRE) {
                if (this.m_count < this.m_length - 1) {
                    this.needKey = false;
                } else {
                    this.dialog_complete = true;
                }
                this.m_canvas.clearkeyPressed();
            }
        } else if (this.m_canvas.keypressFIRE) {
            this.m_count = this.m_charnum * (this.m_count / this.m_charnum + 1) - 1;
            if (this.m_count > this.m_charnum) {
                this.needKey = true;
            }
            this.m_canvas.clearkeyPressed();
        }
    }
}

