/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.DataInputStream;
import utils.YTAniAction;
import utils.YTAniClip;
import utils.YTAniFrame;
import utils.YTAniSprite;
import utils.YTGraphics;
import utils.YTImage;
import utils.YTUtils;

public class YTAnimation {
    int export_type = -1;
    private static final int type_all = 0;
    private static final int type_dat = 1;
    private int img_num = 0;
    private YTImage[] m_images = null;
    private YTAniClip[] m_clips = null;
    private YTAniFrame[] m_frames = null;
    private YTAniAction[] m_actions = null;

    public void init(String res, YTImage[] _img) {
        try {
            int i;
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(res));
            if (dis == null) {
                return;
            }
            this.export_type = dis.readByte();
            this.img_num = dis.readByte();
            if (this.export_type == 1 && (_img == null || _img.length < this.img_num)) {
                return;
            }
            this.m_images = new YTImage[this.img_num];
            if (this.export_type == 0) {
                _img = null;
                for (i = 0; i < this.img_num; ++i) {
                    int length = dis.readInt();
                    byte[] img_data = new byte[length];
                    dis.read(img_data, 0, length);
                    this.m_images[i] = new YTImage(img_data);
                }
            } else {
                for (i = 0; i < this.img_num; ++i) {
                    this.m_images[i] = _img[i];
                }
            }
            short count = dis.readShort();
            this.m_clips = new YTAniClip[count];
            for (i = 0; i < count; ++i) {
                this.m_clips[i] = YTAniClip.readData(dis);
            }
            count = dis.readShort();
            this.m_frames = new YTAniFrame[count];
            for (i = 0; i < count; ++i) {
                this.m_frames[i] = YTAniFrame.readData(dis);
            }
            count = dis.readShort();
            this.m_actions = new YTAniAction[count];
            for (i = 0; i < count; ++i) {
                this.m_actions[i] = YTAniAction.readData(dis);
            }
            dis.close();
            dis = null;
            YTUtils.doGC();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getFrameWidth(int _actionId, int _index) {
        if (_actionId < 0 || _actionId >= this.m_actions.length) {
            return -1;
        }
        if (_index < 0 || _index >= this.m_actions[_actionId].frame_num) {
            return -1;
        }
        return this.m_frames[this.m_actions[_actionId].framesId[_index]].m_width;
    }

    public int getFrameHeight(int _actionId, int _index) {
        if (_actionId < 0 || _actionId >= this.m_actions.length) {
            return -1;
        }
        if (_index < 0 || _index >= this.m_actions[_actionId].frame_num) {
            return -1;
        }
        return this.m_frames[this.m_actions[_actionId].framesId[_index]].m_height;
    }

    public void draw(YTGraphics render, int _actionId, int _index, int x, int y, boolean flip_x, boolean flip_y) {
        try {
            if (_actionId < 0 || _actionId >= this.m_actions.length) {
                return;
            }
            if (_index < 0 || _index >= this.m_actions[_actionId].frame_num) {
                return;
            }
            short frameIndex = this.m_actions[_actionId].framesId[_index];
            int dgflag = 0;
            int clipx = render.getClipX();
            int clipy = render.getClipY();
            int clipwidth = render.getClipWidth();
            int clipheight = render.getClipHeight();
            int i = 0;
            int length = this.m_frames[frameIndex].m_sprites.length;
            for (i = 0; i < length; ++i) {
                YTAniSprite spt = this.m_frames[frameIndex].m_sprites[i];
                YTAniClip clip = this.m_clips[spt.m_clipId];
                int flag = spt.getTrans();
                dgflag = render.getMultiTrans(flag, flip_x, flip_y);
                int posX = x;
                int posY = y;
                posX = flip_x ? (posX -= spt.m_x) : (posX += spt.m_x);
                posY = flip_y ? (posY -= spt.m_y) : (posY += spt.m_y);
                render.drawRegion(this.m_images[clip.m_imgId], clip.dist_x, clip.dist_y, clip.dist_w, clip.dist_h, posX -= flip_x ? clip.dist_w : (short)0, posY -= flip_y ? clip.dist_h : (short)0, dgflag, 20);
            }
            render.clipArea(clipx, clipy, clipwidth, clipheight);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getDelay(int _actionId, int _index) {
        if (_actionId < 0 || _actionId >= this.m_actions.length) {
            return -1;
        }
        if (_index < 0 || _index >= this.m_actions[_actionId].frame_num) {
            return -1;
        }
        return this.m_actions[_actionId].framesDuration[_index];
    }

    public int getFrameNum(int _actionId) {
        if (_actionId < 0 || _actionId >= this.m_actions.length) {
            return -1;
        }
        return this.m_actions[_actionId].frame_num;
    }
}

