/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Angle;
import game.Ball;
import game.Entity;
import game.ImageBank;
import game.SoccerCanvas;
import game.SoundBank;
import javax.microedition.lcdui.Graphics;

public class Player
extends Entity {
    private double topspeed = 0.12;
    private double accel = 0.015;
    private double decel = 0.6;
    private double distFromMid;
    private int halfWidth;

    public Player(SoccerCanvas canvas) {
        super(canvas);
        this.angle = new Angle(1.5707963267948966);
        this.width = ImageBank.getImage("/player/0.0.png").getWidth();
        this.halfWidth = this.width / 2;
        this.height = this.width;
        this.distFromMid = (double)canvas.getFieldSize() - 0.4 * (double)this.halfWidth;
    }

    public void updateSpeed() {
        this.topspeed = 0.12 + (double)this.canvas.getLevel() * 0.02;
        this.accel = 0.015 + (double)this.canvas.getLevel() * 0.002;
        this.decel = 0.6 + (double)this.canvas.getLevel() * 0.01;
    }

    protected void checkMove() {
        boolean moving = false;
        int state = this.canvas.getKeyStates();
        if ((state & 4) != 0) {
            this.moveCW();
            moving = true;
        }
        if ((state & 0x20) != 0) {
            this.moveCCW();
            moving = true;
        }
        this.angle.add(this.addAngle);
        if (!moving) {
            this.addAngle *= this.decel;
        }
    }

    public void think() {
        double halfHeight;
        this.checkMove();
        this.x = (double)this.canvas.getFieldMidX() + Math.cos(this.angle.getAngle()) * this.distFromMid;
        this.y = (double)this.canvas.getFieldMidY() + Math.sin(this.angle.getAngle()) * this.distFromMid;
        Ball ball = this.canvas.getBall();
        double dx = Math.abs((double)this.canvas.getFieldMidX() - ball.x);
        double dy = Math.abs((double)this.canvas.getFieldMidY() - ball.y);
        double ballDfm = Math.sqrt(dx * dx + dy * dy);
        if (Math.abs(this.distFromMid - (double)((float)this.halfWidth / 2.0f) - ballDfm) <= (double)((float)this.halfWidth / 2.0f) && Math.abs(this.angle.diff(this.canvas.getBall().getAngle())) < 1.5707963267948966 && (ballDfm = Math.sqrt((dx = this.x - ball.x) * dx + (dy = this.y - ball.y) * dy)) < (halfHeight = (double)(this.height + ball.getHeight()) / 2.0)) {
            if ((ballDfm -= (double)this.height * 0.2) < 0.0) {
                ballDfm = 0.0;
            }
            if (this.angle.getAngle() <= 0.7853981633974483 || this.angle.getAngle() > 5.497787143782138) {
                if (dy < 0.0) {
                    ballDfm *= -1.0;
                }
            } else if (this.angle.getAngle() <= 2.356194490192345) {
                if (dx > 0.0) {
                    ballDfm *= -1.0;
                }
            } else if (this.angle.getAngle() <= 3.9269908169872414) {
                if (dy > 0.0) {
                    ballDfm *= -1.0;
                }
            } else if (this.angle.getAngle() <= 5.497787143782138 && dx < 0.0) {
                ballDfm *= -1.0;
            }
            double a2 = this.angle.getAngle() + Math.PI + ballDfm / halfHeight * Math.PI * 0.1;
            this.canvas.getBall().kick(a2, -this.addAngle * 0.05);
            this.canvas.getDisplay().vibrate(30);
            SoundBank.playSound("/kick");
        }
    }

    public void paint(Graphics gr) {
        this.drawRotatedImage(gr, "player", 0, 0, (int)this.x, (int)this.y, this.angle.getAngle());
    }

    public void moveCW() {
        if (this.addAngle < 0.0) {
            this.addAngle *= this.decel;
        }
        this.addAngle += this.accel;
        if (this.addAngle > this.topspeed) {
            this.addAngle = this.topspeed;
        }
    }

    public void moveCCW() {
        if (this.addAngle > 0.0) {
            this.addAngle *= this.decel;
        }
        this.addAngle -= this.accel;
        if (this.addAngle < -this.topspeed) {
            this.addAngle = -this.topspeed;
        }
    }
}

