/*
 * Decompiled with CFR 0.152.
 */
package com.tinyline.tiny2d;

import com.tinyline.tiny2d.Tiny2D;
import com.tinyline.tiny2d.TinyPoint;
import com.tinyline.tiny2d.TinyRect;

public final class TinyMatrix {
    public int a;
    public int b;
    public int c;
    public int d;
    public int tx;
    public int ty;

    public TinyMatrix() {
        this.a = 65536;
        this.d = 65536;
    }

    public TinyMatrix(TinyMatrix tinyMatrix) {
        this.a = tinyMatrix.a;
        this.b = tinyMatrix.b;
        this.c = tinyMatrix.c;
        this.d = tinyMatrix.d;
        this.tx = tinyMatrix.tx;
        this.ty = tinyMatrix.ty;
    }

    public final void reset() {
        this.a = 65536;
        this.d = 65536;
        this.ty = 0;
        this.tx = 0;
        this.c = 0;
        this.b = 0;
    }

    public final void concatenate(TinyMatrix tinyMatrix) {
        int n = 0;
        int n2 = 0;
        int n3 = Tiny2D.mul(this.a, tinyMatrix.a);
        int n4 = Tiny2D.mul(this.d, tinyMatrix.d);
        int n5 = Tiny2D.mul(this.tx, tinyMatrix.a) + tinyMatrix.tx;
        int n6 = Tiny2D.mul(this.ty, tinyMatrix.d) + tinyMatrix.ty;
        if (this.b != 0 || this.c != 0 || tinyMatrix.b != 0 || tinyMatrix.c != 0) {
            n3 += Tiny2D.mul(this.b, tinyMatrix.c);
            n4 += Tiny2D.mul(this.c, tinyMatrix.b);
            n = 0 + (Tiny2D.mul(this.a, tinyMatrix.b) + Tiny2D.mul(this.b, tinyMatrix.d));
            n2 = 0 + (Tiny2D.mul(this.c, tinyMatrix.a) + Tiny2D.mul(this.d, tinyMatrix.c));
            n5 += Tiny2D.mul(this.ty, tinyMatrix.c);
            n6 += Tiny2D.mul(this.tx, tinyMatrix.b);
        }
        this.a = n3;
        this.b = n;
        this.c = n2;
        this.d = n4;
        this.tx = n5;
        this.ty = n6;
    }

    public final void copy(TinyMatrix tinyMatrix) {
        this.a = tinyMatrix.a;
        this.b = tinyMatrix.b;
        this.c = tinyMatrix.c;
        this.d = tinyMatrix.d;
        this.tx = tinyMatrix.tx;
        this.ty = tinyMatrix.ty;
    }

    public final void preConcatenate(TinyMatrix tinyMatrix) {
        int n = 0;
        int n2 = 0;
        int n3 = Tiny2D.mul(tinyMatrix.a, this.a);
        int n4 = Tiny2D.mul(tinyMatrix.d, this.d);
        int n5 = Tiny2D.mul(tinyMatrix.tx, this.a) + this.tx;
        int n6 = Tiny2D.mul(tinyMatrix.ty, this.d) + this.ty;
        if (tinyMatrix.b != 0 || tinyMatrix.c != 0 || this.b != 0 || this.c != 0) {
            n3 += Tiny2D.mul(tinyMatrix.b, this.c);
            n4 += Tiny2D.mul(tinyMatrix.c, this.b);
            n = 0 + (Tiny2D.mul(tinyMatrix.a, this.b) + Tiny2D.mul(tinyMatrix.b, this.d));
            n2 = 0 + (Tiny2D.mul(tinyMatrix.c, this.a) + Tiny2D.mul(tinyMatrix.d, this.c));
            n5 += Tiny2D.mul(tinyMatrix.ty, this.c);
            n6 += Tiny2D.mul(tinyMatrix.tx, this.b);
        }
        this.a = n3;
        this.b = n;
        this.c = n2;
        this.d = n4;
        this.tx = n5;
        this.ty = n6;
    }

    public final TinyMatrix inverse() {
        TinyMatrix tinyMatrix;
        block4: {
            int n;
            block3: {
                TinyMatrix tinyMatrix2;
                TinyPoint tinyPoint;
                block2: {
                    tinyMatrix = new TinyMatrix();
                    tinyPoint = new TinyPoint();
                    if (this.b != 0 || this.c != 0) break block2;
                    tinyMatrix.a = Tiny2D.div(65536, this.a);
                    tinyMatrix.d = Tiny2D.div(65536, this.d);
                    tinyMatrix.tx = -Tiny2D.mul(tinyMatrix.a, this.tx);
                    tinyMatrix2 = tinyMatrix;
                    n = Tiny2D.mul(tinyMatrix.d, this.ty);
                    break block3;
                }
                int n2 = Tiny2D.div(this.a, 65536);
                int n3 = Tiny2D.div(this.b, 65536);
                int n4 = Tiny2D.div(this.c, 65536);
                int n5 = Tiny2D.div(this.d, 65536);
                int n6 = Tiny2D.mul(n2, n5) - Tiny2D.mul(n3, n4);
                if (n6 == 0) break block4;
                tinyMatrix.a = Tiny2D.div(this.d, n6);
                tinyMatrix.b = -Tiny2D.div(this.b, n6);
                tinyMatrix.c = -Tiny2D.div(this.c, n6);
                tinyMatrix.d = Tiny2D.div(this.a, n6);
                tinyPoint.x = this.tx;
                tinyPoint.y = this.ty;
                tinyMatrix.a(tinyPoint);
                tinyMatrix.tx = -tinyPoint.x;
                tinyMatrix2 = tinyMatrix;
                n = tinyPoint.y;
            }
            tinyMatrix2.ty = -n;
        }
        return tinyMatrix;
    }

    public final void translate(int n, int n2) {
        this.a = 65536;
        this.d = 65536;
        this.c = 0;
        this.b = 0;
        this.tx = n;
        this.ty = n2;
    }

    public final void scale(int n, int n2) {
        this.a = n;
        this.d = n2;
        this.c = 0;
        this.b = 0;
        this.ty = 0;
        this.tx = 0;
    }

    public final void rotate(int n, int n2, int n3) {
        this.a = Tiny2D.cos(n);
        this.b = Tiny2D.sin(n);
        this.c = -this.b;
        this.d = this.a;
        this.tx = n2 - Tiny2D.mul(this.a, n2) + Tiny2D.mul(this.b, n3);
        this.ty = n3 - Tiny2D.mul(this.b, n2) - Tiny2D.mul(this.a, n3);
    }

    public final void skew(int n, int n2) {
        this.a = 65536;
        this.d = 65536;
        this.ty = 0;
        this.tx = 0;
        this.b = Tiny2D.tan(n2);
        this.c = Tiny2D.tan(n);
    }

    private final void a(TinyPoint tinyPoint) {
        int n = Tiny2D.mul(this.a, tinyPoint.x);
        if (this.c != 0) {
            n += Tiny2D.mul(this.c, tinyPoint.y);
        }
        int n2 = Tiny2D.mul(this.d, tinyPoint.y);
        if (this.b != 0) {
            n2 += Tiny2D.mul(this.b, tinyPoint.x);
        }
        tinyPoint.x = n;
        tinyPoint.y = n2;
    }

    public final void transform(TinyPoint tinyPoint) {
        int n = Tiny2D.mul(this.a, tinyPoint.x) + this.tx;
        if (this.c != 0) {
            n += Tiny2D.mul(this.c, tinyPoint.y);
        }
        int n2 = Tiny2D.mul(this.d, tinyPoint.y) + this.ty;
        if (this.b != 0) {
            n2 += Tiny2D.mul(this.b, tinyPoint.x);
        }
        tinyPoint.x = n;
        tinyPoint.y = n2;
    }

    public final void transformToDev(TinyPoint tinyPoint, TinyPoint tinyPoint2) {
        int n = Tiny2D.mul(this.a, tinyPoint.x) + this.tx;
        if (this.c != 0) {
            n += Tiny2D.mul(this.c, tinyPoint.y);
        }
        int n2 = Tiny2D.mul(this.d, tinyPoint.y) + this.ty;
        if (this.b != 0) {
            n2 += Tiny2D.mul(this.b, tinyPoint.x);
        }
        n = n < 0 ? (n -= 128) : (n += 128);
        n2 = n2 < 0 ? (n2 -= 128) : (n2 += 128);
        tinyPoint2.x = n >> 8;
        tinyPoint2.y = n2 >> 8;
    }

    public final TinyRect transformToDev(TinyRect tinyRect) {
        TinyRect tinyRect2 = new TinyRect();
        TinyPoint tinyPoint = new TinyPoint();
        TinyPoint tinyPoint2 = new TinyPoint();
        if (!tinyRect.isEmpty()) {
            tinyPoint.x = tinyRect.xmin;
            tinyPoint.y = tinyRect.ymin;
            tinyPoint2.x = 0;
            tinyPoint2.y = 0;
            this.transformToDev(tinyPoint, tinyPoint2);
            tinyRect2.add(tinyPoint2);
            tinyPoint.x = tinyRect.xmax;
            this.transformToDev(tinyPoint, tinyPoint2);
            tinyRect2.add(tinyPoint2);
            tinyPoint.y = tinyRect.ymax;
            this.transformToDev(tinyPoint, tinyPoint2);
            tinyRect2.add(tinyPoint2);
            tinyPoint.x = tinyRect.xmin;
            this.transformToDev(tinyPoint, tinyPoint2);
            tinyRect2.add(tinyPoint2);
        }
        return tinyRect2;
    }

    final int a(int n) {
        TinyPoint tinyPoint = new TinyPoint();
        TinyPoint tinyPoint2 = new TinyPoint();
        TinyPoint tinyPoint3 = new TinyPoint();
        tinyPoint.y = 0;
        tinyPoint.x = 0;
        this.a(tinyPoint);
        tinyPoint2.x = n;
        tinyPoint2.y = 0;
        this.a(tinyPoint2);
        tinyPoint3.x = 0;
        tinyPoint3.y = n;
        this.a(tinyPoint3);
        int n2 = Tiny2D.max(tinyPoint.distance(tinyPoint2), tinyPoint.distance(tinyPoint3));
        return n2;
    }
}

