/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Bonus {
    public static final int TIMER_SHIELD_NORMAL_DIVIDER = 5;
    public static final int TIMER_NUKE_NORMAL_DIVIDER = 4;
    public static final int TIMER_SHIELD_SURVIVAL = 2000;
    public static final int TIMER_NUKE_SURVIVAL = 3000;
    public static final int TIMER_SHIELD_REDUCTION = 50;
    public static final int TIMER_NUKE_REDUCTION = 75;
    public static final int BONUS_STRING_MIN_POS_X = 8;
    public static final int BONUS_STRING_MAX_DELTA_X = -8;
    public static final int BONUS_STRING_DELTA_Y = -8;
    public static final int BONUS_STRING_MOVE_Y = -2;
    public static final int BONUS_MAX_SPEED_LASER = 4;
    public static final int BONUS_MAX_SPEED_NORMAL = 6;
    public static final int BONUS_MAX_WIDTH = 28;
    public static final int BONUS_MAX_HEIGHT = 28;
    public static final int POINT_FONT_HEIGHT = 15;
    public static final int[] pointFontPos = new int[]{0, 12, 12, 8, 20, 8, 28, 11, 39, 11, 50, 9, 59, 11, 70, 10, 80, 13, 93, 10};
    public static Image imgPowerups;
    public static Image imgCrates;
    public static Image imgPointScore;
    public static int[] posX;
    public static int[] posY;
    public static int[] width;
    public static int[] height;
    public static int[] speedX;
    public static int[] speedY;
    public static int[] type;
    public static int takenPosX;
    public static int takenPosY;
    public static int takenWidth;
    public static int takenHeight;
    public static int takenType;
    public static int takenAddX;
    public static int takenAddY;
    public static int bonusLoop;
    public static boolean[] bonusArray;
    public static int nbBonusPossible;
    public static int timerShield;
    public static int timerNuke;
    public static final int MAX_BONUS_ON_SCREEN = 6;
    public static final int TYPE_NONE = -1;
    public static final int TYPE_NUKE = 0;
    public static final int TYPE_SHIELD = 1;
    public static final int TYPE_SPEED = 2;
    public static final int TYPE_FIREPOWERUP = 3;
    public static final int TYPE_FIRESPEEDUP = 4;
    public static final int TYPE_FIREUP = 5;
    public static final int TYPE_ORB = 6;
    public static final int TYPE_HOMING = 7;
    public static final int TYPE_LASER = 8;
    public static final int TYPE_ROCKET = 9;
    public static final int TYPE_TARGET = 10;
    public static final int TYPE_THUNDER = 11;
    public static final int BONUS_MAX = 12;
    public static final int TYPE_LASER1 = 12;
    public static final int TYPE_LASER2 = 13;
    public static final int TYPE_LASER3 = 14;
    public static final int TYPE_LASER4 = 15;
    public static String[] bonusString;
    public static int[] bonusStringParam;
    public static final int BONUSSTRING_PARAM_XPOS = 0;
    public static final int BONUSSTRING_PARAM_YPOS = 1;
    public static final int BONUSSTRING_PARAM_FRAME = 2;
    public static final int BONUSSTRING_PARAM_NUMBER = 3;
    public static final int BONUSSTRING_PARAM_MAX = 4;
    public static final int MAX_BONUSSTRING = 8;
    public static final int BONUSSTRING_MAX_FRAME = 15;
    public static int[] bonusTaken;

    static void init(int n) {
        switch (n) {
            case 60: {
                imgPowerups = gameTopLevel.getImage("/powerups.png");
                break;
            }
            case 61: {
                imgCrates = gameTopLevel.getImage("/crates.png");
                break;
            }
            case 62: {
                bonusArray = new boolean[12];
                bonusTaken = new int[12];
                posX = new int[6];
                posY = new int[6];
                width = new int[6];
                height = new int[6];
                speedX = new int[6];
                speedY = new int[6];
                type = new int[6];
                break;
            }
            case 63: {
                imgPointScore = gameTopLevel.getImage("/numbers.png");
            }
        }
    }

    static void initNewGame() {
        for (int i = 0; i < 12; ++i) {
            Bonus.bonusTaken[i] = inGame.levelNb <= 255 ? 0 : (i < 5 ? 1 : 0);
        }
    }

    static void initLevel() {
        int n;
        for (n = 0; n < 6; ++n) {
            Bonus.type[n] = -1;
        }
        bonusLoop = 0;
        bonusString = new String[8];
        bonusStringParam = new int[32];
        for (n = 0; n < 8; ++n) {
            Bonus.bonusString[n] = null;
        }
        if (inGame.levelNb < 255) {
            timerShield = Landscape.distanceLevel / (5 + inGame.levelNb / 4);
            timerNuke = Landscape.distanceLevel / (4 + inGame.levelNb / 4);
        } else if (inGame.levelNb < 512) {
            timerShield = 2000 - Waves.survivalLevel * 50;
            timerNuke = 3000 - Waves.survivalLevel * 75;
        } else {
            timerShield = 0;
        }
        if (inGame.levelNb != 255) {
            for (n = 6; n < 12; ++n) {
                Bonus.bonusArray[n] = false;
            }
        } else {
            for (n = 6; n < 12; ++n) {
                Bonus.bonusArray[n] = true;
            }
        }
        takenType = -1;
    }

    static void closeLevel() {
        gameTopLevel.destruct(bonusString);
        bonusString = null;
        bonusStringParam = null;
    }

    static void generateString(String string, int n, int n2, boolean bl) {
        int n3;
        if (string.equals("0") && bl) {
            return;
        }
        for (n3 = 0; n3 < 8 && bonusString[n3] != null; ++n3) {
        }
        if (n3 != 8) {
            Bonus.bonusString[n3] = string;
            if (n < 8) {
                n = 8;
            }
            Bonus.bonusStringParam[n3 * 4 + 0] = n + -8 + menuGame.bigFont.stringWidth(string) > MOBCanvas.CANVAS_WIDTH ? MOBCanvas.CANVAS_WIDTH - menuGame.bigFont.stringWidth(string) : n + -8;
            Bonus.bonusStringParam[n3 * 4 + 1] = n2 + -8;
            Bonus.bonusStringParam[n3 * 4 + 2] = 0;
            Bonus.bonusStringParam[n3 * 4 + 3] = bl ? 1 : 0;
        }
    }

    static void generate(int n, int n2, int n3, boolean bl) {
        int n4;
        for (n4 = 0; n4 < 6 && type[n4] != -1; ++n4) {
        }
        if (n4 == 6) {
            return;
        }
        if (n3 > 6) {
            n3 = 6;
        }
        Bonus.posX[n4] = n;
        Bonus.posY[n4] = n2;
        Bonus.speedX[n4] = n3 * 5;
        Bonus.speedY[n4] = -3;
        if (bl) {
            Bonus.type[n4] = 12 + Board.laser / 25;
            Bonus.width[n4] = imgCrates.getWidth() / 4;
            Bonus.height[n4] = imgCrates.getHeight();
        } else {
            int n5 = 3;
            Bonus.speedX[n4] = n3 * 6;
            if (inGame.levelNb > 0) {
                ++n5;
            }
            Bonus.type[n4] = Enemy.nbGeneratedPupcopter >= n5 ? (bonusArray[5] ? 5 : Bonus.getType(Math.abs(Enemy.rnd.nextInt()) % nbBonusPossible)) : Bonus.getType(Math.abs(Enemy.rnd.nextInt()) % nbBonusPossible);
            Bonus.width[n4] = imgPowerups.getWidth() / 12;
            Bonus.height[n4] = imgPowerups.getHeight();
            if (type[n4] < 12) {
                int n6 = type[n4];
                bonusTaken[n6] = bonusTaken[n6] + 1;
            }
            if (type[n4] >= 6) {
                Bonus.bonusArray[Bonus.type[n4]] = false;
                --nbBonusPossible;
                Bonus.resetOtherPowerUps();
            }
            if (type[n4] == 1 && inGame.levelNb > 255) {
                timerShield = 400;
            }
        }
    }

    static void update() {
        int n;
        ++bonusLoop;
        timerShield -= 2;
        timerNuke -= 2;
        for (n = 0; n < 8; ++n) {
            if (bonusString[n] == null) continue;
            int n2 = n * 4 + 1;
            bonusStringParam[n2] = bonusStringParam[n2] + -2;
            int n3 = n * 4 + 2;
            bonusStringParam[n3] = bonusStringParam[n3] + 1;
            if (bonusStringParam[n * 4 + 2] != 15) continue;
            Bonus.bonusString[n] = null;
        }
        if (takenType != -1 && ((takenPosX += takenAddX) >> 10 < -28 || (takenPosY += takenAddY) >> 10 < 0)) {
            switch (takenType) {
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    Board.laser += 25;
                    Board.drawStatus |= 4;
                    break;
                }
                case 0: {
                    ++Board.nukeNb;
                }
            }
            takenType = -1;
        }
        for (n = 0; n < 6; ++n) {
            if (type[n] == -1) continue;
            if (posY[n] >= Hero.tankPosY) {
                if (type[n] >= 12) {
                    Explosion.generate(posX[n] - (62 - width[n]) / 2, posY[n] - (55 - height[n]) / 2, 4, 0);
                    RandomObject.addCrater(posX[n] + width[n] / 2, false);
                    Bonus.type[n] = -1;
                }
                Bonus.posY[n] = Hero.tankPosY;
                if ((bonusLoop & 1) != 0 && (inGame.gameStatus & 0x40) == 0) {
                    int n4 = n;
                    posX[n4] = posX[n4] - 1;
                }
                if (posX[n] < -(imgPowerups.getWidth() / 12)) {
                    Bonus.type[n] = -1;
                    continue;
                }
                Bonus.speedY[n] = 0;
                Bonus.speedX[n] = 0;
                continue;
            }
            int n5 = n;
            posX[n5] = posX[n5] + speedX[n] / 5;
            if (speedX[n] < 0) {
                int n6 = n;
                speedX[n6] = speedX[n6] + 1;
            }
            if (speedX[n] > 0) {
                int n7 = n;
                speedX[n7] = speedX[n7] - 1;
            }
            int n8 = n;
            posY[n8] = posY[n8] + speedY[n];
            int n9 = n;
            speedY[n9] = speedY[n9] + 1;
            if (type[n] >= 8) {
                if (speedY[n] <= 4) continue;
                Bonus.speedY[n] = 4;
                continue;
            }
            if (speedY[n] <= 6) continue;
            Bonus.speedY[n] = 6;
        }
    }

    static void updatePossibleBonus() {
        int n;
        int n2 = inGame.levelNb;
        if (inGame.levelNb == 255) {
            n2 = Waves.survivalLevel;
        }
        if (inGame.levelNb >= 512) {
            n2 = inGame.levelNb & 0xFF;
        }
        nbBonusPossible = 0;
        if (timerShield > 0 || Hero.shieldNb >= 4) {
            Bonus.bonusArray[1] = false;
        } else {
            Bonus.bonusArray[1] = true;
            ++nbBonusPossible;
        }
        if (timerNuke > 0 || Board.nukeNb >= 3) {
            Bonus.bonusArray[0] = false;
        } else {
            Bonus.bonusArray[0] = true;
            ++nbBonusPossible;
        }
        if (inGame.levelNb >= 512) {
            Bonus.bonusArray[0] = false;
            nbBonusPossible = 0;
        }
        if (Hero.shotNb == 5) {
            Bonus.bonusArray[5] = false;
        } else if (bonusTaken[5] * 2 <= n2) {
            Bonus.bonusArray[5] = true;
            ++nbBonusPossible;
        } else {
            Bonus.bonusArray[5] = false;
        }
        int n3 = 255;
        for (n = 2; n < 5; ++n) {
            if (bonusTaken[n] >= n3) continue;
            n3 = bonusTaken[n];
        }
        for (n = 2; n < 5; ++n) {
            if (n2 >= bonusTaken[n] && bonusTaken[n] == n3) {
                Bonus.bonusArray[n] = true;
                ++nbBonusPossible;
                continue;
            }
            Bonus.bonusArray[n] = false;
        }
        for (n = 6; n < 12; ++n) {
            if (!bonusArray[n]) continue;
            ++nbBonusPossible;
        }
    }

    static int getType(int n) {
        for (int i = 0; i < 12; ++i) {
            if (!bonusArray[i]) continue;
            if (n == 0) {
                return i;
            }
            --n;
        }
        return -1;
    }

    static void resetOtherPowerUps() {
        for (int i = 6; i < 12; ++i) {
            if (!bonusArray[i]) continue;
            Bonus.bonusArray[i] = false;
            --nbBonusPossible;
        }
    }

    static void survivalNewLevel() {
        for (int i = 6; i < 12; ++i) {
            if (bonusTaken[i] >= 3) continue;
            Bonus.bonusArray[i] = true;
            ++nbBonusPossible;
        }
    }

    static void checkCollision() {
        for (int i = 0; i < 6; ++i) {
            if (type[i] == -1 || !inGame.collision(posX[i], posY[i], width[i], height[i], Hero.tankPosX, Hero.tankPosY, Hero.tankWidth, Hero.tankHeight)) continue;
            Bonus.generateString(gameTopLevel.topLevel.getUtfText(104 + type[i]), posX[i], posY[i], false);
            takenType = type[i];
            takenPosX = posX[i] << 10;
            takenPosY = posY[i] << 10;
            takenWidth = width[i];
            takenHeight = height[i];
            takenAddX = (-28672 - takenPosX) / 8;
            takenAddY = ((Hero.tankPosY << 10) - takenPosY) / 8;
            if (type[i] < 12 && saveGame.gameData[507] == 0) {
                inGame.pushHint(193);
                saveGame.gameData[507] = 1;
            }
            switch (type[i]) {
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    takenAddX = ((MOBCanvas.CANVAS_WIDTH - 28 << 10) - takenPosX) / 16;
                    takenAddY = -takenPosY / 16;
                    if (saveGame.gameData[501] != 0) break;
                    inGame.pushHint(187);
                    saveGame.gameData[501] = 1;
                    break;
                }
                case 0: {
                    takenAddX = -takenPosX / 16;
                    takenAddY = -takenPosY / 16;
                    if (saveGame.gameData[502] == 0) {
                        inGame.pushHint(188);
                        saveGame.gameData[502] = 1;
                    }
                    if (inGame.levelNb != 255) {
                        timerNuke = Landscape.distanceLevel / (4 + inGame.levelNb / 4);
                        break;
                    }
                    timerNuke = 3000 - Waves.survivalLevel * 75;
                    break;
                }
                case 1: {
                    ++Hero.shieldNb;
                    if (inGame.levelNb < 255) {
                        timerShield = Landscape.distanceLevel / (5 + inGame.levelNb / 4);
                        break;
                    }
                    if (inGame.levelNb >= 512) break;
                    timerShield = 2000 - Waves.survivalLevel * 50;
                    break;
                }
                case 2: {
                    if (bonusTaken[type[i]] % 3 != 0) break;
                    ++Hero.speed;
                    break;
                }
                case 3: {
                    if (bonusTaken[type[i]] % 3 != 0 || Hero.power >= 6) break;
                    ++Hero.power;
                    break;
                }
                case 4: {
                    if ((bonusTaken[type[i]] & 1) != 1) break;
                    --Hero.speedShot;
                    break;
                }
                case 5: {
                    ++Hero.shotNb;
                    Hero.speedShot += 2;
                    break;
                }
                case 6: {
                    ++Hero.orbNb;
                    break;
                }
                case 7: {
                    ++Hero.homingNb;
                    break;
                }
                case 8: {
                    ++Hero.laserNb;
                    break;
                }
                case 9: {
                    ++Hero.rocketNb;
                    break;
                }
                case 10: {
                    ++Hero.flakNb;
                    break;
                }
                case 11: {
                    ++Hero.staticNb;
                }
            }
            Bonus.type[i] = -1;
        }
    }

    static void draw(Graphics graphics) {
        int n;
        int n2;
        Image image;
        if (takenType != -1) {
            image = imgPowerups;
            n2 = takenType;
            if (takenType >= 12) {
                image = imgCrates;
                n2 = takenType - 12;
            }
            graphics.drawRegion(image, takenWidth * n2, 0, takenWidth, takenHeight, 0, takenPosX >> 10, takenPosY >> 10, 0x10 | 4);
        }
        for (n = 0; n < 6; ++n) {
            if (type[n] == -1) continue;
            image = imgPowerups;
            n2 = type[n];
            if (type[n] >= 12) {
                image = imgCrates;
                n2 = type[n] - 12;
            }
            graphics.drawRegion(image, width[n] * n2, 0, width[n], height[n], 0, posX[n], posY[n], 0x10 | 4);
        }
        graphics.setFont(menuGame.bigFont);
        for (n = 0; n < 8; ++n) {
            if (bonusString[n] == null) continue;
            if (bonusStringParam[n * 4 + 3] == 1) {
                int n3 = bonusStringParam[n * 4 + 0];
                for (n2 = 0; n2 < bonusString[n].length(); ++n2) {
                    char c = bonusString[n].charAt(n2);
                    c = (char)(c - 48);
                    graphics.drawRegion(imgPointScore, pointFontPos[c * 2], 0, pointFontPos[c * 2 + 1], 15, 0, n3, bonusStringParam[n * 4 + 1], 0x10 | 4);
                    n3 += pointFontPos[c * 2 + 1];
                }
                continue;
            }
            graphics.setColor(0, 0, 0);
            graphics.drawString(bonusString[n], bonusStringParam[n * 4 + 0] + 1, bonusStringParam[n * 4 + 1] + 1, 0x10 | 4);
            int n4 = 255 - bonusStringParam[n * 4 + 2] * 12;
            graphics.setColor(n4, n4, n4);
            graphics.drawString(bonusString[n], bonusStringParam[n * 4 + 0], bonusStringParam[n * 4 + 1], 0x10 | 4);
        }
    }
}

