/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Tank
extends MySprite {
    protected static Random rand = new Random();
    protected Bullet[] bullet;
    protected static int iItemX;
    protected static int iItemY;
    protected static int iItemStyle;
    protected static boolean bItemAppeared;
    protected int iMaxBulletNum;
    protected int iBulletNum;
    protected int iBloodNum;
    protected int iBulletSpeed;
    protected int iPauseTime;
    protected static int iFlagAroundState;
    private static int iFlagAroundStateTime;
    protected int fireState;
    protected boolean bPause;
    protected boolean bAvoidCollides;

    public Tank(int n, int n2) {
        super(n);
        this.iMaxBulletNum = n2;
        this.bullet = new Bullet[n2];
        for (int i = 0; i < n2; ++i) {
            this.bullet[i] = new Bullet();
        }
    }

    public static boolean isItemAppeared() {
        return bItemAppeared;
    }

    public boolean isAvoidCollides() {
        return this.bAvoidCollides;
    }

    public void setAvoidCollides(boolean bl) {
        this.bAvoidCollides = bl;
    }

    public static int getItemX() {
        return iItemX;
    }

    public static int getItemY() {
        return iItemY;
    }

    public static int getItemStyle() {
        return iItemStyle;
    }

    public static int getTransform(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 5;
            }
        }
        return 0;
    }

    public void setPause(int n) {
        this.bPause = true;
        this.iPauseTime = n;
    }

    public void levelInit() {
        this.iState = 3;
        for (int i = 0; i < this.iMaxBulletNum; ++i) {
            this.bullet[i].levelInit();
        }
        this.bPause = false;
    }

    public static void levelStaticInit() {
        iFlagAroundState = 0;
        bItemAppeared = false;
    }

    public void itemInit() {
        if (iPlayerChoice == 1) {
            iItemStyle = rand.nextInt(6) + 1;
            iItemX = rand.nextInt(20) * 8 + 16;
            iItemY = rand.nextInt(20) * 8 + 16;
            if (iPlayerNum > 1) {
                Tank.tc.blueTooth.startSend();
                Tank.tc.blueTooth.addElement(iItemStyle);
                Tank.tc.blueTooth.addElement(iItemX);
                Tank.tc.blueTooth.addElement(iItemY);
                Tank.tc.blueTooth.overSend();
            }
        } else {
            Tank.tc.blueTooth.startReceive();
            iItemStyle = Tank.tc.blueTooth.getIntElement();
            iItemX = Tank.tc.blueTooth.getIntElement();
            iItemY = Tank.tc.blueTooth.getIntElement();
        }
    }

    public void paint(Graphics graphics) {
        for (int i = 0; i < this.iBulletNum; ++i) {
            this.bullet[i].paint(graphics);
        }
        switch (this.iState) {
            case 0: {
                if (this.iTime % 4 > 1) {
                    this.drawSmallCross(graphics);
                    break;
                }
                this.drawBigCross(graphics);
                break;
            }
            case 2: {
                if (this.iTime % 7 < 3) {
                    Tank.drawBulletExplode(graphics, this.x, this.y);
                    break;
                }
                Tank.drawTankExplode(graphics, this.x, this.y);
            }
        }
    }

    public void toExplode() {
        this.iState = 2;
        this.iTime = 9;
    }

    public void toWait() {
        this.iState = 3;
        this.iTime = 4;
    }

    public void toAppear() {
        this.iState = 1;
    }

    public void toAppearing() {
        this.iState = 0;
        this.iTime = 12;
    }

    public void drawSmallCross(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(this.x + 4, this.y + 7, 7, 1);
        graphics.fillRect(this.x + 7, this.y + 4, 1, 7);
        graphics.fillRect(this.x + 6, this.y + 6, 3, 3);
    }

    public void drawBigCross(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(this.x + 1, this.y + 7, 13, 1);
        graphics.fillRect(this.x + 7, this.y + 1, 1, 13);
        graphics.fillRect(this.x + 5, this.y + 5, 5, 5);
        graphics.fillRect(this.x + 4, this.y + 6, 7, 3);
        graphics.fillRect(this.x + 6, this.y + 4, 3, 7);
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void move(int n, int n2) {
        switch (n) {
            case 1: {
                this.y -= 4 * n2;
                break;
            }
            case 2: {
                this.y += 4 * n2;
                break;
            }
            case 3: {
                this.x -= 4 * n2;
                break;
            }
            case 4: {
                this.x += 4 * n2;
            }
        }
    }

    public void turn(int n) {
        if (this.x % 8 != 0 && n < 3) {
            if (this.iDirection == 3) {
                this.move(4, 1);
            } else {
                this.move(3, 1);
            }
        }
        if (this.y % 8 != 0 && n > 2) {
            if (this.iDirection == 1) {
                this.move(2, 1);
            } else {
                this.move(1, 1);
            }
        }
        this.iDirection = n;
    }

    public void fire(int n) {
        for (int i = 0; i < this.iBulletNum; ++i) {
            if (this.bullet[i].getState() != 0) continue;
            this.bullet[i].toRun(this.iDirection, this.iSide, this.iBulletSpeed, this.x, this.y, this.bDestroyRock, n);
            break;
        }
    }

    public void action(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.iDirection = n3;
        if (n4 > 0) {
            this.fire(n4);
        }
    }

    public void sendData() {
        Tank.tc.blueTooth.addElement(this.x);
        Tank.tc.blueTooth.addElement(this.y);
        Tank.tc.blueTooth.addElement(this.iDirection);
        Tank.tc.blueTooth.addElement(this.fireState);
        if (this.fireState > 0) {
            this.fireState = 0;
        }
    }

    public void sceneUpdate(Tank tank) {
        for (int i = 0; i < this.iBulletNum; ++i) {
            this.bullet[i].sceneUpdate();
        }
        switch (this.iState) {
            case 1: {
                if (!tc.ifCancelAvoidCollides(tank)) break;
                this.bAvoidCollides = false;
            }
        }
        if (this.bPause) {
            --this.iPauseTime;
            if (this.iPauseTime <= 0) {
                this.bPause = false;
            }
        }
    }

    public boolean ifHaveBarrier(Tank tank) {
        int n;
        if (this.x < 0 || this.x > 192 || this.y < 0 || this.y > 192) {
            return true;
        }
        for (n = 0; n < 4; ++n) {
            if (n == 2 || !this.collidesWith(tlmap[n], n)) continue;
            return true;
        }
        if (tc.ifTankCollidesTank(tank)) {
            return true;
        }
        for (n = 0; n < 2; ++n) {
            if (n * 15 + this.x < 96 || n * 15 + this.x >= 112 || (n + 2) / 2 * 15 + this.y < 192) continue;
            return true;
        }
        return false;
    }

    public boolean collidesWith(int[][] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        if (n == 0) {
            n2 = this.y / 4;
            n3 = this.x / 4;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (nArray[n2 + j][n3 + i] == 0) continue;
                    return true;
                }
            }
        } else {
            n2 = this.y / 8 + this.iDirection % 3 / 2 * (this.y % 8 / 4);
            n3 = this.x / 8 + this.iDirection / 4 * (this.x % 8 / 4);
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (nArray[n2 + j][n3 + i] == 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean collidesWith(Tank tank) {
        if (this.iState == 1 && tank.getState() == 1 && tank != this) {
            int n = tank.getX();
            int n2 = tank.getY();
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    int n3 = this.x + i * 15;
                    int n4 = this.y + j * 15;
                    if (n3 < n || n3 >= n + 15 || n4 < n2 || n4 >= n2 + 15) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean ifCollidesItem() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                int n = this.x + i * 15;
                int n2 = this.y + j * 15;
                if ((n < iItemX + 4 || n >= iItemX + 12 || n2 < iItemY || n2 >= iItemY + 16) && (n < iItemX || n >= iItemX + 16 || n2 < iItemY + 4 || n2 >= iItemY + 12)) continue;
                bItemAppeared = false;
                return true;
            }
        }
        return false;
    }

    public boolean ifCollidesBullet(Bullet bullet) {
        int n = bullet.getSide();
        int n2 = bullet.getX();
        int n3 = bullet.getY();
        if (this.iState == 1 && n != this.iSide) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (n2 + i < this.x || n2 + i >= this.x + 16 || n3 + j < this.y || n3 + j >= this.y + 16) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean ifBulletCollidesBullet(Bullet bullet) {
        for (int i = 0; i < this.iBulletNum; ++i) {
            if (!this.bullet[i].ifCollidesBullet(bullet)) continue;
            return true;
        }
        return false;
    }

    public static void changeFlagAroundState(int n) {
        iFlagAroundState = n;
        iFlagAroundStateTime = 250;
        Tank.clearFlagAround();
        switch (n) {
            case 1: {
                Tank.protectFlag();
            }
        }
        for (int i = 0; i < 4; ++i) {
            Tank.mapReset(i);
        }
    }

    public static void clearFlagAround() {
        for (int i = 0; i < 4; ++i) {
            int n = (3 - i) / 3 + 1;
            for (int j = 0; j < n * 4; ++j) {
                for (int k = 0; k < n * 6; ++k) {
                    Tank.tlmap[i][22 * n + j][10 * n + k] = 0;
                }
            }
        }
    }

    public static void protectFlag() {
        for (int i = 0; i < 4; ++i) {
            Tank.tlmap[1][23][11 + i] = 2;
            Tank.tlmap[1][24 + i % 2][11 + i / 2 * 3] = 2;
        }
    }

    public static void recoveryFlag() {
        for (int i = 0; i < 4; ++i) {
            Tank.tlmap[0][46][22 + i * 2] = 1;
            Tank.tlmap[0][46][23 + i * 2] = 2;
            Tank.tlmap[0][47][22 + i * 2] = 9;
            Tank.tlmap[0][47][23 + i * 2] = 10;
            Tank.tlmap[0][48 + i % 2 * 2][22 + i / 2 * 6] = 1;
            Tank.tlmap[0][48 + i % 2 * 2][23 + i / 2 * 6] = 2;
            Tank.tlmap[0][49 + i % 2 * 2][22 + i / 2 * 6] = 9;
            Tank.tlmap[0][49 + i % 2 * 2][23 + i / 2 * 6] = 10;
        }
    }

    public static void flagAroundUpdate() {
        if (iFlagAroundState > 0 && --iFlagAroundStateTime <= 50) {
            Tank.clearFlagAround();
            if (iFlagAroundStateTime % 4 < 2) {
                Tank.recoveryFlag();
            } else {
                switch (iFlagAroundState) {
                    case 1: {
                        Tank.protectFlag();
                    }
                }
            }
            for (int i = 0; i < 4; ++i) {
                Tank.mapReset(i);
            }
            if (iFlagAroundStateTime <= 0) {
                iFlagAroundState = 0;
            }
        }
    }

    public static void drawItemScore(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.drawString("500", iItemX, iItemY, 0);
    }
}

