/*
 * Decompiled with CFR 0.152.
 */
package level4;

import accessories.Ammo;
import accessories.AmmoType;
import accessories.Bumb;
import accessories.EnemyHealth;
import game.ExpandedSprite;
import game.GNSprite;
import game.Game;
import game.Main;
import game.ViewPort;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import level4.Enemy2Control;

public class Enemy2
extends GNSprite {
    public final int TYPE0;
    public final int TYPE1;
    public final int TYPE2;
    protected boolean laserIncreasing = true;
    protected ExpandedSprite spriteLaser;
    protected Image imgLaser;
    protected boolean hittedPlayer;
    protected Image[] laserFrames;
    private int currentLaserIndex;
    private int time;
    private int changeCounter = 0;
    private final int changeTime;
    private int spX = 0;
    private int spY = 3;
    private int type;
    private int health = 60;
    private int hitCounter;
    private int ammCounter;
    private Enemy2Control enemy2Control;
    private int laserCounter;

    public Enemy2(Image image, int type, Enemy2Control enemy2Control, Image imgLaser, int laserWidth, int laserHeight) {
        super(image, image.getWidth() / 2, image.getHeight());
        this.TYPE0 = 0;
        this.TYPE1 = 1;
        this.TYPE2 = 2;
        this.changeTime = 20;
        this.setPosition(ViewPort.WIDTH / 2 - this.getWidth() / 2, -this.getHeight());
        this.type = type;
        this.enemy2Control = enemy2Control;
        if (Game.savedEnemyHealth != -1) {
            this.health = Game.savedEnemyHealth;
            Game.savedEnemyHealth = -1;
        }
        if (type == 0) {
            this.defineCollisionRectangle(115, 170, 35, 33);
        } else if (type == 1) {
            this.defineCollisionRectangle(105, 155, 50, 65);
        } else if (type == 2) {
            this.defineCollisionRectangle(105, 165, 57, 33);
        }
        this.setLaserFrames(imgLaser, laserWidth, laserHeight);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.spriteLaser != null) {
            this.spriteLaser.draw(g);
        }
    }

    public void cycle() {
        Game.enemyHealthForSave = this.health;
        if (new AnySprite(this.getSprite()).collidesWith(Game.player, true)) {
            Bumb.generate(Bumb.TYPE4, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE4.width) / 2, this.getY() + Math.abs(this.getHeight() - Bumb.TYPE4.height) / 2);
            this.enemy2Control.clean();
            Game.player.hit(Game.player.health);
            return;
        }
        if (this.spriteLaser != null) {
            this.cycleLaser();
        }
        this.nextFrame();
        ++this.time;
        this.setSP();
        if (this.hitCounter == 2) {
            this.spY = -2;
            --this.hitCounter;
        } else if (this.hitCounter == 1) {
            this.spY = 2;
            --this.hitCounter;
        }
        this.move();
        this.ammo();
        if (this.getY() > ViewPort.HEIGHT) {
            this.enemy2Control.clean();
        }
    }

    private void move() {
        if (this.spriteLaser != null && !this.hittedPlayer) {
            this.spriteLaser.setPosition(this.spriteLaser.getX() + this.spX, this.spriteLaser.getY() + this.spY);
        }
        this.setPosition(this.getX() + this.spX, this.getY() + this.spY);
    }

    private void setSP() {
        if (this.getY() + this.getHeight() < this.getHeight()) {
            this.setRndXSP();
            return;
        }
        if (this.time > 500) {
            int screenCenter;
            int enemyCenter = this.getX() + this.getWidth() / 2;
            this.spX = enemyCenter > (screenCenter = ViewPort.WIDTH / 2) + 2 ? -2 : (enemyCenter < screenCenter - 2 ? 2 : 0);
            this.spY = 4;
            return;
        }
        this.spY = 0;
        this.setRndXSP();
    }

    private void setRndXSP() {
        if (this.getX() < 0) {
            this.spX = 3;
            this.changeCounter = 20;
            return;
        }
        if (this.getX() + this.getWidth() > ViewPort.WIDTH) {
            this.spX = -3;
            this.changeCounter = 20;
            return;
        }
        if (this.changeCounter > 0) {
            --this.changeCounter;
            return;
        }
        int rnd = Main.random(1);
        if (rnd == 0) {
            this.spX = 3;
            this.changeCounter = 20;
        } else {
            this.spX = -3;
            this.changeCounter = 20;
        }
    }

    protected void nextLaserFrame() {
        this.currentLaserIndex = (this.currentLaserIndex + 1) % this.laserFrames.length;
        this.spriteLaser.setImage(this.laserFrames[this.currentLaserIndex]);
    }

    private void setLaserFrames(Image imgLaser, int laserWidth, int laserHeight) {
        int columns = imgLaser.getWidth() / laserWidth;
        int rows = imgLaser.getHeight() / laserHeight;
        this.laserFrames = new Image[rows * columns];
        int count = 0;
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < columns; ++i) {
                this.laserFrames[count] = Image.createImage((Image)imgLaser, (int)(i * laserWidth), (int)(j * laserHeight), (int)laserWidth, (int)laserHeight, (int)0);
                ++count;
            }
        }
    }

    protected void generateLaser() {
        this.laserCounter = 0;
        this.spriteLaser = new ExpandedSprite(this.laserFrames[0], 0, 1);
        this.hittedPlayer = false;
        this.spriteLaser.setMinimumHeight();
        this.spriteLaser.setPosition(this.getX() + this.getWidth() / 2 - this.spriteLaser.getWidth() / 2, this.getY() + this.getHeight() - 20);
    }

    protected void cycleLaser() {
        ++this.laserCounter;
        if (this.laserCounter > 30 && !this.hittedPlayer) {
            this.laserIncreasing = false;
        }
        if (!this.hittedPlayer && this.spriteLaser.collidesWith(Game.player, true)) {
            Game.player.hit(5);
            this.hittedPlayer = true;
            this.laserIncreasing = false;
        }
        if (this.laserIncreasing) {
            this.spriteLaser.increaseHight(20);
            if (this.spriteLaser.reachedMaxHeight()) {
                this.nextLaserFrame();
            }
        } else {
            this.spriteLaser.decreaseHeight(10);
            this.spriteLaser.setPosition(this.spriteLaser.getX(), this.spriteLaser.getY() + 10);
            if (this.spriteLaser.reachedMinHeight()) {
                this.spriteLaser = null;
                this.laserIncreasing = true;
            }
        }
    }

    public void hit(Ammo am) {
        if (this.hitCounter == 0) {
            this.hitCounter = 2;
        }
        ++Game.player.score;
        this.health -= am.type.healthEffect;
        EnemyHealth.addHealthObject(this.ID, 30, 60, this.health, 5, 10);
        if (this.health <= 0) {
            Bumb.generate(Bumb.TYPE4, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE4.width) / 2, this.getY() + this.getHeight() / 2 - Bumb.TYPE4.height / 2);
            this.enemy2Control.clean();
        } else {
            Bumb.generateOnCondition(Bumb.TYPE1, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE1.width) / 2, this.getY() + this.getHeight() - Bumb.TYPE1.height);
        }
    }

    private void ammo() {
        if (this.spriteLaser != null) {
            return;
        }
        if (this.ammCounter > 0) {
            --this.ammCounter;
            return;
        }
        this.ammCounter = 10 + Main.random(10);
        switch (this.type) {
            case 0: {
                this.ammoType0();
                break;
            }
            case 1: {
                this.ammoType1();
                break;
            }
            case 2: {
                this.ammoType2();
            }
        }
    }

    private void ammoType0() {
        this.ammoType0Fifth();
    }

    private void ammoType1() {
        this.ammoType1Fifth();
    }

    private void ammoType2() {
        this.ammoType2Fifth();
    }

    private void ammoType0Fifth() {
        int rnd = 0;
        rnd = this.health > 40 ? 0 : (this.health > 20 ? 1 : 2);
        AmmoType ammoType = null;
        switch (rnd) {
            case 0: {
                ammoType = Ammo.TYPE19;
                break;
            }
            case 1: {
                ammoType = Ammo.TYPE20;
                break;
            }
            case 2: {
                ammoType = Ammo.TYPE21;
            }
        }
        switch (Main.random(2)) {
            case 0: {
                Ammo.generate(this.getX() + 35, this.getY() + this.getHeight() - 40, ammoType, 1, 12);
                Ammo.generate(this.getX() + 219, this.getY() + this.getHeight() - 40, ammoType, 1, 12);
                break;
            }
            case 1: {
                Ammo.generate(this.getX() + 70, this.getY() + this.getHeight() - 22, ammoType, 1, 12);
                Ammo.generate(this.getX() + 180, this.getY() + this.getHeight() - 22, ammoType, 1, 12);
                break;
            }
            case 2: {
                Ammo.generate(this.getX() + 100, this.getY() + this.getHeight() - 12, ammoType, 1, 12);
                Ammo.generate(this.getX() + 165, this.getY() + this.getHeight() - 12, ammoType, 1, 12);
            }
        }
    }

    private void ammoType1Fifth() {
        int rnd = 0;
        rnd = this.health > 40 ? 0 : (this.health > 20 ? 1 : 2);
        AmmoType ammoType = null;
        switch (rnd) {
            case 0: {
                ammoType = Ammo.TYPE19;
                break;
            }
            case 1: {
                ammoType = Ammo.TYPE20;
                break;
            }
            case 2: {
                ammoType = Ammo.TYPE21;
            }
        }
        switch (Main.random(2)) {
            case 0: {
                Ammo.generate(this.getX() + 25, this.getY() + 205, ammoType, 1, 12);
                Ammo.generate(this.getX() + 223, this.getY() + 205, ammoType, 1, 12);
                break;
            }
            case 1: {
                Ammo.generate(this.getX() + 75, this.getY() + 114, ammoType, 1, 12);
                Ammo.generate(this.getX() + 175, this.getY() + 114, ammoType, 1, 12);
                break;
            }
            case 2: {
                Ammo.generate(this.getX() + 120, this.getY() + 215, ammoType, 1, 12);
            }
        }
    }

    private void ammoType2Fifth() {
        int rnd = 0;
        rnd = this.health > 40 ? 0 : (this.health > 20 ? 1 : 2);
        AmmoType ammoType = null;
        switch (rnd) {
            case 0: {
                ammoType = Ammo.TYPE19;
                break;
            }
            case 1: {
                ammoType = Ammo.TYPE20;
                break;
            }
            case 2: {
                ammoType = Ammo.TYPE21;
            }
        }
        switch (Main.random(2)) {
            case 0: {
                Ammo.generate(this.getX() + 35, this.getY() + 175, ammoType, 1, 12);
                Ammo.generate(this.getX() + 220, this.getY() + 175, ammoType, 1, 12);
                break;
            }
            case 1: {
                Ammo.generate(this.getX() + 75, this.getY() + 200, ammoType, 1, 12);
                Ammo.generate(this.getX() + 182, this.getY() + 200, ammoType, 1, 12);
                break;
            }
            case 2: {
                Ammo.generate(this.getX() + 95, this.getY() + 180, ammoType, 1, 12);
                Ammo.generate(this.getX() + 150, this.getY() + 180, ammoType, 1, 12);
            }
        }
    }

    class AnySprite
    extends Sprite {
        AnySprite(Sprite sprite) {
            super(sprite);
            this.defineCollisionRectangle(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

