/*
 * Decompiled with CFR 0.152.
 */
package level3.planes;

import accessories.Ammo;
import accessories.Bumb;
import game.GNSprite;
import game.Game;
import game.ViewPort;
import javax.microedition.lcdui.Image;
import level3.planes.PlaneGroup;

public class PlaneEnemy
extends GNSprite {
    public final int TYPE0;
    public final int TYPE1;
    public final int TYPE2;
    private PlaneGroup planeGroup;
    private int sp = 6;
    private int health = 3;
    private int ammoCounter;
    private int type;

    public PlaneEnemy(Image image, int width, int height, PlaneGroup planeGroup, int type) {
        super(image, width, height);
        this.TYPE0 = 0;
        this.TYPE1 = 1;
        this.TYPE2 = 2;
        this.planeGroup = planeGroup;
        this.type = type;
    }

    public void cycle() {
        if (this.collidesWith(Game.player, true)) {
            this.planeGroup.removeEnemy(this);
            Game.player.hit(5);
            Bumb.generate(Bumb.TYPE3, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE3.width) / 2, this.getY() + Math.abs(this.getHeight() - Bumb.TYPE3.height) / 2);
            return;
        }
        this.setPosition(this.getX(), this.getY() + this.sp);
        if (this.exitedView()) {
            this.planeGroup.removeEnemy(this);
        }
        if (this.ammoCounter == 0 && this.getY() >= this.getHeight() / 2) {
            this.generateAmmo();
            this.ammoCounter = 20;
        }
        if (this.ammoCounter != 0) {
            --this.ammoCounter;
        }
    }

    public void generateAmmo() {
        switch (this.type) {
            case 0: {
                Ammo.generate(this.getX() + this.getWidth() / 5 - Ammo.TYPE7.width / 2, this.getY() + this.getHeight(), Ammo.TYPE7, 1, 12);
                Ammo.generate(this.getX() + this.getWidth() - this.getWidth() / 5 - Ammo.TYPE7.width / 2, this.getY() + this.getHeight(), Ammo.TYPE7, 1, 12);
                Ammo.generate(this.getX() + this.getWidth() / 2 - Ammo.TYPE7.width / 2, this.getY() + this.getHeight(), Ammo.TYPE7, 1, 12);
                break;
            }
            case 1: {
                Ammo.generate(this.getX() + this.getWidth() / 5 - Ammo.TYPE7.width / 2, this.getY() + this.getHeight() / 2, Ammo.TYPE7, 1, 12);
                Ammo.generate(this.getX() + this.getWidth() - this.getWidth() / 5 - Ammo.TYPE7.width / 2, this.getY() + this.getHeight() / 2, Ammo.TYPE7, 1, 12);
                break;
            }
            case 2: {
                Ammo.generate(this.getX() + this.getWidth() / 2 - Ammo.TYPE7.width / 2, this.getY() + this.getHeight(), Ammo.TYPE7, 1, 12);
            }
        }
    }

    public boolean exitedView() {
        return this.getY() > ViewPort.HEIGHT;
    }

    public void hit(Ammo ammo) {
        ++Game.player.score;
        this.health -= ammo.type.healthEffect;
        if (this.health <= 0) {
            Bumb.generate(Bumb.TYPE3, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE3.width) / 2, this.getY() + Math.abs(this.getHeight() - Bumb.TYPE3.height) / 2);
            this.planeGroup.removeEnemy(this);
        }
    }
}

