/*
 * Decompiled with CFR 0.152.
 */
package level3.laser;

import accessories.Ammo;
import accessories.Bumb;
import game.ExpandedSprite;
import game.GNSprite;
import game.Game;
import game.ViewPort;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import level3.laser.LaserGroup;

public abstract class LaserEnemy
extends GNSprite {
    protected boolean laserIncreasing = true;
    protected ExpandedSprite spriteLaser;
    protected int sp = 5;
    protected Image imgLaser;
    protected boolean hittedPlayer;
    protected Image[] laserFrames;
    private int currentLaserIndex;
    private int health = 3;
    private LaserGroup myGroup;

    public LaserEnemy(Image image, int width, int height, int frameIndex) {
        super(image, width, height);
        this.setFrame(frameIndex);
    }

    public LaserGroup getMyGroup() {
        return this.myGroup;
    }

    public void setMyGroup(LaserGroup myGroup) {
        this.myGroup = myGroup;
    }

    public int getSp() {
        return this.sp;
    }

    public void setSp(int sp) {
        this.sp = sp;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public void draw(Graphics g) {
        super.paint(g);
        if (this.spriteLaser != null) {
            this.spriteLaser.draw(g);
        }
    }

    public void move() {
        if (this.spriteLaser != null) {
            this.spriteLaser.setPosition(this.spriteLaser.getX(), this.spriteLaser.getY() + this.sp);
        }
        this.setPosition(this.getX(), this.getY() + this.sp);
    }

    protected void nextLaserFrame() {
        this.currentLaserIndex = (this.currentLaserIndex + 1) % this.laserFrames.length;
        this.spriteLaser.setImage(this.laserFrames[this.currentLaserIndex]);
    }

    public abstract void cycle();

    public boolean exitedView() {
        return this.getY() > ViewPort.HEIGHT;
    }

    public void hit(Ammo ammo) {
        ++Game.player.score;
        this.health -= ammo.type.healthEffect;
        if (this.health <= 0) {
            Bumb.generate(Bumb.TYPE3, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE3.width) / 2, this.getY() + Math.abs(this.getHeight() - Bumb.TYPE3.height) / 2);
            this.remove();
        }
    }

    protected void remove() {
        this.myGroup.remove(this);
        Game.removeElement(this);
    }
}

