/*
 * Decompiled with CFR 0.152.
 */
package cycles;

import game.Game;
import game.ViewPort;

public class Track {
    static final int AXIS_X = 0;
    static final int AXIS_Y = 1;
    static final int UP = 0;
    static final int DOWN = 1;
    static final int LEFT = 2;
    static final int RIGHT = 3;
    int tempX;
    int tempY;
    int[] directions;
    int axis;
    int edge;
    int currentDir;
    int dirIndex;
    int periodX;
    int periodY;
    int x;
    int y;
    int sp;
    int vx;
    int vy;

    public Track(int edge, int axis, int sp) {
        this.axis = axis;
        this.edge = edge;
        this.sp = sp;
        if (edge == 2 && axis == 1) {
            this.x = 0;
            this.y = 0;
            this.directions = new int[5];
            this.directions[0] = 14;
            this.directions[1] = 13;
            this.directions[2] = 12;
            this.directions[3] = 11;
            this.directions[4] = 10;
            this.currentDir = 14;
        } else if (edge == 3 && axis == 1) {
            this.x = ViewPort.WIDTH;
            this.y = 0;
            this.directions = new int[5];
            this.directions[0] = 10;
            this.directions[1] = 11;
            this.directions[2] = 12;
            this.directions[3] = 13;
            this.directions[4] = 14;
            this.currentDir = 10;
        }
    }

    public void changeDir() {
        ++this.dirIndex;
        if (this.dirIndex > 4) {
            --this.dirIndex;
        }
        this.currentDir = this.directions[this.dirIndex];
        this.periodX = 0;
        this.periodY = 0;
    }

    public void cycle() {
        int errorX = Math.abs(this.tempX - this.x * 1000);
        int errorY = Math.abs(this.tempY - this.y * 1000);
        if (errorX > 1000 || errorY > 1000) {
            this.tempX = this.x * 1000;
            this.tempY = this.y * 1000;
        }
        this.tempX += this.sp * Game.cos[this.currentDir];
        this.tempY -= this.sp * Game.sin[this.currentDir];
        this.vx = this.sp * Game.cos[this.currentDir] / 1000;
        this.vy = this.sp * Game.sin[this.currentDir] / 1000;
        this.x = this.tempX / 1000;
        this.y = this.tempY / 1000;
        this.periodX += Math.abs(this.vx);
        this.periodY += Math.abs(this.vy);
        switch (this.axis) {
            case 0: {
                if (this.periodX < ViewPort.WIDTH / 5) break;
                this.changeDir();
                break;
            }
            case 1: {
                if (this.periodY < ViewPort.HEIGHT / 5) break;
                this.changeDir();
            }
        }
    }
}

