/*
 * Decompiled with CFR 0.152.
 */
package accessories;

import game.GNSprite;
import game.Game;
import game.SoundsPlayer;
import game.ViewPort;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Bonus
extends GNSprite {
    public static final byte TYPE_HEALTH = 0;
    public static final byte TYPE_WEAPON = 1;
    public static final int WIDTH = 22;
    public static final int HEIGHT = 22;
    static Vector vectorHealth;
    static Image imgHealth;
    static Image imgWeapon;
    int sp = 2;
    int direction = 12;
    int frameNumb;
    int frameIndex;
    int type;

    public static void create() {
        vectorHealth = new Vector();
        try {
            imgHealth = Image.createImage((String)"/health.png");
            imgWeapon = Image.createImage((String)"/weapon.png");
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public static void clean() {
        vectorHealth = null;
        imgHealth = null;
        imgWeapon = null;
    }

    public static void cycleAll() {
        for (int j = vectorHealth.size() - 1; j >= 0; --j) {
            ((Bonus)vectorHealth.elementAt(j)).cycle();
        }
    }

    public static void drawAll(Graphics g) {
        for (int j = vectorHealth.size() - 1; j >= 0; --j) {
            ((Bonus)vectorHealth.elementAt(j)).draw(g);
        }
    }

    public static void generate(int x, int y, int type) {
        Bonus h = null;
        h = type == 0 ? new Bonus(imgHealth, imgHealth.getWidth() / 4, imgHealth.getHeight() / 2, 8, type) : new Bonus(imgWeapon, imgWeapon.getWidth() / 4, imgWeapon.getHeight() / 2, 8, type);
        h.setPosition(x, y);
        vectorHealth.addElement(h);
    }

    public Bonus(Image img, int width, int height, int frameNumb, int type) {
        super(img, width, height);
        this.frameNumb = frameNumb;
        this.type = type;
    }

    public void cycle() {
        if (this.collidesWith(Game.player, true)) {
            SoundsPlayer.getInstance().bonusSound();
            if (this.type == 0) {
                Game.player.bonusHealth(10);
            } else {
                Game.player.bonusWeapon();
            }
            vectorHealth.removeElement(this);
            return;
        }
        this.move();
        if (this.getY() > ViewPort.HEIGHT - ViewPort.HEIGHT / 5) {
            vectorHealth.removeElement(this);
        }
        this.frameIndex = (this.frameIndex + 1) % this.frameNumb;
        this.setFrame(this.frameIndex);
    }

    public void draw(Graphics g) {
        super.draw(g);
    }

    public void move() {
        int errorX = Math.abs(this.tempX - this.getX() * 1000);
        int errorY = Math.abs(this.tempY - this.getY() * 1000);
        if (errorX > 1000 || errorY > 1000) {
            this.tempX = this.getX() * 1000;
            this.tempY = this.getY() * 1000;
        }
        this.tempX += this.sp * Game.cos[this.direction];
        this.tempY -= this.sp * Game.sin[this.direction];
        this.setPosition(this.tempX / 1000, this.tempY / 1000);
    }
}

