/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.customise.Function;
import com.sinaflying.customise.GameParameter;
import com.sinaflying.database.DataTable;
import com.sinaflying.database.GameDB;
import com.sinaflying.engine.KeyCode;
import com.sinaflying.engine.ResourceManager;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameMessageBox;
import com.sinaflying.game.GameRoleData;
import com.sinaflying.game.MainActor;
import com.sinaflying.game.MessageBoxHandler;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.Scene;
import com.sinaflying.game.SceneUI;
import javax.microedition.lcdui.Graphics;

public class GameUI
implements MessageBoxHandler {
    private static GameUI _instance;
    private static GameMessageBox _message;
    private int _state;
    private int _frame;
    private int _shopFrame;
    private int _fingerX;
    private int _fingerY;
    private boolean _selRootMenu;
    private boolean _selRoleMenu;
    private boolean _selRoleEquipMenu;
    private boolean _selShopRootMenu;
    private boolean _gridNull;
    private boolean _callConfirm;
    private boolean _callMessage;
    private boolean _tooleUse;
    private boolean _exitMenu;
    private int _curRootItem;
    private int _maxRootItem;
    private int _curRoleItem;
    private int _maxRoleItem;
    private int _curShopItem;
    private int _maxShopItem;
    private int _curRoleEquipItem;
    private int _maxRoleEquipItem;
    private int _rowRoleEquipItem;
    private int _curRoleEquipRow;
    private int _curGridItem;
    private int _maxGridItem;
    private int _rowGridItem;
    private int _curGridRow;
    private int _curGridBase;
    private int _rootX;
    private int _rootY;
    private int _rootS;
    private int _roleX;
    private int _roleY;
    private int _roleS;
    private int _roleEquipX;
    private int _roleEquipY;
    private int _roleEquipRS;
    private int _roleEquipLS;
    private int _roleEquipN;
    private int _gridX;
    private int _gridY;
    private int _gridRS;
    private int _gridLS;
    private int _gridRN;
    private int _gridLN;
    private int _gridMax;
    private int _infoX;
    private int _infoY;
    private int _infoRS;
    private int _infoLS;
    private int _curTaskMan;
    private int _curShopKind;
    private int[] _proprety;
    private int[][] _roleEquip;
    private int[][] _gridInfo;
    private String[] _content;
    private String[] _gridName;
    private String[] _subContent;
    private int _contentFrame;
    private int _contentOffsetY;
    private int _contentOffsetMaxY;
    private boolean _teacher;
    private boolean _teaching;
    private int _appointCount;
    private int _appointRoot;
    private int _appointItem;
    private int _appointIndex;
    private int _appointKey;

    public static GameUI getInstance() {
        if (_instance == null) {
            _instance = new GameUI();
            _instance.init(0);
        }
        return _instance;
    }

    public void init(int n) {
        this.initRootPos();
        this.initRolePos();
        this.initRoleEquipPos();
        this.initGridPos();
        this.initInfoPos();
        switch (n) {
            case 0: {
                this.functionMenuInit();
                break;
            }
            case 1: {
                this.taskMenuInit();
                break;
            }
            case 2: {
                this.shopMenuInit();
            }
        }
        this._state = n;
        _message = GameMessageBox.getInstance(this);
        this._callMessage = false;
        this._callConfirm = false;
        this._tooleUse = !SceneUI.getInstance().getClosToolGrid() || Scene._isInCity;
    }

    public void update() {
        this.appointCount();
        if (!Scene._isInCity) {
            if (SceneUI.getInstance().isCountDownZero()) {
                this._exitMenu = true;
                this.isExitUI();
                if (this._callMessage) {
                    _message.dispose();
                }
            } else {
                SceneUI.getInstance().countDownProcess();
            }
        }
        if (this._callMessage) {
            _message.update();
            return;
        }
        if (!this.teachUpdate()) {
            this.changeFingerPos();
            return;
        }
        switch (this._state) {
            case 0: {
                this.functionMenuUpdate();
                break;
            }
            case 1: {
                this.taskMenuUpdate();
                break;
            }
            case 2: {
                this.shopMenuUpdate();
            }
        }
        KeyCode.resetCurKey();
        this.changeFingerPos();
        this.isExitUI();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean teachUpdate() {
        if (!this._teaching && !this._teacher) {
            return true;
        }
        if (KeyCode.getCurKey() != this._appointKey) {
            switch (KeyCode.getCurKey()) {
                case 4: 
                case 8: {
                    return true;
                }
                case 1: 
                case 2: {
                    return !this._selRootMenu;
                }
            }
        }
        switch (this._state) {
            case 0: {
                switch (this._frame) {
                    case 0: {
                        if (!this._selRoleEquipMenu || this._appointIndex != this._curRoleEquipItem + this._rowRoleEquipItem * this._curRoleEquipRow || KeyCode.getCurKey() != this._appointKey && (this._appointKey != 16 || !KeyCode.isPressConfirmKey())) break;
                        this._teaching = false;
                        this.finishHandle();
                        return true;
                    }
                }
                break;
            }
        }
        if (this._appointKey == 0) {
            this._teaching = false;
            this.finishHandle();
            return true;
        }
        if (this._appointKey == 524288 && KeyCode.isPressCancelKey()) {
            this._teaching = false;
            this.finishHandle();
            return true;
        }
        if (this._appointKey == 16 && !this._gridNull && !KeyCode.isPressCancelKey()) {
            if (this._callConfirm) {
                this._teaching = false;
                this._callConfirm = false;
                this.finishHandle();
                return true;
            }
            return this._appointIndex == this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1];
        }
        return false;
    }

    public void paint(Graphics graphics) {
        switch (this._state) {
            case 0: {
                this.paintFunctionMenu(graphics);
                this.paintMoney(graphics);
                break;
            }
            case 1: {
                this.paintTaskMenu(graphics);
                break;
            }
            case 2: {
                this.paintShopMenu(graphics);
                this.paintMoney(graphics);
            }
        }
        this.paintFinger(graphics);
        this.paintYesNo(graphics);
        this.drawTeacher(graphics);
        if (this._callMessage) {
            _message.draw(graphics);
        }
        if (!Scene._isInCity) {
            SceneUI.getInstance().countDownDraw(graphics);
        }
    }

    private void isExitUI() {
        if (this._exitMenu) {
            GameMainLogic.getInstance().changeState((byte)1);
            Scene.getInstance().changeState((byte)0);
            this._exitMenu = false;
            switch (this._state) {
                case 0: {
                    if (!this._teaching) break;
                    Scene.getInstance().closeGameUI();
                    this._teaching = false;
                    break;
                }
                case 1: 
                case 2: {
                    Scene.getInstance().closeGameUI();
                }
            }
            if (!this._tooleUse) {
                Scene.getInstance().updateCamera();
                SceneUI.getInstance().toolMenuInfo();
            }
        }
    }

    public void setToolUse(boolean bl) {
        this._tooleUse = bl;
    }

    private void changeFingerPos() {
        if (!this._selRootMenu && !this._selRoleMenu && !this._selRoleEquipMenu && this._gridNull) {
            return;
        }
        switch (this._state) {
            case 0: {
                if (this._selRootMenu) {
                    this._fingerX = this._rootX + this._rootS * this._curRootItem;
                    this._fingerY = this._rootY;
                    return;
                }
                switch (this._frame) {
                    case 0: {
                        if (this._selRoleMenu) {
                            this._fingerX = this._roleX + this._roleS * this._curRoleItem;
                            this._fingerY = this._roleY;
                            break;
                        }
                        if (this._selRoleEquipMenu) {
                            this._fingerX = this._roleEquipX + this._curRoleEquipItem * this._roleEquipRS;
                            this._fingerX += this._curRoleEquipRow == 0 ? 0 : 24;
                            this._fingerY = this._roleEquipY + this._curRoleEquipRow * this._roleEquipLS;
                            break;
                        }
                        this._fingerX = this._gridX + this._curGridItem * this._gridRS;
                        this._fingerY = this._gridY + (this._curGridRow - this._curGridBase) * this._gridLS;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: {
                        this._fingerX = this._gridX + this._curGridItem * this._gridRS;
                        this._fingerY = this._gridY + (this._curGridRow - this._curGridBase) * this._gridLS;
                        break;
                    }
                    case 4: {
                        this._fingerX = 120;
                        this._fingerY = this._gridY + (this._curGridRow - this._curGridBase) * this._gridLS;
                    }
                }
                break;
            }
            case 1: {
                if (this._gridNull) {
                    return;
                }
                this._fingerX = 120;
                this._fingerY = this._gridY + (this._curGridRow - this._curGridBase) * this._gridLS;
                break;
            }
            case 2: {
                if (this._selShopRootMenu) {
                    this._fingerX = this._rootX + this._rootS * this._curShopItem;
                    this._fingerY = this._rootY;
                    return;
                }
                switch (this._shopFrame) {
                    case 0: 
                    case 1: {
                        this._fingerX = this._gridX + this._curGridItem * this._gridRS;
                        this._fingerY = this._gridY + (this._curGridRow - this._curGridBase) * this._gridLS;
                    }
                }
            }
        }
    }

    private void paintFinger(Graphics graphics) {
        if (!this._selRootMenu && !this._selRoleMenu && !this._selRoleEquipMenu && this._gridNull) {
            return;
        }
        switch (this._state) {
            case 1: {
                if (!this._gridNull) break;
                return;
            }
        }
        if (this._appointCount % 4 > 1) {
            ResourceManager._avats[80].draw(graphics, this._fingerX, this._fingerY, 12, 0, 0);
        } else {
            ResourceManager._avats[80].draw(graphics, this._fingerX, this._fingerY, 12, 3, 0);
        }
    }

    private void paintMoney(Graphics graphics) {
        int n = Function.countOffsetX(RoleTeamData.getInstance().getMoney(), 0, 9) + 13;
        ResourceManager._spts[80].draw(graphics, 120 - (n >> 1), 300, 93, 0, 4 | 0x10);
        Function.drawNumer(graphics, 120 + (n >> 1), 300, RoleTeamData.getInstance().getMoney(), 0, 1);
    }

    private void paintYesNo(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        switch (this._state) {
            case 0: {
                if (this._selRootMenu) {
                    Function.drawYesNoKey(graphics, false, true);
                    return;
                }
                block4 : switch (this._frame) {
                    case 0: {
                        if (this._selRoleMenu) {
                            Function.drawYesNoKey(graphics, false, true);
                            break;
                        }
                        if (this._selRoleEquipMenu) {
                            Function.drawYesNoKey(graphics, true, true);
                            break;
                        }
                        if (this._gridNull) {
                            Function.drawYesNoKey(graphics, false, true);
                            break;
                        }
                        Function.drawYesNoKey(graphics, true, true);
                        break;
                    }
                    case 2: {
                        if (this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1] >= 20) {
                            Function.drawYesNoKey(graphics, false, true);
                            break;
                        }
                        if (Scene._isInCity) {
                            switch (this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1]) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 6: 
                                case 7: {
                                    Function.drawYesNoKey(graphics, true, true);
                                    break block4;
                                }
                            }
                            Function.drawYesNoKey(graphics, false, true);
                            break;
                        }
                        if (!this._tooleUse) {
                            Function.drawYesNoKey(graphics, false, true);
                            break;
                        }
                        Function.drawYesNoKey(graphics, true, true);
                        break;
                    }
                    case 5: {
                        Function.drawYesNoKey(graphics, true, true);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        Function.drawYesNoKey(graphics, false, true);
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                if (this._gridNull) {
                    Function.drawYesNoKey(graphics, false, true);
                    break;
                }
                Function.drawYesNoKey(graphics, true, true);
            }
        }
        if (this._teaching && this._appointKey == 524288 && this._appointCount % 7 > 3) {
            Function.drawRect(graphics, 215, 300, 16, 16, 0xFF0000);
        }
    }

    private void drawTeacher(Graphics graphics) {
        if (!this._teacher) {
            return;
        }
        ResourceManager._avats[100].draw(graphics, 60, 314, 0, 0, 0);
    }

    private void appointCount() {
        ++this._appointCount;
        this._appointCount = this._appointCount >= 100 ? 0 : this._appointCount;
    }

    public void functionMenuInit() {
        this._selRootMenu = true;
        this._selRoleMenu = false;
        this._selRoleEquipMenu = false;
        this._curRootItem = 0;
        this._maxRootItem = 6;
        this.changeSubMenu(0);
    }

    public void functionMenuUpdate() {
        if (this._selRootMenu) {
            this.rootMenuProcess();
            return;
        }
        switch (this._frame) {
            case 0: {
                this.roleRootMenuProcess();
                break;
            }
            case 1: {
                this.weaponMenuProcess();
                break;
            }
            case 2: {
                this.toolMenuProcess();
                break;
            }
            case 3: {
                this.equipMenuProcess();
                break;
            }
            case 4: {
                this.taskMenuProcess();
                break;
            }
            case 5: {
                this.soonMenuProcess();
            }
        }
    }

    public void paintFunctionMenu(Graphics graphics) {
        this.rootMenuDraw(graphics);
        switch (this._frame) {
            case 0: {
                this.roleRootMenuDraw(graphics);
                break;
            }
            case 1: {
                this.weaponMenuDraw(graphics);
                break;
            }
            case 2: {
                this.toolMenuDraw(graphics);
                break;
            }
            case 3: {
                this.equipMenuDraw(graphics);
                break;
            }
            case 4: {
                this.taskMenuDraw(graphics);
                break;
            }
            case 5: {
                this.soonMenuDraw(graphics);
            }
        }
    }

    private void rootMenuProcess() {
        int n = KeyCode.getCurKey();
        switch (n) {
            case 1: {
                --this._curRootItem;
                this._curRootItem = Math.max(this._curRootItem, 0);
                this.changeSubMenu(this._curRootItem);
                break;
            }
            case 2: {
                ++this._curRootItem;
                this._curRootItem = Math.min(this._curRootItem, this._maxRootItem - 1);
                this.changeSubMenu(this._curRootItem);
                break;
            }
            case 8: {
                this.intoSubMenu(this._curRootItem);
            }
        }
        if (KeyCode.isPressCancelKey()) {
            this._exitMenu = true;
        }
    }

    private void initRootPos() {
        this._rootX = 27;
        this._rootY = 30;
        this._rootS = 35;
    }

    private void rootMenuDraw(Graphics graphics) {
        Function.drawBackGroud(graphics, 2, 10, 233, 305);
        Function.drawRootBack(graphics, 2, 28, 0, 0);
        int n = 0;
        while (n < this._maxRootItem) {
            if (this._curRootItem == n) {
                ResourceManager._avats[80].draw(graphics, this._rootX + n * this._rootS, this._rootY, (n << 1) + 1, 0, 0);
            } else {
                ResourceManager._avats[80].draw(graphics, this._rootX + n * this._rootS, this._rootY, n << 1, 0, 0);
            }
            ++n;
        }
    }

    private void changeSubMenu(int n) {
        this._frame = n;
        switch (n) {
            case 0: {
                this.initGridPos();
                this.resetGrid();
                this.isGridNull();
                this.initRoleMenu();
                this.resetRoleEuipMenu();
                this.initRoleEquipMenu();
                this.initRoleProprety();
                this.resetRolePropretySign();
                break;
            }
            case 1: {
                this.resetGrid();
                this.initGridPos();
                this.initWeaponMenu();
                this.isGridNull();
                this.gridContentSub();
                break;
            }
            case 2: {
                this.resetGrid();
                this.initGridPos();
                this.initToolMenu();
                this.isGridNull();
                this.gridContentSub();
                break;
            }
            case 3: {
                this.resetGrid();
                this.initGridPos();
                this.initEquipMenu();
                this.isGridNull();
                this.gridContentSub();
                break;
            }
            case 4: {
                this.resetTaskGrid();
                this.resetTaskGridPos();
                this.initTaskMenu();
                this.isGridNull();
                this.gridContentSub();
                break;
            }
            case 5: {
                this.resetGrid();
                this.initGridPos();
                this.initSoonBuyMenu();
                this.isGridNull();
                this.gridContentSub();
            }
        }
    }

    private void initRoleMenu() {
        this._curRoleItem = 0;
        this._maxRoleItem = 0;
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n = 0;
        while (n < 3) {
            if (roleTeamData.getExistFlag(n)) {
                ++this._maxRoleItem;
            }
            ++n;
        }
    }

    private void resetRoleEuipMenu() {
        this._curRoleEquipItem = 0;
        this._maxRoleEquipItem = 0;
        this._rowRoleEquipItem = 0;
        this._curRoleEquipRow = 0;
    }

    private void initRoleEquipMenu() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        GameRoleData gameRoleData = roleTeamData.getRoleData(this._curRoleItem);
        if (gameRoleData == null) {
            return;
        }
        int[] nArray = gameRoleData.getEquipInx();
        this._maxRoleEquipItem = nArray.length;
        this._rowRoleEquipItem = 4;
        this._roleEquip = new int[this._maxRoleEquipItem][5];
        this._content = new String[this._maxRoleEquipItem];
        this._gridName = new String[this._maxRoleEquipItem];
        int n = 0;
        while (n < this._maxRoleEquipItem) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this._roleEquip[n][0] = 5;
                    break;
                }
                case 4: {
                    this._roleEquip[n][0] = 3;
                    break;
                }
                case 5: 
                case 6: {
                    this._roleEquip[n][0] = 4;
                }
            }
            this._roleEquip[n][1] = nArray[n];
            this.creatGridInfo(this._roleEquip[n][0], this._roleEquip[n][1], this._roleEquip[n], this._content, this._gridName, n);
            ++n;
        }
    }

    private void initRoleProprety() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        GameRoleData gameRoleData = roleTeamData.getRoleData(this._curRoleItem);
        if (gameRoleData == null) {
            return;
        }
        int[] nArray = gameRoleData.getRoleInx();
        this._proprety[0] = nArray[0];
        this._proprety[1] = nArray[1];
        this._proprety[2] = nArray[7];
        this._proprety[3] = nArray[8];
        this._proprety[4] = nArray[2];
        this._proprety[5] = nArray[3];
        this._proprety[6] = nArray[4];
        this._proprety[7] = nArray[5];
        this._proprety[8] = nArray[9];
        this._proprety[9] = nArray[6];
        this._proprety[8] = Scene._isInCity ? 100 : this._proprety[8];
    }

    private void resetRolePropretySign() {
        this._proprety[10] = 0;
        this._proprety[13] = 0;
        this._proprety[11] = 0;
        this._proprety[12] = 0;
    }

    private void resetGrid() {
        this._curGridItem = 0;
        this._maxGridItem = 0;
        this._rowGridItem = 6;
        this._curGridRow = 0;
        this._curGridBase = 0;
    }

    private void resetTaskGrid() {
        this._curGridItem = 0;
        this._maxGridItem = 0;
        this._rowGridItem = 1;
        this._curGridRow = 0;
        this._curGridBase = 0;
    }

    private void resetTaskGridPos() {
        this._gridX = 33;
        this._gridY = 79;
        this._gridRS = 32;
        this._gridLS = 34;
        this._gridRN = 1;
        this._gridLN = 4;
        this._gridMax = this._gridRN * this._gridLN;
    }

    private void isGridNull() {
        this._gridNull = this._maxGridItem <= 0;
    }

    private void initRoleEquipStoreMenu() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        GameDB gameDB = GameDB.getGameDataBase();
        GameRoleData gameRoleData = roleTeamData.getRoleData(this._curRoleItem);
        int n = gameRoleData.getRoleInx()[1];
        switch (this._curRoleEquipItem + this._curRoleEquipRow * this._rowRoleEquipItem) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                DataTable dataTable;
                int[] nArray = roleTeamData.getPackageInfo(0);
                boolean[] blArray = roleTeamData.getPackageExist(0);
                int n2 = 0;
                while (n2 < blArray.length) {
                    if (blArray[n2] && this._curRoleEquipItem == (dataTable = gameDB.getData(5, n2)).getIntItem(5) && n >= dataTable.getIntItem(6)) {
                        this._maxGridItem += Function.countGridNumber(nArray[n2]);
                    }
                    ++n2;
                }
                this._gridInfo = new int[this._maxGridItem][5];
                this._gridName = new String[this._maxGridItem];
                this._content = new String[this._maxGridItem];
                int n3 = 0;
                int n4 = 0;
                while (n3 < blArray.length) {
                    if (blArray[n3] && this._curRoleEquipItem == (dataTable = gameDB.getData(5, n3)).getIntItem(5) && n >= dataTable.getIntItem(6)) {
                        int n5 = nArray[n3] / 99;
                        n5 = nArray[n3] < 99999 ? (n5 += nArray[n3] % 99 > 0 ? 1 : 0) + n4 : 1 + n4;
                        while (n4 < n5) {
                            this._gridInfo[n4][0] = 5;
                            this._gridInfo[n4][1] = n3;
                            this._gridInfo[n4][3] = n4 < n5 - 1 ? 99 : nArray[n3] % 99;
                            this._gridInfo[n4][3] = nArray[n3] % 99 == 0 ? 99 : this._gridInfo[n4][3];
                            this._gridInfo[n4][3] = nArray[n3] == 99999 ? nArray[n3] : this._gridInfo[n4][3];
                            this.creatGridInfo(this._gridInfo[n4][0], this._gridInfo[n4][1], this._gridInfo[n4], this._content, this._gridName, n4);
                            ++n4;
                        }
                    }
                    ++n3;
                }
                break;
            }
            case 4: {
                DataTable dataTable;
                int[] nArray = roleTeamData.getPackageInfo(1);
                boolean[] blArray = roleTeamData.getPackageExist(1);
                int n6 = 0;
                while (n6 < blArray.length) {
                    if (blArray[n6] && n >= (dataTable = gameDB.getData(3, n6)).getIntItem(4)) {
                        this._maxGridItem += Function.countGridNumber(nArray[n6]);
                    }
                    ++n6;
                }
                this._gridInfo = new int[this._maxGridItem][5];
                this._gridName = new String[this._maxGridItem];
                this._content = new String[this._maxGridItem];
                int n7 = 0;
                int n8 = 0;
                while (n7 < blArray.length) {
                    if (blArray[n7] && n >= (dataTable = gameDB.getData(3, n7)).getIntItem(4)) {
                        int n9 = nArray[n7] / 99;
                        n9 = nArray[n7] < 99999 ? (n9 += nArray[n7] % 99 > 0 ? 1 : 0) + n8 : 1 + n8;
                        while (n8 < n9) {
                            this._gridInfo[n8][0] = 3;
                            this._gridInfo[n8][1] = n7;
                            this._gridInfo[n8][3] = n8 < n9 - 1 ? 99 : nArray[n7] % 99;
                            this._gridInfo[n8][3] = nArray[n7] % 99 == 0 ? 99 : this._gridInfo[n8][3];
                            this._gridInfo[n8][3] = nArray[n7] == 99999 ? nArray[n7] : this._gridInfo[n8][3];
                            this.creatGridInfo(this._gridInfo[n8][0], this._gridInfo[n8][1], this._gridInfo[n8], this._content, this._gridName, n8);
                            ++n8;
                        }
                    }
                    ++n7;
                }
                break;
            }
            case 5: 
            case 6: {
                DataTable dataTable;
                int[] nArray = roleTeamData.getPackageInfo(2);
                boolean[] blArray = roleTeamData.getPackageExist(2);
                int n10 = 0;
                while (n10 < blArray.length) {
                    if (blArray[n10] && this._curRoleEquipItem + this._curRoleEquipRow * this._rowRoleEquipItem - 5 == (dataTable = gameDB.getData(4, n10)).getIntItem(9) >> 1) {
                        this._maxGridItem += Function.countGridNumber(nArray[n10]);
                    }
                    ++n10;
                }
                this._gridInfo = new int[this._maxGridItem][5];
                this._gridName = new String[this._maxGridItem];
                this._content = new String[this._maxGridItem];
                int n11 = 0;
                int n12 = 0;
                while (n11 < blArray.length) {
                    if (blArray[n11] && this._curRoleEquipItem + this._curRoleEquipRow * this._rowRoleEquipItem - 5 == (dataTable = gameDB.getData(4, n11)).getIntItem(9) >> 1) {
                        int n13 = nArray[n11] / 99;
                        n13 = nArray[n11] < 99999 ? (n13 += nArray[n11] % 99 > 0 ? 1 : 0) + n12 : 1 + n12;
                        while (n12 < n13) {
                            this._gridInfo[n12][0] = 4;
                            this._gridInfo[n12][1] = n11;
                            this._gridInfo[n12][3] = n12 < n13 - 1 ? 99 : nArray[n11] % 99;
                            this._gridInfo[n12][3] = nArray[n11] % 99 == 0 ? 99 : this._gridInfo[n12][3];
                            this._gridInfo[n12][3] = nArray[n11] == 99999 ? nArray[n11] : this._gridInfo[n12][3];
                            this.creatGridInfo(this._gridInfo[n12][0], this._gridInfo[n12][1], this._gridInfo[n12], this._content, this._gridName, n12);
                            ++n12;
                        }
                    }
                    ++n11;
                }
                break;
            }
        }
    }

    private void initWeaponMenu() {
        int n;
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int[] nArray = roleTeamData.getPackageInfo(1);
        boolean[] blArray = roleTeamData.getPackageExist(1);
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                this._maxGridItem += Function.countGridNumber(nArray[n2]);
            }
            ++n2;
        }
        nArray = roleTeamData.getPackageInfo(2);
        blArray = roleTeamData.getPackageExist(2);
        int n3 = 0;
        while (n3 < blArray.length) {
            if (blArray[n3]) {
                this._maxGridItem += Function.countGridNumber(nArray[n3]);
            }
            ++n3;
        }
        this._gridInfo = new int[this._maxGridItem][5];
        this._content = new String[this._maxGridItem];
        this._gridName = new String[this._maxGridItem];
        nArray = roleTeamData.getPackageInfo(1);
        blArray = roleTeamData.getPackageExist(1);
        int n4 = 0;
        int n5 = 0;
        n4 = 0;
        while (n4 < blArray.length) {
            if (blArray[n4]) {
                n = nArray[n4] / 99;
                n = nArray[n4] < 99999 ? (n += nArray[n4] % 99 > 0 ? 1 : 0) + n5 : 1 + n5;
                while (n5 < n) {
                    this._gridInfo[n5][0] = 3;
                    this._gridInfo[n5][1] = n4;
                    this._gridInfo[n5][3] = n5 < n - 1 ? 99 : nArray[n4] % 99;
                    this._gridInfo[n5][3] = nArray[n4] % 99 == 0 ? 99 : this._gridInfo[n5][3];
                    this._gridInfo[n5][3] = nArray[n4] == 99999 ? nArray[n4] : this._gridInfo[n5][3];
                    this.creatGridInfo(this._gridInfo[n5][0], this._gridInfo[n5][1], this._gridInfo[n5], this._content, this._gridName, n5);
                    ++n5;
                }
            }
            ++n4;
        }
        nArray = roleTeamData.getPackageInfo(2);
        blArray = roleTeamData.getPackageExist(2);
        n4 = 0;
        while (n4 < blArray.length) {
            if (blArray[n4]) {
                n = nArray[n4] / 99;
                n = nArray[n4] < 99999 ? (n += nArray[n4] % 99 > 0 ? 1 : 0) + n5 : 1 + n5;
                while (n5 < n) {
                    this._gridInfo[n5][0] = 4;
                    this._gridInfo[n5][1] = n4;
                    this._gridInfo[n5][3] = n5 < n - 1 ? 99 : nArray[n4] % 99;
                    this._gridInfo[n5][3] = nArray[n4] % 99 == 0 ? 99 : this._gridInfo[n5][3];
                    this._gridInfo[n5][3] = nArray[n4] == 99999 ? nArray[n4] : this._gridInfo[n5][3];
                    this.creatGridInfo(this._gridInfo[n5][0], this._gridInfo[n5][1], this._gridInfo[n5], this._content, this._gridName, n5);
                    ++n5;
                }
            }
            ++n4;
        }
    }

    private void initToolMenu() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int[] nArray = roleTeamData.getPackageInfo(3);
        boolean[] blArray = roleTeamData.getPackageExist(3);
        int n = 0;
        while (n < blArray.length) {
            if (blArray[n]) {
                this._maxGridItem += Function.countGridNumber(nArray[n]);
            }
            ++n;
        }
        this._gridInfo = new int[this._maxGridItem][5];
        this._content = new String[this._maxGridItem];
        this._gridName = new String[this._maxGridItem];
        nArray = roleTeamData.getPackageInfo(3);
        blArray = roleTeamData.getPackageExist(3);
        int n2 = 0;
        int n3 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                int n4 = nArray[n2] / 99;
                n4 = nArray[n2] < 99999 ? (n4 += nArray[n2] % 99 > 0 ? 1 : 0) + n3 : 1 + n3;
                while (n3 < n4) {
                    this._gridInfo[n3][0] = 2;
                    this._gridInfo[n3][1] = n2;
                    this._gridInfo[n3][3] = n3 < n4 - 1 ? 99 : nArray[n2] % 99;
                    this._gridInfo[n3][3] = nArray[n2] % 99 == 0 ? 99 : this._gridInfo[n3][3];
                    this._gridInfo[n3][3] = nArray[n2] == 99999 ? nArray[n2] : this._gridInfo[n3][3];
                    this.creatGridInfo(this._gridInfo[n3][0], this._gridInfo[n3][1], this._gridInfo[n3], this._content, this._gridName, n3);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private void initEquipMenu() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int[] nArray = roleTeamData.getPackageInfo(0);
        boolean[] blArray = roleTeamData.getPackageExist(0);
        int n = 0;
        while (n < blArray.length) {
            if (blArray[n]) {
                this._maxGridItem += Function.countGridNumber(nArray[n]);
            }
            ++n;
        }
        this._gridInfo = new int[this._maxGridItem][5];
        this._content = new String[this._maxGridItem];
        this._gridName = new String[this._maxGridItem];
        nArray = roleTeamData.getPackageInfo(0);
        blArray = roleTeamData.getPackageExist(0);
        int n2 = 0;
        int n3 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                int n4 = nArray[n2] / 99;
                n4 = nArray[n2] < 99999 ? (n4 += nArray[n2] % 99 > 0 ? 1 : 0) + n3 : 1 + n3;
                while (n3 < n4) {
                    this._gridInfo[n3][0] = 5;
                    this._gridInfo[n3][1] = n2;
                    this._gridInfo[n3][3] = n3 < n4 - 1 ? 99 : nArray[n2] % 99;
                    this._gridInfo[n3][3] = nArray[n2] % 99 == 0 ? 99 : this._gridInfo[n3][3];
                    this._gridInfo[n3][3] = nArray[n2] == 99999 ? nArray[n2] : this._gridInfo[n3][3];
                    this.creatGridInfo(this._gridInfo[n3][0], this._gridInfo[n3][1], this._gridInfo[n3], this._content, this._gridName, n3);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private void initTaskMenu() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        boolean[] blArray = roleTeamData.getPackageExist(4);
        int n = 0;
        while (n < blArray.length) {
            if (blArray[n]) {
                ++this._maxGridItem;
            }
            ++n;
        }
        this._gridInfo = new int[this._maxGridItem][5];
        this._content = new String[this._maxGridItem];
        this._gridName = new String[this._maxGridItem];
        blArray = roleTeamData.getPackageExist(4);
        int n2 = 0;
        int n3 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                this._gridInfo[n3][0] = 6;
                this._gridInfo[n3][1] = n2;
                this.creatGridInfo(this._gridInfo[n3][0], this._gridInfo[n3][1], this._gridInfo[n3], this._content, this._gridName, n3);
                ++n3;
            }
            ++n2;
        }
    }

    private void initSoonBuyMenu() {
        DataTable dataTable;
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        GameDB gameDB = GameDB.getGameDataBase();
        boolean[] blArray = roleTeamData.getPackageExist(3);
        int n = 0;
        while (n < blArray.length) {
            dataTable = gameDB.getData(2, n);
            if (dataTable.getIntItem(9) == 1) {
                ++this._maxGridItem;
            }
            ++n;
        }
        blArray = roleTeamData.getPackageExist(2);
        int n2 = 0;
        while (n2 < blArray.length) {
            dataTable = gameDB.getData(4, n2);
            if (dataTable.getIntItem(13) == 1) {
                ++this._maxGridItem;
            }
            ++n2;
        }
        blArray = roleTeamData.getPackageExist(1);
        int n3 = 0;
        while (n3 < blArray.length) {
            dataTable = gameDB.getData(3, n3);
            if (dataTable.getIntItem(9) == 1) {
                ++this._maxGridItem;
            }
            ++n3;
        }
        blArray = roleTeamData.getPackageExist(0);
        int n4 = 0;
        while (n4 < blArray.length) {
            dataTable = gameDB.getData(5, n4);
            if (dataTable.getIntItem(9) == 1) {
                ++this._maxGridItem;
            }
            ++n4;
        }
        this._gridInfo = new int[this._maxGridItem][5];
        this._content = new String[this._maxGridItem];
        this._gridName = new String[this._maxGridItem];
        blArray = roleTeamData.getPackageExist(3);
        int n5 = 0;
        int n6 = 0;
        n5 = 0;
        while (n5 < blArray.length) {
            dataTable = gameDB.getData(2, n5);
            if (dataTable.getIntItem(9) == 1) {
                this._gridInfo[n6][0] = 2;
                this._gridInfo[n6][1] = n5;
                this._gridInfo[n6][3] = 0;
                this.creatGridInfo(this._gridInfo[n6][0], this._gridInfo[n6][1], this._gridInfo[n6], this._content, this._gridName, n6);
                ++n6;
            }
            ++n5;
        }
        blArray = roleTeamData.getPackageExist(2);
        n5 = 0;
        while (n5 < blArray.length) {
            dataTable = gameDB.getData(4, n5);
            if (dataTable.getIntItem(13) == 1) {
                this._gridInfo[n6][0] = 4;
                this._gridInfo[n6][1] = n5;
                this._gridInfo[n6][3] = 0;
                this.creatGridInfo(this._gridInfo[n6][0], this._gridInfo[n6][1], this._gridInfo[n6], this._content, this._gridName, n6);
                ++n6;
            }
            ++n5;
        }
        blArray = roleTeamData.getPackageExist(1);
        n5 = 0;
        while (n5 < blArray.length) {
            dataTable = gameDB.getData(3, n5);
            if (dataTable.getIntItem(9) == 1) {
                this._gridInfo[n6][0] = 3;
                this._gridInfo[n6][1] = n5;
                this._gridInfo[n6][3] = 0;
                this.creatGridInfo(this._gridInfo[n6][0], this._gridInfo[n6][1], this._gridInfo[n6], this._content, this._gridName, n6);
                ++n6;
            }
            ++n5;
        }
        blArray = roleTeamData.getPackageExist(0);
        n5 = 0;
        while (n5 < blArray.length) {
            dataTable = gameDB.getData(5, n5);
            if (dataTable.getIntItem(9) == 1) {
                this._gridInfo[n6][0] = 5;
                this._gridInfo[n6][1] = n5;
                this._gridInfo[n6][3] = 0;
                this.creatGridInfo(this._gridInfo[n6][0], this._gridInfo[n6][1], this._gridInfo[n6], this._content, this._gridName, n6);
                ++n6;
            }
            ++n5;
        }
    }

    private void creatGridInfo(int n, int n2, int[] nArray, String[] stringArray, String[] stringArray2, int n3) {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(n, n2);
        switch (n) {
            case 5: {
                nArray[2] = dataTable.getIntItem(8);
                nArray[4] = dataTable.getIntItem(7);
                stringArray2[n3] = dataTable.getStringItem(1);
                stringArray[n3] = dataTable.getStringItem(2);
                break;
            }
            case 4: {
                nArray[2] = dataTable.getIntItem(12);
                nArray[4] = dataTable.getIntItem(11);
                stringArray2[n3] = dataTable.getStringItem(1);
                stringArray[n3] = dataTable.getStringItem(2);
                break;
            }
            case 3: {
                nArray[2] = dataTable.getIntItem(7);
                nArray[4] = dataTable.getIntItem(6);
                stringArray2[n3] = dataTable.getStringItem(1);
                stringArray[n3] = dataTable.getStringItem(2);
                break;
            }
            case 2: {
                nArray[2] = dataTable.getIntItem(8);
                nArray[4] = dataTable.getIntItem(6);
                stringArray2[n3] = dataTable.getStringItem(1);
                stringArray[n3] = dataTable.getStringItem(2);
                break;
            }
            case 6: {
                nArray[2] = -1;
                nArray[4] = 0;
                stringArray2[n3] = dataTable.getStringItem(1);
                stringArray[n3] = dataTable.getStringItem(2);
            }
        }
    }

    private void intoSubMenu(int n) {
        switch (n) {
            case 0: {
                this._selRoleMenu = true;
                this._selRoleEquipMenu = false;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (!this._gridNull) break;
                return;
            }
        }
        this._selRootMenu = false;
    }

    private void roleRootMenuProcess() {
        if (this._selRoleMenu) {
            this.roleMenuProcess();
        } else if (this._selRoleEquipMenu) {
            this.roleEquipMenuProcess();
        } else {
            this.roleEquipStoreMenuProcess();
        }
    }

    private void roleMenuProcess() {
        int n = KeyCode.getCurKey();
        switch (n) {
            case 1: {
                --this._curRoleItem;
                this._curRoleItem = Math.max(this._curRoleItem, 0);
                this.resetRoleEuipMenu();
                this.initRoleEquipMenu();
                this.initRoleProprety();
                this.resetRolePropretySign();
                break;
            }
            case 2: {
                ++this._curRoleItem;
                this._curRoleItem = Math.min(this._curRoleItem, this._maxRoleItem - 1);
                this.resetRoleEuipMenu();
                this.initRoleEquipMenu();
                this.initRoleProprety();
                this.resetRolePropretySign();
                break;
            }
            case 4: {
                this._selRoleMenu = false;
                this._selRootMenu = true;
                break;
            }
            case 8: {
                this._selRoleMenu = false;
                this._selRoleEquipMenu = true;
            }
        }
        if (KeyCode.isPressCancelKey()) {
            this._selRoleMenu = false;
            this._selRootMenu = true;
        }
    }

    private void roleEquipMenuProcess() {
        int n = KeyCode.getCurKey();
        switch (n) {
            case 1: {
                this._curRoleEquipItem = --this._curRoleEquipItem < 0 ? this._rowRoleEquipItem - 1 : this._curRoleEquipItem;
                this._curRoleEquipItem += this._rowRoleEquipItem * this._curRoleEquipRow;
                this._curRoleEquipItem = Math.min(this._curRoleEquipItem, this._maxRoleEquipItem - 1);
                this._curRoleEquipItem %= this._rowRoleEquipItem;
                break;
            }
            case 2: {
                ++this._curRoleEquipItem;
                this._curRoleEquipItem %= this._rowRoleEquipItem;
                this._curRoleEquipItem += this._rowRoleEquipItem * this._curRoleEquipRow;
                this._curRoleEquipItem = this._curRoleEquipItem > this._maxRoleEquipItem - 1 ? 0 : this._curRoleEquipItem % this._rowRoleEquipItem;
                break;
            }
            case 4: {
                if (--this._curRoleEquipRow >= 0) break;
                this._selRoleEquipMenu = false;
                this._selRoleMenu = true;
                this._curRoleEquipRow = 0;
                break;
            }
            case 8: {
                ++this._curRoleEquipRow;
                if (this._curRoleEquipRow * this._rowRoleEquipItem > this._maxRoleEquipItem - 1) {
                    --this._curRoleEquipRow;
                }
                this._curRoleEquipItem += this._curRoleEquipRow * this._rowRoleEquipItem;
                this._curRoleEquipItem = Math.min(this._curRoleEquipItem, this._maxRoleEquipItem - 1);
                this._curRoleEquipItem %= this._rowRoleEquipItem;
            }
        }
        if (KeyCode.isPressConfirmKey()) {
            this._selRoleMenu = false;
            this._selRoleEquipMenu = false;
            this.resetGrid();
            this.initRoleEquipStoreMenu();
            this.isGridNull();
            this.gridContentSub();
        }
        if (KeyCode.isPressCancelKey()) {
            this._selRootMenu = true;
            this._selRoleMenu = false;
            this._selRoleEquipMenu = false;
        }
    }

    private void gridMenuProcess() {
        int n = KeyCode.getCurKey();
        switch (n) {
            case 1: {
                this._curGridItem = --this._curGridItem < 0 ? this._rowGridItem - 1 : this._curGridItem;
                this._curGridItem += this._rowGridItem * this._curGridRow;
                this._curGridItem = Math.min(this._curGridItem, this._maxGridItem - 1);
                this._curGridItem %= this._rowGridItem;
                this.gridContentSub();
                break;
            }
            case 2: {
                ++this._curGridItem;
                this._curGridItem %= this._rowGridItem;
                this._curGridItem += this._rowGridItem * this._curGridRow;
                this._curGridItem = this._curGridItem > this._maxGridItem - 1 ? 0 : this._curGridItem % this._rowGridItem;
                this.gridContentSub();
                break;
            }
            case 4: {
                if (--this._curGridRow < this._curGridBase) {
                    this._curGridBase = Math.max(this._curGridRow, 0);
                }
                if (this._curGridRow < 0) {
                    this._curGridRow = 0;
                    switch (this._state) {
                        case 0: {
                            switch (this._frame) {
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: {
                                    this._selRootMenu = true;
                                }
                            }
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            switch (this._shopFrame) {
                                case 0: 
                                case 1: {
                                    this._selShopRootMenu = true;
                                }
                            }
                        }
                    }
                }
                this.gridContentSub();
                break;
            }
            case 8: {
                if (++this._curGridRow * this._rowGridItem > this._maxGridItem - 1) {
                    --this._curGridRow;
                }
                if (this._curGridRow > this._curGridBase + this._gridLN - 1) {
                    ++this._curGridBase;
                }
                this._curGridItem += this._curGridRow * this._rowGridItem;
                this._curGridItem = Math.min(this._curGridItem, this._maxGridItem - 1);
                this._curGridItem %= this._rowGridItem;
                this.gridContentSub();
            }
        }
    }

    private void gridMenuDraw(Graphics graphics) {
        Function.drawBorder(graphics, 12, 56, 216, 147);
        Function.drawGlide(graphics, 214, this._gridY - 16, 0, 130, this._maxGridItem / this._gridRN + (this._maxGridItem % this._gridRN > 0 ? 1 : 0) - this._gridLN, this._curGridBase);
        int n = 0;
        while (n < this._gridMax) {
            ResourceManager._avats[80].draw(graphics, this._gridX + n % this._gridRN * this._gridRS, this._gridY + n / this._gridRN * this._gridLS, 15, 0, 0);
            ++n;
        }
        int n2 = 0;
        while (n2 < this._maxGridItem - this._curGridBase * this._gridRN && n2 < this._gridMax) {
            if (!this._callMessage && this._teaching && this._appointIndex == this._gridInfo[n2 + this._curGridBase * this._gridRN][1] && this._appointCount % 7 > 3) {
                Function.drawRect(graphics, this._gridX + n2 % this._gridRN * this._gridRS - 15, this._gridY + n2 / this._gridRN * this._gridLS - 15, 29, 28, 0xFF0000);
            }
            if (this._curGridItem + this._curGridRow * this._rowGridItem == n2 + this._curGridBase * this._gridRN) {
                this.gridNameDraw(graphics, this._gridX + n2 % this._gridRN * this._gridRS, this._gridY + n2 / this._gridRN * this._gridLS);
            }
            ResourceManager._avats[60].draw(graphics, this._gridX + n2 % this._gridRN * this._gridRS, this._gridY + n2 / this._gridRN * this._gridLS, this._gridInfo[n2 + this._curGridBase * this._gridRN][2], 0, 0);
            if (this._gridInfo[n2 + this._curGridBase * this._gridRN][3] != 0) {
                int n3 = Function.countOffsetX(this._gridInfo[n2 + this._curGridBase * this._gridRN][3], 0, 7) - 15;
                if (this._gridInfo[n2 + this._curGridBase * this._gridRN][3] > 99) {
                    ResourceManager._spts[80].draw(graphics, this._gridX + n2 % this._gridRN * this._gridRS - 15, this._gridY + n2 / this._gridRN * this._gridLS + 4, 109, 0, 4 | 0x10);
                } else {
                    Function.drawNumer(graphics, this._gridX + n2 % this._gridRN * this._gridRS + n3, this._gridY + n2 / this._gridRN * this._gridLS + 4, this._gridInfo[n2 + this._curGridBase * this._gridRN][3], 0, 0);
                }
                if (this._state == 0 && this._frame == 2 && this._gridInfo[n2 + this._curGridBase * this._gridRN][1] < 20) {
                    if (Scene._isInCity) {
                        switch (this._gridInfo[n2 + this._curGridBase * this._gridRN][1]) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 6: 
                            case 7: {
                                break;
                            }
                            default: {
                                ResourceManager._spts[81].draw(graphics, this._gridX + n2 % this._gridRN * this._gridRS + 3, this._gridY + n2 / this._gridRN * this._gridLS - 12, 13, 0, 0);
                                break;
                            }
                        }
                    } else if (!this._tooleUse) {
                        ResourceManager._spts[81].draw(graphics, this._gridX + n2 % this._gridRN * this._gridRS + 3, this._gridY + n2 / this._gridRN * this._gridLS - 12, 13, 0, 0);
                    }
                }
            }
            ++n2;
        }
    }

    private void gridContentSub() {
        if (this._gridNull) {
            return;
        }
        String[] stringArray = Function.subString(this._content[this._curGridItem + this._curGridRow * this._rowGridItem], 210 / Function.C_WORD_W);
        this._subContent = null;
        int n = 0;
        int n2 = 0;
        switch (this._state) {
            case 0: {
                if (this._frame == 5) {
                    n = 1;
                    this._subContent = new String[stringArray.length + n];
                    this._subContent[n2] = "\u4ef7\u683c\uff1a" + String.valueOf(this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][4]);
                    ++n2;
                    break;
                }
                if (this._frame == 4) {
                    DataTable dataTable;
                    n2 = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1];
                    int[] nArray = GameDB.getGameDataBase().getData(6, n2).getArrayItem(6);
                    int[] nArray2 = GameDB.getGameDataBase().getData(6, n2).getArrayItem(7);
                    int[] nArray3 = RoleTeamData.getInstance().getPackageInfo(5);
                    int[] nArray4 = RoleTeamData.getInstance().getPackageInfo(3);
                    n = (nArray.length >> 1) + (nArray2.length >> 1);
                    this._subContent = new String[stringArray.length + n];
                    n2 = 0;
                    int n3 = 1;
                    while (n3 < nArray.length) {
                        dataTable = GameDB.getGameDataBase().getData(1, nArray[n3 - 1]);
                        this._subContent[n2] = dataTable.getStringItem(1) + "(" + String.valueOf(nArray3[nArray[n3 - 1]]) + "/" + String.valueOf(nArray[n3]) + ")";
                        ++n2;
                        n3 += 2;
                    }
                    int n4 = 1;
                    while (n4 < nArray2.length) {
                        dataTable = GameDB.getGameDataBase().getData(2, nArray2[n4 - 1]);
                        this._subContent[n2] = dataTable.getStringItem(1) + "(" + String.valueOf(nArray4[nArray2[n4 - 1]]) + "/" + String.valueOf(nArray2[n4]) + ")";
                        ++n2;
                        n4 += 2;
                    }
                    break;
                }
                this._subContent = new String[stringArray.length];
                break;
            }
            case 2: {
                if (this._shopFrame == 0) {
                    n = 1;
                    this._subContent = new String[stringArray.length + n];
                    this._subContent[n2] = "\u4ef7\u683c\uff1a" + String.valueOf(this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][4]);
                    ++n2;
                    break;
                }
                this._subContent = new String[stringArray.length];
                break;
            }
            default: {
                this._subContent = new String[stringArray.length];
            }
        }
        System.arraycopy(stringArray, 0, this._subContent, n, stringArray.length);
        this._contentFrame = 20;
        this._contentOffsetY = 0;
        this._contentOffsetMaxY = (this._subContent.length - 80 / Function.C_WORD_H) * Function.C_WORD_H;
    }

    private void gridContentMove() {
        if (this._contentOffsetMaxY <= 0) {
            return;
        }
        this._contentFrame = this._contentFrame - 1 < 0 ? 0 : this._contentFrame - 1;
        this._contentOffsetY = this._contentFrame == 0 && this._contentOffsetY == this._contentOffsetMaxY ? 0 : this._contentOffsetY;
        this._contentOffsetY = this._contentFrame == 0 ? this._contentOffsetY + 1 : this._contentOffsetY;
        this._contentOffsetY = this._contentOffsetY > this._contentOffsetMaxY ? this._contentOffsetMaxY : this._contentOffsetY;
        this._contentFrame = this._contentFrame == 0 && this._contentOffsetY == this._contentOffsetMaxY ? 40 : this._contentFrame;
        this._contentOffsetY = this._contentFrame == 20 && this._contentOffsetY == this._contentOffsetMaxY ? 0 : this._contentOffsetY;
    }

    private void gridContentDraw(Graphics graphics) {
        Function.drawBorder(graphics, 12, 206, 216, 90);
        if (this._gridNull) {
            return;
        }
        this.gridContentMove();
        graphics.setClip(12, 211, 216, 80);
        graphics.setColor(0);
        int n = 15;
        int n2 = 210;
        int n3 = 0;
        while (n3 < this._subContent.length) {
            graphics.drawString(this._subContent[n3], n, n2 - this._contentOffsetY + n3 * Function.C_WORD_H, 4 | 0x10);
            ++n3;
        }
        graphics.setClip(0, 0, 240, 320);
    }

    private void gridNameDraw(Graphics graphics, int n, int n2) {
        if (this._gridNull) {
            return;
        }
        if (this._state == 0 && this._selRootMenu) {
            return;
        }
        if (this._state == 2 && this._selShopRootMenu) {
            return;
        }
        int n3 = n - Function.C_WORD_W * 4;
        n3 = n3 < 0 ? Function.C_WORD_H >> 1 : n3;
        n3 = n3 + Function.C_WORD_W * 8 > 214 ? 213 - Function.C_WORD_W * 8 : n3;
        int n4 = n2 - Function.C_WORD_H - 20;
        Function.drawNamePanel(graphics, n3, n4, Function.C_WORD_W * 8, Function.C_WORD_H + 2, 0xFFFFFF);
        graphics.setColor(0);
        graphics.drawString(this._gridName[this._curGridItem + this._curGridRow * this._rowGridItem], n3 + Function.C_WORD_W * 4, n4 + 1, 1 | 0x10);
    }

    private void roleEquipStoreMenuProcess() {
        this.gridMenuProcess();
        this.roleEquipCompare();
        if (!this._gridNull && KeyCode.isPressConfirmKey()) {
            this._callMessage = true;
            _message = GameMessageBox.getInstance(this);
            _message.initShopStyle(1, GameParameter.STR_CONTENT[0]);
        }
        if (KeyCode.isPressCancelKey()) {
            this._selRoleMenu = false;
            this._selRoleEquipMenu = true;
            this._gridNull = false;
            this.resetRolePropretySign();
        }
    }

    private void roleEquipChange() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        GameRoleData gameRoleData = roleTeamData.getRoleData(this._curRoleItem);
        int n = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][0];
        int n2 = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1];
        switch (n) {
            case 5: {
                roleTeamData.consumeEquip(n2, -1);
                n2 = gameRoleData.getIntoEquip(this._curRoleEquipItem + this._rowRoleEquipItem * this._curRoleEquipRow, n2);
                roleTeamData.consumeEquip(n2, 1);
                break;
            }
            case 3: {
                roleTeamData.consumeWeapon(n2, -1);
                n2 = gameRoleData.getIntoEquip(this._curRoleEquipItem + this._rowRoleEquipItem * this._curRoleEquipRow, n2);
                roleTeamData.consumeWeapon(n2, 1);
                break;
            }
            case 4: {
                n2 = gameRoleData.getIntoEquip(this._curRoleEquipItem + this._rowRoleEquipItem * this._curRoleEquipRow, n2);
            }
        }
        int n3 = this._curGridItem;
        this._maxGridItem = 0;
        this.initRoleEquipMenu();
        this.initRoleEquipStoreMenu();
        this.isGridNull();
        this._curGridItem += this._curGridRow * this._rowGridItem;
        this._curGridItem = Math.min(this._curGridItem, this._maxGridItem - 1);
        this._curGridItem %= this._rowGridItem;
        this._curGridRow -= this._curGridRow > 0 && this._curGridItem != n3 && n3 == 0 ? 1 : 0;
        this.gridContentSub();
        this.initRoleProprety();
        this.resetRolePropretySign();
        this._callConfirm = true;
    }

    private void roleEquipCompare() {
        GameDB gameDB = GameDB.getGameDataBase();
        int n = this._curGridItem + this._rowGridItem * this._curGridRow;
        int n2 = this._curRoleEquipItem + this._rowRoleEquipItem * this._curRoleEquipRow;
        this.resetRolePropretySign();
        if (this._gridNull) {
            return;
        }
        switch (this._gridInfo[n][0]) {
            case 5: {
                DataTable dataTable = gameDB.getData(5, this._gridInfo[n][1]);
                DataTable dataTable2 = gameDB.getData(5, this._roleEquip[n2][1]);
                if (dataTable.getIntItem(3) > dataTable2.getIntItem(3)) {
                    this._proprety[10] = 2;
                } else if (dataTable.getIntItem(3) < dataTable2.getIntItem(3)) {
                    this._proprety[10] = 1;
                }
                if (dataTable.getIntItem(4) > dataTable2.getIntItem(4)) {
                    this._proprety[13] = 2;
                    break;
                }
                if (dataTable.getIntItem(4) >= dataTable2.getIntItem(4)) break;
                this._proprety[13] = 1;
                break;
            }
            case 3: {
                DataTable dataTable = gameDB.getData(3, this._gridInfo[n][1]);
                DataTable dataTable3 = gameDB.getData(3, this._roleEquip[n2][1]);
                if (dataTable.getIntItem(5) > dataTable3.getIntItem(5)) {
                    this._proprety[11] = 2;
                    break;
                }
                if (dataTable.getIntItem(5) >= dataTable3.getIntItem(5)) break;
                this._proprety[11] = 1;
                break;
            }
            case 4: {
                DataTable dataTable = gameDB.getData(4, this._gridInfo[n][1]);
                DataTable dataTable4 = gameDB.getData(4, this._roleEquip[n2][1]);
                if (dataTable.getIntItem(7) > dataTable4.getIntItem(7)) {
                    if (dataTable.getIntItem(9) == 2) {
                        this._proprety[12] = 2;
                        break;
                    }
                    this._proprety[11] = 2;
                    break;
                }
                if (dataTable.getIntItem(7) >= dataTable4.getIntItem(7)) break;
                if (dataTable.getIntItem(9) == 2) {
                    this._proprety[12] = 1;
                    break;
                }
                this._proprety[11] = 1;
            }
        }
    }

    private void roleRootMenuDraw(Graphics graphics) {
        if (this._selRootMenu || this._selRoleMenu || this._selRoleEquipMenu) {
            this.roleMenuDraw(graphics);
            this.roleEquipMenuDraw(graphics);
        } else {
            this.roleEquipStoreMenuDraw(graphics);
        }
        this.rolePropretyDraw(graphics);
    }

    private void initRolePos() {
        this._roleX = 50;
        this._roleY = 118;
        this._roleS = 70;
    }

    private void initRoleEquipPos() {
        this._roleEquipX = 42;
        this._roleEquipY = 152;
        this._roleEquipRS = 50;
        this._roleEquipLS = 32;
        this._roleEquipN = 4;
    }

    private void roleMenuDraw(Graphics graphics) {
        Function.drawBorder(graphics, 12, 56, 216, 74);
        int n = 0;
        while (n < 3) {
            ResourceManager._avats[80].draw(graphics, this._roleX + this._roleS * n, this._roleY, 13, 0, 0);
            if (n < this._maxRoleItem) {
                ResourceManager._avats[n].draw(graphics, this._roleX + this._roleS * n, this._roleY, 4, 0, 0);
            } else {
                ResourceManager._avats[80].draw(graphics, this._roleX + this._roleS * n, this._roleY, 14, 0, 0);
            }
            ++n;
        }
    }

    private void initGridPos() {
        this._gridX = 33;
        this._gridY = 79;
        this._gridRS = 32;
        this._gridLS = 34;
        this._gridRN = 6;
        this._gridLN = 4;
        this._gridMax = this._gridRN * this._gridLN;
    }

    private void initInfoPos() {
        this._infoX = 22;
        this._infoY = 218;
        this._infoRS = 80;
        this._infoLS = 18;
        this._proprety = new int[14];
    }

    private void roleEquipMenuDraw(Graphics graphics) {
        Function.drawBorder(graphics, 12, 133, 216, 70);
        int n = 0;
        while (n < this._maxRoleEquipItem) {
            ResourceManager._avats[80].draw(graphics, this._roleEquipX + n % this._roleEquipN * this._roleEquipRS + (n / this._roleEquipN == 0 ? 0 : 24), this._roleEquipY + n / this._roleEquipN * this._roleEquipLS, 15, 0, 0);
            if (!this._callMessage && this._teaching && this._appointIndex == n && this._appointCount % 7 > 3) {
                Function.drawRect(graphics, this._roleEquipX + n % this._roleEquipN * this._roleEquipRS + (n / this._roleEquipN == 0 ? 0 : 24) - 15, this._roleEquipY + n / this._roleEquipN * this._roleEquipLS - 15, 29, 28, 0xFF0000);
            }
            ResourceManager._avats[60].draw(graphics, this._roleEquipX + n % this._roleEquipN * this._roleEquipRS + (n / this._roleEquipN == 0 ? 0 : 24), this._roleEquipY + n / this._roleEquipN * this._roleEquipLS, this._roleEquip[n][2], 0, 0);
            ResourceManager._avats[80].draw(graphics, this._roleEquipX + 14 + n % this._roleEquipN * this._roleEquipRS + (n / this._roleEquipN == 0 ? 0 : 24), this._roleEquipY + 13 + n / this._roleEquipN * this._roleEquipLS, 16 + n, 0, 0);
            ++n;
        }
    }

    private void roleEquipStoreMenuDraw(Graphics graphics) {
        Function.drawBorder(graphics, 12, 56, 216, 147);
        Function.drawGlide(graphics, 214, this._gridY - 16, 0, 130, this._maxGridItem / this._gridRN + (this._maxGridItem % this._gridRN > 0 ? 1 : 0) - this._gridLN, this._curGridBase);
        int n = 0;
        while (n < this._gridMax) {
            ResourceManager._avats[80].draw(graphics, this._gridX + n % this._gridRN * this._gridRS, this._gridY + n / this._gridRN * this._gridLS, 15, 0, 0);
            ++n;
        }
        int n2 = 0;
        while (n2 < this._maxGridItem - this._curGridBase * this._gridRN && n2 < this._gridMax) {
            if (!this._callMessage && this._teaching && this._appointIndex == this._gridInfo[n2 + this._curGridBase * this._gridRN][1] && this._appointCount % 7 > 3) {
                Function.drawRect(graphics, this._gridX + n2 % this._gridRN * this._gridRS - 15, this._gridY + n2 / this._gridRN * this._gridLS - 15, 29, 28, 0xFF0000);
            }
            if (this._curGridItem + this._curGridRow * this._rowGridItem == n2 + this._curGridBase * this._gridRN) {
                this.gridNameDraw(graphics, this._gridX + n2 % this._gridRN * this._gridRS, this._gridY + n2 / this._gridRN * this._gridLS);
            }
            ResourceManager._avats[60].draw(graphics, this._gridX + n2 % this._gridRN * this._gridRS, this._gridY + n2 / this._gridRN * this._gridLS, this._gridInfo[n2 + this._curGridBase][2], 0, 0);
            if (this._gridInfo[n2 + this._curGridBase * this._gridRN][3] != 0) {
                int n3 = Function.countOffsetX(this._gridInfo[n2 + this._curGridBase * this._gridRN][3], 0, 7) - 15;
                if (this._gridInfo[n2 + this._curGridBase * this._gridRN][3] > 99) {
                    ResourceManager._spts[80].draw(graphics, this._gridX + n2 % this._gridRN * this._gridRS - 15, this._gridY + n2 / this._gridRN * this._gridLS + 4, 109, 0, 4 | 0x10);
                } else {
                    Function.drawNumer(graphics, this._gridX + n2 % this._gridRN * this._gridRS + n3, this._gridY + n2 / this._gridRN * this._gridLS + 4, this._gridInfo[n2 + this._curGridBase * this._gridRN][3], 0, 0);
                }
            }
            ++n2;
        }
    }

    private void rolePropretyDraw(Graphics graphics) {
        int n;
        Function.drawBorder(graphics, 12, 206, 216, 90);
        int n2 = 0;
        while (n2 < GameParameter.ROLE_PRO.length) {
            n = 0;
            while (n < GameParameter.ROLE_PRO[n2].length) {
                ResourceManager._spts[80].draw(graphics, this._infoX + this._infoRS * n2, this._infoY + this._infoLS * n, GameParameter.ROLE_PRO[n2][n], 0, 4 | 0x10);
                ResourceManager._spts[80].draw(graphics, this._infoX + this._infoRS * n2 + 28, this._infoY + this._infoLS * n + 1, 104, 0, 4 | 0x10);
                ++n;
            }
            ++n2;
        }
        n = 37;
        ResourceManager._spts[80].draw(graphics, this._infoX + this._infoRS * 0 + n, this._infoY + this._infoLS * 0, GameParameter.ROLE_NAME[this._proprety[0]], 0, 4 | 0x10);
        n = Function.countOffsetX(this._proprety[1], 0, 9) + 37;
        Function.drawNumer(graphics, this._infoX + this._infoRS * 0 + n, this._infoY + this._infoLS * 1, this._proprety[1], 0, 1);
        n = Function.countOffsetX(this._proprety[2], this._proprety[3], 9) + 37;
        Function.drawNumer(graphics, this._infoX + this._infoRS * 1 + n, this._infoY + this._infoLS * 0, this._proprety[2], this._proprety[3], 1);
        n = Function.countOffsetX(this._proprety[4], this._proprety[5], 9) + 37;
        Function.drawNumer(graphics, this._infoX + this._infoRS * 1 + n, this._infoY + this._infoLS * 1, this._proprety[4], this._proprety[5], 1);
        if (this._proprety[10] > 0) {
            ResourceManager._spts[80].draw(graphics, 225, this._infoY + this._infoLS * 1, this._proprety[10] == 2 ? 106 : 114, 0, 8 | 0x10);
        }
        n = Function.countOffsetX(this._proprety[6], 0, 9) + 37;
        Function.drawNumer(graphics, this._infoX + this._infoRS * 1 + n, this._infoY + this._infoLS * 2, this._proprety[6], 0, 1);
        if (this._proprety[11] > 0) {
            ResourceManager._spts[80].draw(graphics, 225, this._infoY + this._infoLS * 2, this._proprety[11] == 2 ? 106 : 114, 0, 8 | 0x10);
        }
        n = Function.countOffsetX(this._proprety[7], 0, 9) + 37;
        Function.drawNumer(graphics, this._infoX + this._infoRS * 1 + n, this._infoY + this._infoLS * 3, this._proprety[7], 0, 1);
        if (this._proprety[12] > 0) {
            ResourceManager._spts[80].draw(graphics, 225, this._infoY + this._infoLS * 3, this._proprety[12] == 2 ? 106 : 114, 0, 8 | 0x10);
        }
        n = Function.countOffsetX(this._proprety[8], 0, 9) + 37;
        Function.drawNumer(graphics, this._infoX + this._infoRS * 0 + n, this._infoY + this._infoLS * 2, this._proprety[8], 0, 1);
        n = Function.countOffsetX(this._proprety[9], 0, 9) + 37;
        Function.drawNumer(graphics, this._infoX + this._infoRS * 0 + n, this._infoY + this._infoLS * 3, this._proprety[9], 0, 1);
        if (this._proprety[13] > 0) {
            ResourceManager._spts[80].draw(graphics, 100, this._infoY + this._infoLS * 3, this._proprety[13] == 2 ? 106 : 114, 0, 8 | 0x10);
        }
    }

    private void weaponMenuProcess() {
        this.gridMenuProcess();
        if (KeyCode.isPressCancelKey()) {
            this._selRootMenu = true;
        }
    }

    private void weaponMenuDraw(Graphics graphics) {
        this.gridMenuDraw(graphics);
        this.gridContentDraw(graphics);
    }

    private void toolMenuProcess() {
        block6: {
            block8: {
                block7: {
                    this.gridMenuProcess();
                    if (!KeyCode.isPressConfirmKey()) break block6;
                    if (!this._tooleUse) {
                        return;
                    }
                    if (!Scene._isInCity) break block7;
                    switch (this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1]) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: {
                            break block8;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1] >= 20) {
                    return;
                }
            }
            this._callMessage = true;
            _message = GameMessageBox.getInstance(this);
            _message.initShopStyle(1, GameParameter.STR_CONTENT[1]);
        }
        if (KeyCode.isPressCancelKey()) {
            this._selRootMenu = true;
        }
    }

    private void toolUse() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        GameDB gameDB = GameDB.getGameDataBase();
        if (this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1] <= 3) {
            MainActor mainActor;
            this._callMessage = true;
            _message = GameMessageBox.getInstance(this);
            int n = 0;
            int n2 = 0;
            while (n2 < 3) {
                if (roleTeamData.getExistFlag(n2) && (mainActor = Scene.getInstance().getMainActor(n2)) != null && !mainActor.isDeathState()) {
                    ++n;
                }
                ++n2;
            }
            String[] stringArray = new String[n];
            int n3 = 0;
            int n4 = 0;
            while (n3 < 3) {
                if (roleTeamData.getExistFlag(n3) && (mainActor = Scene.getInstance().getMainActor(n3)) != null && !mainActor.isDeathState()) {
                    DataTable dataTable = gameDB.getData(1, n3);
                    stringArray[n4] = dataTable.getStringItem(1);
                    ++n4;
                }
                ++n3;
            }
            _message.initChooseStyle(stringArray);
            return;
        }
        if (this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1] <= 5) {
            MainActor mainActor;
            this._callMessage = true;
            _message = GameMessageBox.getInstance(this);
            int n = 0;
            int n5 = 0;
            while (n5 < 3) {
                if (roleTeamData.getExistFlag(n5) && (mainActor = Scene.getInstance().getMainActor(n5)) != null && mainActor.isDeathState()) {
                    ++n;
                }
                ++n5;
            }
            if (n == 0) {
                this._callMessage = false;
                return;
            }
            String[] stringArray = new String[n];
            int n6 = 0;
            int n7 = 0;
            while (n6 < 3) {
                if (roleTeamData.getExistFlag(n6) && (mainActor = Scene.getInstance().getMainActor(n6)) != null && mainActor.isDeathState()) {
                    DataTable dataTable = gameDB.getData(1, n6);
                    stringArray[n7] = dataTable.getStringItem(1);
                    ++n7;
                }
                ++n6;
            }
            _message.initChooseStyle(stringArray);
            return;
        }
        MainActor mainActor = (MainActor)Scene.getInstance().getFocusActor();
        switch (this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1]) {
            case 6: 
            case 7: {
                int n = 0;
                while (n < 3) {
                    if (roleTeamData.getExistFlag(n)) {
                        mainActor = Scene.getInstance().getMainActor(n);
                        mainActor.setUesTool(this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1]);
                    }
                    ++n;
                }
                break;
            }
            default: {
                mainActor.setUesTool(this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1]);
            }
        }
        this._exitMenu = true;
        this._callConfirm = true;
        this._tooleUse = false;
        roleTeamData.consumeTool(this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1], -1);
        int n = this._curGridItem;
        this._maxGridItem = 0;
        this.initToolMenu();
        this.isGridNull();
        this.gridContentSub();
        this._curGridItem += this._curGridRow * this._rowGridItem;
        this._curGridItem = Math.min(this._curGridItem, this._maxGridItem - 1);
        this._curGridItem %= this._rowGridItem;
        this._curGridRow -= this._curGridRow > 0 && this._curGridItem != n && n == 0 ? 1 : 0;
    }

    private void toolMenuDraw(Graphics graphics) {
        this.gridMenuDraw(graphics);
        this.gridContentDraw(graphics);
    }

    private void equipMenuProcess() {
        this.gridMenuProcess();
        if (KeyCode.isPressCancelKey()) {
            this._selRootMenu = true;
        }
    }

    private void equipMenuDraw(Graphics graphics) {
        this.gridMenuDraw(graphics);
        this.gridContentDraw(graphics);
    }

    private void taskMenuProcess() {
        this.gridMenuProcess();
        if (KeyCode.isPressCancelKey()) {
            this._selRootMenu = true;
        }
    }

    private void taskMenuDraw(Graphics graphics) {
        Function.drawBorder(graphics, 12, 56, 216, 147);
        int n = 0;
        while (n < this._gridMax) {
            ResourceManager._avats[80].draw(graphics, 115, this._gridY + n / this._gridRN * this._gridLS - 1, 23, 0, 0);
            ++n;
        }
        graphics.setColor(0);
        int n2 = 0;
        while (n2 < this._maxGridItem - this._curGridBase * this._gridRN && n2 < this._gridMax) {
            graphics.drawString(this._gridName[n2 + this._curGridBase], 115, this._gridY + n2 / this._gridRN * this._gridLS - (Function.C_WORD_H >> 1) - 1, 1 | 0x10);
            ++n2;
        }
        Function.drawGlide(graphics, 214, this._gridY - 16, 0, 130, this._maxGridItem / this._gridRN + (this._maxGridItem % this._gridRN > 0 ? 1 : 0) - this._gridLN, this._curGridBase);
        this.gridContentDraw(graphics);
    }

    private void soonMenuProcess() {
        this.gridMenuProcess();
        if (KeyCode.isPressConfirmKey()) {
            this._callMessage = true;
            _message = GameMessageBox.getInstance(this);
            _message.initShopStyle(0, GameParameter.STR_CONTENT[2]);
            _message.initShopBuy(this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][4], RoleTeamData.getInstance().getMoney());
        }
        if (KeyCode.isPressCancelKey()) {
            this._selRootMenu = true;
        }
    }

    private void soonMenuConfirm(int n) {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n2 = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][0];
        int n3 = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1];
        int n4 = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][4];
        switch (n2) {
            case 5: {
                roleTeamData.consumeEquip(n3, n);
                break;
            }
            case 3: {
                roleTeamData.consumeWeapon(n3, n);
                break;
            }
            case 4: {
                roleTeamData.consumeBomb(n3, n);
                break;
            }
            case 2: {
                roleTeamData.consumeTool(n3, n);
            }
        }
        roleTeamData.consumeMoney(-n4 * n);
        this._callConfirm = true;
    }

    private void soonMenuDraw(Graphics graphics) {
        this.gridMenuDraw(graphics);
        this.gridContentDraw(graphics);
    }

    private void taskMenuInit() {
        this.resetTaskGrid();
        this.resetTaskGridPos();
        this.initTaskData();
        this.isGridNull();
    }

    public void setTaskMan(int n) {
        this._curTaskMan = n;
    }

    private void initTaskData() {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(1, this._curTaskMan);
        int[] nArray = dataTable.getArrayItem(12);
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        boolean[] blArray = roleTeamData.getPackageExist(4);
        int n = roleTeamData.getRoleData(0).getRoleInx()[1];
        int n2 = 0;
        while (n2 < nArray.length) {
            DataTable dataTable2;
            if (!blArray[nArray[n2]] && (dataTable2 = gameDB.getData(6, nArray[n2])).getIntItem(4) <= n) {
                ++this._maxGridItem;
            }
            ++n2;
        }
        this._gridInfo = new int[this._maxGridItem][5];
        this._content = new String[this._maxGridItem];
        this._gridName = new String[this._maxGridItem];
        int n3 = 0;
        int n4 = 0;
        while (n3 < nArray.length) {
            DataTable dataTable3;
            if (!blArray[nArray[n3]] && (dataTable3 = gameDB.getData(6, nArray[n3])).getIntItem(4) <= n) {
                this._gridInfo[n4][0] = 6;
                this._gridInfo[n4][1] = nArray[n3];
                this._gridInfo[n4][3] = 0;
                this.creatGridInfo(this._gridInfo[n4][0], this._gridInfo[n4][1], this._gridInfo[n4], this._content, this._gridName, n4);
                ++n4;
            }
            ++n3;
        }
    }

    private void taskMenuUpdate() {
        this.gridMenuProcess();
        if (!this._gridNull && KeyCode.isPressConfirmKey()) {
            this._callMessage = true;
            _message = GameMessageBox.getInstance(this);
            _message.initShopStyle(1, GameParameter.STR_CONTENT[4]);
        }
        if (KeyCode.isPressCancelKey()) {
            this._exitMenu = true;
        }
    }

    private void achieveTask() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1];
        roleTeamData.consumeTask(n, 1);
        GameMainLogic._gameTaskIndex = n;
        int n2 = this._curGridItem;
        this._maxGridItem = 0;
        this.taskMenuInit();
        this.isGridNull();
        this._curGridItem += this._curGridRow * this._rowGridItem;
        this._curGridItem = Math.min(this._curGridItem, this._maxGridItem - 1);
        this._curGridItem %= this._rowGridItem;
        this._curGridRow -= this._curGridRow > 0 && this._curGridItem != n2 && n2 == 0 ? 1 : 0;
        this._callConfirm = true;
        this._exitMenu = true;
    }

    private void paintTaskMenu(Graphics graphics) {
        Function.fillScreen(graphics, 12, 56, 216, 147, 16768940);
        Function.drawBorder(graphics, 12, 56, 216, 147);
        int n = 0;
        while (n < this._gridMax) {
            ResourceManager._avats[80].draw(graphics, 115, this._gridY + n / this._gridRN * this._gridLS - 1, 23, 0, 0);
            ++n;
        }
        graphics.setColor(0);
        int n2 = 0;
        while (n2 < this._maxGridItem - this._curGridBase * this._gridRN && n2 < this._gridMax) {
            graphics.drawString(this._gridName[n2 + this._curGridBase], 115, this._gridY + n2 / this._gridRN * this._gridLS - (Function.C_WORD_H >> 1) - 1, 1 | 0x10);
            ++n2;
        }
        Function.drawGlide(graphics, 214, this._gridY - 16, 0, 130, this._maxGridItem / this._gridRN + (this._maxGridItem % this._gridRN > 0 ? 1 : 0) - this._gridLN, this._curGridBase);
    }

    private void shopMenuInit() {
        this._selShopRootMenu = true;
        this._curShopItem = 0;
        this._maxShopItem = 2;
        this.changeShopSubMenu(0);
    }

    public void setShopKind(int n) {
        this._curShopKind = n;
    }

    private void changeShopSubMenu(int n) {
        switch (n) {
            case 0: {
                this.resetGrid();
                this.initGridPos();
                this.initShopMenuBuy();
                this.isGridNull();
                this.gridContentSub();
                break;
            }
            case 1: {
                this.resetGrid();
                this.initGridPos();
                this.initShopMenuSell();
                this.isGridNull();
                this.gridContentSub();
            }
        }
        this._shopFrame = n;
    }

    private void initShopMenuBuy() {
        DataTable dataTable;
        int n;
        GameDB gameDB = GameDB.getGameDataBase();
        switch (this._curShopKind) {
            case 0: {
                n = gameDB.getDataNum(5);
                int n2 = 0;
                while (n2 < n) {
                    dataTable = gameDB.getData(5, n2);
                    if (dataTable.getIntItem(9) < 2) {
                        ++this._maxGridItem;
                    }
                    ++n2;
                }
                break;
            }
            case 1: {
                n = gameDB.getDataNum(4);
                int n3 = 0;
                while (n3 < n) {
                    dataTable = gameDB.getData(4, n3);
                    if (dataTable.getIntItem(13) < 2) {
                        ++this._maxGridItem;
                    }
                    ++n3;
                }
                n = gameDB.getDataNum(3);
                int n4 = 0;
                while (n4 < n) {
                    dataTable = gameDB.getData(3, n4);
                    if (dataTable.getIntItem(9) < 2) {
                        ++this._maxGridItem;
                    }
                    ++n4;
                }
                break;
            }
            case 2: {
                n = gameDB.getDataNum(2);
                int n5 = 0;
                while (n5 < n) {
                    dataTable = gameDB.getData(2, n5);
                    if (dataTable.getIntItem(9) < 2) {
                        ++this._maxGridItem;
                    }
                    ++n5;
                }
                break;
            }
        }
        this._gridInfo = new int[this._maxGridItem][5];
        this._content = new String[this._maxGridItem];
        this._gridName = new String[this._maxGridItem];
        int n6 = 0;
        int n7 = 0;
        switch (this._curShopKind) {
            case 0: {
                n = gameDB.getDataNum(5);
                n6 = 0;
                while (n6 < n) {
                    dataTable = gameDB.getData(5, n6);
                    if (dataTable.getIntItem(9) != 2) {
                        this._gridInfo[n7][0] = 5;
                        this._gridInfo[n7][1] = n6;
                        this._gridInfo[n7][3] = 0;
                        this.creatGridInfo(this._gridInfo[n7][0], this._gridInfo[n7][1], this._gridInfo[n7], this._content, this._gridName, n7);
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
            case 1: {
                n = gameDB.getDataNum(4);
                n6 = 0;
                while (n6 < n) {
                    dataTable = gameDB.getData(4, n6);
                    if (dataTable.getIntItem(13) != 2) {
                        this._gridInfo[n7][0] = 4;
                        this._gridInfo[n7][1] = n6;
                        this._gridInfo[n7][3] = 0;
                        this.creatGridInfo(this._gridInfo[n7][0], this._gridInfo[n7][1], this._gridInfo[n7], this._content, this._gridName, n7);
                        ++n7;
                    }
                    ++n6;
                }
                n = gameDB.getDataNum(3);
                n6 = 0;
                while (n6 < n) {
                    dataTable = gameDB.getData(3, n6);
                    if (dataTable.getIntItem(9) != 2) {
                        this._gridInfo[n7][0] = 3;
                        this._gridInfo[n7][1] = n6;
                        this._gridInfo[n7][3] = 0;
                        this.creatGridInfo(this._gridInfo[n7][0], this._gridInfo[n7][1], this._gridInfo[n7], this._content, this._gridName, n7);
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
            case 2: {
                n = gameDB.getDataNum(2);
                n6 = 0;
                while (n6 < n) {
                    dataTable = gameDB.getData(2, n6);
                    if (dataTable.getIntItem(9) != 2) {
                        this._gridInfo[n7][0] = 2;
                        this._gridInfo[n7][1] = n6;
                        this._gridInfo[n7][3] = 0;
                        this.creatGridInfo(this._gridInfo[n7][0], this._gridInfo[n7][1], this._gridInfo[n7], this._content, this._gridName, n7);
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
        }
    }

    private void initShopMenuSell() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int[] nArray = roleTeamData.getPackageInfo(3);
        boolean[] blArray = roleTeamData.getPackageExist(3);
        int n = 0;
        while (n < blArray.length) {
            if (blArray[n] && nArray[n] < 99999) {
                this._maxGridItem += Function.countGridNumber(nArray[n]);
            }
            ++n;
        }
        nArray = roleTeamData.getPackageInfo(2);
        blArray = roleTeamData.getPackageExist(2);
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2] && nArray[n2] < 99999) {
                this._maxGridItem += Function.countGridNumber(nArray[n2]);
            }
            ++n2;
        }
        nArray = roleTeamData.getPackageInfo(1);
        blArray = roleTeamData.getPackageExist(1);
        int n3 = 0;
        while (n3 < blArray.length) {
            if (blArray[n3] && nArray[n3] < 99999) {
                this._maxGridItem += Function.countGridNumber(nArray[n3]);
            }
            ++n3;
        }
        nArray = roleTeamData.getPackageInfo(0);
        blArray = roleTeamData.getPackageExist(0);
        int n4 = 0;
        while (n4 < blArray.length) {
            if (blArray[n4] && nArray[n4] < 99999) {
                this._maxGridItem += Function.countGridNumber(nArray[n4]);
            }
            ++n4;
        }
        this._gridInfo = new int[this._maxGridItem][5];
        this._content = new String[this._maxGridItem];
        this._gridName = new String[this._maxGridItem];
        nArray = roleTeamData.getPackageInfo(3);
        blArray = roleTeamData.getPackageExist(3);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n5 = 0;
        while (n5 < blArray.length) {
            if (blArray[n5] && nArray[n5] < 99999) {
                n7 = nArray[n5] / 99;
                n7 = nArray[n5] < 99999 ? (n7 += nArray[n5] % 99 > 0 ? 1 : 0) + n6 : 1 + n6;
                while (n6 < n7) {
                    this._gridInfo[n6][0] = 2;
                    this._gridInfo[n6][1] = n5;
                    this._gridInfo[n6][3] = n6 < n7 - 1 ? 99 : nArray[n5] % 99;
                    this._gridInfo[n6][3] = nArray[n5] % 99 == 0 ? 99 : this._gridInfo[n6][3];
                    this._gridInfo[n6][3] = nArray[n5] == 99999 ? nArray[n5] : this._gridInfo[n6][3];
                    this.creatGridInfo(this._gridInfo[n6][0], this._gridInfo[n6][1], this._gridInfo[n6], this._content, this._gridName, n6);
                    ++n6;
                }
            }
            ++n5;
        }
        nArray = roleTeamData.getPackageInfo(2);
        blArray = roleTeamData.getPackageExist(2);
        n5 = 0;
        while (n5 < blArray.length) {
            if (blArray[n5] && nArray[n5] < 99999) {
                n7 = nArray[n5] / 99;
                n7 = nArray[n5] < 99999 ? (n7 += nArray[n5] % 99 > 0 ? 1 : 0) + n6 : 1 + n6;
                while (n6 < n7) {
                    this._gridInfo[n6][0] = 4;
                    this._gridInfo[n6][1] = n5;
                    this._gridInfo[n6][3] = n6 < n7 - 1 ? 99 : nArray[n5] % 99;
                    this._gridInfo[n6][3] = nArray[n5] % 99 == 0 ? 99 : this._gridInfo[n6][3];
                    this._gridInfo[n6][3] = nArray[n5] == 99999 ? nArray[n5] : this._gridInfo[n6][3];
                    this.creatGridInfo(this._gridInfo[n6][0], this._gridInfo[n6][1], this._gridInfo[n6], this._content, this._gridName, n6);
                    ++n6;
                }
            }
            ++n5;
        }
        nArray = roleTeamData.getPackageInfo(1);
        blArray = roleTeamData.getPackageExist(1);
        n5 = 0;
        while (n5 < blArray.length) {
            if (blArray[n5] && nArray[n5] < 99999) {
                n7 = nArray[n5] / 99;
                n7 = nArray[n5] < 99999 ? (n7 += nArray[n5] % 99 > 0 ? 1 : 0) + n6 : 1 + n6;
                while (n6 < n7) {
                    this._gridInfo[n6][0] = 3;
                    this._gridInfo[n6][1] = n5;
                    this._gridInfo[n6][3] = n6 < n7 - 1 ? 99 : nArray[n5] % 99;
                    this._gridInfo[n6][3] = nArray[n5] % 99 == 0 ? 99 : this._gridInfo[n6][3];
                    this._gridInfo[n6][3] = nArray[n5] == 99999 ? nArray[n5] : this._gridInfo[n6][3];
                    this.creatGridInfo(this._gridInfo[n6][0], this._gridInfo[n6][1], this._gridInfo[n6], this._content, this._gridName, n6);
                    ++n6;
                }
            }
            ++n5;
        }
        nArray = roleTeamData.getPackageInfo(0);
        blArray = roleTeamData.getPackageExist(0);
        n5 = 0;
        while (n5 < blArray.length) {
            if (blArray[n5] && nArray[n5] < 99999) {
                n7 = nArray[n5] / 99;
                n7 = nArray[n5] < 99999 ? (n7 += nArray[n5] % 99 > 0 ? 1 : 0) + n6 : 1 + n6;
                while (n6 < n7) {
                    this._gridInfo[n6][0] = 5;
                    this._gridInfo[n6][1] = n5;
                    this._gridInfo[n6][3] = n6 < n7 - 1 ? 99 : nArray[n5] % 99;
                    this._gridInfo[n6][3] = nArray[n5] % 99 == 0 ? 99 : this._gridInfo[n6][3];
                    this._gridInfo[n6][3] = nArray[n5] == 99999 ? nArray[n5] : this._gridInfo[n6][3];
                    this.creatGridInfo(this._gridInfo[n6][0], this._gridInfo[n6][1], this._gridInfo[n6], this._content, this._gridName, n6);
                    ++n6;
                }
            }
            ++n5;
        }
    }

    private void shopMenuUpdate() {
        if (this._selShopRootMenu) {
            this.shopRootMenuUpdate();
            return;
        }
        switch (this._shopFrame) {
            case 0: {
                this.shopBuyMenuProcess();
                break;
            }
            case 1: {
                this.shopSellMenuProcess();
            }
        }
    }

    private void shopRootMenuUpdate() {
        int n = KeyCode.getCurKey();
        switch (n) {
            case 1: {
                --this._curShopItem;
                this._curShopItem = Math.max(this._curShopItem, 0);
                this.changeShopSubMenu(this._curShopItem);
                break;
            }
            case 2: {
                ++this._curShopItem;
                this._curShopItem = Math.min(this._curShopItem, this._maxShopItem - 1);
                this.changeShopSubMenu(this._curShopItem);
                break;
            }
            case 8: {
                if (this._gridNull) break;
                this._selShopRootMenu = false;
            }
        }
        if (KeyCode.isPressCancelKey()) {
            this._exitMenu = true;
        }
    }

    private void shopBuyMenuProcess() {
        this.gridMenuProcess();
        if (KeyCode.isPressConfirmKey()) {
            this._callMessage = true;
            _message = GameMessageBox.getInstance(this);
            _message.initShopStyle(0, GameParameter.STR_CONTENT[2]);
            _message.initShopBuy(this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][4], RoleTeamData.getInstance().getMoney());
        }
        if (KeyCode.isPressCancelKey()) {
            this._selShopRootMenu = true;
        }
    }

    private void shopSellMenuProcess() {
        this.gridMenuProcess();
        if (KeyCode.isPressConfirmKey()) {
            this._callMessage = true;
            _message = GameMessageBox.getInstance(this);
            _message.initShopStyle(0, GameParameter.STR_CONTENT[3]);
            _message.initShopSell(this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][4] >> 1, this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][3]);
        }
        if (KeyCode.isPressCancelKey()) {
            this._selShopRootMenu = true;
        }
    }

    private void shopBuy(int n) {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n2 = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][0];
        int n3 = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1];
        int n4 = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][4];
        switch (n2) {
            case 5: {
                roleTeamData.consumeEquip(n3, n);
                break;
            }
            case 3: {
                roleTeamData.consumeWeapon(n3, n);
                break;
            }
            case 4: {
                roleTeamData.consumeBomb(n3, n);
                break;
            }
            case 2: {
                roleTeamData.consumeTool(n3, n);
            }
        }
        roleTeamData.consumeMoney(-n4 * n);
        this._callConfirm = true;
    }

    private void shopSell(int n) {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n2 = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][0];
        int n3 = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1];
        int n4 = this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][4];
        switch (n2) {
            case 5: {
                roleTeamData.consumeEquip(n3, -n);
                break;
            }
            case 3: {
                roleTeamData.consumeWeapon(n3, -n);
                break;
            }
            case 4: {
                roleTeamData.consumeBomb(n3, -n);
                break;
            }
            case 2: {
                roleTeamData.consumeTool(n3, -n);
            }
        }
        roleTeamData.consumeMoney((n4 >> 1) * n);
        int n5 = this._curGridItem;
        this._maxGridItem = 0;
        this.initShopMenuSell();
        this.isGridNull();
        this._curGridItem += this._curGridRow * this._rowGridItem;
        this._curGridItem = Math.min(this._curGridItem, this._maxGridItem - 1);
        this._curGridItem %= this._rowGridItem;
        this._curGridRow -= this._curGridRow > 0 && this._curGridItem != n5 && n5 == 0 ? 1 : 0;
        this.gridContentSub();
        this._callConfirm = true;
    }

    private void paintShopMenu(Graphics graphics) {
        this.shopRootMenuDraw(graphics);
        switch (this._shopFrame) {
            case 0: {
                this.shopBuyMenuDraw(graphics);
                break;
            }
            case 1: {
                this.shopSellMenuDraw(graphics);
            }
        }
    }

    private void shopRootMenuDraw(Graphics graphics) {
        Function.drawBackGroud(graphics, 2, 10, 233, 305);
        Function.drawRootBack(graphics, 2, 28, 0, 0);
        int n = 0;
        while (n < this._maxShopItem) {
            if (this._curShopItem == n) {
                ResourceManager._avats[80].draw(graphics, this._rootX + n * this._rootS, this._rootY, (12 + n << 1) + 1, 0, 0);
            } else {
                ResourceManager._avats[80].draw(graphics, this._rootX + n * this._rootS, this._rootY, 12 + n << 1, 0, 0);
            }
            ++n;
        }
    }

    private void shopBuyMenuDraw(Graphics graphics) {
        this.gridMenuDraw(graphics);
        this.gridContentDraw(graphics);
    }

    private void shopSellMenuDraw(Graphics graphics) {
        this.gridMenuDraw(graphics);
        this.gridContentDraw(graphics);
    }

    public void finishHandle() {
        this._callMessage = false;
        this._teacher = false;
        Scene.getInstance().updateScript();
    }

    public void resultHandle(int n) {
        this._callMessage = false;
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n2 = Scene.getInstance().getFocusActor()._x;
        int n3 = Scene.getInstance().getFocusActor()._y;
        int n4 = 0;
        int n5 = 0;
        while (n4 < 3) {
            if (roleTeamData.getExistFlag(n4)) {
                MainActor mainActor = Scene.getInstance().setHpForMainActor(n4);
                if (this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1] <= 3) {
                    if (!mainActor.isDeathState()) {
                        if (n5 == n) {
                            mainActor.setUesTool(this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1]);
                            this._exitMenu = true;
                            this._tooleUse = false;
                            break;
                        }
                        ++n5;
                    }
                } else if (this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1] <= 5 && mainActor != null && mainActor.isDeathState()) {
                    if (n5 == n) {
                        mainActor.setPos(n2, n3);
                        mainActor.setUesTool(this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1]);
                        this._exitMenu = true;
                        this._tooleUse = false;
                        break;
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        roleTeamData.consumeTool(this._gridInfo[this._curGridItem + this._curGridRow * this._rowGridItem][1], -1);
        int n6 = this._curGridItem;
        this._maxGridItem = 0;
        this.initToolMenu();
        this.isGridNull();
        this.gridContentSub();
        this._curGridItem += this._curGridRow * this._rowGridItem;
        this._curGridItem = Math.min(this._curGridItem, this._maxGridItem - 1);
        this._curGridItem %= this._rowGridItem;
        this._curGridRow -= this._curGridRow > 0 && this._curGridItem != n6 && n6 == 0 ? 1 : 0;
    }

    public void buySuccessedTip(String string) {
        this._callMessage = true;
        _message = GameMessageBox.getInstance(this);
        _message.initSinglePageStyle(0, 0, string, 0);
        SceneUI.getInstance().toolMenuInfo();
    }

    public void shopResultHandle(int n) {
        this._callMessage = false;
        block0 : switch (this._state) {
            case 0: {
                switch (this._frame) {
                    case 0: {
                        this.roleEquipChange();
                        break;
                    }
                    case 2: {
                        this.toolUse();
                        break;
                    }
                    case 5: {
                        this.soonMenuConfirm(n);
                        if (n > 0) {
                            this.buySuccessedTip("\u8d2d\u4e70\u6210\u529f");
                            break;
                        }
                        this.buySuccessedTip("\u8d2d\u4e70\u5931\u8d25");
                    }
                }
                break;
            }
            case 1: {
                this.achieveTask();
                break;
            }
            case 2: {
                switch (this._shopFrame) {
                    case 0: {
                        this.shopBuy(n);
                        if (n > 0) {
                            this.buySuccessedTip("\u8d2d\u4e70\u6210\u529f");
                            break block0;
                        }
                        this.buySuccessedTip("\u8d2d\u4e70\u5931\u8d25");
                        break block0;
                    }
                    case 1: {
                        this.shopSell(n);
                        if (n > 0) {
                            this.buySuccessedTip("\u552e\u5356\u6210\u529f");
                            break block0;
                        }
                        this.buySuccessedTip("\u552e\u5356\u5931\u8d25");
                    }
                }
            }
        }
    }

    public void cancelHandle() {
        this._callMessage = false;
    }

    public void teaching(int n, int n2, int n3, int n4) {
        if (n <= 5) {
            this.init(0);
            this.changeSubMenu(n);
        }
        this._appointRoot = n;
        this._appointItem = n2;
        if (this._appointRoot == 0) {
            switch (this._appointItem) {
                case 0: {
                    this._selRootMenu = false;
                    this._selRoleMenu = true;
                    this._selRoleEquipMenu = false;
                    break;
                }
                case 1: {
                    this._selRootMenu = false;
                    this._selRoleMenu = false;
                    this._selRoleEquipMenu = true;
                }
            }
        }
        this._appointIndex = n3;
        if (this._appointRoot == 0) {
            if (this._selRoleEquipMenu) {
                this._curRoleEquipItem = this._appointIndex % this._rowRoleEquipItem;
                this._curRoleEquipRow = this._appointIndex / this._rowRoleEquipItem;
            } else if (!this._selRoleMenu && !this._selRootMenu) {
                int n5 = 0;
                while (n5 < this._gridInfo.length) {
                    if (this._gridInfo[n5][1] == this._appointIndex) {
                        this._curGridItem = n5 % this._rowGridItem;
                        this._curGridRow = n5 / this._rowGridItem;
                    }
                    ++n5;
                }
            }
        } else {
            int n6 = 0;
            while (n6 < this._gridInfo.length) {
                if (this._gridInfo[n6][1] == this._appointIndex) {
                    this._curGridItem = n6 % this._rowGridItem;
                    this._curGridRow = n6 / this._rowGridItem;
                }
                ++n6;
            }
        }
        this._appointKey = n4;
        switch (this._appointKey) {
            case -1: {
                this._appointKey = 0;
                break;
            }
            case 0: {
                this._appointKey = 16;
                break;
            }
            case 1: {
                this._appointKey = 524288;
            }
        }
        this._teaching = true;
    }

    public void teachingDialog(String string) {
        this._callMessage = true;
        this._teacher = true;
        _message = GameMessageBox.getInstance(this);
        _message.initDialogStyle(60, 260, null, string);
    }

    public void teachingExit() {
        GameMainLogic.getInstance().changeState((byte)1);
    }
}

