/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.customise.Function;
import com.sinaflying.database.DataTable;
import com.sinaflying.database.GameDB;
import com.sinaflying.engine.Avatar;
import com.sinaflying.engine.KeyCode;
import com.sinaflying.game.Actor;
import com.sinaflying.game.GameInterface;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.Scene;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Assistant
extends Actor {
    private int _kind;
    private int _lLimit;
    private int _rLimit;
    private String name;

    public Assistant(int n, Avatar avatar) {
        super(n, avatar);
        this.setKind(n);
    }

    private void setKind(int n) {
        switch (n) {
            case 72: 
            case 73: 
            case 75: 
            case 77: 
            case 78: 
            case 79: {
                this._kind = 0;
                break;
            }
            case 90: {
                this._kind = 4;
                break;
            }
            case 92: {
                this._kind = 3;
                break;
            }
            case 82: {
                this._kind = 5;
                break;
            }
            case 91: {
                this._kind = 6;
            }
        }
        if (n >= 18 && n <= 29) {
            this._kind = 2;
        }
    }

    public boolean init(byte[] byArray) {
        super.init(byArray);
        this.initData();
        return true;
    }

    public void init(int n, int n2, int n3) {
        super.init(n, n2, n3);
        this.initData();
    }

    public void initData() {
        switch (this._kind) {
            case 0: {
                this.initEffect();
                break;
            }
            case 2: {
                this.initNPC();
                break;
            }
            case 3: {
                this.initFlyHouse();
                break;
            }
            case 4: {
                this.initFlyCloud();
                break;
            }
            case 5: {
                this.initPassPoint();
                break;
            }
            case 6: {
                this.initRecordPoint();
            }
        }
    }

    public void ai() {
        switch (this._kind) {
            case 0: {
                this.effectProcess();
                break;
            }
            case 2: {
                this.npcProcess();
                break;
            }
            case 3: {
                this.flyHouseProcess();
                break;
            }
            case 4: {
                this.flyCloudProcess();
                break;
            }
            case 5: {
                this.passPointProcess();
                break;
            }
            case 6: {
                this.recordPointProcess();
            }
        }
    }

    public void step() {
        if (this.isExecuteStep()) {
            this.nextFrame();
            this._dx = this._vx;
            this._dy = this._vy;
            this._vx += this._ax;
            this._vx = this._ax > 0 && this._vx > this._fx ? this._fx : this._vx;
            this._vx = this._ax < 0 && this._vx < this._fx ? this._fx : this._vx;
            this._vy += this._ay;
            this._vy = this._ay > 0 && this._vy > this._fy ? this._fy : this._vy;
            this._vy = this._ay < 0 && this._vy < this._fy ? this._fy : this._vy;
            this._x += this._dx;
            this._y += this._dy;
            switch (this._kind) {
                case 2: {
                    this.checkGround();
                }
            }
        }
    }

    public void triggerActorScript() {
        if (!this.scriptHandle()) {
            return;
        }
        switch (this._kind) {
            case 2: {
                this.npcScriptInfo();
                break;
            }
            case 5: {
                this.pssPointScriptInfo();
                break;
            }
            case 6: {
                this.recordPointScriptInfo();
            }
        }
    }

    public void setAI(boolean bl) {
        super.setAI(bl);
        switch (this._kind) {
            case 2: {
                this._vx = 0;
                this._vy = 0;
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        super.draw(graphics, n, n2, n3, n4);
        switch (this._kind) {
            case 2: {
                if (this.noDrawName()) break;
                this.drawName(graphics, n, n2, n3, n4);
            }
        }
    }

    private boolean noDrawName() {
        return this._action == this._anim.getActionNum() - 1;
    }

    private void drawName(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.name.length();
        int n6 = (this._x >> 10) - n - n3 - Function.C_WORD_W * n5 / 2 - 1;
        int n7 = (this._y >> 10) - n2 - n4 + 5;
        Function.drawNamePanel(graphics, n6, n7, Function.C_WORD_W * n5 + 2, Function.C_WORD_H + 2, 0xFFFFFF);
        graphics.setColor(0);
        graphics.drawString(this.name, n6 + 1, n7 + 1, 4 | 0x10);
    }

    private void initEffect() {
    }

    private void effectProcess() {
        if (this._curFrame >= this._actFrmNum - 1) {
            this.disActive();
        }
    }

    private void initNPC() {
        byte by = Scene._actorInitData[this._id][9];
        DataTable dataTable = GameDB.getGameDataBase().getData(1, by);
        this.name = dataTable.getStringItem(1);
    }

    private void npcProcess() {
        if (this._scene.isScriptEnd() && this._curAction != this._actionNum - 1) {
            this.triggerActorScript();
        }
    }

    private void npcScriptInfo() {
        byte by = Scene._actorInitData[this._id][8];
        GameMainLogic._gameTaskMan = Scene._actorInitData[this._id][9];
        GameMainLogic._gameTaskIndex = -1;
        this._scene.doScript(by, -1);
    }

    private void initFlyHouse() {
        this._vx = Function.Random(2, false) > 0 ? 1024 : -1024;
        this._lLimit = (this._x >> 10) - 120;
        this._lLimit = Math.max(this._lLimit, 0);
        this._rLimit = (this._x >> 10) + 120;
        this._rLimit = Math.min(this._rLimit, this._scene.getWidth());
    }

    private void flyHouseProcess() {
        int n = this._x >> 10;
        this._vx = n <= this._lLimit ? -this._vx : this._vx;
        this._vx = n >= this._rLimit ? -this._vx : this._vx;
    }

    private void initFlyCloud() {
        this._vx = Function.Random(2, false) > 0 ? 1024 : -1024;
        this._lLimit = (this._x >> 10) - 120;
        this._lLimit = Math.max(this._lLimit, 0);
        this._rLimit = (this._x >> 10) + 120;
        this._rLimit = Math.min(this._rLimit, this._scene.getWidth());
    }

    private void flyCloudProcess() {
        int n = this._x >> 10;
        this._vx = n <= this._lLimit ? -this._vx : this._vx;
        this._vx = n >= this._rLimit ? -this._vx : this._vx;
    }

    private void initRecordPoint() {
    }

    private void recordPointProcess() {
        if (this._scene.isScriptEnd()) {
            switch (this._kind) {
                case 6: {
                    if (this.collide(this._scene.getFocusActor())) {
                        this.changeAction(1);
                        break;
                    }
                    this.changeAction(0);
                }
            }
            this.triggerActorScript();
        }
    }

    private void recordPointScriptInfo() {
        this._scene.getGameLogic().changeState((byte)0);
        GameMainLogic._interface.changeState((byte)10);
        GameMainLogic._interface.setInMenuState(true);
    }

    private void initPassPoint() {
    }

    private void passPointProcess() {
        if (this._scene.isScriptEnd()) {
            this.triggerActorScript();
        }
    }

    private void pssPointScriptInfo() {
        byte by = Scene._actorInitData[this._id][8];
        byte by2 = Scene._actorInitData[this._id][9];
        byte by3 = Scene._actorInitData[this._id][10];
        if (by == 100) {
            try {
                GameInterface._bigMap = Image.createImage((String)"/res/L0.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this._scene.resetPos();
            GameMainLogic._interface._curPoint = 0;
            this._scene.getGameLogic().changeState((byte)0);
            GameMainLogic._interface.changeState((byte)20);
        } else {
            GameMainLogic._interface.changeLevel(by, by2, by3);
        }
        KeyCode.resetCurKey();
    }
}

