/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.engine;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.sinaflying.customise.Function;
import com.sinaflying.customise.R;
import com.sinaflying.database.DataTable;
import com.sinaflying.database.GameDB;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.Scene;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledBackground {
    public int cw;
    public int ch;
    public int mapx;
    public int mapy;
    public byte[][] axTile;
    public int w;
    public int h;
    public int tw;
    public int th;
    public static int[] activeTile = new int[32];
    public static short[][] activeTilePixel = new short[32][];
    public static byte[][] foreTilePixelIndex;
    public static int foreW;
    public static int foreH;
    private boolean _openBlack;
    public byte[][] tileMask;
    public static byte[][] bombMask;
    public static short[] tilePalette;
    public static byte[] tilePixel;
    public static int[] tileIdMaskId;
    public static int timgw;
    public static int timgh;
    public int forePrevMapX;
    public int forePrevMapY;
    public static int exceed;
    public static int tid;
    public static int solidTiles;
    public static short[] buffer;
    public static Image distantView;
    public static byte curDistantIndex;
    public static int[] distantIndex;
    public static int[][] mendiumIndex;
    public static int[][] mendiumData;
    public static Image[] mediumView;

    public TiledBackground(int n, int n2) {
        this.cw = n;
        this.ch = n2;
    }

    public void setPositionInMap(int n, int n2) {
        this.mapx = n;
        this.mapy = n2;
    }

    public void drawFore(Graphics graphics) {
        this.directDraw(graphics, this.mapx, this.mapy, this.cw, this.ch);
    }

    public void drawDistant(Graphics graphics) {
        this.drawDistantView(graphics, this.mapx, this.mapy, this.cw, this.ch);
        this.drawBlackScreen(graphics);
    }

    public void drawMedium(Graphics graphics) {
        this.drawMediumView(graphics, this.mapx, this.mapy, this.cw, this.ch);
    }

    private void setFastMode(int n, int n2) {
        this.initForeIdx(n, n2);
        this.init();
    }

    public void init() {
        int n = 0;
        while (n < activeTile.length) {
            TiledBackground.activeTile[n] = 0;
            ++n;
        }
        this.forePrevMapX = -1;
        this.forePrevMapY = -1;
    }

    private void initForeIdx(int n, int n2) {
        int n3 = n % this.tw == 0 ? n + this.tw : n - n % this.tw + 2 * this.tw;
        int n4 = n2 % this.th == 0 ? n2 + this.th : n2 - n2 % this.th + 2 * this.th;
        foreW = n3 / this.tw;
        foreH = n4 / this.th;
        foreTilePixelIndex = new byte[foreH][];
        int n5 = 0;
        while (n5 < foreH) {
            TiledBackground.foreTilePixelIndex[n5] = new byte[foreW];
            int n6 = 0;
            while (n6 < foreW) {
                TiledBackground.foreTilePixelIndex[n5][n6] = -1;
                ++n6;
            }
            ++n5;
        }
    }

    protected void directDraw(Graphics graphics, int n, int n2, int n3, int n4) {
        try {
            int n5;
            int n6;
            int n7;
            int n8 = Math.max(n, 0);
            int n9 = Math.min(n + n3, this.w * this.tw);
            int n10 = Math.max(n2, 0);
            int n11 = Math.min(n2 + n4, this.h * this.th);
            int n12 = n8 - n8 % this.tw;
            int n13 = n10 - n10 % this.th;
            int n14 = n - n % this.tw;
            int n15 = n2 - n2 % this.th;
            int n16 = 0;
            int n17 = 0;
            if (n14 > this.forePrevMapX) {
                n16 = this.forePrevMapX / this.tw + n3 / this.tw + 1;
                n17 = n14 / this.tw + n3 / this.tw + 1;
            } else if (n14 < this.forePrevMapX) {
                n16 = n14 / this.tw;
                n17 = this.forePrevMapX / this.tw;
            }
            int n18 = n16;
            while (n18 <= n17) {
                n7 = 0;
                while (n7 < foreH) {
                    n6 = n18 % foreW;
                    this.resetForeTileIndex(n6, n7);
                    ++n7;
                }
                ++n18;
            }
            n16 = 0;
            n17 = 0;
            if (n15 > this.forePrevMapY) {
                n16 = this.forePrevMapY / this.th + n4 / this.th + 1;
                n17 = n15 / this.th + n4 / this.th + 1;
            } else if (n15 < this.forePrevMapY) {
                n16 = n15 / this.th;
                n17 = this.forePrevMapY / this.th;
            }
            n7 = n16;
            while (n7 < n17) {
                n6 = 0;
                while (n6 < foreW) {
                    n5 = n7 % foreH;
                    this.resetForeTileIndex(n6, n5);
                    ++n6;
                }
                ++n7;
            }
            DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
            exceed = 0;
            n5 = n13;
            while (n5 < n11) {
                int n19 = n5 / this.th;
                int n20 = n12;
                while (n20 < n9) {
                    int n21 = n20 / this.tw;
                    int n22 = this.getTileIndex(n21, n19, tileIdMaskId);
                    if (n22 != -1) {
                        byte by = foreTilePixelIndex[n19 % foreH][n21 % foreW];
                        short[] sArray = by >= 0 ? activeTilePixel[by] : this.fillTilePixel(n21, n19);
                        directGraphics.drawPixels(sArray, true, 0, this.tw, n20 - n, n5 - n2, this.tw, this.th, 0, 4444);
                    }
                    n20 += this.tw;
                }
                n5 += this.th;
            }
            this.forePrevMapX = n14;
            this.forePrevMapY = n15;
        }
        catch (Exception exception) {
            System.out.println("Direct draw error : " + exception);
        }
    }

    protected void resetForeTileIndex(int n, int n2) {
        if (foreTilePixelIndex[n2][n] >= 0) {
            TiledBackground.activeTile[TiledBackground.foreTilePixelIndex[n2][n]] = 0;
        }
        TiledBackground.foreTilePixelIndex[n2][n] = -1;
    }

    protected short[] fillTilePixel(int n, int n2) {
        short[] sArray;
        int n3 = this.getTileIndex(n, n2, tileIdMaskId);
        if (n3 < 0) {
            return null;
        }
        int n4 = this.getFreeTilePixel();
        if (n4 >= 0) {
            sArray = activeTilePixel[n4];
            TiledBackground.activeTile[n4] = 1;
            TiledBackground.foreTilePixelIndex[n2 % TiledBackground.foreH][n % TiledBackground.foreW] = (byte)n4;
        } else {
            sArray = buffer;
            ++exceed;
        }
        int n5 = tileIdMaskId[0];
        byte[] byArray = this.getTileMask(tileIdMaskId[1]);
        int n6 = n5 * this.tw * this.th;
        int n7 = 0;
        int n8 = 8;
        int n9 = 255;
        int n10 = 0;
        while (n10 < this.tw * this.th) {
            if (n8 == 8) {
                n9 = byArray[n7++];
                n8 = 0;
            }
            if ((n9 & 0x80) == 0) {
                sArray[n10] = tilePalette[0];
            } else {
                try {
                    int n11 = tilePixel[n6 + n10];
                    if (n11 < 0) {
                        n11 += 256;
                    }
                    sArray[n10] = tilePalette[n11];
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            n9 <<= 1;
            ++n8;
            ++n10;
        }
        return sArray;
    }

    public void dispose() {
        this.axTile = null;
    }

    private void drawDistantView(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = distantView.getWidth();
        int n6 = -(n >>= 1) % n5;
        graphics.setClip(0, 0, n3, n4);
        graphics.drawImage(distantView, n6, 0, 0x10 | 4);
        int n7 = n6 + n5;
        if (n7 >= n + n3) {
            return;
        }
        graphics.drawImage(distantView, n7, 0, 0x10 | 4);
    }

    private void drawMediumView(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = mendiumData[curDistantIndex].length >> 2;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = mendiumData[curDistantIndex][(n6 << 2) + 0];
            if (n7 >= 0) {
                int n8 = 0;
                while (n8 < mendiumIndex[curDistantIndex].length) {
                    if (mendiumIndex[curDistantIndex][n8] == n7) break;
                    ++n8;
                }
                int n9 = mediumView[n8].getWidth();
                int n10 = mediumView[n8].getHeight();
                int n11 = mendiumData[curDistantIndex][(n6 << 2) + 2];
                int n12 = mendiumData[curDistantIndex][(n6 << 2) + 3];
                if (n11 < n + n3 && n12 < n2 + n4 && n11 + n9 >= n && n12 + n10 >= n2) {
                    int n13 = mendiumData[curDistantIndex][(n6 << 2) + 1];
                    int n14 = n11 > n ? 0 : n - n11;
                    int n15 = n12 > n2 ? 0 : n2 - n12;
                    n9 -= n14;
                    n10 -= n15;
                    switch (n13) {
                        case 1: {
                            n15 = 0;
                            break;
                        }
                        case 2: {
                            n14 = 0;
                            break;
                        }
                        case 3: {
                            n15 = 0;
                            n14 = 0;
                        }
                    }
                    n11 = n11 - n < 0 ? 0 : n11 - n;
                    n12 = n12 - n2 < 0 ? 0 : n12 - n2;
                    try {
                        graphics.drawRegion(mediumView[n8], n14, n15, n9, n10, n13, n11, n12, 0x10 | 4);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            ++n6;
        }
    }

    public static void loadBombMask() {
        try {
            int n = 0;
            while (n < bombMask.length) {
                TiledBackground.bombMask[n] = new byte[512];
                TiledBackground.bombMask[n] = R.readInputData("/res/mask" + n + ".msk", -1);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("load background global error : " + exception);
        }
    }

    public void loadTilePixel(int n) {
        try {
            int n2;
            DataInputStream dataInputStream = R.openDataInputStream("/res/m" + n + ".pix", -1);
            int n3 = dataInputStream.readShort();
            tilePalette = new short[n3];
            int n4 = 0;
            while (n4 < n3) {
                n2 = dataInputStream.readByte();
                short s = dataInputStream.readByte();
                TiledBackground.tilePalette[n4] = (short)(s << 8 & 0xFF00 | n2 & 0xFF);
                ++n4;
            }
            n3 = dataInputStream.readShort();
            timgw = n3 * this.tw;
            n3 = dataInputStream.readShort();
            timgh = n3 * this.th;
            n2 = timgw * timgh;
            tilePixel = new byte[n2];
            dataInputStream.read(tilePixel);
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadTileMask(int n) {
        try {
            int n2;
            int n3;
            int n4 = 0;
            byte[] byArray = R.readInputData("/res/a" + n + ".msk", -1);
            int n5 = R.readInt(byArray, n4, 1);
            ++n4;
            n5 = 0;
            int n6 = 0;
            while (n6 < this.h) {
                if (this.axTile[n6][0] != 0) {
                    n3 = 0;
                    n2 = 1;
                    while (n3 < this.w) {
                        if (this.axTile[n6][n2] < 0) {
                            n3 += -this.axTile[n6][n2];
                            ++n2;
                            continue;
                        }
                        ++n3;
                        n2 += 2;
                        ++n5;
                    }
                }
                ++n6;
            }
            this.tileMask = new byte[n5][];
            n3 = this.tw * this.th / 8;
            n5 = 0;
            n2 = 0;
            while (n2 < this.h) {
                if (this.axTile[n2][0] != 0) {
                    int n7 = 0;
                    int n8 = 1;
                    while (n7 < this.w) {
                        if (this.axTile[n2][n8] < 0) {
                            n7 += -this.axTile[n2][n8];
                            ++n8;
                            continue;
                        }
                        byte by = this.axTile[n2][n8 + 1];
                        this.tileMask[n5] = new byte[n3];
                        System.arraycopy(byArray, 1 + n3 * by, this.tileMask[n5], 0, n3);
                        this.axTile[n2][n8 + 1] = (byte)n5;
                        ++n5;
                        ++n7;
                        n8 += 2;
                    }
                }
                ++n2;
            }
            byArray = null;
        }
        catch (Exception exception) {
            System.out.println("load tile mask error :" + exception);
        }
    }

    public static TiledBackground load(GameMainLogic gameMainLogic, int n) {
        TiledBackground tiledBackground;
        try {
            int n2 = Scene._isInCity ? 0 : 0;
            tiledBackground = new TiledBackground(240, 320 - n2);
            DataInputStream dataInputStream = R.openDataInputStream("/res/m" + n + ".xmm", -1);
            short s = dataInputStream.readShort();
            tiledBackground.w = dataInputStream.readShort();
            tiledBackground.h = dataInputStream.readShort();
            tiledBackground.tw = dataInputStream.readByte();
            tiledBackground.th = dataInputStream.readByte();
            tiledBackground.axTile = new byte[tiledBackground.h][];
            int n3 = 0;
            while (n3 < tiledBackground.h) {
                byte by = dataInputStream.readByte();
                tiledBackground.axTile[n3] = new byte[by];
                dataInputStream.read(tiledBackground.axTile[n3]);
                ++n3;
            }
            dataInputStream.close();
            tid = s;
            tiledBackground.loadTilePixel(tid);
            tiledBackground.loadTileMask(tiledBackground.changeIndex(n));
            tiledBackground.changeDistantData(n);
            tiledBackground.setFastMode(240, 320 - n2);
            tiledBackground._openBlack = false;
        }
        catch (Exception exception) {
            System.out.println("Exception: load map file error " + exception);
            return null;
        }
        return tiledBackground;
    }

    public static void loadDistantData() {
        curDistantIndex = (byte)-1;
        GameDB gameDB = GameDB.getGameDataBase();
        int n = gameDB.getDataNum(0);
        distantIndex = new int[n];
        mendiumIndex = new int[n][];
        mendiumData = new int[n][];
        int n2 = 0;
        while (n2 < n) {
            DataTable dataTable = gameDB.getData(0, n2);
            TiledBackground.distantIndex[n2] = dataTable.getIntItem(1);
            TiledBackground.mendiumIndex[n2] = dataTable.getArrayItem(2);
            TiledBackground.mendiumData[n2] = dataTable.getArrayItem(3);
            ++n2;
        }
    }

    public void changeDistantData(int n) {
        if (n == curDistantIndex) {
            return;
        }
        curDistantIndex = (byte)n;
        distantView = null;
        mediumView = null;
        try {
            distantView = Image.createImage((String)("/res/b" + distantIndex[curDistantIndex] + ".png"));
            int n2 = mendiumIndex[curDistantIndex].length;
            mediumView = new Image[n2];
            int n3 = 0;
            while (n3 < n2) {
                if (mendiumIndex[curDistantIndex][n3] >= 0) {
                    TiledBackground.mediumView[n3] = Image.createImage((String)("/res/z" + mendiumIndex[curDistantIndex][n3] + ".png"));
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setMapPosition(int n, int n2) {
        this.mapx = n;
        this.mapy = n2;
    }

    public void bombAt(int n, int n2, int n3) {
        this.maskFore(n - 32, n2 - 32, bombMask[n3], 64, 64);
    }

    protected void maskFore(int n, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n % this.tw;
        int n6 = n2 % this.th;
        int n7 = n - n5;
        int n8 = n2 - n6;
        int n9 = -1;
        int n10 = -1;
        int n11 = Math.max(n7, 0);
        int n12 = Math.min(n + n3, this.w * this.tw);
        int n13 = Math.max(n8, 0);
        int n14 = Math.min(n2 + n4, this.h * this.th);
        int n15 = n13;
        while (n15 < n14) {
            int n16 = n11;
            while (n16 < n12) {
                block18: {
                    int n17;
                    block17: {
                        int n18 = 0;
                        n17 = 0;
                        try {
                            n18 = this.getTileIndex(n16 / this.tw, n15 / this.th, tileIdMaskId);
                            if (n18 >= solidTiles) break block17;
                            break block18;
                        }
                        catch (Exception exception) {
                            System.out.println("Get Tile Error: " + exception);
                        }
                    }
                    try {
                        this.resetForeTileIndex(n16 / this.tw % foreW, n15 / this.th % foreH);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    try {
                        int n19 = n15;
                        int n20 = n16;
                        byte[] byArray2 = this.getTileMask(n16 / this.tw, n15 / this.th);
                        int n21 = 0;
                        while (n21 < byArray2.length) {
                            if (n19 >= n2) {
                                if (n19 < n14) {
                                    n17 = (n19 - n8 - n6) * 8;
                                    n17 += (n20 - n7) / 8;
                                    if (n20 >= n) {
                                        n17 = n20 <= n12 - this.tw ? (n17 -= n5 / 8) : (n17 -= n5 / 8);
                                    }
                                    n9 = 0;
                                    n10 = -1;
                                    int n22 = 0;
                                    while (n22 < 4) {
                                        n9 <<= 8;
                                        n9 = n17 + n22 < byArray.length ? (n9 |= byArray[n17 + n22] & 0xFF) : (n9 |= 0xFF);
                                        ++n22;
                                    }
                                    if (n20 < n) {
                                        n9 >>>= n5;
                                        n9 |= (n10 <<= this.tw - n5);
                                    } else if (n20 > n12 - this.tw) {
                                        n10 <<= n5;
                                        n9 |= (n10 >>>= n5);
                                    }
                                    int n23 = 0;
                                    while (n23 < 4) {
                                        int n24 = n21 + n23;
                                        byArray2[n24] = (byte)(byArray2[n24] & (n9 >>> (3 - n23) * 8 & 0xFF));
                                        ++n23;
                                    }
                                }
                                break;
                            }
                            n21 += 4;
                            ++n19;
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Set Mask Error: " + exception);
                    }
                }
                n16 += this.tw;
            }
            n15 += this.th;
        }
    }

    public void operateBlackScreen(boolean bl) {
        this._openBlack = bl;
    }

    private void drawBlackScreen(Graphics graphics) {
        if (this._openBlack) {
            Function.fillScreen(graphics, 0, 0, 240, 320, 0);
        }
    }

    protected int getTileIndex(int n, int n2, int[] nArray) {
        try {
            if (n2 < 0 || n2 > this.h || n < 0 || n > this.w || this.axTile[n2][0] == 0) {
                return -1;
            }
            int n3 = 1;
            int n4 = 0;
            while (n4 < n) {
                if (this.axTile[n2][n3] < 0) {
                    n4 += -this.axTile[n2][n3];
                    ++n3;
                    continue;
                }
                ++n4;
                n3 += 2;
            }
            if (n4 > n || this.axTile[n2][n3] < 0) {
                return -1;
            }
            nArray[0] = this.axTile[n2][n3];
            nArray[1] = this.axTile[n2][n3 + 1];
            if (nArray[1] < 0) {
                nArray[1] = nArray[1] + 256;
            }
            return this.axTile[n2][n3];
        }
        catch (Exception exception) {
            System.out.println("Get Index err " + exception);
            return -1;
        }
    }

    protected int getFreeTilePixel() {
        int n = 0;
        while (n < 32) {
            if (activeTile[n] == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected byte[] getTileMask(int n) {
        return this.tileMask[n];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] getTileMask(int n, int n2) {
        int n3 = 1;
        int n4 = 0;
        try {
            if (n2 < 0 || n2 > this.h || n < 0 || n > this.w || this.axTile[n2][0] == 0) {
                return null;
            }
            while (true) {
                if (n4 >= n) {
                    if (n4 <= n && this.axTile[n2][n3] >= 0) break;
                    return null;
                }
                if (this.axTile[n2][n3] < 0) {
                    n4 += -this.axTile[n2][n3];
                    ++n3;
                    continue;
                }
                ++n4;
                n3 += 2;
            }
            int n5 = this.axTile[n2][n3 + 1];
            if (n5 < 0) {
                n5 += 256;
            }
            return this.tileMask[n5];
        }
        catch (Exception exception) {
            System.out.println("Get Mask error " + exception);
            return null;
        }
    }

    public byte[] getPhys(int n, int n2) {
        if (n < 0 || n >= this.tw * this.w || n2 < 0 || n2 >= this.th * this.h) {
            return null;
        }
        return this.getTileMask(n / this.tw, n2 / this.th);
    }

    public int getSolidGround(byte[] byArray, int n, int n2) {
        int n3 = -1;
        int n4 = n % this.tw;
        int n5 = n2 % this.th;
        int n6 = n5 * this.tw / 8;
        int n7 = n4 / 8;
        int n8 = n4 % 8;
        int n9 = 0;
        while (n9 < 8 && n5 + n9 < this.th) {
            byte by = byArray[n6 + this.tw / 8 * n9 + n7];
            if (((by = (byte)(by << n8)) & 0x80) != 0) {
                n3 = n2 / this.th * this.th + n5 + n9;
                return n3;
            }
            ++n9;
        }
        return n3;
    }

    public int getWidth() {
        return this.tw * this.w;
    }

    public int getHeight() {
        return this.th * this.h;
    }

    public int getTileWidth() {
        return this.tw;
    }

    public int getTileHeigth() {
        return this.th;
    }

    private int changeIndex(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
        }
        return n;
    }

    static {
        int n = 0;
        while (n < activeTilePixel.length) {
            TiledBackground.activeTilePixel[n] = new short[1024];
            ++n;
        }
        buffer = new short[1024];
        tileIdMaskId = new int[2];
        bombMask = new byte[4][];
        curDistantIndex = (byte)-1;
    }
}

