/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class OMScreen
implements Runnable {
    protected static final int MILLIS_PER_TICK = 50;
    static final short IMAGE_R_BG = 1;
    static final short IMAGE_R_PALM = 2;
    static final short IMAGE_R_WINDOWS = 3;
    static final short IMAGE_D_MONETS = 20;
    static final short IMAGE_D_STORAGESRC = 21;
    static final short IMAGE_D_GRADIENT = 24;
    static final short IMAGE_D_MESHKI = 25;
    static final short IMAGE_D_SAFESRC = 26;
    static final short IMAGE_D_STOIKA = 27;
    static final short IMAGE_D_BALKON = 28;
    static final short IMAGE_D_SERVER = 29;
    static final short IMAGE_D_PCSCR = 30;
    static final short IMAGE_D_PC = 31;
    static final short IMAGE_D_MONEY = 32;
    static final short IMAGE_D_SERV1 = 33;
    static final short IMAGE_D_SERV2 = 34;
    static final short IMAGE_D_SAFE = 35;
    static final short IMAGE_D_STORAGE = 36;
    static final short IMAGE_D_BG = 37;
    static final short IMAGE_E_BG = 40;
    static final short IMAGE_E_VASE = 41;
    static final short IMAGE_E_SOFA = 42;
    static final short IMAGE_E_BAR = 43;
    static final short IMAGE_E_TABLE = 44;
    static final short IMAGE_E_STATUE = 45;
    static final short IMAGE_KLERK = 70;
    static final short IMAGE_POLICE = 71;
    static final short IMAGE_BOSS = 72;
    static final short IMAGE_HEAD_K = 100;
    static final short IMAGE_HEAD_B = 101;
    static final short IMAGE_MENUTOP = 102;
    static final short IMAGE_SPLASH = 103;
    static final short IMAGE_FINAL = 104;
    static final short IMAGE_SHOTGUN = 105;
    static final short NUM_IDI = 200;
    public static final short DEFEAT_SOUND = 1;
    public static final short RELOAD_SOUND = 2;
    public static final short FIRE_SOUND = 3;
    public static final short WIN_SOUND = 4;
    public static final short CRASH_SOUND = 5;
    public static final short ENEMY_APPEAR = 1;
    public static final short ENEMY_WAIT = 2;
    public static final short ENEMY_FIRE1 = 3;
    public static final short ENEMY_FIRE2 = 4;
    public static final short ENEMY_DEATH = 5;
    public static final short SHOOTGUN_IDLE = 0;
    public static final short SHOOTGUN_RELOAD = 1;
    public static final short SHOOTGUN_SHOOT1 = 2;
    public static final short SHOOTGUN_SHOOT2 = 3;
    public static final short LAYER_BACKGROUND = 0;
    public static final short LAYER_BEHIND_ENEMIES = 1;
    public static final short LAYER_TOPMOST = 2;
    public static final short ANIMATION_IDLE = 0;
    public static final short ANIMATION_PLAY = 1;
    public static final short ANIMATION_ENDS = 2;
    public static final short GAME_STATE_SPLASH = 0;
    public static final short GAME_STATE_ACTION = 1;
    public static final short GAME_STATE_WIN = 2;
    public static final short GAME_STATE_LOSE = 3;
    public static final short COMBO_NONE = 0;
    public static final short COMBO_SIMPLE = 1;
    public static final short COMBO_SUPER = 2;
    public static final short COMBO_MEGA = 3;
    public static final short ENEMY_SIMPLE = 0;
    public static final short ENEMY_BOSS1 = 1;
    public static final short ENEMY_BOSS2 = 2;
    public static final short WINDOWS_COUNT = 6;
    public static final short SPLASH_START = 0;
    public static final short SPLASH_LEVEL = 1;
    public static final short SPLASH_FINAL = 2;
    public static final short SCREEN_MENU = 0;
    public static final short SCREEN_SPLASH = 1;
    public static final short SCREEN_GAME = 2;
    public static final short SCREEN_STAT = 3;
    public static final short SCREEN_HOF = 4;
    public static final short SCREEN_HELP = 5;
    public static final short KEY_NUM0 = 48;
    public static final short KEY_NUM1 = 49;
    public static final short KEY_NUM2 = 50;
    public static final short KEY_NUM3 = 51;
    public static final short KEY_NUM4 = 52;
    public static final short KEY_NUM5 = 53;
    public static final short KEY_NUM6 = 54;
    public static final short KEY_NUM7 = 55;
    public static final short KEY_NUM8 = 56;
    public static final short KEY_NUM9 = 57;
    public static final short KEY_SOFTKEY1 = -6;
    public static final short KEY_SOFTKEY2 = -7;
    public static final short KEY_SOFTKEY3 = -5;
    public static final int FACE_SYSTEM = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_PLAIN = 0;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_SMALL = 8;
    public static final int VCENTER = 2;
    public static final int HCENTER = 1;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int BASELINE = 64;
    public static final int DOTTED = 1;
    public static final int SOLID = 0;
    public static final int FLIP_HORIZONTAL = 8192;
    static final short LABEL_ABOUT = 0;
    static final short LABEL_EXIT = 1;
    static final short LABEL_NEWGAME = 2;
    static final short LABEL_BACK = 3;
    static final short LABEL_CONTINUE = 4;
    static final short LABEL_GAMEOVER = 5;
    static final short STRING_WIN = 6;
    static final short STRING_CONTINUE1 = 7;
    static final short STRING_CONTINUE2 = 8;
    static final short LABEL_CHALLENGE = 9;
    static final short LABEL_SNDON = 10;
    static final short LABEL_SNDOFF = 11;
    static final short LABEL_DEMO = 12;
    static final short LABEL_PLOT = 13;
    static final short LABEL_CONTROL1 = 14;
    static final short LABEL_CONTROL2 = 15;
    static final short LABEL_FAME = 16;
    static final short LABEL_HELP = 17;
    static final short LABEL_DELETE = 18;
    static final short LABEL_OK = 19;
    static final short LABEL_PRESSANYKEY = 20;
    static final short LABEL_RIP = 21;
    static final short LABEL_COMPLETE = 22;
    static final short LABEL_KILLS = 23;
    static final short LABEL_DEVASTATION = 24;
    static final short LABEL_SCORE = 25;
    static final short LABEL_COMBO_SIMPLE = 26;
    static final short LABEL_COMBO_SUPER = 27;
    static final short LABEL_COMBO_MEGA = 28;
    static final short LABEL_MENU_EXIT = 29;
    static final short FINAL_SPLASH1 = 30;
    static final short FINAL_SPLASH2 = 31;
    static final short FINAL_SPLASH3 = 32;
    static final short FINAL_SPLASH4 = 33;
    static final short FINAL_SPLASH5 = 34;
    static final short FINAL_SPLASH6 = 35;
    static final short FINAL_SPLASH7 = 36;
    static final short FINAL_SPLASH8 = 37;
    static final short FINAL_SPLASH9 = 38;
    static final short FINAL_SPLASH10 = 39;
    static final short FINAL_SPLASH11 = 40;
    static final short FINAL_SPLASH12 = 41;
    static final short LABEL_GETREADY = 42;
    static final short LEVEL_NAME1 = 43;
    static final short LEVEL_NAME2 = 44;
    static final short LEVEL_NAME3 = 45;
    static final short LABEL_PLUS_100 = 46;
    static final short LABEL_PLUS_400 = 47;
    static final short LABEL_PLUS_1000 = 48;
    static final short LABEL_CLEAR = 49;
    static final short LABEL_PAUSED = 50;
    static final short HOF_NAME1 = 51;
    static final short HOF_SCORE1 = 52;
    static final short HOF_NAME2 = 53;
    static final short HOF_SCORE2 = 54;
    static final short HOF_NAME3 = 55;
    static final short HOF_SCORE3 = 56;
    static final short HOF_NAME4 = 57;
    static final short HOF_SCORE4 = 58;
    static final short HOF_NAME5 = 59;
    static final short HOF_SCORE5 = 60;
    static final short CHARS_KEY2 = 61;
    static final short CHARS_KEY3 = 62;
    static final short CHARS_KEY4 = 63;
    static final short CHARS_KEY5 = 64;
    static final short CHARS_KEY6 = 65;
    static final short CHARS_KEY7 = 66;
    static final short CHARS_KEY8 = 67;
    static final short CHARS_KEY9 = 68;
    static final short STRING_HELP1 = 69;
    static final short STRING_HELP2 = 70;
    static final short STRING_HELP3 = 71;
    static final short STRING_HELP4 = 72;
    static final short STRING_HELP5 = 73;
    static final short STRING_HELP6 = 74;
    static final short STRING_HELP7 = 75;
    static final short STRING_HELP8 = 76;
    static final short STRING_HELP9 = 77;
    static final short STRING_HELP10 = 78;
    static final short STRING_HELP11 = 79;
    static final short STRING_HELP12 = 80;
    static final short STRING_HELP13 = 81;
    static final short STRING_HELP14 = 82;
    static final short STRING_HELP15 = 83;
    static final short STRING_HELP16 = 84;
    static final short STRING_HELP17 = 85;
    static final short LABEL_GAMESPL1 = 86;
    static final short LABEL_GAMESPL2 = 87;
    static final short LABEL_GAMEKEY1 = 88;
    static final short LABEL_GAMEKEY2 = 89;
    static final short LABEL_GAMEKEY3 = 90;
    static final short LABEL_GAMEKEY4 = 91;
    static final short LABEL_OM = 92;
    static final short STRING_DEMO = 93;
    static final short STRING_LOADING = 94;
    static final short NUM_IDS = 95;
    protected int nTick = 200;
    protected OMCanvas canvas;
    protected volatile Thread animationThread;
    public Font fontDefault;
    public Font fontMenu;
    public Image[] images = new Image[200];
    protected long nTimeStart = 0L;
    int nDuration = 0;
    boolean bWaitKeyAfterPause = false;
    protected boolean bStop = false;
    protected boolean bRunning = false;
    protected Graphics g;
    OM om;
    int nScreenType;
    int[] nKeyboardQueue = new int[16];
    int nKeyboardQueueLength = 0;
    char[][] cs;

    OMScreen() {
    }

    OMScreen(OM oM, int n) {
        this.om = oM;
        this.nScreenType = n;
        this.fontDefault = Font.getFont((int)0, (int)1, (int)0);
        this.fontMenu = Font.getFont((int)0, (int)1, (int)8);
        this.cs = oM.cs;
    }

    public void loadImage(int n) {
        try {
            if (this.images[n] == null) {
                this.images[n] = Image.createImage((String)("/" + new String(this.itos(n)) + ".png"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onTick() {
    }

    public void onPaint() {
    }

    public void onLoadResources() {
    }

    public void onKeyPressed(int n) {
    }

    public void onStart() {
    }

    public final void run() {
        Thread thread = Thread.currentThread();
        boolean bl = false;
        while (thread == this.animationThread && !this.bStop) {
            if (!this.bRunning) continue;
            long l = System.currentTimeMillis();
            this.nDuration = (int)(OMScreen.getTime() - this.nTimeStart);
            if (this.canvas != null && this.canvas.isShown()) {
                this.canvas.paint();
                this.canvas.flushGraphics();
            }
            this.onTick();
            for (int i = 0; !this.bStop && i < this.nKeyboardQueueLength; ++i) {
                this.keyPressed(this.nKeyboardQueue[i]);
            }
            this.nKeyboardQueueLength = 0;
            long l2 = System.currentTimeMillis() - l;
            if (l2 < 50L) {
                try {
                    Thread.sleep(50L - l2);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Thread.yield();
        }
        if (this.bStop) {
            this.stopThread();
        }
    }

    public final void keyPressedQueue(int n) {
        if (this.nKeyboardQueueLength < 16) {
            this.nKeyboardQueue[this.nKeyboardQueueLength++] = n;
        }
    }

    public final void keyPressed(int n) {
        if (this.om.bPaused) {
            if (this.bWaitKeyAfterPause) {
                long l = OMScreen.getTime();
                this.nTimeStart = this.nTimeStart == 0L ? this.om.nPaused : (this.nTimeStart += l - this.om.nPaused);
                this.nDuration = (int)(l - this.nTimeStart);
                this.om.bPaused = false;
                this.om.nPaused = 0L;
            } else {
                this.onKeyPressed(n);
            }
        } else {
            this.onKeyPressed(n);
        }
    }

    public final void start() {
        this.onLoadResources();
        this.onStart();
        this.animationThread = new Thread(this);
        this.animationThread.start();
        boolean bl = this.bRunning = !this.om.bPaused;
        if (this.bRunning) {
            this.nTimeStart = OMScreen.getTime();
        }
    }

    public final void resumePause() {
        if (this.om.bPaused && !this.bWaitKeyAfterPause) {
            long l = OMScreen.getTime();
            this.nTimeStart = this.nTimeStart == 0L ? this.om.nPaused : (this.nTimeStart += l - this.om.nPaused);
            this.nDuration = (int)(l - this.nTimeStart);
            this.om.bPaused = false;
            this.om.nPaused = 0L;
        }
        this.bRunning = true;
    }

    final void pause() {
        if (this.om.nPaused == 0L) {
            this.om.nPaused = OMScreen.getTime();
        }
        this.om.bPaused = true;
        this.bRunning = false;
    }

    public final void stop() {
        this.bStop = true;
    }

    public final void stopThread() {
        this.bRunning = false;
        this.canvas = null;
        Thread.yield();
        this.animationThread = null;
        for (int i = 0; i < this.images.length; ++i) {
            this.images[i] = null;
        }
    }

    public void setCanvas(OMCanvas oMCanvas) {
        this.canvas = oMCanvas;
    }

    public void paint(Graphics graphics) {
        if (graphics != null) {
            this.g = graphics;
        }
        if (this.bRunning) {
            this.onPaint();
        }
    }

    public void setStrokeStyle(int n) {
        this.g.setStrokeStyle(n);
    }

    public void setColor(int n) {
        this.g.setColor(n);
    }

    public void setColor(int n, int n2, int n3) {
        this.g.setColor(n, n2, n3);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n, n2, n3, n4);
    }

    public int getImageWidth(int n) {
        return this.images[n].getWidth();
    }

    public int getImageHeight(int n) {
        return this.images[n].getHeight();
    }

    public void setDefaultFont() {
        this.g.setFont(this.fontDefault);
    }

    public void setMenuFont() {
        this.g.setFont(this.fontMenu);
    }

    public int getMenuFontHeight() {
        return this.fontMenu.getHeight();
    }

    public void drawString(int n, int n2, int n3, int n4) {
        if (n >= 69 && n <= 85) {
            if (n == 69) {
                this.g.drawString("Press the number keys on ", n2, n3, n4);
            } else if (n == 70) {
                this.g.drawString("to shot different zones of the ", n2, n3, n4);
                this.g.drawString("screen / bank. ", n2, n3 + 13, n4);
            } else if (n == 71) {
                this.g.drawString("within the office areas , and ", n2, n3 + 12, n4);
            } else if (n == 72) {
                this.g.drawString("   Dont forget to reload  ", n2, n3 + 12, n4);
            } else if (n == 73) {
                this.g.drawString(" when your gun is empty. ", n2, n3 + 12, n4);
            } else if (n == 74) {
                this.g.drawString("Kill 6 Zombies with 6 shots ,", n2, n3, n4);
            } else if (n == 75) {
                this.g.drawString("     and damage the building  ", n2, n3, n4);
            } else if (n == 76) {
                this.g.drawString("as well without reloading and ", n2 - 2, n3, n4);
            } else if (n == 77) {
                this.g.drawString("    gain extra COMBO points!   ", n2 - 1, n3, n4);
            } else if (n == 78) {
                this.g.drawString(" Do this in succession ,  ", n2, n3, n4);
            } else if (n == 79) {
                this.g.drawString("without getting hit and", n2 - 2, n3, n4);
            } else if (n == 80) {
                this.g.drawString(" gain SUPER COMBO ,and MEGA ", n2, n3, n4);
                this.g.drawString("        COMBO points ! ", n2 + 3, n3 + 15, n4);
            } else if (n == 81) {
                this.g.drawString("Kill a certain number of ", n2, n3, n4);
            } else if (n == 82) {
                this.g.drawString("Zombies per level to progress   ", n2, n3, n4);
            } else if (n == 83) {
                this.g.drawString("to the next floor of the bank,", n2 - 2, n3, n4);
            } else if (n == 84) {
                this.g.drawString("looking for the source of the ", n2, n3, n4);
            } else if (n == 85) {
                this.g.drawString("     Virus , and try to also ", n2, n3, n4);
                this.g.drawString("  score as many points as  ", n2 - 4, n3 + 14, n4);
                this.g.drawString("      you can in the chellenge ", n2 - 2, n3 + 29, n4);
                this.g.drawString("                mode also !  ", n2 + 2, n3 + 44, n4);
            }
        } else {
            this.g.drawString(new String(this.cs[n]), n2, n3, n4);
        }
    }

    public void drawString(String string, int n, int n2, int n3) {
        this.g.drawString(string, n, n2, n3);
    }

    public void drawString(char[] cArray, int n, int n2, int n3) {
        this.g.drawString(new String(cArray), n, n2, n3);
    }

    public int getFontHeight() {
        return this.fontDefault.getHeight();
    }

    public int getStringWidth(int n) {
        return this.fontDefault.stringWidth(new String(this.cs[n]));
    }

    public int getStringWidth(String string) {
        return this.fontDefault.stringWidth(string);
    }

    public int getMenuStringWidth(String string) {
        return this.fontMenu.stringWidth(string);
    }

    public static long getTime() {
        return System.currentTimeMillis();
    }

    public void drawTile(Tile tile, int n, int n2) {
        this.g.drawRegion(this.images[tile.nResIdx], tile.x, tile.y, tile.w, tile.h, 0, tile.shiftX + n, tile.shiftY + n2, 20);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.g.drawLine(n, n2, n3, n4);
    }

    public int getCanvasWidth() {
        return this.canvas.getWidth();
    }

    public int getCanvasHeight() {
        return this.canvas.getHeight();
    }

    public int stoi(char[] cArray) {
        return Integer.valueOf(new String(cArray));
    }

    public int stoi(String string) {
        return Integer.valueOf(string);
    }

    public char[] itos(int n) {
        String string = String.valueOf(n);
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        return cArray;
    }

    public char[] concat(char[] cArray, char[] cArray2) {
        int n;
        char[] cArray3 = new char[cArray.length + cArray2.length];
        for (n = 0; n < cArray.length; ++n) {
            cArray3[n] = cArray[n];
        }
        for (n = 0; n < cArray2.length; ++n) {
            cArray3[n + cArray.length] = cArray2[n];
        }
        return cArray3;
    }

    public char[] concat(char[] cArray, char c) {
        char[] cArray2 = new char[cArray.length + 1];
        for (int i = 0; i < cArray.length; ++i) {
            cArray2[i] = cArray[i];
        }
        cArray2[cArray.length] = c;
        return cArray2;
    }
}

