/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;

public class OMLevelLoader {
    int[][] staticPositionsX = new int[2][];
    int[][] staticPositionsY = new int[2][];
    Tile[][] staticTiles = new Tile[2][];
    Animation[] animations = null;
    int nEnemiesToKill;
    int nNominalEnemyFrequency;
    boolean bWithBoss;
    char[][] text;
    int name;
    Enemy[] enemies;
    OM om;
    protected int[] nRequiredImages = null;
    protected int[][] nEnemyAllow;

    OMLevelLoader(OM oM, String string) {
        this.om = oM;
        try {
            this.LoadEnemies(((Object)((Object)oM)).getClass().getResourceAsStream("enemies.dat"));
            this.Load(((Object)((Object)oM)).getClass().getResourceAsStream(string));
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    boolean isLevelPassed(int n) {
        return n >= this.nEnemiesToKill;
    }

    void init() {
        int n;
        for (n = 0; n < this.animations.length; ++n) {
            if (this.animations[n] == null) continue;
            this.animations[n].nInitiatedMoment = 0;
            this.animations[n].nState = 0;
        }
        for (n = 0; n < this.nEnemyAllow.length; ++n) {
            this.enemies[n].allowWindows(this.nEnemyAllow[n]);
        }
    }

    public int[] getRequiredImages() {
        return this.nRequiredImages;
    }

    public int loadShort(InputStream inputStream) throws Exception {
        int n = inputStream.read();
        return n >= 128 ? (n - 128) * 256 + inputStream.read() : n;
    }

    public char[] loadString(InputStream inputStream) throws Exception {
        char[] cArray = new char[this.loadShort(inputStream)];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)inputStream.read();
        }
        return cArray;
    }

    public int[] readArray(InputStream inputStream, int n) throws Exception {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.om.loadShort(inputStream);
        }
        return nArray;
    }

    public void Load(InputStream inputStream) throws Exception {
        int n;
        int n2 = this.om.loadShort(inputStream);
        this.animations = new Animation[n2];
        for (n = 0; n < n2; ++n) {
            int n3 = this.om.loadShort(inputStream);
            int n4 = this.om.loadShort(inputStream);
            int n5 = this.om.loadShort(inputStream);
            Animation animation = new Animation(n3, n4, n5);
            animation.tiles = new Tile[this.om.loadShort(inputStream)][];
            for (int i = 0; i < animation.tiles.length; ++i) {
                animation.tiles[i] = new Tile[this.om.loadShort(inputStream)];
                for (int j = 0; j < animation.tiles[i].length; ++j) {
                    animation.tiles[i][j] = new Tile(this.readArray(inputStream, Tile.getByteArraySize()));
                }
            }
            this.animations[n] = animation;
        }
        n2 = this.om.loadShort(inputStream);
        this.staticPositionsX[0] = new int[n2];
        this.staticPositionsY[0] = new int[n2];
        this.staticTiles[0] = new Tile[n2];
        for (n = 0; n < n2; ++n) {
            this.staticTiles[0][n] = new Tile(this.readArray(inputStream, Tile.getByteArraySize()));
            this.staticPositionsX[0][n] = this.loadShort(inputStream);
            this.staticPositionsY[0][n] = this.loadShort(inputStream);
        }
        n2 = this.loadShort(inputStream);
        this.staticPositionsX[1] = new int[n2];
        this.staticPositionsY[1] = new int[n2];
        this.staticTiles[1] = new Tile[n2];
        for (n = 0; n < n2; ++n) {
            this.staticTiles[1][n] = new Tile(this.readArray(inputStream, Tile.getByteArraySize()));
            this.staticPositionsX[1][n] = this.loadShort(inputStream);
            this.staticPositionsY[1][n] = this.loadShort(inputStream);
        }
        n2 = this.loadShort(inputStream);
        this.nRequiredImages = this.readArray(inputStream, n2);
        n2 = this.loadShort(inputStream);
        this.nEnemyAllow = new int[n2][];
        for (n = 0; n < n2; ++n) {
            this.nEnemyAllow[n] = this.readArray(inputStream, 24);
        }
        this.nEnemiesToKill = this.loadShort(inputStream);
        this.nNominalEnemyFrequency = this.loadShort(inputStream);
        this.bWithBoss = this.loadShort(inputStream) == 1;
        this.name = this.loadShort(inputStream);
        this.text = new char[this.loadShort(inputStream)][];
        for (n = 0; n < this.text.length; ++n) {
            this.text[n] = this.loadString(inputStream);
        }
        inputStream.close();
    }

    protected void LoadEnemies(InputStream inputStream) throws Exception {
        int n = this.loadShort(inputStream);
        this.enemies = new Enemy[n];
        for (int i = 0; i < this.enemies.length; ++i) {
            int n2;
            int n3 = this.loadShort(inputStream);
            int n4 = this.loadShort(inputStream);
            int n5 = this.loadShort(inputStream);
            this.enemies[i] = new Enemy(n3, n4, n5);
            this.enemies[i].tiles = new Tile[4][];
            this.enemies[i].tiles[0] = new Tile[this.loadShort(inputStream)];
            for (n2 = 0; n2 < this.enemies[i].tiles[0].length; ++n2) {
                this.enemies[i].tiles[0][n2] = new Tile(this.readArray(inputStream, Tile.getByteArraySize()));
            }
            this.enemies[i].tiles[1] = new Tile[this.loadShort(inputStream)];
            for (n2 = 0; n2 < this.enemies[i].tiles[1].length; ++n2) {
                this.enemies[i].tiles[1][n2] = new Tile(this.readArray(inputStream, Tile.getByteArraySize()));
            }
            this.enemies[i].tiles[2] = new Tile[this.loadShort(inputStream)];
            for (n2 = 0; n2 < this.enemies[i].tiles[2].length; ++n2) {
                this.enemies[i].tiles[2][n2] = new Tile(this.readArray(inputStream, Tile.getByteArraySize()));
            }
            this.enemies[i].tiles[3] = new Tile[this.loadShort(inputStream)];
            for (n2 = 0; n2 < this.enemies[i].tiles[3].length; ++n2) {
                this.enemies[i].tiles[3][n2] = new Tile(this.readArray(inputStream, Tile.getByteArraySize()));
            }
        }
        inputStream.close();
    }
}

