/*
 * Decompiled with CFR 0.152.
 */
package draw;

import Actor.Bldg;
import Actor.GameObj;
import Actor.Player;
import Actor.Prop;
import Actor.Skill;
import KScript.INativeAPI;
import KScript.KScriptObjectX;
import basic.BasicCanvas;
import basic.BeginMidlet;
import basic.Draw;
import basic.KFile;
import basic.KSpriteX;
import basic.KUtils;
import basic.Resource;
import draw.DialogueDraw;
import draw.MenuDraw;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GameMainDraw
extends Draw
implements INativeAPI {
    public static final byte COMPARE_OBJ = 0;
    public static byte MOVE_MAX_SPEED = (byte)100;
    public static final byte CAMERA_FOCUS_OBJ = 2;
    public static final byte CAMERA_FOCUS_MAP = 1;
    public static final byte CAMERA_NULL = 0;
    private static byte cameraFocusStateNow;
    private static short cameraTargetMapX;
    private static short cameraTargetMapY;
    private static GameObj cameraObj;
    public static KScriptObjectX cameraWaitKsox;
    public static GameObj[] npcArray;
    public static Player player;
    private static Vector boxVector;
    public static Vector enemyVector;
    private static Vector skillVector;
    private static Vector arrowVector;
    private static Vector elementVector;
    public static Vector goodsVector;
    public static final byte STATE_NULL = 0;
    public static final byte STATE_PLAYER_CONTROL = 1;
    public static final byte STATE_PLAYER_MOVE = 2;
    public static byte stateNow;
    public static KScriptObjectX tempKsox;
    public static KScriptObjectX mapKsox;
    public static boolean playerControlAble;
    public static boolean playerCanAttack;
    public static boolean isTeach;
    public static KScriptObjectX teachKsox;
    public static byte teachState;
    public static final byte DIR_U = 0;
    public static final byte DIR_D = 1;
    public static final byte DIR_L = 2;
    public static final byte DIR_R = 3;
    private static short[] titleSide;
    static short cameraX;
    static short cameraY;
    static short cameraWidth;
    static short cameraHeight;
    static short canMoveX;
    static short canMoveY;
    static short canMoveWidth;
    static short canMoveHeight;
    public static byte levels;
    public static byte[] activateLevels;
    public static byte levelsMax;
    public static byte playerID;
    public static short AngleMax;
    public static short AngleMin;
    public static short VigorMax;
    public static boolean isDrawAnger;
    public static short angerMax;
    public static short anger;
    public static boolean isAnger;
    public static byte angerNum;
    public static Bldg house;
    public static final byte BOUT_PLAYER = 1;
    public static final byte BOUT_ENEMY = 2;
    public static final byte BOUT_END = 3;
    public static final byte BOUT_WIN = 4;
    public static final byte BOUT_OVER = 5;
    public static final byte BOUT_ADDENEMY = 6;
    public static final byte BOUT_REVIVE = 7;
    public static byte tempBoutState;
    public static byte boutStartDefer;
    public static byte boutState;
    public static byte boutNow;
    public static short enemyMax;
    public static short enemyMin;
    public static short killEnemyNum;
    public static short houseHP;
    public static short houseMAX;
    public static byte[][] star;
    public static short countdown;
    public static boolean isVigorOut;
    public static boolean beginVigor;
    public static String[] enemySay;
    public static String[] playerSay;
    static KScriptObjectX boutKsox;
    static KSpriteX nu;
    public static boolean isDrop;
    public static byte dropOdds;
    public static short[] dropPhysicOdds;
    public static short dropPhysicNum;
    public static short hitBasicScore;
    public static short enemyScore;
    public static short hitScore;
    public static short hpScore;
    public static short score;
    boolean isDrawZi;
    byte ziState;
    short zispeed;
    short ziX;
    short ziY;
    int enemyBulletCount;
    public static boolean isCanKeyKill;
    public static boolean isCanKeyNum1;
    public static boolean tempCanKill;
    static Vector teachKey;
    boolean[] isHitKey;
    public static Vector v_cue;
    public static byte cueTime;
    public static Skill skill;
    public static GameObj touchObj;
    public static short npcId;
    public static final byte MOVE_MIN_X = 1;
    public static final byte MOVE_MIN_Y = 1;
    public static boolean showMapEnemy;
    public static boolean showEnemy;
    public static boolean oldLoadEnemy;
    public static boolean isUpdateGameObj;
    public static final int TYPE_BG = 0;
    public static final int TYPE_ELEMENT = 1;
    public static final int TYPE_ENEMY = 2;
    public static final int TYPE_GROUND = 3;
    public static final int TYPE_GROUND_SMASH = 4;
    public static final int TYPE_HOUSE = 5;
    public static final int TYPE_ARROW = 6;
    public static short[] enemyId;
    public static short[] initEnemySiteX;
    public static short[] initEnemySiteY;
    public static String missionName;
    public static String missionInfo;
    static Vector imgList;
    public static int count;
    public static final byte TREMOR_UD = 1;
    public static final byte TREMOR_LR = 2;
    public static final byte TREMOR_UDLR = 3;
    public static final byte TREMOR_UR = 4;
    private static byte tremor;
    public static byte tremorNum;
    public static int tremorCount;
    public static boolean enemyIsRun;
    public static boolean enemyAI;
    public static short judgeEnmeyId;
    public static short judgeEnmeyNum;
    public static short guardBout;
    private Vector deadEnemy = new Vector();
    public boolean isRevival;
    static Vector v_effect;
    Vector enemySite = new Vector();
    public static final byte LOAD = 1;
    public static final byte READ = 2;
    public byte loadState;
    public static boolean isLoadEnd;
    static KSpriteX spx_loading;
    public static boolean isDrawSun;
    boolean isDrawCrit;
    static Player nonceEnemy;
    static byte nonceShowTime;
    int mapColor;
    public static boolean isDrawNoMap;
    public static byte[][] smallDate;
    short hitNum;
    static short hitMaxNum;
    byte hitShowTime = (byte)50;
    public static short[][] shorcutSite;
    static String[] shorcutzi;
    static Prop[] shorcut_prop;
    static Vector state_prop;
    short cueW;
    short cueH;
    public static boolean isBlackClose;
    public static boolean isDrawBlack;
    public static short blackH;
    public static short blackS;
    public static short BORDERH;
    public static boolean isDrawHP;
    public static boolean isFlash;
    public static int flashTime;
    public static int flashColor;
    public static KFile file;
    public static final byte rmsIndex = 1;
    public static final String rmsName = "ddt1";
    public static final String noteRms = "ddtnote1";
    public static String mapIniName;
    public static String mapName;
    public static short nameW;
    public static short nameH;
    public static byte nameTime;
    public static boolean isDrawName;
    public static byte[] label;
    public static byte[] savelabel;
    public static String path;
    public static short mapWidth;
    public static short mapHeight;
    private static final int ID_OBJECT = 1112490570;
    private static final int VERSION_OBJECT = 1;
    public static final int eachTileWidth = 16;
    public static final int eachTileHeight = 16;
    protected static int columns;
    protected static int rows;
    public static int viewX;
    public static int viewY;
    public static int viewWidth;
    public static int viewHeight;
    boolean isOpen;
    InputStream is = null;
    public static boolean isDrawPiaoYeZi;
    public static KSpriteX spx_yezi;
    public static byte[] yeziAct;
    public static short[] yeziX;
    public static short[] yeziY;
    public static byte[] yeziSpeed;
    public static byte[] yeziShow;
    public static byte[] yeziTime;
    public static byte yezinum;
    private static boolean isDrawStar;
    public static short[][] starPos;
    public static byte[] starSpeed;
    public static short[] starIndex;
    public static final int STARNUM = 80;
    public static byte speedOfScroll;
    public static final byte RAIN_MID = 0;
    public static final byte RAIN_LEFT = 1;
    public static final byte RAIN_RIGHT = -1;
    public static byte rain_dir;
    public static Random rnd;
    static boolean isDrawDot;
    static byte[] dotShow;
    static KSpriteX[] spx_dot;
    static boolean isDrawYun;
    static short[] yunX;
    static short[] yunY;

    public GameMainDraw(int sw, int sh) {
        super(sw, sh);
        titleSide = new short[4];
    }

    public void setCameraToObj(GameObj obj, KScriptObjectX script, boolean scriptWait) {
        cameraObj = obj;
        GameMainDraw.setCameraFocusState(2);
        this.setKScriptWait(script, scriptWait);
    }

    private void setKScriptWait(KScriptObjectX script, boolean scriptWait) {
        if (scriptWait) {
            cameraWaitKsox = script;
            cameraWaitKsox.setWait(false);
        } else {
            cameraWaitKsox = null;
        }
    }

    public static void setState(int state) {
        stateNow = (byte)state;
    }

    public static void setCameraFocusState(int state) {
        cameraFocusStateNow = (byte)state;
    }

    public static void addElementNpc(GameObj obj) {
        obj.ownType = (byte)6;
        elementVector.addElement(obj);
        isUpdateGameObj = true;
    }

    public static GameObj getObj(int id, Vector vector) {
        int length = vector.size();
        for (int i = length - 1; i >= 0; --i) {
            GameObj npc = (GameObj)vector.elementAt(i);
            if (npc.ownId != id) continue;
            return npc;
        }
        return null;
    }

    public static void addBox(Bldg obj) {
        GameMainDraw.addImageList(obj.spriteX.imageIndex);
        boxVector.addElement(obj);
        isUpdateGameObj = true;
    }

    public static void addEnemy(Player obj) {
        GameMainDraw.addImageList(obj.spriteX.imageIndex);
        enemyVector.addElement(obj);
        isUpdateGameObj = true;
    }

    public static void addArrow(GameObj obj) {
        GameMainDraw.addImageList(obj.spriteX.imageIndex);
        arrowVector.addElement(obj);
    }

    public static void setPlayer(Player obj) {
        player = obj;
    }

    public static void setPlayerMapArray(int x, int y) {
        player.setSite(x * 16 + 8, (y + 1) * 16);
    }

    public static void resetNpcArray(boolean hasEnemy) {
        int i;
        int length = 1;
        int lengthA = 0;
        int lengthB = boxVector.size();
        int lengthC = enemyVector.size();
        if (!hasEnemy) {
            lengthC = 0;
        }
        int lengthE = 0;
        int lengthF = elementVector.size();
        int lengthG = goodsVector.size();
        npcArray = new GameObj[length + lengthA + lengthB + lengthC + lengthE + lengthF + lengthG];
        if (player != null) {
            GameMainDraw.npcArray[0] = player;
        }
        for (i = 0; i < lengthB; ++i) {
            GameMainDraw.npcArray[i + length + lengthA] = (GameObj)boxVector.elementAt(i);
        }
        for (i = 0; i < lengthC; ++i) {
            GameMainDraw.npcArray[i + length + lengthA + lengthB] = (GameObj)enemyVector.elementAt(i);
        }
        for (i = 0; i < lengthF; ++i) {
            GameMainDraw.npcArray[i + length + lengthA + lengthB + lengthC + lengthE] = (GameObj)elementVector.elementAt(i);
        }
        for (i = 0; i < lengthG; ++i) {
            GameMainDraw.npcArray[i + length + lengthA + lengthB + lengthC + lengthE + lengthF] = (GameObj)goodsVector.elementAt(i);
        }
    }

    public static boolean isOutScreen(GameObj obj) {
        if (obj == null || obj.spriteX == null) {
            return true;
        }
        short x = obj.siteX;
        short y = obj.siteY;
        int w = obj.spriteX.getFrameWidth();
        int h = obj.spriteX.getFrameHeight();
        return GameMainDraw.isOutScreen(x - (w >> 1), y - h, w, h);
    }

    public static boolean isOutScreen(int x, int y, int w, int h) {
        int srceenY;
        int srceenW = GameMainDraw.getViewWidth();
        int srceenH = GameMainDraw.getViewHeight();
        int srceenX = GameMainDraw.getViewX();
        return !KUtils.hit(x, y, w, h, srceenX, srceenY = GameMainDraw.getViewY(), srceenW, srceenH);
    }

    public static void setCanMoveSite(int x, int y, int w, int h) {
        canMoveX = (short)x;
        canMoveY = (short)y;
        canMoveWidth = (short)w;
        canMoveHeight = (short)h;
    }

    public void cameraMoveLogic() {
        int cameraTargetX = -1;
        int cameraTargetY = -1;
        if (cameraFocusStateNow == 2) {
            if (cameraObj == null) {
                return;
            }
            cameraTargetX = GameMainDraw.cameraObj.siteX - GameMainDraw.getViewWidth() / 2;
            cameraTargetY = GameMainDraw.cameraObj.siteY - GameMainDraw.getViewHeight() / 2;
        } else if (cameraFocusStateNow == 1) {
            cameraTargetX = cameraTargetMapX - GameMainDraw.getViewWidth() / 2;
            cameraTargetY = cameraTargetMapY - GameMainDraw.getViewHeight() / 2;
        }
        cameraTargetX = Math.min(cameraTargetX, cameraWidth - BasicCanvas.screenWidth);
        cameraTargetY = Math.min(cameraTargetY, cameraHeight - BasicCanvas.screenHeight);
        cameraTargetX = Math.max(cameraTargetX, cameraX);
        cameraTargetY = Math.max(cameraTargetY, cameraY);
        int cameraMoveSpeedX = Math.min(MOVE_MAX_SPEED, Math.abs(cameraTargetX - GameMainDraw.getViewX()) / 2);
        int cameraMoveSpeedY = Math.min(MOVE_MAX_SPEED, Math.abs(cameraTargetY - GameMainDraw.getViewY()) / 2);
        int tempMoveX = 0;
        int tempMoveY = 0;
        if (GameMainDraw.getViewY() < cameraTargetY) {
            tempMoveY = cameraMoveSpeedY <= 2 ? cameraTargetY - GameMainDraw.getViewY() : cameraMoveSpeedY;
        } else if (GameMainDraw.getViewY() > cameraTargetY) {
            int n = tempMoveY = cameraMoveSpeedY <= 2 ? cameraTargetY - GameMainDraw.getViewY() : -cameraMoveSpeedY;
        }
        if (GameMainDraw.getViewX() < cameraTargetX) {
            tempMoveX = cameraMoveSpeedX <= 2 ? cameraTargetX - GameMainDraw.getViewX() : cameraMoveSpeedX;
        } else if (GameMainDraw.getViewX() > cameraTargetX) {
            tempMoveX = cameraMoveSpeedX <= 2 ? cameraTargetX - GameMainDraw.getViewX() : -cameraMoveSpeedX;
        }
        this.moveView(tempMoveX, tempMoveY);
        if (GameMainDraw.getViewX() == cameraTargetX && GameMainDraw.getViewY() == cameraTargetY && cameraWaitKsox != null) {
            cameraWaitKsox.setWait(true);
            cameraWaitKsox = null;
        }
    }

    public static void toStand() {
        player.stand(false);
    }

    public static boolean isCanMove(int x, int y, int w, int h) {
        return GameMainDraw.isObjPass(1, x, y, w, h, boxVector);
    }

    public static boolean isObjPass(int dir, int x, int y, int w, int h, Vector objs) {
        int length = objs.size();
        GameObj nNpc = null;
        short[] tempSite = new short[4];
        short temp = 0;
        for (int i = length - 1; i >= 0; --i) {
            short[] coll;
            nNpc = (GameObj)objs.elementAt(i);
            if (!nNpc.isAlive || nNpc.isLayout && nNpc.layout == 0) continue;
            if (nNpc.ownType == 5) {
                Player enemy = (Player)nNpc;
                if (enemy.deadState != 0 || enemy.stateNow == 5 || enemy.stateNow == 6 || enemy.isAir || !KUtils.hit(x, y, w, h, nNpc.siteX - nNpc.npcW / 2, nNpc.siteY - nNpc.npcH, nNpc.npcW, nNpc.npcH)) continue;
                tempSite[0] = (short)(nNpc.siteY - nNpc.npcH - 1);
                tempSite[1] = (short)(nNpc.siteY + 1);
                tempSite[2] = (short)(nNpc.siteX - nNpc.npcW / 2);
                tempSite[3] = (short)(nNpc.siteX + nNpc.npcW / 2);
                short dirSite = tempSite[dir ^ 1];
                if (temp != 0 && !(dir % 2 == 1 ? temp > dirSite : temp < dirSite)) continue;
                temp = dirSite;
                titleSide = tempSite;
                continue;
            }
            if (nNpc.ownType != 2) continue;
            int num = 0;
            while ((coll = nNpc.spriteX.getCollision(num)) != null) {
                if (KUtils.hit(nNpc.siteX + coll[0], nNpc.siteY + coll[1], coll[2], coll[3], x, y, w, h)) {
                    tempSite[0] = (short)(nNpc.siteY + coll[1]);
                    tempSite[1] = (short)(nNpc.siteY + coll[1] + coll[3]);
                    tempSite[2] = (short)(nNpc.siteX + coll[0]);
                    tempSite[3] = (short)(nNpc.siteX + coll[0] + coll[2]);
                    short dirSite = tempSite[dir ^ 1];
                    if (temp == 0 || (dir % 2 == 1 ? temp > dirSite : temp < dirSite)) {
                        temp = dirSite;
                        titleSide = tempSite;
                        tempSite = new short[4];
                    }
                }
                ++num;
            }
        }
        return temp == 0;
    }

    public static boolean isOutMap(int x, int y) {
        if (x < cameraX || x >= cameraWidth || y >= cameraHeight) {
            GameMainDraw.titleSide[0] = (short)(cameraHeight - 1);
            GameMainDraw.titleSide[1] = cameraY;
            GameMainDraw.titleSide[2] = cameraWidth;
            GameMainDraw.titleSide[3] = cameraX;
            return true;
        }
        return false;
    }

    public static boolean isCanMove(int x, int y) {
        if (x < cameraX || x >= cameraWidth || y < cameraY || y >= cameraHeight) {
            GameMainDraw.titleSide[0] = (short)(cameraHeight - 1);
            GameMainDraw.titleSide[1] = cameraY;
            GameMainDraw.titleSide[2] = cameraWidth;
            GameMainDraw.titleSide[3] = cameraX;
            return false;
        }
        if (canMoveWidth > 0 && canMoveHeight > 0 && (x < canMoveX || x >= canMoveWidth || y < canMoveY || y >= canMoveHeight)) {
            GameMainDraw.titleSide[0] = (short)(canMoveHeight - 1);
            GameMainDraw.titleSide[1] = canMoveY;
            GameMainDraw.titleSide[2] = canMoveWidth;
            GameMainDraw.titleSide[3] = canMoveX;
            return false;
        }
        return true;
    }

    public static boolean isCollisionNpc(GameObj player, GameObj obj) {
        return KUtils.hit(player.siteX - player.npcW / 2, player.siteY - player.npcH, player.npcW, player.npcH, obj.siteX - obj.npcW / 2, obj.siteY - obj.npcH, obj.npcW, obj.npcH);
    }

    public static void alterHouseHp(int h) {
        if ((houseHP = (short)(houseHP + h)) < 0) {
            houseHP = 0;
            GameMainDraw.house.stateNow = 1;
        } else if (houseHP > houseMAX) {
            houseHP = houseMAX;
        }
    }

    public static void activateLevels(int levels) {
        for (int i = 0; i < activateLevels.length; ++i) {
            GameMainDraw.activateLevels[i] = (byte)levels;
        }
    }

    public static void toLevels(int levels) {
        GameMainDraw.levels = (byte)levels;
        Resource.clearAllKScript();
        KScriptObjectX tempKsox = Resource.getKSOX("/gamess/selectLevels.s");
        tempKsox.runMethods("main");
    }

    public static void initGame(int hpMax, int emyMax) {
        boutState = (byte)3;
        boutNow = 0;
        killEnemyNum = 0;
        hitMaxNum = 0;
        enemyScore = 0;
        hitScore = 0;
        hpScore = 0;
        score = 0;
        anger = 0;
        GameMainDraw.player.oldVigor = 0;
        GameMainDraw.player.vigor = 0;
        GameMainDraw.player.angle = (short)45;
        enemyMax = (short)emyMax;
        houseHP = houseMAX = (short)hpMax;
        isVigorOut = false;
        beginVigor = false;
        judgeEnmeyId = (short)-1;
        judgeEnmeyNum = 0;
        guardBout = (short)-1;
        dropOdds = (byte)30;
        if (playerSay == null) {
            // empty if block
        }
        String[] num = Resource.getListDate(Prop.getPhysicDB(), 6);
        dropPhysicOdds = new short[num.length];
        for (int i = 0; i < num.length; ++i) {
            GameMainDraw.dropPhysicOdds[i] = (short)(Integer.parseInt(num[i]) + (i > 0 ? dropPhysicOdds[i - 1] : 0));
        }
        shorcut_prop = new Prop[4];
        state_prop.removeAllElements();
        player.clearAddState();
        Player.addHP = (short)Math.min(200, levels / 5 * 50);
        angerNum = 1;
        if (isAnger) {
            anger = angerMax;
        }
    }

    public void setBoutInfo(String name, String info) {
        missionName = name;
        missionInfo = info;
        BasicCanvas.toMenu();
        BasicCanvas.menuDraw.initGameInfo();
    }

    public void playerBoutStart() {
        boutState = 1;
        playerCanAttack = false;
        isVigorOut = false;
        beginVigor = false;
        GameMainDraw.player.oldVigor = GameMainDraw.player.vigor;
        GameMainDraw.player.vigor = 0;
        GameMainDraw.player.stateNow = (byte)7;
        GameMainDraw.player.actionCount = 0;
        countdown = (short)20;
        count = 0;
        this.hitNum = 0;
        hitScore = 0;
        dropPhysicNum = 0;
        GameMainDraw.player.rageBout = (byte)(GameMainDraw.player.rageBout - 1);
        if (GameMainDraw.player.rageBout <= 0) {
            player.clearRage();
        }
        this.setCameraToSite(GameMainDraw.player.siteX, GameMainDraw.player.siteY, false, null);
        this.initDrawZi();
        this.judgeAddState();
        if (v_effect != null) {
            int length = v_effect.size();
            for (int j = length - 1; j >= 0; --j) {
                GameObj spx = (GameObj)v_effect.elementAt(j);
                spx.aliveTime = (byte)(spx.aliveTime - 1);
                if (spx.aliveTime > 0) continue;
                v_effect.removeElementAt(j);
            }
        }
        boutNow = (byte)(boutNow + 1);
    }

    private void judgeAddState() {
        int size = state_prop.size();
        for (int i = size - 1; i >= 0; --i) {
            Prop prop = (Prop)state_prop.elementAt(i);
            prop.bout = (byte)(prop.bout - 1);
            if (prop.bout > 0) continue;
            this.clearAddState(prop);
            state_prop.removeElementAt(i);
        }
    }

    public void enemyBoutStart() {
        boutState = (byte)2;
        this.enemySite.removeAllElements();
        int size = enemyVector.size();
        short siteX = 0;
        for (int i = 0; i < size; ++i) {
            Player emy = (Player)enemyVector.elementAt(i);
            if (emy.deadState != 0) continue;
            emy.initBout();
            if (emy.dir == 0 && siteX > emy.siteX || siteX == 0) {
                siteX = emy.siteX;
                nonceEnemy = emy;
                continue;
            }
            if (emy.dir != 1 || siteX >= emy.siteX) continue;
            siteX = emy.siteX;
            nonceEnemy = emy;
        }
        player.stand(true);
        this.setCameraToObj(nonceEnemy, null, false);
    }

    public void initDrawZi() {
        this.ziState = 0;
        this.isDrawZi = true;
        this.zispeed = (short)(-BasicCanvas.screenWidth / 3);
        this.ziX = BasicCanvas.screenWidth;
        this.ziY = (short)(BasicCanvas.screenHeight / 2 - 50);
    }

    public void boutStart(int state) {
        if (tempBoutState != state) {
            boutState = (byte)3;
            tempBoutState = (byte)state;
            if (this.hitNum > hitMaxNum) {
                hitMaxNum = this.hitNum;
            }
            if (teachState == state && teachKsox != null) {
                teachKsox.setWait(true);
                teachKsox = null;
            }
            skill = null;
            if (tempBoutState == 1) {
                if (this.judgeWin()) {
                    GameMainDraw.GameWin();
                    tempBoutState = 0;
                } else {
                    boutStartDefer = (byte)10;
                }
            } else if (tempBoutState == 2) {
                if (this.judgeWin()) {
                    GameMainDraw.GameWin();
                    tempBoutState = 0;
                } else {
                    boutStartDefer = (byte)5;
                }
            }
        }
    }

    public void shootBullet(Player obj, int type) {
        obj.actionCount = (byte)(obj.actionCount + 1);
        Skill skill = new Skill(this, obj);
        if (obj.ownType == 3) {
            skill.init(type, obj.getAttackNum(), obj.getAngle(), obj.vigor, true);
        } else if (obj.ownType == 5) {
            if (obj.siteY < GameMainDraw.house.siteY - 20) {
                skill.init(type, GameMainDraw.house.siteX + 20 * KUtils.genRand(-3, 3), GameMainDraw.house.siteY - 20, true);
            } else {
                skill.init(type, GameMainDraw.house.siteX, GameMainDraw.house.siteY - 20, true);
            }
        }
        obj.setState(2);
        obj.setSkill(skill);
        if (skill.spx != null) {
            this.setCameraToObj(skill.spx[skill.spxNum / 2], null, false);
        }
        if (obj.ownType == 3) {
            GameMainDraw.skill = skill;
        }
    }

    public void playerControl() {
        if (houseHP <= 0) {
            return;
        }
        if (teachKey != null) {
            int length = teachKey.size();
            int hitNum = 0;
            boolean isHitTeach = BasicCanvas.anyKeyUp();
            for (int i = length - 1; i >= 0; --i) {
                int key = (Integer)teachKey.elementAt(i);
                if (BasicCanvas.pressKey(key)) {
                    isHitTeach = true;
                    if (this.isHitKey[i]) break;
                    this.isHitKey[i] = true;
                    break;
                }
                if (!this.isHitKey[i]) continue;
                hitNum = (byte)(hitNum + 1);
            }
            if (!isHitTeach) {
                return;
            }
        }
        if (boutState != 1 || GameMainDraw.player.stateNow == 2 || skill != null) {
            return;
        }
        if (!beginVigor) {
            if (BasicCanvas.hitKey(4)) {
                this.useShorcut(0);
                return;
            }
            if (BasicCanvas.hitKey(16)) {
                this.useShorcut(1);
                return;
            }
            if (BasicCanvas.hitKey(256)) {
                this.useShorcut(2);
                return;
            }
            if (BasicCanvas.hitKey(1024)) {
                this.useShorcut(3);
                return;
            }
            if (BasicCanvas.hitKey(2)) {
                if (isDrawAnger && anger >= angerMax) {
                    if (isAnger || angerNum > 0) {
                        angerNum = (byte)(angerNum - 1);
                        anger = 0;
                        this.toRageState();
                    } else {
                        BasicCanvas.initCue("\u8bf7\u4e8e\u5546\u57ce\u4e2d\u5f00\u901a", 2000, 500);
                    }
                }
                return;
            }
        }
        if (playerCanAttack && BasicCanvas.pressKey(131136)) {
            if (!beginVigor) {
                beginVigor = true;
                this.setCameraToSite(GameMainDraw.player.siteX, GameMainDraw.player.siteY, false, null);
            }
            if (isVigorOut) {
                GameMainDraw.player.vigor = (short)(GameMainDraw.player.vigor - 1);
                if (GameMainDraw.player.vigor <= 0) {
                    GameMainDraw.player.vigor = (short)10;
                    playerCanAttack = false;
                }
            } else if (GameMainDraw.player.vigor < VigorMax) {
                GameMainDraw.player.vigor = (short)(GameMainDraw.player.vigor + 1);
            } else {
                isVigorOut = true;
            }
        } else if (BasicCanvas.pressKey(32800)) {
            if (GameMainDraw.player.siteX > viewX + BasicCanvas.screenWidth / 2) {
                GameMainDraw.player.dir = 0;
            }
            if (!beginVigor) {
                cameraTargetMapX = (short)Math.max(0, cameraTargetMapX - 30);
            }
        } else if (BasicCanvas.pressKey(65664)) {
            if (GameMainDraw.player.siteX < viewX + BasicCanvas.screenWidth / 2) {
                GameMainDraw.player.dir = 1;
            }
            if (!beginVigor) {
                cameraTargetMapX = (short)Math.min(cameraWidth, cameraTargetMapX + 30);
            }
        } else if (BasicCanvas.pressKey(8200)) {
            if (GameMainDraw.player.angle < AngleMax) {
                GameMainDraw.player.angle = (short)(GameMainDraw.player.angle + 1);
            }
        } else if (BasicCanvas.pressKey(16896)) {
            if (GameMainDraw.player.angle > AngleMin) {
                GameMainDraw.player.angle = (short)(GameMainDraw.player.angle - 1);
            }
        } else {
            BasicCanvas.pressKeyInfo = 0;
            if (beginVigor && skill == null) {
                byte type = playerID;
                this.shootBullet(player, type);
            }
        }
    }

    private void toRageState() {
        player.toRage();
        int[] id = new int[]{0, 3, 4, 5};
        for (int i = 0; i < id.length; ++i) {
            Prop temp = Prop.getProp(id[i]);
            temp.bout = (byte)2;
            this.addPlayerSkill(player, temp);
        }
    }

    private void clearTeachKey() {
        teachKey = null;
    }

    public static void toCue(String string) {
        v_cue.addElement(string);
    }

    public void playerMove(GameObj npc, int dx, int dy) {
        if (npc.isMove) {
            short px = npc.siteX;
            short py = npc.siteY;
            int pw = 2;
            int ph = 2;
            short halfpw = (short)(pw / 2);
            short toppy = (short)(py - ph);
            int total_move = 0;
            boolean isMove = true;
            if (dy != 0) {
                total_move = 0;
                while (total_move < Math.abs(dy)) {
                    int move = Math.max(Math.abs(dy) - total_move, 1);
                    if (!GameMainDraw.isCanMove(px - halfpw, toppy + move, pw, ph)) {
                        py = titleSide[0];
                        isMove = npc.isMove = false;
                        break;
                    }
                    if (!isMove) continue;
                    py = (short)(py + move);
                    total_move += Math.abs(move);
                }
            }
            npc.setSite(px, py);
        }
    }

    public void key() {
        if (this.drawStatus == 1) {
            switch (stateNow) {
                case 1: {
                    if (BasicCanvas.hitKey(262144)) {
                        BasicCanvas.toMenu();
                        BasicCanvas.menuDraw.initMenu();
                        return;
                    }
                    if (BasicCanvas.hitKey(524288)) {
                        BasicCanvas.toMenu();
                        BasicCanvas.menuDraw.initSystem();
                        return;
                    }
                    if (!playerControlAble) break;
                    this.playerControl();
                }
            }
        }
    }

    public int touchKey(int x, int y) {
        return -1;
    }

    public boolean loadObject(int objectID, int direction, int x, int y, String string, int customProperty) {
        String[] str = KUtils.splitString(string, ',');
        String[] sprpng = str.length == 1 ? new String[]{"/map/" + str[0], "/map/" + str[0]} : str;
        switch (objectID) {
            case 0: {
                this.mapColor = string.equals("bg1") ? 15376647 : 4963582;
                if (!isDrawNoMap) {
                    if (x >= BasicCanvas.screenWidth) break;
                    if (customProperty > 15) {
                        columns = customProperty;
                    }
                    for (int i = 0; i < 3; ++i) {
                        GameObj elem = new GameObj(this);
                        elem.spriteX = Resource.getKSpriteX(sprpng[0], sprpng[1]);
                        elem.setSite(120 + 240 * i, 320);
                        elem.setLayout(1);
                        GameMainDraw.addElementNpc(elem);
                    }
                    break;
                }
                if (customProperty <= 15) break;
                columns = customProperty;
                break;
            }
            case 2: {
                break;
            }
            case 6: {
                int action = direction;
                this.setArrowSite(action, x, y);
                break;
            }
            case 1: {
                GameObj elem = new GameObj(this);
                elem.setSite(x, y);
                elem.spriteX = Resource.getKSpriteX(sprpng[0], sprpng[1]);
                elem.spriteX.setAction(direction);
                elem.spriteX.setFrame((byte)KUtils.genRand(elem.spriteX.getSequenceLength()));
                if (customProperty > 0) {
                    elem.setLayout(customProperty);
                }
                GameMainDraw.addElementNpc(elem);
                break;
            }
            case 3: 
            case 4: {
                for (int i = 0; i < direction; ++i) {
                    Bldg obj = new Bldg(this, objectID);
                    obj.spriteX = Resource.getKSpriteX(sprpng[0], sprpng[1]);
                    obj.setSite(x + obj.spriteX.getFrameWidth() * i, y);
                    if (customProperty > 0) {
                        obj.setLayout(customProperty);
                    }
                    GameMainDraw.addBox(obj);
                }
                break;
            }
            case 5: {
                Bldg obj = new Bldg(this, objectID);
                obj.setSite(x, y);
                obj.dir = (byte)direction;
                obj.spriteX = Resource.getKSpriteX(sprpng[0], sprpng[1]);
                obj.spriteX.setAction(direction);
                obj.npcW = (short)55;
                obj.npcH = (short)55;
                obj.setLayout(100);
                obj.isMapLoad = true;
                house = obj;
                GameMainDraw.addBox(obj);
            }
        }
        return true;
    }

    public void callAPI(KScriptObjectX obj, String method) {
        if (!(this.callMapAPI(obj, method) || this.callGameAPI(obj, method) || this.callMissionAPI(obj, method) || this.callInfoAPI(obj, method))) {
            if (method.indexOf("Npc") != -1) {
                this.callNpcAPI(obj, method);
            } else if (method.indexOf("Player") != -1) {
                this.callPlayerAPI(obj, method);
            } else if (method.indexOf("Enemy") != -1) {
                this.callEnemyAPI(obj, method);
            }
        }
    }

    private boolean callGameAPI(KScriptObjectX obj, String method) {
        if (method.equals("setTeachKey")) {
            String str = obj.getString();
            playerControlAble = true;
            GameMainDraw.setState(1);
            this.setCameraToObj(player, null, false);
            this.setTeachKey(str);
        } else if (method.equals("clearTeachKey")) {
            this.clearTeachKey();
        } else if (method.equals("isEnemyRun")) {
            enemyIsRun = obj.getBoolean();
        } else if (method.equals("canKeyNum1")) {
            isCanKeyNum1 = obj.getBoolean();
        } else if (method.equals("tempCanKill")) {
            tempCanKill = obj.getBoolean();
        } else if (method.equals("canKeyKill")) {
            isCanKeyKill = obj.getBoolean();
        } else if (method.equals("isTeach")) {
            isTeach = obj.getBoolean();
        } else if (method.equals("pauseTeach")) {
            teachState = (byte)obj.getInt();
            teachKsox = obj;
            obj.setWait(false);
        } else if (method.equals("getIsSave")) {
            obj.setRetVal(MenuDraw.isSave);
        } else if (method.equals("setControl")) {
            boolean is = obj.getBoolean();
            if (!is) {
                playerControlAble = false;
                player.stand(false);
            } else {
                playerControlAble = true;
                GameMainDraw.setState(1);
                this.setCameraToObj(player, obj, false);
            }
        } else if (method.equals("setMapState")) {
            GameMainDraw.setState(obj.getInt());
        } else if (method.equals("setCanAttack")) {
            playerCanAttack = obj.getBoolean();
        } else if (method.equals("playSkill")) {
            this.shootBullet(player, playerID);
        } else if (method.equals("getPlayerID")) {
            obj.setRetVal(playerID);
        } else if (method.equals("toYESNO")) {
            BasicCanvas.initSelectCue(obj.getString(), 0);
            tempKsox = obj;
            obj.setWait(false);
        } else if (method.equals("playerBoutStart")) {
            this.playerBoutStart();
        } else if (method.equals("enemyBoutStart")) {
            this.enemyBoutStart();
        } else if (method.equals("BoutStart")) {
            this.boutStart(obj.getInt());
        } else if (method.equals("startGame")) {
            int emyMax = obj.getInt();
            int hpMax = obj.getInt();
            GameMainDraw.initGame(hpMax, emyMax);
        } else if (method.equals("winKillEnemy")) {
            judgeEnmeyNum = (short)obj.getInt();
            judgeEnmeyId = (short)obj.getInt();
            if (judgeEnmeyNum < 0) {
                judgeEnmeyNum = 0;
            }
        } else if (method.equals("winBout")) {
            guardBout = (short)obj.getInt();
        } else if (method.equals("Bout")) {
            guardBout = (short)obj.getInt();
        } else if (method.equals("getLevels")) {
            obj.setRetVal(levels);
        } else if (method.equals("toLevels")) {
            GameMainDraw.toLevels(obj.getInt());
        } else if (!method.equals("objToSay")) {
            if (method.equals("setIsAnger")) {
                isAnger = obj.getBoolean();
                MenuDraw.saveNoteRms();
            } else if (method.equals("getIsAnger")) {
                obj.setRetVal(isAnger);
            } else if (method.equals("addShortcut")) {
                GameMainDraw.addShortcut(Prop.getProp(obj.getInt()));
            } else if (method.equals("isDrop")) {
                isDrop = obj.getBoolean();
            } else if (method.equals("isDrawAnger")) {
                isDrawAnger = obj.getBoolean();
            } else if (method.equals("setAngerNum")) {
                angerNum = (byte)obj.getInt();
            } else if (method.equals("setRevival")) {
                this.isRevival = true;
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean callMapAPI(KScriptObjectX obj, String method) {
        if (method.equals("toMapCue")) {
            GameMainDraw.toCue(obj.getString());
        } else if (method.equals("showMapName")) {
            GameMainDraw.setMapName(obj.getString());
        } else if (method.equals("setMapView")) {
            boolean isMove = obj.getBoolean();
            int y = obj.getInt();
            int x = obj.getInt();
            this.setCameraToSite(x, y, isMove, obj);
        } else if (method.equals("setViewToEnemy")) {
            boolean wait = obj.getBoolean();
            int id = obj.getInt();
            GameObj nn = GameMainDraw.getObj(id, enemyVector);
            if (nn == null) {
                BasicCanvas.Debug("setViewToNpc id \u9519\u8bef\uff1a" + id);
            } else {
                this.setCameraToObj(nn, obj, wait);
            }
        } else if (method.equals("setViewToPlayer")) {
            this.setCameraToObj(player, obj, obj.getBoolean());
        } else if (method.equals("setCameraSpeed")) {
            int speed = obj.getInt();
            MOVE_MAX_SPEED = (byte)speed;
        } else if (method.equals("loadMap")) {
            String name = obj.getString();
            this.toMap(name, obj);
        } else if (method.equals("setBlackScreen")) {
            blackS = (short)obj.getInt();
            BORDERH = (short)obj.getInt();
            BORDERH = (short)(BasicCanvas.screenHeight * BORDERH / 320);
            isBlackClose = obj.getBoolean();
            if (isBlackClose) {
                blackH = 0;
            }
            isDrawBlack = true;
            if (BORDERH != blackS) {
                tempKsox = obj;
                obj.setWait(false);
            }
        } else if (method.equals("closeBlackScreen")) {
            isDrawBlack = false;
        } else if (method.equals("playFlash")) {
            GameMainDraw.setFlashEffect(obj.getInt(), Integer.parseInt(obj.getString(), 16));
        } else if (method.equals("tremorScreen")) {
            int time = obj.getInt();
            GameMainDraw.setTremor(obj.getInt(), 2, time);
        } else if (method.equals("setCamera")) {
            cameraHeight = (short)(obj.getInt() * 16);
            cameraWidth = (short)(obj.getInt() * 16);
            cameraY = (short)(obj.getInt() * 16);
            cameraX = (short)(obj.getInt() * 16);
        } else if (method.equals("setNowCamera")) {
            cameraHeight = (short)(GameMainDraw.getViewY() + BasicCanvas.screenHeight);
            cameraWidth = (short)(GameMainDraw.getViewX() + BasicCanvas.screenWidth);
            cameraY = (short)GameMainDraw.getViewY();
            cameraX = (short)GameMainDraw.getViewX();
        } else if (method.equals("setOldCamera")) {
            cameraHeight = mapHeight;
            cameraWidth = mapWidth;
            cameraY = 0;
            cameraX = 0;
        } else if (method.equals("setCanMove")) {
            int h = obj.getInt() * 16;
            int w = obj.getInt() * 16;
            int y = obj.getInt() * 16;
            int x = obj.getInt() * 16;
            GameMainDraw.setCanMoveSite(x, y, w, h);
        } else {
            return false;
        }
        return true;
    }

    private void setCameraToSite(int x, int y, boolean isMove, KScriptObjectX obj) {
        cameraTargetMapX = (short)x;
        cameraTargetMapY = (short)y;
        if (!isMove) {
            int cameraTargetX = cameraTargetMapX - GameMainDraw.getViewWidth() / 2;
            int cameraTargetY = cameraTargetMapY - GameMainDraw.getViewHeight() / 2;
            cameraTargetX = Math.max(cameraTargetX, 0);
            cameraTargetY = Math.max(cameraTargetY, 0);
            cameraTargetX = Math.min(cameraTargetX, mapWidth - GameMainDraw.getViewWidth());
            cameraTargetY = Math.min(cameraTargetY, mapHeight - GameMainDraw.getViewHeight());
            GameMainDraw.setViewPosition(cameraTargetX, cameraTargetY);
        }
        GameMainDraw.setCameraFocusState(1);
        this.setKScriptWait(obj, isMove);
    }

    private boolean callPlayerAPI(KScriptObjectX obj, String method) {
        if (method.equals("initPlayer")) {
            player.initPlayer(obj.getInt());
        } else if (method.equals("drawPlayerState")) {
            isDrawHP = obj.getBoolean();
        } else if (method.equals("setPlayerTo")) {
            boolean isMove = obj.getBoolean();
            int d = obj.getInt();
            int y = obj.getInt();
            int x = obj.getInt();
            player.setSite(x, y);
            if (d >= 0) {
                GameMainDraw.player.dir = (byte)d;
                player.stand(true);
            }
            if (!isMove) {
                GameMainDraw.toPlayerCamera(player);
            }
        } else if (method.equals("getPlayerMapX")) {
            obj.setRetVal(player.getMapArrayX());
        } else if (method.equals("getPlayerMapY")) {
            obj.setRetVal(player.getMapArrayY());
        } else if (method.equals("getPlayerX")) {
            obj.setRetVal(GameMainDraw.player.siteX);
        } else if (method.equals("getPlayerY")) {
            obj.setRetVal(GameMainDraw.player.siteY);
        } else if (method.equals("setPlayerAction")) {
            int action = obj.getInt();
            player.setAction(action);
            player.setState(0);
        } else if (method.equals("setPlayerAlive")) {
            GameMainDraw.player.isAlive = obj.getBoolean();
        } else if (method.equals("getPlayerDir")) {
            obj.setRetVal(GameMainDraw.player.dir);
        } else if (method.equals("addPlayerHp")) {
            player.alterHp(obj.getInt());
        } else if (method.equals("setPlayerAV")) {
            GameMainDraw.player.vigor = (short)obj.getInt();
            GameMainDraw.player.angle = (short)obj.getInt();
        } else if (method.equals("getPlayerVigor")) {
            obj.setRetVal(GameMainDraw.player.vigor);
        } else if (method.equals("setPlayerAnger")) {
            anger = (short)obj.getInt();
        } else {
            return false;
        }
        return true;
    }

    private boolean callEnemyAPI(KScriptObjectX obj, String method) {
        if (method.equals("addEnemy")) {
            int i;
            int dir = obj.getInt();
            int siteY = obj.getInt();
            int siteX = obj.getInt();
            int num = obj.getInt();
            enemyId = new short[num];
            for (i = enemyId.length - 1; i >= 0; --i) {
                GameMainDraw.enemyId[i] = (short)obj.getInt();
            }
            for (i = 0; i < num; ++i) {
                int x = siteX + KUtils.genRand(-5 + i * 10, (i + 1) * 10) * (dir == 0 ? -1 : 1);
                int y = siteY;
                x = Math.max(5, x);
                x = Math.min(cameraWidth, x);
                this.addEnemy(enemyId[i], 0, x, y, dir, false);
            }
        } else if (method.equals("initEnemySite")) {
            int num = obj.getInt();
            initEnemySiteX = new short[num];
            initEnemySiteY = new short[num];
            for (int i = num - 1; i >= 0; --i) {
                GameMainDraw.initEnemySiteY[i] = (short)obj.getInt();
                GameMainDraw.initEnemySiteX[i] = (short)obj.getInt();
            }
        } else if (method.equals("addRandomEnemy")) {
            int i;
            int index = obj.getInt();
            int dir = obj.getInt();
            int num = obj.getInt();
            int idnum = obj.getInt();
            enemyId = new short[idnum];
            for (i = enemyId.length - 1; i >= 0; --i) {
                GameMainDraw.enemyId[i] = (short)obj.getInt();
            }
            for (i = 0; i < num; ++i) {
                int x = initEnemySiteX[index] + KUtils.genRand(-9 + i * 120 / num, (i + 1) * 120 / num) * (dir == 0 ? -1 : 1);
                short y = initEnemySiteY[index];
                x = Math.max(5, x);
                x = Math.min(cameraWidth, x);
                this.addEnemy(enemyId[KUtils.genRand(idnum)], 0, x, y, dir, false);
            }
            this.setCameraToSite(initEnemySiteX[index], initEnemySiteY[index], true, obj);
        } else if (method.equals("addMoreEnemy")) {
            int i;
            int index = obj.getInt();
            int dir = obj.getInt();
            int num = obj.getInt();
            enemyId = new short[num];
            for (i = num - 1; i >= 0; --i) {
                GameMainDraw.enemyId[i] = (short)obj.getInt();
            }
            for (i = 0; i < num; ++i) {
                int x = initEnemySiteX[index] + KUtils.genRand(-9 + i * 120 / num, (i + 1) * 120 / num) * (dir == 0 ? -1 : 1);
                if (isTeach) {
                    x = initEnemySiteX[index] + KUtils.genRand(80 / num * i, 80 / num * (i + 1)) * (dir == 0 ? -1 : 1);
                }
                short y = initEnemySiteY[index];
                x = Math.max(5, x);
                x = Math.min(cameraWidth, x);
                this.addEnemy(enemyId[i], 0, x, y, dir, false);
            }
            this.setCameraToObj((GameObj)enemyVector.elementAt(enemyVector.size() - 1), obj, true);
        } else if (method.equals("addEnemyEnd")) {
            enemyMin = (short)obj.getInt();
            boutKsox = obj;
            obj.setWait(false);
        } else if (method.equals("hideEnemy")) {
            showEnemy = false;
            isUpdateGameObj = true;
        } else if (method.equals("showEnemy")) {
            showEnemy = true;
            isUpdateGameObj = true;
        } else if (method.equals("getEnemyNum")) {
            obj.setRetVal(enemyVector.size());
        } else if (method.equals("clearEnemy")) {
            int type = obj.getInt();
            if (type == 0) {
                enemyVector.removeAllElements();
            } else {
                int length = enemyVector.size();
                for (int i = length - 1; i >= 0; --i) {
                    Player nNpc = (Player)enemyVector.elementAt(i);
                    if (nNpc.type != type) continue;
                    enemyVector.removeElementAt(i);
                }
            }
            isUpdateGameObj = true;
        } else if (method.equals("allEnemyAttack")) {
            this.enemyBoutStart();
            int length = enemyVector.size();
            for (int i = length - 1; i >= 0; --i) {
                Player nNpc = (Player)enemyVector.elementAt(i);
                nNpc.isAttack = true;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean callNpcAPI(KScriptObjectX obj, String method) {
        return false;
    }

    private boolean callMissionAPI(KScriptObjectX obj, String method) {
        if (method.equals("addMission")) {
            missionInfo = obj.getString();
            missionName = obj.getString();
        } else if (method.equals("initMission")) {
            missionInfo = obj.getString();
            missionName = obj.getString();
            this.setBoutInfo(missionName, missionInfo);
        } else {
            return false;
        }
        return true;
    }

    private void addEnemy(int id, int ownId, int x, int y, int dir, boolean isBirth) {
        Player eNpc = new Player(this);
        eNpc.initEnemy(id);
        eNpc.eventid = (byte)ownId;
        eNpc.isCanRevival = 0;
        eNpc.initX = (short)x;
        eNpc.initY = (short)y;
        eNpc.setSite(eNpc.initX, eNpc.initY);
        eNpc.dir = (byte)(dir % 4);
        eNpc.stand(true);
        GameMainDraw.addEnemy(eNpc);
    }

    private void setArrowSite(int action, int y, int x) {
        GameObj arrow = new GameObj(this);
        arrow.setSite(x, y);
        arrow.spriteX = Resource.getKSpriteX("/arrow", "/arrow");
        arrow.ownId = (short)action;
        arrow.setAction(action);
        arrow.isLayout = true;
        arrow.layout = 0;
        GameMainDraw.addArrow(arrow);
    }

    public static void judgeMissionEnemy(int id) {
        killEnemyNum = (short)(killEnemyNum + 1);
        if (id == judgeEnmeyId || judgeEnmeyId == 0) {
            judgeEnmeyNum = (short)(judgeEnmeyNum - 1);
        }
    }

    public static void judgeMissionProp(Prop p, boolean isAdd) {
    }

    public void toMap(String name, KScriptObjectX temp) {
        mapIniName = name;
        if (!mapIniName.endsWith("_object.obj")) {
            mapIniName = mapIniName + "_object.obj";
        }
        this.setDrawStatus(0);
        this.loadState = 1;
        BasicCanvas.isDrawEffect = false;
        if (BasicCanvas.containsDraw(BasicCanvas.menuDraw)) {
            BasicCanvas.menuDraw.clear();
        }
        BasicCanvas.removeAllCanvas();
        BasicCanvas.addDrawToTop(this);
        mapKsox = temp;
        mapKsox.setWait(false);
    }

    public static void removeBox(Bldg obj) {
        boxVector.removeElement(obj);
        isUpdateGameObj = true;
    }

    public static void removeEnemy(GameObj obj) {
        if (obj != null) {
            enemyVector.removeElement(obj);
            isUpdateGameObj = true;
        }
    }

    public static void addImageList(int index) {
        int size = imgList.size();
        for (int i = size - 1; i >= 0; --i) {
            String s = (String)imgList.elementAt(i);
            if (!s.equals("" + index)) continue;
            return;
        }
        imgList.addElement("" + index);
    }

    public static void clearVector() {
        boxVector.removeAllElements();
        enemyVector.removeAllElements();
        arrowVector.removeAllElements();
        elementVector.removeAllElements();
        goodsVector.removeAllElements();
        skillVector.removeAllElements();
        if (npcArray != null) {
            for (int i = 0; i < npcArray.length; ++i) {
                if (npcArray[i] == null || GameMainDraw.npcArray[i].ownType == 3) continue;
                GameMainDraw.npcArray[i] = null;
            }
        }
        touchObj = null;
        nonceEnemy = null;
        v_effect = null;
    }

    public static void clear() {
        GameMainDraw.clearVector();
        count = 0;
        GameMainDraw.setCanMoveSite(0, 0, 0, 0);
        enemyAI = true;
        isDrop = true;
        isDrawAnger = true;
        MOVE_MAX_SPEED = (byte)32;
        judgeEnmeyNum = (short)-1;
        v_cue = new Vector();
        isDrawBlack = false;
        isFlash = false;
        isTeach = false;
        GameMainDraw.clearEffect();
        teachKsox = null;
        boutKsox = null;
        isDrawHP = true;
        teachKey = null;
        Resource.clearSpriteX();
        Resource.clearDb();
        Resource.removeAllImage();
        Prop.clearDb();
        Player.enemydb = null;
        skill = null;
        smallDate = null;
    }

    public void clearMemory() {
        this.setDrawStatus(2);
        this.loadState = 1;
        stateNow = 0;
        npcArray = null;
        cameraObj = null;
        GameMainDraw.clear();
    }

    public static void setTremor(int t, int n, int time) {
        if (tremor == 0 || t == 0) {
            tremor = (byte)t;
            tremorNum = (byte)n;
            tremorCount = time;
            count = 0;
        }
    }

    public void logicMain() {
        ++count;
        if (boutState == 7) {
            if (BasicCanvas.containsDraw(BasicCanvas.menuDraw)) {
                return;
            }
            if (this.isRevival) {
                houseHP = houseMAX;
                boutNow = 0;
                int size = enemyVector.size();
                for (int i = 0; i < size; ++i) {
                    Player emy = (Player)enemyVector.elementAt(i);
                    emy.hp = 0;
                    emy.setState(4);
                }
                skillVector.removeAllElements();
                boutState = (byte)2;
                this.isRevival = false;
            } else {
                GameMainDraw.GameOver();
            }
        }
        this.cameraMoveLogic();
        this.tremorLogic();
        try {
            if (npcArray != null) {
                this.npcArrayLogic();
            }
            this.enemyLogic();
            this.skillLogic();
            this.boxLogic();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.statePropLogic();
        if (tempBoutState > 0 && (boutStartDefer = (byte)(boutStartDefer - 1)) <= 0) {
            if (tempBoutState == 1) {
                this.playerBoutStart();
            } else if (tempBoutState == 2) {
                this.enemyBoutStart();
            }
            tempBoutState = 0;
        }
        if (boutState != 5 && boutState != 7 && this.judgeOver()) {
            GameMainDraw.GameOver();
        }
    }

    private void npcArrayLogic() {
        for (int i = 0; i < npcArray.length; ++i) {
            if (npcArray[i] == null || !GameMainDraw.npcArray[i].isAlive) continue;
            npcArray[i].logic();
        }
        int length1 = arrowVector.size();
        for (int i = length1 - 1; i >= 0; --i) {
            GameObj arrow = (GameObj)arrowVector.elementAt(i);
            arrow.logic();
        }
    }

    public static void GameOver() {
        boutState = (byte)5;
        BasicCanvas.toMenu();
        BasicCanvas.menuDraw.initOver();
    }

    public boolean judgeWin() {
        if (judgeEnmeyId >= 0) {
            if (boutNow >= guardBout && judgeEnmeyNum <= 0) {
                return true;
            }
            if (judgeEnmeyNum <= 0 && boutKsox == null) {
                return true;
            }
        }
        return false;
    }

    public boolean judgeOver() {
        if (guardBout > 0 && boutNow > guardBout) {
            return true;
        }
        return houseHP <= 0;
    }

    public static void GameWin() {
        boutState = (byte)4;
        if (levels >= activateLevels[playerID]) {
            GameMainDraw.activateLevels(levels + 1);
        }
        hpScore = houseHP;
        hitScore = (short)(hitBasicScore * hitMaxNum);
        score = (short)(enemyScore + hitScore + hpScore);
        if (isTeach) {
            for (int i = 0; i < star.length; ++i) {
                GameMainDraw.star[i][GameMainDraw.levels] = 3;
            }
        } else {
            short MedalScore = (short)(enemyScore + hitBasicScore * (playerID == 0 ? 20 : 35) + houseMAX);
            int rate = score * 100 / MedalScore;
            byte temp = (byte)(rate >= 90 ? 3 : (rate >= 70 ? 2 : (rate >= 50 ? 1 : 0)));
            if (temp > star[playerID][levels]) {
                for (int i = 0; i < star.length; ++i) {
                    GameMainDraw.star[i][GameMainDraw.levels] = temp;
                }
            }
        }
        BasicCanvas.toMenu();
        BasicCanvas.menuDraw.initWin();
        if (teachState == 4 && teachKsox != null) {
            teachKsox.setWait(true);
            teachKsox = null;
        }
        GameMainDraw.saveMainRms();
    }

    public static int getPlayerStarNum(int id) {
        int num = 0;
        for (int i = 0; i < star[id].length; ++i) {
            num += star[id][i];
        }
        return num;
    }

    private void boxLogic() {
        int size = boxVector.size();
        block9: for (int i = size - 1; i >= 0; --i) {
            Bldg obj = (Bldg)boxVector.elementAt(i);
            if (obj == null) continue;
            switch (obj.type) {
                case 5: {
                    int bruiseAttack = 0;
                    if (houseHP < houseMAX / 2) {
                        bruiseAttack = 4;
                    }
                    switch (obj.stateNow) {
                        case 0: {
                            obj.setAction(0 + obj.dir + bruiseAttack);
                            continue block9;
                        }
                        case 1: {
                            obj.setAction(2 + obj.dir + bruiseAttack);
                            if (!obj.spriteX.ActionEnd()) continue block9;
                            obj.stateNow = 0;
                            continue block9;
                        }
                    }
                    continue block9;
                }
                case 4: {
                    if (smallDate != null) {
                        int xx = obj.getMapArrayX();
                        int yy = obj.getMapArrayY();
                        if (xx >= 0 && xx < GameMainDraw.getColumns()) {
                            GameMainDraw.smallDate[xx][yy] = 2;
                        }
                    }
                    if (obj.stateNow == 0 || obj.stateNow == 2) {
                        obj.setAction(obj.stateNow);
                        if (obj.isOpen <= 0) {
                            if (skill == null) continue block9;
                            for (int j = 0; j < GameMainDraw.skill.spxNum; ++j) {
                                if (!skill.isHitObj(j, obj)) continue;
                                obj.stateNow = (byte)(obj.stateNow + 1);
                                obj.isOpen = (byte)10;
                                continue block9;
                            }
                            continue block9;
                        }
                        obj.isOpen = (byte)(obj.isOpen - 1);
                        continue block9;
                    }
                    if (obj.stateNow == 1) {
                        obj.setAction(1);
                        if (!obj.spriteX.ActionEnd()) continue block9;
                        obj.stateNow = (byte)2;
                        continue block9;
                    }
                    obj.setAction(3);
                    if (!obj.spriteX.ActionEnd()) continue block9;
                    GameMainDraw.removeBox(obj);
                    continue block9;
                }
                case 6: {
                    if (!obj.spriteX.ActionEnd()) continue block9;
                    obj.aliveTime = (byte)(obj.aliveTime - 1);
                    if (obj.aliveTime > 0) continue block9;
                    GameMainDraw.removeBox(obj);
                    continue block9;
                }
            }
        }
    }

    private void tremorLogic() {
        switch (tremor) {
            case 1: {
                if (count % 2 == 1) {
                    viewY += tremorNum;
                    break;
                }
                viewY -= tremorNum;
                break;
            }
            case 2: {
                if (count % 2 == 0) {
                    viewX += tremorNum;
                    break;
                }
                viewX -= tremorNum;
                break;
            }
            case 3: {
                if (count % 4 == 0) {
                    viewX += 4;
                } else if (count % 4 == 2) {
                    viewX -= 4;
                }
                if (count % 4 == 1) {
                    viewY -= 4;
                    break;
                }
                if (count % 4 != 3) break;
                viewY += 4;
                break;
            }
            case 4: {
                viewX = count % 2 == 0 ? ++viewX : --viewX;
                if (count % 2 == 0) {
                    ++viewY;
                    break;
                }
                --viewY;
            }
        }
        if (tremorCount == 0) {
            tremor = 0;
        } else if (tremorCount > 0) {
            --tremorCount;
            if (count == 1) {
                tremorNum = (byte)(tremorNum * 2);
            }
            if (tremorCount == 0) {
                tremorNum = (byte)(tremorNum / 2);
            }
        }
    }

    private void enemyLogic() {
        if (!showEnemy || !enemyIsRun) {
            return;
        }
        int size = enemyVector.size();
        int enemyBoutEnd = 0;
        for (int i = size - 1; i >= 0; --i) {
            Player emy = (Player)enemyVector.elementAt(i);
            if (emy == null || !emy.isAlive) continue;
            if (emy.deadState == 1) {
                enemyScore = (short)(enemyScore + emy.score);
                GameMainDraw.judgeMissionEnemy(emy.ownId);
                if (emy.isCanRevival == 0) {
                    emy.deadState = (byte)2;
                    this.deadEnemy.addElement(emy);
                    isUpdateGameObj = true;
                } else {
                    emy.deadState = (byte)3;
                }
            }
            if (smallDate != null) {
                int xx = emy.getMapArrayX();
                int yy = emy.getMapArrayY();
                if (xx >= 0 && xx < GameMainDraw.getColumns() && yy < GameMainDraw.getRows()) {
                    GameMainDraw.smallDate[xx][yy] = 5;
                }
            }
            if (emy.deadState != 0 || emy.stateNow == 5 || emy.stateNow == 6 || emy.stateNow == 4) continue;
            this.playerMove(emy, 0, 10);
            if (emy.isHit && skill != null) {
                for (int j = 0; j < GameMainDraw.skill.spxNum; ++j) {
                    if (emy.hp <= 0 || !skill.isHitObj(j, emy)) continue;
                    this.judgeSkillHurt(skill, emy);
                    emy.isMove = true;
                }
            }
            if (emy.hp <= 0 || !enemyAI || boutState != 2) continue;
            if (emy.type == 4) {
                this.enemyBossAI(emy, emy.aiLevel);
            } else {
                this.enemyShortAI(emy, emy.aiLevel);
            }
            if (emy.boutStart) continue;
            ++enemyBoutEnd;
        }
        if (boutState == 2 && enemyBoutEnd >= size && skillVector.size() == 0) {
            if (boutKsox != null && enemyVector.size() < enemyMin) {
                boutKsox.setWait(true);
                boutKsox = null;
                boutState = (byte)6;
                boutStartDefer = (byte)10;
            } else {
                this.boutStart(1);
            }
        }
        if (boutState == 6 && cameraWaitKsox == null) {
            byte by = boutStartDefer;
            boutStartDefer = (byte)(by - 1);
            if (by <= 0) {
                this.boutStart(1);
            }
        }
    }

    public boolean isShootBldg(int type, int dir, GameObj obj) {
        int x = obj.siteX - obj.npcW / 2;
        int y = obj.siteY - obj.npcH + 2;
        short w = obj.npcW;
        short h = obj.npcH;
        int length = boxVector.size();
        Bldg nNpc = null;
        for (int i = length - 1; i >= 0; --i) {
            nNpc = (Bldg)boxVector.elementAt(i);
            if (type != 3 ? type == 5 && nNpc.type != 3 : nNpc.type == 5) continue;
            short[] coll = nNpc.spriteX.getCollision();
            if (coll == null || !KUtils.hit(nNpc.siteX + coll[0], nNpc.siteY + coll[1], coll[2], coll[3], x, y, w, h)) continue;
            obj.siteY = (short)(nNpc.siteY + coll[1]);
            return true;
        }
        return false;
    }

    private void skillLogic() {
        Object spx;
        if (skill != null && !GameMainDraw.skill.isPlay) {
            skill = null;
            if (GameMainDraw.player.actionCount >= player.getShootTime()) {
                this.boutStart(2);
            } else {
                this.shootBullet(player, playerID);
                return;
            }
        }
        int size = skillVector.size();
        for (int j = size - 1; j >= 0; --j) {
            Skill sk = (Skill)skillVector.elementAt(j);
            if (sk == null) {
                skillVector.removeElementAt(j);
                continue;
            }
            if (!sk.isPlay) {
                skillVector.removeElementAt(j);
            } else {
                spx = sk.spx;
                if (spx != null) {
                    block5: for (int i = 0; i < ((Object)spx).length; ++i) {
                        if (spx[i] == null) continue;
                        switch (((GameObj)spx[i]).stateNow) {
                            case 0: {
                                if (sk.firePlayer.ownType == 3) {
                                    if (this.isShootBldg(3, 1, (GameObj)spx[i])) {
                                        sk.setBomb(i);
                                    }
                                } else if (sk.firePlayer.ownType == 5) {
                                    if (GameMainDraw.isCollisionNpc((GameObj)spx[i], house)) {
                                        sk.setBomb(i);
                                    } else if (((GameObj)spx[i]).siteY >= GameMainDraw.house.siteY) {
                                        ((GameObj)spx[i]).siteY = GameMainDraw.house.siteY;
                                        sk.setBomb(i);
                                    }
                                }
                                if (!GameMainDraw.isOutMap(((GameObj)spx[i]).siteX, ((GameObj)spx[i]).siteY)) continue block5;
                                sk.clearSpx(i);
                                continue block5;
                            }
                            case 1: {
                                if (sk.firePlayer.ownType != 5 || !sk.isHit || !sk.isHitObj(i, house)) continue block5;
                                sk.isHit = false;
                                int odds = KUtils.genRand(100);
                                if (odds >= sk.firePlayer.getShoot()) continue block5;
                                GameMainDraw.alterHouseHp(-sk.getHurt());
                            }
                        }
                    }
                }
            }
            sk.logic();
        }
        if (v_effect != null) {
            int length = v_effect.size();
            for (int j = length - 1; j >= 0; --j) {
                spx = (GameObj)v_effect.elementAt(j);
                ((GameObj)spx).logic();
            }
        }
    }

    public void setSkillEffect(GameObj obj, int type) {
    }

    public void judgeSkillHurt(Skill sk, Player bruiseP) {
        if (bruiseP.equals(player)) {
            if (!KUtils.isDead) {
                return;
            }
        } else {
            this.addHitNum();
        }
        bruiseP.setState(4);
        bruiseP.injure = 10;
        bruiseP.isHit = false;
        int hurtNum = -(sk.getHurt() - bruiseP.recovery);
        if (isTeach) {
            hurtNum = -bruiseP.hp;
        }
        if (hurtNum >= 0) {
            hurtNum = -1;
        }
        bruiseP.alterHp(hurtNum);
        bruiseP.setHurtShow(hurtNum, false);
    }

    public void addSkill(Skill skill) {
        if (skill != null) {
            skillVector.addElement(skill);
            isUpdateGameObj = true;
        }
    }

    public void enemyShortAI(Player emy, int level) {
        if (emy.stateNow == 4 || !emy.boutStart) {
            return;
        }
        emy.attackCount = (byte)(emy.attackCount + 1);
        if (emy.stateNow != 1 && this.enemyAttack(emy, house)) {
            emy.attackCount = emy.attackSpeed;
            if (emy.skill == null || !emy.skill.isPlay) {
                int size = this.enemySite.size();
                for (int i = 0; i < size; ++i) {
                    int[] s = (int[])this.enemySite.elementAt(i);
                    if (!KUtils.hit(s[0] - 10, s[1] - 5, 20, 10, emy.siteX, emy.siteY, 1, 1) || KUtils.genRand(10) >= 2) continue;
                    return;
                }
                this.enemySite.addElement(new int[]{emy.siteX, emy.siteY});
                this.shootBullet(emy, 2);
                if (emy.actionCount >= emy.getShootTime()) {
                    emy.boutStart = false;
                }
            }
        } else {
            this.enemyWalk(emy);
        }
    }

    public void enemyWalk(Player emy) {
        if (emy.stateNow != 1) {
            emy.setState(1);
            emy.leisureCount = isTeach ? (short)((byte)KUtils.genRand(2, 6)) : (short)((byte)KUtils.genRand(emy.leisureStop / 2));
        }
        emy.leisureCount = (short)(emy.leisureCount + 1);
        if (GameMainDraw.isCanMove(emy.siteX + (emy.dir == 0 ? -16 - KUtils.genRand(20) : 16 + KUtils.genRand(20)), emy.siteY, 2, 2)) {
            emy.isMove = true;
            if (Math.abs(emy.siteX - GameMainDraw.house.siteX) <= BasicCanvas.screenWidth * 3 / 2 && KUtils.genRand(10) < 6) {
                emy.stand(true);
                emy.isAttack = true;
            }
        } else if (emy.leisureCount > emy.leisureStop / 2 && Math.abs(emy.siteX - GameMainDraw.house.siteX) <= emy.attackSpace + 50) {
            emy.stand(true);
            if (KUtils.genRand(10) < 5) {
                emy.isAttack = true;
            }
        } else if (emy.leisureCount >= emy.leisureStop) {
            emy.boutStart = false;
            emy.stand(true);
            emy.attackCount = (byte)KUtils.genRand(emy.attackSpeed);
        }
    }

    public void enemyBossAI(Player emy, int level) {
        if (emy.stateNow == 4 || !emy.boutStart) {
            return;
        }
        emy.attackCount = (byte)(emy.attackCount + 1);
        if (emy.stateNow != 1 && this.enemyAttack(emy, house)) {
            emy.attackCount = emy.attackSpeed;
            if (emy.skill == null || !emy.skill.isPlay) {
                this.shootBullet(emy, 2);
                if (emy.actionCount >= emy.getShootTime()) {
                    emy.boutStart = false;
                }
            }
        } else {
            this.enemyWalk(emy);
        }
    }

    private boolean enemyAttack(Player emy, GameObj obj) {
        return Math.abs(emy.siteX - obj.siteX) <= emy.attackSpace || emy.isAttack;
    }

    public void paintLoad(Graphics g) {
        if (!BeginMidlet.isPause) {
            switch (this.loadState) {
                case 1: {
                    this.loadMap();
                    this.loadIndex = (byte)(this.loadIndex + 1);
                    break;
                }
                case 2: {
                    this.loadIndex = (byte)(this.loadIndex + 1);
                    break;
                }
            }
        }
        if (this.loadIndex >= 11) {
            this.loadIndex = (byte)11;
            if (isLoadEnd) {
                isLoadEnd = false;
                Resource.clearSpriteX();
                if (mapKsox != null) {
                    mapKsox.setWait(true);
                    mapKsox = null;
                }
                this.drawStatus = 1;
            }
        }
        GameMainDraw.drawSchedule(this.loadIndex);
    }

    public static void drawSchedule(int index) {
        Resource.addRect((byte)1, 0, BasicCanvas.screenHeight / 2 - 19, BasicCanvas.screenWidth, 38, true, 0, 0, 2000);
        Resource.addRect((byte)1, 0, BasicCanvas.screenHeight / 2 - 19, BasicCanvas.screenWidth, 1, true, 0, 0xFFFFFF, 2000);
        Resource.addRect((byte)1, 0, BasicCanvas.screenHeight / 2 + 19, BasicCanvas.screenWidth, 1, true, 0, 0xFFFFFF, 2000);
        Resource.addString("\u52a0\u8f7d\u4e2d...", BasicCanvas.screenWidth / 2, (BasicCanvas.screenHeight - BasicCanvas.fontHeight) / 2, 17, 0xFFFFFF, 2000);
    }

    private void loadMap() {
        switch (this.loadIndex) {
            case 1: {
                isLoadEnd = false;
                GameMainDraw.player.isAlive = true;
                playerControlAble = false;
                stateNow = 0;
                Resource.clearKScriptObjectXExcept(mapKsox);
                GameMainDraw.clear();
                System.gc();
                break;
            }
            case 2: {
                GameMainDraw.setTremor(0, 2, 0);
                showEnemy = true;
                MenuDraw.isSave = true;
                break;
            }
            case 3: {
                this.isLoadMap(mapIniName);
                this.loadMap(0);
                break;
            }
            case 4: {
                this.loadMap(1);
                this.loadMap(2);
                break;
            }
            case 5: {
                this.loadMap(3);
                this.loadMap(4);
                this.setViewSize(BasicCanvas.screenWidth, BasicCanvas.screenHeight);
                enemyIsRun = true;
                cameraX = 0;
                cameraY = 0;
                cameraWidth = mapWidth;
                cameraHeight = mapHeight;
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                if (mapKsox == null) break;
                mapKsox.setWait(true);
                mapKsox = null;
                break;
            }
        }
    }

    private static void clearEffect() {
        GameMainDraw.clearStar();
        GameMainDraw.clearYeZi();
        GameMainDraw.clearDot();
        GameMainDraw.clearYun();
    }

    public static void addGoods(Prop obj) {
        dropPhysicNum = (short)(dropPhysicNum + 1);
        goodsVector.addElement(obj);
        isUpdateGameObj = true;
    }

    public static void removGoods(Prop obj) {
        dropPhysicNum = (short)(dropPhysicNum - 1);
        goodsVector.removeElement(obj);
        isUpdateGameObj = true;
    }

    public void paintMain(Graphics g) {
        Resource.addRect((byte)1, 0, 0, BasicCanvas.screenWidth, BasicCanvas.screenHeight, true, 0, this.mapColor, -1);
        this.drawMapName(BasicCanvas.screenWidth / 2, 80);
        this.drawObj(g);
        this.drawSkill(g);
        this.drawFightUI();
        this.drawEffect(g);
        this.drawDoubleHit();
        GameMainDraw.drawSmallMap(g);
        this.resetNpc();
    }

    public static void initSmallDate() {
        int y;
        int x;
        smallDate = new byte[GameMainDraw.getColumns()][GameMainDraw.getRows()];
        int size = boxVector.size();
        for (int i = size - 1; i >= 0; --i) {
            int j;
            Bldg obj = (Bldg)boxVector.elementAt(i);
            x = obj.getMapArrayX();
            y = obj.getMapArrayY();
            if (x >= GameMainDraw.getColumns() || y >= GameMainDraw.getRows() || smallDate[x][y] != 0) continue;
            if (obj.type == 3) {
                for (j = 0; j < smallDate.length; ++j) {
                    GameMainDraw.smallDate[j][y] = 1;
                }
                continue;
            }
            if (obj.type == 4) {
                GameMainDraw.smallDate[x][y] = 2;
                continue;
            }
            if (obj.type != 5) continue;
            for (j = y + 1; j > y - 8; --j) {
                GameMainDraw.smallDate[x][j] = 3;
            }
        }
        if (player != null) {
            x = player.getMapArrayX();
            y = player.getMapArrayY();
            GameMainDraw.smallDate[x][y] = 4;
        }
    }

    public static void drawSmallMap(Graphics g) {
        if (smallDate == null) {
            GameMainDraw.initSmallDate();
        }
        int width = GameMainDraw.getColumns() * 2 + 2;
        int height = GameMainDraw.getRows() * 2 + 2;
        int x = BasicCanvas.screenWidth - width + 1;
        Resource.addRect((byte)1, BasicCanvas.screenWidth - width, 0, width, height, false, 0, 0xFFFFFF, 2000);
        Resource.addRect((byte)8, x, 1, width - 2, height - 2, false, 0, -1308622848, 2000);
        for (int i = 0; i < smallDate.length; ++i) {
            int y = 1;
            for (int j = 0; j < smallDate[i].length; ++j) {
                switch (smallDate[i][j]) {
                    case 1: 
                    case 2: {
                        Resource.addRect((byte)1, x, y, 4, 1, true, 0, 0xB6B6B8, 2000);
                        if (smallDate[i][j] != 2) break;
                        GameMainDraw.smallDate[i][j] = 0;
                        break;
                    }
                    case 3: {
                        Resource.addRect((byte)1, x, y, 2, 2, true, 0, 0xB6B6B8, 2000);
                        break;
                    }
                    case 4: {
                        Resource.addRect((byte)1, x - 2, y - 2, 6, 4, true, 0, 65311, 2000);
                        Resource.addRect((byte)1, x - 1, y - 3, 4, 6, true, 0, 65311, 2000);
                        break;
                    }
                    case 5: {
                        Resource.addRect((byte)1, x - 1, y - 1, 4, 4, true, 0, 0xFF0707, 2000);
                        GameMainDraw.smallDate[i][j] = 0;
                    }
                }
                y += 2;
            }
            x += 2;
        }
    }

    private void drawFightUI() {
        if (isDrawHP) {
            int x = 3;
            int y = 0;
            MenuDraw.drawSkinRect(0, 0, 0, 57, 65);
            Resource.addImage(80, x, y + 4, 0);
            KUtils.paintNumberR(0, "" + (boutNow < 10 ? "0" + boutNow : "" + boutNow), x + 45, y + 5, 2000);
            Resource.addImage(29, x, y + 22, 0);
            Resource.addImage(13, x, y + 43, 0);
            KUtils.paintNumberR(1, "" + killEnemyNum, x + 45, y + 26, 2000);
            KUtils.drawCrossRect(x + 20, y + 44, 30, 15, 7603468, -1);
            Resource.addRect((byte)1, x + 21, y + 45, 27, 12, false, 0, 0xFFFFFF, 2000);
            Resource.addRect((byte)1, x + 22, y + 46, houseHP * 26 / houseMAX, 11, true, 0, 0xFF0000, 2000);
            if (houseHP > 0 && houseHP < houseMAX / 100) {
                KUtils.paintNumberR(2, "1", x + 46, y + 47, 2000);
            } else {
                KUtils.paintNumberR(2, "" + houseHP * 100 / houseMAX, x + 46, y + 47, 2000);
            }
            Resource.addImage(69, 0, BasicCanvas.screenHeight, 36, 2, 2000);
            Resource.addImage(69, BasicCanvas.screenWidth, BasicCanvas.screenHeight, 40);
            Resource.addImage(75, 0, BasicCanvas.screenHeight - 2, 0, 0, 29, 16, 36);
            Resource.addImage(75, BasicCanvas.screenWidth, BasicCanvas.screenHeight - 2, 0, 16, 29, 16, 40);
            x = 30;
            int w = BasicCanvas.screenWidth - 79;
            KUtils.drawCrossRect(x, BasicCanvas.screenHeight - 13, w, 13, 6696456, 4069632);
            Resource.addRect((byte)1, x + 2, BasicCanvas.screenHeight - 11, GameMainDraw.player.oldVigor * (w - 4) / VigorMax, 9, true, 0, 2188462, 2000);
            Resource.addRect((byte)1, x + 2, BasicCanvas.screenHeight - 11, GameMainDraw.player.vigor * (w - 4) / VigorMax, 9, true, 0, 16753970, 2000);
            Resource.setScreenClip(x, BasicCanvas.screenHeight - 11, w, 5);
            for (int i = 0; i < w / 15 + 1; ++i) {
                Resource.addImage(22, x + 5 + 15 * i, BasicCanvas.screenHeight - 11, 0);
            }
            Resource.closeScreenClip();
            Resource.addImage(21, x - 3 + GameMainDraw.player.vigor * (w - 4) / VigorMax, BasicCanvas.screenHeight - 13, 0);
            KUtils.paintNumberR(1, "" + GameMainDraw.player.vigor, BasicCanvas.screenWidth - x, BasicCanvas.screenHeight - 13, 2000);
            Resource.addImage(20, 0, BasicCanvas.screenHeight - 66, 0);
            int angleX = KUtils.getCosAngleValue(GameMainDraw.player.angle) * 16 / 100000;
            int angleY = KUtils.getSinAngleValue(GameMainDraw.player.angle) * 16 / 100000;
            Resource.addLine(20, BasicCanvas.screenHeight - 47, 20 + angleX, BasicCanvas.screenHeight - 47 - angleY, 0, 65140, 2000);
            Resource.addLine(20, BasicCanvas.screenHeight - 46, 20 + angleX, BasicCanvas.screenHeight - 46 - angleY, 0, 65140, 2000);
            Resource.addRect((byte)1, 18, BasicCanvas.screenHeight - 46, 5, 2, true, 0, 0xFF0000, 2000);
            Resource.addRect((byte)1, 19, BasicCanvas.screenHeight - 48, 3, 5, true, 0, 0xFF0000, 2000);
            KUtils.paintNumber(1, "" + (GameMainDraw.player.angle < 10 ? "0" + GameMainDraw.player.angle : "" + GameMainDraw.player.angle), 10, BasicCanvas.screenHeight - 42, 2000);
            if (isDrawAnger) {
                KUtils.drawCrossRect(BasicCanvas.screenWidth - 30, BasicCanvas.screenHeight - 50, 30, 30, 16774001, -1);
                Resource.addRect((byte)1, BasicCanvas.screenWidth - 29, BasicCanvas.screenHeight - 49, 27, 27, false, 0, 10632964, 2000);
                Resource.addRect((byte)1, BasicCanvas.screenWidth - 28, BasicCanvas.screenHeight - 48, 25, 25, false, 0, 13662470, 2000);
                Resource.addRect((byte)1, BasicCanvas.screenWidth - 27, BasicCanvas.screenHeight - 23 - anger * 24 / angerMax, 24, anger * 24 / angerMax, true, 0, 16707595, 2000);
                if (anger >= angerMax && count % 3 == 1) {
                    Resource.addRect((byte)1, BasicCanvas.screenWidth - 27, BasicCanvas.screenHeight - 47, 24, 24, true, 0, 16691467, 2000);
                }
                Resource.addImage(51, BasicCanvas.screenWidth - 25, BasicCanvas.screenHeight - 45, 20);
            }
            if (boutState == 1) {
                angleX = KUtils.getCosAngleValue(player.getAngle()) * 50 / 10;
                angleY = KUtils.getSinAngleValue(player.getAngle()) * 50 / 10;
                int px = GameMainDraw.player.siteX + (GameMainDraw.player.dir == 0 ? -37 : 37) - viewX;
                int py = GameMainDraw.player.siteY - 27 - viewY;
                for (int i = 0; i < 10; ++i) {
                    Resource.addRect((byte)1, px + angleX * i / 100000, py - angleY * i / 100000, 3, 3, true, 0, 16721160, GameMainDraw.player.siteY - 1);
                }
                if (!beginVigor) {
                    Resource.addImage(62, 0 + (count % 4 > 1 ? -1 : 1), BasicCanvas.screenHeight / 2 - 12, 20, 6, 2000);
                    Resource.addImage(62, BasicCanvas.screenWidth + (count % 4 > 1 ? 1 : -1), BasicCanvas.screenHeight / 2 - 12, 24, 5, 2000);
                }
            }
            this.drawStateProp();
            GameMainDraw.drawShorcut();
        }
    }

    private void drawStateProp() {
        int size = state_prop.size();
        for (int i = 0; i < size; ++i) {
            Prop prop = (Prop)state_prop.elementAt(i);
            prop.paint(52 + 21 * i, BasicCanvas.screenHeight - 42);
        }
    }

    private void statePropLogic() {
        int size = state_prop.size();
        for (int i = size - 1; i >= 0; --i) {
            Prop prop = (Prop)state_prop.elementAt(i);
            prop.logic();
        }
    }

    private void drawEffect(Graphics g) {
        if (!this.drawPlayerStart()) {
            this.drawCountdown();
        }
    }

    private void drawCountdown() {
        if (boutState == 1) {
            if (!DialogueDraw.isDialogue && playerControlAble && !beginVigor && count % 12 == 0) {
                countdown = (short)(countdown - 1);
            }
            if (countdown <= 0) {
                this.enemyBoutStart();
            }
            KUtils.paintNumber(5, countdown > 9 ? "" + countdown : "0" + countdown, BasicCanvas.screenWidth / 2 - KUtils.numWidth[5], 3, 2000);
        }
    }

    private boolean drawPlayerStart() {
        if (this.isDrawZi && houseHP > 0) {
            this.ziX = (short)(this.ziX + this.zispeed);
            if (this.ziState == 0) {
                this.zispeed = (short)(this.zispeed + BasicCanvas.screenWidth / 15);
                if (this.ziX < BasicCanvas.screenWidth / 2 - Resource.getImageWidth(17) / 2) {
                    this.ziX = (short)(BasicCanvas.screenWidth / 2 - Resource.getImageWidth(17) / 2);
                    this.zispeed = 0;
                    this.ziState = (byte)(this.ziState + 1);
                }
            } else {
                this.ziState = (byte)(this.ziState + 1);
                if (this.ziState > 5) {
                    this.zispeed = (short)(this.zispeed - 30);
                }
                if (this.ziX < -200) {
                    this.isDrawZi = false;
                    playerCanAttack = true;
                }
            }
            Resource.addImage(17, this.ziX, this.ziY, 0);
            return true;
        }
        return false;
    }

    public void addHitNum() {
        this.hitNum = (short)(this.hitNum + 1);
        if ((anger = (short)(anger + 4)) >= angerMax) {
            anger = angerMax;
        }
        this.hitShowTime = (byte)30;
    }

    private void drawDoubleHit() {
        if (this.hitNum > 0 && this.hitShowTime > 0) {
            this.hitShowTime = (byte)(this.hitShowTime - 1);
            Resource.addImage(11, BasicCanvas.screenWidth - 2, BasicCanvas.screenHeight / 3, 24);
            KUtils.paintNumberR(6, (this.hitNum < 10 ? "0" : "") + this.hitNum, BasicCanvas.screenWidth - 37, BasicCanvas.screenHeight / 3 + 7, 2000);
        }
    }

    private synchronized void resetNpc() {
        int size = this.deadEnemy.size();
        if (isUpdateGameObj || size > 0) {
            for (int i = size - 1; i >= 0; --i) {
                enemyVector.removeElement(this.deadEnemy.elementAt(i));
                this.deadEnemy.removeElementAt(i);
            }
            GameMainDraw.resetNpcArray(showEnemy);
            isUpdateGameObj = false;
        }
    }

    private void drawMapName(int x, int y) {
        if (!isDrawName || BasicCanvas.isDrawEffect) {
            return;
        }
        boolean isdraw = true;
        nameW = (short)(BasicCanvas.screenWidth + 8);
        if (nameH < BasicCanvas.fontHeight + 4) {
            nameH = (short)(nameH + (BasicCanvas.fontHeight + 2) / 4);
            isdraw = false;
        }
        if (nameH > 0) {
            BasicCanvas.drawCueSkin(x - nameW / 2, y - nameH / 2, nameW, nameH);
        }
        if (isdraw) {
            if ((nameTime = (byte)(nameTime + 1)) > 20) {
                isDrawName = false;
            }
            Resource.addString(mapName, x, y - BasicCanvas.fontHeight / 2, 17, 0xFFFFFF, 2000);
        }
    }

    private void setTeachKey(String str) {
        if (teachKey == null) {
            teachKey = new Vector();
        }
        teachKey.removeAllElements();
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            String key = str.substring(i, i + 1);
            if (key.equals("2")) {
                teachKey.addElement(new Integer(8200));
                continue;
            }
            if (key.equals("4")) {
                teachKey.addElement(new Integer(32800));
                continue;
            }
            if (key.equals("6")) {
                teachKey.addElement(new Integer(65664));
                continue;
            }
            if (key.equals("8")) {
                teachKey.addElement(new Integer(16896));
                continue;
            }
            if (key.equals("5")) {
                teachKey.addElement(new Integer(131136));
                continue;
            }
            if (key.equals("*")) {
                teachKey.addElement(new Integer(2048));
                continue;
            }
            if (key.equals("#")) {
                teachKey.addElement(new Integer(4096));
                continue;
            }
            if (key.equals("7")) {
                teachKey.addElement(new Integer(256));
                continue;
            }
            if (key.equals("9")) {
                teachKey.addElement(new Integer(1024));
                continue;
            }
            if (key.equals("0")) {
                teachKey.addElement(new Integer(2));
                continue;
            }
            if (key.equals("1")) {
                teachKey.addElement(new Integer(4));
                continue;
            }
            if (!key.equals("3")) continue;
            teachKey.addElement(new Integer(16));
        }
        this.isHitKey = new boolean[teachKey.size()];
    }

    public static void setFlashEffect(int t, int c) {
        isFlash = true;
        count = 0;
        flashTime = t;
        flashColor = c;
    }

    private void drawFlash() {
        if (isFlash) {
            if (count % 2 == 0) {
                Resource.addRect((byte)1, 0, 0, BasicCanvas.screenWidth, BasicCanvas.screenHeight, true, 20, flashColor, 2000);
            }
            if (flashTime != 0 && count > flashTime) {
                isFlash = false;
                flashTime = 0;
            }
        }
    }

    private void drawBlack(Graphics g) {
        if (isDrawBlack) {
            if (isBlackClose) {
                if (blackH < BORDERH) {
                    blackH = (short)(blackH + blackS);
                } else if (tempKsox != null) {
                    tempKsox.setWait(true);
                    tempKsox = null;
                }
            } else if (BORDERH > 1) {
                BORDERH = (short)(BORDERH - blackS);
                blackH = (short)(blackH - blackS);
            } else if (tempKsox != null) {
                tempKsox.setWait(true);
                tempKsox = null;
            }
            Resource.addRect((byte)1, 0, 0, BasicCanvas.screenWidth, blackH, true, 20, 0, 2000);
            Resource.addRect((byte)1, 0, BasicCanvas.screenHeight - blackH, BasicCanvas.screenWidth, blackH, true, 20, 0, 2000);
        }
    }

    public static void drawShorcut() {
        for (int i = 0; i < shorcutSite.length; ++i) {
            Resource.addImage(24, shorcutSite[i][0], shorcutSite[i][1], 20);
            if (shorcut_prop[i] != null) {
                shorcut_prop[i].logic();
                shorcut_prop[i].paint(shorcutSite[i][0] + 12, shorcutSite[i][1] + 20);
            }
            KUtils.paintNumber(2, shorcutzi[i], shorcutSite[i][0], shorcutSite[i][1], 2000);
        }
    }

    public static void addShortcut(Prop obj) {
        GameMainDraw.removGoods(obj);
        obj.setState(2);
        for (int i = 0; i < shorcut_prop.length; ++i) {
            if (shorcut_prop[i] != null) continue;
            GameMainDraw.shorcut_prop[i] = obj;
            break;
        }
    }

    public static void clearShortcut(int index) {
        GameMainDraw.shorcut_prop[index] = null;
    }

    public void useShorcut(int index) {
        this.addPlayerSkill(player, shorcut_prop[index]);
        GameMainDraw.clearShortcut(index);
    }

    public void addPlayerSkill(Player obj, Prop p_add) {
        if (p_add != null) {
            p_add.setState(3);
            if (state_prop.size() >= 8) {
                state_prop.removeElementAt(0);
                this.clearAddState((Prop)state_prop.elementAt(0));
            }
            int size = state_prop.size();
            for (int i = 0; i < size; ++i) {
                Prop prop = (Prop)state_prop.elementAt(i);
                if (prop.type != p_add.type) continue;
                if (prop.type == 1) {
                    if (p_add.value != prop.value) continue;
                    state_prop.removeElementAt(i);
                    this.clearAddState(p_add);
                    break;
                }
                if (prop.type == 2) continue;
                state_prop.removeElementAt(i);
                this.clearAddState(p_add);
                break;
            }
            state_prop.addElement(p_add);
            switch (p_add.type) {
                case 1: {
                    obj.shootTime = (byte)(obj.shootTime + p_add.value);
                    break;
                }
                case 4: {
                    obj.attackArea = p_add.value;
                    break;
                }
                case 2: {
                    obj.crit = (short)(obj.crit + p_add.value);
                    break;
                }
                case 3: {
                    obj.bulletNum = p_add.value;
                    break;
                }
                case 5: {
                    obj.shootTime = (byte)2;
                    obj.crit = (short)50;
                    obj.bulletNum = (byte)2;
                    break;
                }
            }
        }
    }

    public void clearAddState(Prop prop) {
        switch (prop.type) {
            case 1: {
                GameMainDraw.player.shootTime = (byte)(GameMainDraw.player.shootTime - prop.value);
                break;
            }
            case 4: {
                GameMainDraw.player.attackArea = 0;
                break;
            }
            case 2: {
                GameMainDraw.player.crit = (short)(GameMainDraw.player.crit - prop.value);
                break;
            }
            case 3: {
                GameMainDraw.player.bulletNum = 0;
                break;
            }
            case 5: {
                GameMainDraw.player.shootTime = 0;
                GameMainDraw.player.crit = 0;
                GameMainDraw.player.bulletNum = 0;
                break;
            }
        }
    }

    private void drawSkill(Graphics g) {
        int size = skillVector.size();
        for (int j = 0; j < size; ++j) {
            Skill sk = (Skill)skillVector.elementAt(j);
            sk.paint(g);
        }
        if (v_effect != null) {
            int length = v_effect.size();
            for (int j = length - 1; j >= 0; --j) {
                GameObj spx = (GameObj)v_effect.elementAt(j);
                spx.paint(spx.siteX - viewX, spx.siteY - viewY, 2000);
            }
        }
    }

    private void paintCue(Graphics g, int x, int y) {
        int size = v_cue.size();
        if (size > 0) {
            String str = (String)v_cue.elementAt(0);
            if (this.cueH < BasicCanvas.fontHeight + 4) {
                this.cueW = (short)(this.cueW + 30);
                this.cueH = (short)(this.cueH + 6);
            } else {
                Resource.addString(str, x, y - (BasicCanvas.fontHeight >> 1), 17, 0xFFFF00, 2000);
                cueTime = (byte)(cueTime - 1);
                if (cueTime < -(size == 1 ? (byte)20 : 10)) {
                    v_cue.removeElementAt(0);
                    this.cueW = 0;
                    this.cueH = 0;
                    cueTime = 0;
                }
            }
        }
    }

    private void drawObj(Graphics g) {
        if (npcArray != null) {
            int length = npcArray.length;
            for (int i = 0; i < length; ++i) {
                if (npcArray[i] == null || !GameMainDraw.npcArray[i].isAlive || GameMainDraw.isOutScreen(npcArray[i])) continue;
                npcArray[i].paint(GameMainDraw.npcArray[i].siteX - GameMainDraw.getViewX(), GameMainDraw.npcArray[i].siteY - GameMainDraw.getViewY());
            }
        }
        int length1 = arrowVector.size();
        for (int i = length1 - 1; i >= 0; --i) {
            GameObj arrow = (GameObj)arrowVector.elementAt(i);
            arrow.paint(arrow.siteX - GameMainDraw.getViewX(), arrow.siteY - GameMainDraw.getViewY());
        }
    }

    public void release() {
    }

    public static void toPlayerCamera(GameObj obj) {
        if (obj == null) {
            return;
        }
        int cameraTargetX = obj.siteX - GameMainDraw.getViewWidth() / 2;
        int cameraTargetY = obj.siteY - GameMainDraw.getViewHeight() / 2;
        cameraTargetX = Math.max(cameraTargetX, cameraX);
        cameraTargetY = Math.max(cameraTargetY, cameraY);
        cameraTargetX = Math.min(cameraTargetX, cameraWidth - GameMainDraw.getViewWidth());
        cameraTargetY = Math.min(cameraTargetY, cameraHeight - GameMainDraw.getViewHeight());
        GameMainDraw.setViewPosition(cameraTargetX, cameraTargetY);
        cameraFocusStateNow = (byte)2;
        cameraObj = obj;
    }

    public static void setMapName(String name) {
        mapName = name;
        nameW = 0;
        nameH = 0;
        nameTime = 0;
        isDrawName = true;
    }

    private static void savePlayer(KFile file) {
        try {
            file.writeUTF(GameMainDraw.player.name);
            file.writeShort(GameMainDraw.player.level);
            file.writeInt(GameMainDraw.player.exercise);
            file.writeShort(GameMainDraw.player.mostHp);
            file.writeShort(GameMainDraw.player.hp);
            file.writeShort(GameMainDraw.player.mostMp);
            file.writeShort(GameMainDraw.player.mp);
            file.writeShort(GameMainDraw.player.attack);
            file.writeShort(GameMainDraw.player.recovery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initPlayer(int id) {
        Player player = new Player(this);
        player.initPlayer(id);
        GameMainDraw.setPlayer(player);
    }

    public static void saveMainRms() {
        KFile kf = new KFile();
        KFile.delete(rmsName);
        kf.open(rmsName, 6);
        try {
            int i;
            for (i = 0; i < activateLevels.length; ++i) {
                kf.writeByte(activateLevels[i]);
            }
            for (i = 0; i < star.length; ++i) {
                for (int j = 0; j < star[i].length; ++j) {
                    kf.writeByte(star[i][j]);
                }
            }
            int length = label.length;
            for (int i2 = 0; i2 < length; ++i2) {
                kf.writeByte(label[i2]);
            }
            kf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        MenuDraw.saveNoteRms();
    }

    public static void loadMainRms() {
        KFile loadKf = new KFile();
        boolean loadIs = loadKf.open(rmsName, 1);
        if (loadIs) {
            try {
                int i;
                for (i = 0; i < activateLevels.length; ++i) {
                    GameMainDraw.activateLevels[i] = loadKf.readByte();
                }
                for (i = 0; i < star.length; ++i) {
                    for (int j = 0; j < star[i].length; ++j) {
                        GameMainDraw.star[i][j] = loadKf.readByte();
                    }
                }
                int length = label.length;
                for (int i2 = 0; i2 < length; ++i2) {
                    GameMainDraw.label[i2] = loadKf.readByte();
                }
                loadKf.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void newGame() {
    }

    public static int getLabel(int index) {
        if (index >= label.length) {
            BasicCanvas.Debug("getLabel wrong:" + index + " >=" + label.length);
            return -1;
        }
        return label[index];
    }

    public static void setLabel(int index, int size) {
        if (index >= label.length) {
            BasicCanvas.Debug("setLabel wrong:" + index + " >=" + label.length);
            return;
        }
        GameMainDraw.label[index] = (byte)size;
    }

    public static int getSaveLabel(int index) {
        if (index >= savelabel.length) {
            BasicCanvas.Debug("getSaveLabel wrong:" + index + " >=" + savelabel.length);
            return -1;
        }
        return savelabel[index];
    }

    public static void setSaveLabel(int index, int size) {
        if (index >= savelabel.length) {
            BasicCanvas.Debug("setSaveLabel wrong:" + index + " >=" + savelabel.length);
            return;
        }
        GameMainDraw.savelabel[index] = (byte)size;
    }

    private boolean callInfoAPI(KScriptObjectX obj, String method) {
        if (method.equals("getLabel")) {
            int index = obj.getInt();
            obj.setRetVal(GameMainDraw.getLabel(index));
            System.out.println("-----getLabel------  " + index + " " + GameMainDraw.getLabel(index));
        } else if (method.equals("setLabel")) {
            int size = obj.getInt();
            int index = obj.getInt();
            GameMainDraw.setLabel(index, size);
            System.out.println("-----setLabel------  " + index + " " + size);
        } else if (method.equals("getSaveLabel")) {
            int index = obj.getInt();
            obj.setRetVal(GameMainDraw.getSaveLabel(index));
        } else if (method.equals("setSaveLabel")) {
            int size = obj.getInt();
            int index = obj.getInt();
            GameMainDraw.setSaveLabel(index, size);
            MenuDraw.saveNoteRms();
        } else {
            return false;
        }
        return true;
    }

    public boolean isLoadMap(String mapName) {
        int index = mapName.lastIndexOf(47);
        path = null;
        path = index < 1 ? "" : mapName.substring(0, index);
        this.is = "a".getClass().getResourceAsStream(mapName);
        boolean bl = this.isOpen = this.is != null;
        if (!this.isOpen) {
            System.out.println("\u5730\u56fe\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef  " + mapName);
        }
        return this.isOpen;
    }

    /*
     * Exception decompiling
     */
    public boolean loadMap(int index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 25[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int getColumns() {
        return columns;
    }

    public static int getRows() {
        return rows;
    }

    public void setView(int viewX, int viewY, int viewWidth, int viewHeight) {
        GameMainDraw.setViewPosition(viewX, viewY);
        this.setViewSize(viewWidth, viewHeight);
    }

    public static void setViewPosition(int vx, int vy) {
        if (vx < 0) {
            viewX = 0;
        } else if (vx + viewWidth > mapWidth) {
            viewX = mapWidth - viewWidth;
            if (viewX < 0) {
                viewX = 0;
            }
        } else {
            viewX = vx;
        }
        if (vy < 0) {
            viewY = 0;
        } else if (vy + viewHeight > mapHeight) {
            viewY = mapHeight - viewHeight;
            if (viewY < 0) {
                viewY = 0;
            }
        } else {
            viewY = vy;
        }
    }

    public void setViewSize(int vw, int vh) {
        viewWidth = vw < 0 ? 0 : (vw > mapWidth ? vw : vw);
        viewHeight = vh < 0 ? 0 : (vh > mapHeight ? vh : vh);
    }

    public void moveView(int dx, int dy) {
        GameMainDraw.setViewPosition(viewX + dx, viewY + dy);
    }

    public static int getViewX() {
        return viewX;
    }

    public static int getViewY() {
        return viewY;
    }

    public static int getViewWidth() {
        return viewWidth;
    }

    public static int getViewHeight() {
        return viewHeight;
    }

    public static void initYeZi() {
        isDrawPiaoYeZi = true;
        spx_yezi = Resource.getKSpriteX("yezi", "yezi");
        yeziAct = new byte[yezinum];
        yeziX = new short[yezinum];
        yeziY = new short[yezinum];
        yeziSpeed = new byte[yezinum];
        yeziShow = new byte[yezinum];
        yeziTime = new byte[yezinum];
        for (int i = 0; i < yezinum; ++i) {
            GameMainDraw.yeziX[i] = (short)(viewX + KUtils.genRand(BasicCanvas.screenWidth / 4, BasicCanvas.screenWidth * 2));
            GameMainDraw.yeziY[i] = (short)(viewY + KUtils.genRand(-20, BasicCanvas.screenHeight / 4));
            GameMainDraw.yeziSpeed[i] = (byte)(KUtils.genRand(4, 6) * 3);
            GameMainDraw.yeziShow[i] = (byte)(i * KUtils.genRand(2, 8));
        }
    }

    public static void clearYeZi() {
        isDrawPiaoYeZi = false;
        spx_yezi = null;
        yeziAct = null;
        yeziX = null;
        yeziY = null;
        yeziSpeed = null;
        yeziShow = null;
        yeziTime = null;
    }

    public void drawPiaoYeZi() {
        for (int i = 0; i < yezinum; ++i) {
            if (yeziShow[i] <= 0) {
                spx_yezi.setAction(yeziAct[i]);
                spx_yezi.paint(yeziX[i] - viewX, yeziY[i] - viewY, 2000);
                int n = i;
                yeziTime[n] = (byte)(yeziTime[n] + 1);
                if (yeziAct[i] < 1) {
                    int n2 = i;
                    yeziX[n2] = (short)(yeziX[n2] - 6);
                } else {
                    int n3 = i;
                    yeziX[n3] = (short)(yeziX[n3] - 15);
                }
                int n4 = i;
                yeziY[n4] = (short)(yeziY[n4] + yeziSpeed[i]);
                if (yeziTime[i] % 8 == 4) {
                    int n5 = i;
                    yeziAct[n5] = (byte)(yeziAct[n5] + 1);
                }
                if (yeziAct[i] < 4 && yeziY[i] - viewY <= BasicCanvas.screenHeight - 50) continue;
                GameMainDraw.yeziAct[i] = 0;
                GameMainDraw.yeziX[i] = (short)(viewX + KUtils.genRand(BasicCanvas.screenWidth / 4, BasicCanvas.screenWidth * 2));
                GameMainDraw.yeziY[i] = (short)(viewY + KUtils.genRand(-20, BasicCanvas.screenHeight / 4));
                GameMainDraw.yeziShow[i] = (byte)(i * KUtils.genRand(2, 8));
                GameMainDraw.yeziTime[i] = 0;
                continue;
            }
            int n = i;
            yeziShow[n] = (byte)(yeziShow[n] - 1);
        }
    }

    private static void initRainPos(int i) {
        GameMainDraw.starPos[i][0] = (short)(Math.abs(rnd.nextInt()) % (screenWidth * 3) - screenWidth);
        GameMainDraw.starPos[i][1] = (short)(-Math.abs(rnd.nextInt()) % screenHeight);
        GameMainDraw.starSpeed[i] = (byte)(Math.abs(rnd.nextInt()) % 10 + speedOfScroll);
        GameMainDraw.starIndex[i] = 0;
    }

    public static void initStar() {
        starPos = new short[80][2];
        starSpeed = new byte[80];
        starIndex = new short[80];
        for (int i = 0; i < 80; ++i) {
            GameMainDraw.initRainPos(i);
        }
        isDrawStar = true;
    }

    public static void moveStar() {
        for (int i = 0; i < 80; ++i) {
            if (starIndex[i] >= 0) {
                short[] sArray = starPos[i];
                sArray[1] = (short)(sArray[1] + starSpeed[i]);
                if (rain_dir != 0) {
                    short[] sArray2 = starPos[i];
                    sArray2[0] = (short)(sArray2[0] + rain_dir * starSpeed[i] / 2);
                }
                int n = i;
                starIndex[n] = (short)(starIndex[n] + starSpeed[i]);
                if (starIndex[i] <= screenHeight - 60) continue;
                GameMainDraw.starIndex[i] = -1;
                short[] sArray3 = starPos[i];
                sArray3[1] = (short)(sArray3[1] + GameMainDraw.getViewY());
                short[] sArray4 = starPos[i];
                sArray4[0] = (short)(sArray4[0] + GameMainDraw.getViewX());
                continue;
            }
            int n = i;
            starIndex[n] = (short)(starIndex[n] - 1);
            if (starIndex[n] >= -2) continue;
            GameMainDraw.initRainPos(i);
        }
    }

    public static void clearStar() {
        starPos = null;
        starSpeed = null;
        starIndex = null;
        isDrawStar = false;
    }

    public static void drawStar(Graphics g) {
        if (starPos == null) {
            GameMainDraw.initStar();
        }
        for (int i = 0; i < 80; ++i) {
            if (starIndex[i] >= 0) {
                if (GameMainDraw.isOutScreen(starPos[i][0] + GameMainDraw.getViewX(), starPos[i][1] + GameMainDraw.getViewY(), 10, 10)) continue;
                for (int j = 0; j < 3; ++j) {
                    Resource.addLine(starPos[i][0] + j * rain_dir, starPos[i][1] + 2 * j, starPos[i][0] + (j + 1) * rain_dir, starPos[i][1] + 2 * (j + 1), 0, 0xCCCCCC - 0x222222 * j, 10);
                }
                continue;
            }
            if (GameMainDraw.isOutScreen(starPos[i][0], starPos[i][1], 10, 10)) continue;
            byte index = (byte)starIndex[i];
            g.setColor(0x888888);
            g.drawArc(starPos[i][0] + index - GameMainDraw.getViewX(), starPos[i][1] + 5 + index - GameMainDraw.getViewY(), -index * 2, (int)(-index), 0, 360);
            Resource.addArcRound(2, starPos[i][0] + index - GameMainDraw.getViewX(), starPos[i][1] + 5 + index - GameMainDraw.getViewY(), -index * 2, -index, 0, 360, false, 0, 0x888888, 10);
        }
        GameMainDraw.moveStar();
    }

    public static void initDot() {
        isDrawDot = true;
        int w = BasicCanvas.screenWidth / 3;
        int h = BasicCanvas.screenHeight / 2;
        spx_dot = new KSpriteX[6];
        dotShow = new byte[6];
        for (int i = 0; i < dotShow.length; ++i) {
            GameMainDraw.spx_dot[i] = Resource.getKSpriteX("sxx", "sxx");
            spx_dot[i].setPosition(viewX + w * (i % 4) + KUtils.genRand(-30, 30), viewY + h * (i / 3) + KUtils.genRand(-20, 20));
            GameMainDraw.dotShow[i] = (byte)KUtils.genRand(0, 30);
        }
    }

    public static void drawDot() {
        int w = BasicCanvas.screenWidth / 4;
        int h = BasicCanvas.screenHeight / 4;
        for (int i = 0; i < spx_dot.length; ++i) {
            if (dotShow[i] <= 0) {
                int x = spx_dot[i].getX();
                int y = spx_dot[i].getY();
                spx_dot[i].paintSite(x - viewX, y - viewY, 2);
                spx_dot[i].update();
                if (!spx_dot[i].ActionIsOver()) continue;
                spx_dot[i].setPosition(viewX + w * (i % 4) + KUtils.genRand(-30, 30), viewY + h * (i / 3) + KUtils.genRand(-20, 20));
                GameMainDraw.dotShow[i] = (byte)KUtils.genRand(0, 30);
                continue;
            }
            int n = i;
            dotShow[n] = (byte)(dotShow[n] - 1);
        }
    }

    public static void clearDot() {
        spx_dot = null;
        dotShow = null;
        isDrawDot = false;
    }

    public static void initYun() {
        isDrawYun = true;
        yunX = new short[2];
        yunY = new short[2];
        for (int i = 0; i < yunX.length; ++i) {
            GameMainDraw.yunX[i] = (short)(i * mapWidth / 2 - 180);
            GameMainDraw.yunY[i] = (short)(-20 + i * 100);
        }
    }

    public void drawYun() {
        for (int i = 0; i < yunX.length; ++i) {
            Resource.addImage(79, yunX[i] - viewX, yunY[i] - viewY, 20, 0, 2);
        }
        yunX[0] = (short)(yunX[0] + 1);
        yunX[1] = (short)(yunX[1] - 1);
        if (yunX[0] > mapWidth) {
            GameMainDraw.yunX[0] = (short)Resource.getImageWidth(79);
        }
        if (yunX[1] < 0) {
            GameMainDraw.yunX[1] = mapWidth;
        }
    }

    public static void clearYun() {
        isDrawYun = false;
        yunX = null;
        yunY = null;
    }

    static {
        boxVector = new Vector();
        enemyVector = new Vector();
        skillVector = new Vector();
        arrowVector = new Vector();
        elementVector = new Vector();
        goodsVector = new Vector();
        playerCanAttack = true;
        titleSide = null;
        activateLevels = new byte[2];
        levelsMax = (byte)20;
        AngleMax = (short)80;
        AngleMin = (short)20;
        VigorMax = (short)70;
        isDrawAnger = true;
        angerMax = (short)100;
        anger = 0;
        tempBoutState = 0;
        boutStartDefer = 0;
        boutState = 0;
        boutNow = (byte)10;
        enemyMax = (short)20;
        enemyMin = (short)20;
        killEnemyNum = (short)20;
        houseHP = (short)20;
        houseMAX = (short)100;
        star = new byte[2][levelsMax];
        countdown = 0;
        isDrop = true;
        hitBasicScore = (short)50;
        isCanKeyKill = false;
        isCanKeyNum1 = true;
        v_cue = new Vector();
        showMapEnemy = true;
        showEnemy = true;
        oldLoadEnemy = true;
        missionName = "\u627e\u56de\u5931\u843d\u7684\u8bb0\u5fc6";
        missionInfo = "\u627e\u56de\u5931\u843d\u7684\u8bb0\u5fc6\u770b\u89c1\u523b\u5f55\u673a\u627e\u56de\u5931\u843d\u7684\u8bb0\u5fc6\u4f7f\u5f97\u6492\u5a07\u7684";
        imgList = new Vector();
        count = 0;
        tremor = 0;
        tremorCount = 0;
        enemyIsRun = true;
        enemyAI = true;
        judgeEnmeyId = (short)-1;
        judgeEnmeyNum = (short)-1;
        guardBout = (short)-1;
        v_effect = null;
        isDrawNoMap = false;
        shorcutSite = new short[][]{{40, (short)(BasicCanvas.screenHeight - 36)}, {70, (short)(BasicCanvas.screenHeight - 36)}, {(short)(BasicCanvas.screenWidth - 93), (short)(BasicCanvas.screenHeight - 36)}, {(short)(BasicCanvas.screenWidth - 63), (short)(BasicCanvas.screenHeight - 36)}};
        shorcutzi = new String[]{"1", "3", "7", "9"};
        shorcut_prop = new Prop[4];
        state_prop = new Vector();
        blackS = (short)3;
        BORDERH = (short)50;
        isDrawHP = true;
        flashColor = 0;
        file = null;
        mapName = "\u5730\u56fe";
        label = new byte[100];
        savelabel = new byte[30];
        yezinum = (byte)50;
        speedOfScroll = (byte)10;
        rain_dir = 1;
        rnd = new Random();
    }
}

