/*
 * Decompiled with CFR 0.152.
 */
package basic;

import basic.BasicCanvas;
import basic.KSpriteX;
import basic.Resource;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;

public class KUtils {
    public static final int STRING_FORMAT_UNICODE = 0;
    public static final int STRING_FORMAT_UTF8 = 1;
    public static final int STRING_FORMAT_GB2312 = 2;
    public static boolean isSay = true;
    public static boolean isDead = true;
    public static boolean isSuper = false;
    public static boolean isMinus = true;
    public static boolean loadSprictRc = false;
    public static boolean SprictSplit = false;
    public static boolean isDrawTest = false;
    private static Random random = new Random();
    public static short[] numPng = new short[9];
    public static byte[] numWidth = new byte[9];
    public static byte[] numHeight = new byte[9];
    static short BUFFERSIZE = (short)1024;
    private static short textY = 0;
    private static short textH = 0;
    private static short fontY = 0;
    private static short oldY = 0;
    private static String oldStr = "";
    private static Vector text;
    private static short rollCount;
    public static byte textRow;
    public static short textHeight;
    public static boolean rollEnd;
    static int[] angleValue;
    static int tempAngle;
    static int tempValue;

    public static int apxSin(int x1k) {
        int p = 1;
        if ((x1k = 1000 * x1k / 360 % 1000) < 0) {
            x1k += 1000;
        }
        if (x1k > 250) {
            if (x1k < 500) {
                x1k = 500 - x1k;
            } else if (x1k < 750) {
                p = -1;
                x1k -= 500;
            } else {
                p = -1;
                x1k = 1000 - x1k;
            }
        }
        x1k = x1k * 3141 * 2 / 1000;
        int sq = x1k * x1k / 1000;
        long ret = x1k * 1000000 + x1k * (-sq / 6 * 1000 + sq * sq / 120);
        return (int)(ret / 1005000L) * p;
    }

    public static int apxCos(int x1k) {
        return KUtils.apxSin(x1k + 250);
    }

    public static final int sqrt(int n) {
        long res = 0L;
        if (n > 0) {
            res = 1L;
            res = (res + (long)n / res) / 2L;
            while (res * res > (long)n) {
                res = (res + (long)n / res) / 2L;
            }
        }
        return (int)res;
    }

    public static byte[] readStream(InputStream in, int bufferSize) throws IOException {
        if (bufferSize <= 0) {
            bufferSize = BUFFERSIZE;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(bufferSize);
        byte[] buf = new byte[BUFFERSIZE];
        int n = 0;
        while ((n = in.read(buf)) >= 0) {
            bout.write(buf, 0, n);
        }
        buf = null;
        return bout.toByteArray();
    }

    public static void paintNumber(int index, String sNum, int x, int y, int drawLevel) {
        KUtils.paintNumber(index, sNum, x, y, numWidth[index], numHeight[index], drawLevel);
    }

    public static void paintNumber(int index, String sNum, int x, int y, int w, int h, int drawLevel) {
        char[] aChar = sNum.toCharArray();
        int length = aChar.length;
        for (int i = 0; i < length; ++i) {
            KUtils.paintOneNum(numPng[index], aChar[i] - 48, x + i * w, y, w, h, drawLevel);
        }
    }

    public static void paintNumberR(int index, String sNum, int x, int y, int drawLevel) {
        KUtils.paintNumberR(index, sNum, x, y, numWidth[index], numHeight[index], drawLevel);
    }

    public static void paintNumberR(int index, String sNum, int x, int y, int w, int h, int drawLevel) {
        char[] aChar = sNum.toCharArray();
        int length = aChar.length;
        int begin = 0;
        for (int i = length - 1; i >= 0; --i) {
            KUtils.paintOneNum(numPng[index], aChar[i] - 48, x - ++begin * w, y, w, h, drawLevel);
        }
    }

    public static void paintOneNum(int img, int num, int x, int y, int w, int h, int drawLevel) {
        if (num == -1 || num == -5) {
            num = 10;
        } else if (num == -6) {
            num = 11;
        } else if (num == -13) {
            num = 12;
        } else if (num == -11) {
            num = 13;
        } else if (num < 0 || num > 9) {
            BasicCanvas.Debug("paintOneNum wrong :" + num);
        }
        Resource.addImage(img, x, y, num * w, 0, w, h, 20, 0, drawLevel);
    }

    public static InputStream loadResource(String name) {
        return name.getClass().getResourceAsStream(name);
    }

    public static byte[] loadResourceData(String name) {
        byte[] dat = null;
        InputStream is = KUtils.loadResource(name);
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = 0;
        try {
            while ((len = is.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        dat = baos.toByteArray();
        return dat;
    }

    public static int genRand(int range) {
        return Math.abs(random.nextInt()) % range;
    }

    public static int genRand(int min, int max) {
        return KUtils.genRand(Math.abs(max - min) + 1) + Math.min(min, max);
    }

    public static String[] splitString(String src, char ch) {
        if (src == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int index = 0;
        int length = src.length();
        for (int i = 0; i < length; ++i) {
            if (src.charAt(i) == ch) {
                if (i - index >= 1) {
                    v.addElement(src.substring(index, i));
                }
                index = i + 1;
                continue;
            }
            if (i != length - 1) continue;
            v.addElement(src.substring(index, length));
        }
        int size = v.size();
        if (size == 0) {
            return null;
        }
        String[] s = new String[size];
        for (int i = 0; i < size; ++i) {
            s[i] = (String)v.elementAt(i);
        }
        return s;
    }

    public static int getMaxLength(String[] obj) {
        int stringW = 0;
        for (int i = 0; i < obj.length; ++i) {
            int w = BasicCanvas.fontStyle.stringWidth(obj[i]);
            if (w <= stringW) continue;
            stringW = w;
        }
        return stringW;
    }

    public static final int[] expandArray(int[] oldArray, int expandBy) {
        int[] newArray = new int[oldArray.length + expandBy];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    public static final int[] addArrayElement(int[] oldArray, int element) {
        int[] newArray = new int[oldArray.length + 1];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static final int[] removeArrayElement(int[] oldArray, int index) {
        if (oldArray == null) {
            System.out.println("\u6570\u7ec4\u4e3a\u7a7a");
            return null;
        }
        int[] temp = oldArray;
        if (temp.length > 0) {
            int i;
            oldArray = new int[temp.length - 1];
            for (i = 0; i < index; ++i) {
                oldArray[i] = temp[i];
            }
            for (i = index; i < oldArray.length; ++i) {
                oldArray[i] = temp[i + 1];
            }
        }
        return oldArray;
    }

    public static int readByte(InputStream is) throws IOException {
        int ch = is.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public static int readDWord(InputStream is, int mode) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read()) | (ch3 = is.read()) | (ch4 = is.read())) < 0) {
            throw new EOFException();
        }
        if (mode == 0) {
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }
        return (ch1 << 0) + (ch2 << 8) + (ch3 << 16) + (ch4 << 24);
    }

    public static int readWord(InputStream is, int mode) throws IOException {
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read())) < 0) {
            throw new EOFException();
        }
        if (mode == 0) {
            return (ch1 << 8) + (ch2 << 0);
        }
        return (ch1 << 0) + (ch2 << 8);
    }

    public static String readString(InputStream is, int format) {
        try {
            switch (format) {
                case 0: {
                    StringBuffer sb = new StringBuffer();
                    int size = KUtils.readByte(is);
                    sb.setLength(size);
                    for (int i = 0; i < size; ++i) {
                        char ch = (char)KUtils.readWord(is, 1);
                        sb.setCharAt(i, ch);
                    }
                    return sb.toString();
                }
            }
            BasicCanvas.Debug("\u4e0d\u652f\u6301\u7684\u683c\u5f0f:" + format);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            BasicCanvas.Debug("\u5b57\u7b26\u4e32\u683c\u5f0f\u9519\u8bef:" + format);
        }
        return null;
    }

    public static void wrap(String value, Font font, int firstLineWidth, int lineWidth, Vector list) {
        char[] valueChars = value.toCharArray();
        int startPos = 0;
        int lastSpacePos = -1;
        int lastSpacePosLength = 0;
        int currentLineWidth = 0;
        for (int i = 0; i < valueChars.length; ++i) {
            char c = valueChars[i];
            currentLineWidth += font.charWidth(c);
            if (c == '\n') {
                list.addElement(new String(valueChars, startPos, i - startPos));
                lastSpacePos = -1;
                startPos = i + 1;
                currentLineWidth = 0;
                firstLineWidth = lineWidth;
                i = startPos;
                continue;
            }
            if (currentLineWidth >= firstLineWidth && i > 0) {
                if (lastSpacePos == -1) {
                    list.addElement(new String(valueChars, startPos, --i - startPos));
                    startPos = i;
                    currentLineWidth = 0;
                } else {
                    currentLineWidth -= lastSpacePosLength;
                    list.addElement(new String(valueChars, startPos, lastSpacePos - startPos));
                    startPos = lastSpacePos + 1;
                    lastSpacePos = -1;
                }
                firstLineWidth = lineWidth;
                continue;
            }
            if (c != ' ' && c != '\t') continue;
            lastSpacePos = i;
            lastSpacePosLength = currentLineWidth;
        }
        list.addElement(new String(valueChars, startPos, valueChars.length - startPos));
    }

    public static int getFactRow() {
        return -fontY / (BasicCanvas.fontHeight + 1);
    }

    public static void addFactRow(int r) {
        fontY = (short)(fontY + (short)((BasicCanvas.fontHeight + 1) * r));
    }

    public static int getShowRow() {
        return textH / (BasicCanvas.fontHeight + 1);
    }

    public static void clearText() {
        fontY = 0;
        oldStr = "";
        rollCount = 0;
        text = null;
        rollEnd = false;
    }

    public static final void drawRollText(String str, int x, int y, int w, int h, int anchor, int color, boolean isRoll, int layout) {
        if (str == null) {
            return;
        }
        textY = (short)y;
        textH = (short)h;
        if (!oldStr.equals(str) || textY != oldY) {
            fontY = 0;
            oldStr = str;
            oldY = textY;
            rollCount = 0;
            text = null;
            rollEnd = false;
        }
        if (text == null) {
            int length = str.length();
            int width = 0;
            int start = 0;
            int oldAnchor = anchor;
            text = new Vector();
            for (int i = 0; i < length; ++i) {
                if (i < length - 2) {
                    boolean is = false;
                    if (str.substring(i, i + 2).equals("/n")) {
                        text.addElement(str.substring(start, i));
                        text.addElement("" + anchor);
                        is = true;
                    }
                    if (str.substring(i, i + 2).equals("/m")) {
                        text.addElement(str.substring(start, i));
                        text.addElement("" + anchor);
                        is = true;
                        anchor = 17;
                    }
                    if (is) {
                        start = i += 2;
                        if (i < length - 3) {
                            width = BasicCanvas.fontStyle.stringWidth(str.substring(i + 2, i + 3));
                        }
                    }
                }
                if ((width += BasicCanvas.fontStyle.stringWidth(str.substring(i, i + 1))) >= w) {
                    text.addElement(str.substring(start, i));
                    text.addElement("" + anchor);
                    start = i;
                    width = BasicCanvas.fontStyle.stringWidth(str.substring(i, i + 1));
                    if (anchor != oldAnchor) {
                        anchor = oldAnchor;
                    }
                }
                if (i != length - 1) continue;
                text.addElement(str.substring(start, length));
                text.addElement("" + anchor);
            }
        }
        byte fontHeight = (byte)(BasicCanvas.fontHeight + 1);
        short posY = (short)(textY + fontY);
        short factH = 0;
        int clipX = x;
        int clipY = y;
        if (anchor == 17) {
            clipX = x - w / 2 + 1;
        } else if (anchor == 33) {
            clipX = x - w / 2 + 1;
            clipY = y - fontHeight;
        }
        if (text != null) {
            int size = text.size();
            textRow = (byte)(size >> 1);
            for (int j = 0; j < size; j += 2) {
                Resource.addString((String)text.elementAt(j), x, posY, clipX, clipY, w, h, Integer.parseInt((String)text.elementAt(j + 1)), color, layout);
                if (posY >= y) {
                    factH = (short)(factH + fontHeight);
                }
                posY = (short)(posY + fontHeight);
            }
            textHeight = (short)(fontHeight * textRow);
        }
        if (isRoll && textHeight > h) {
            if ((rollCount = (short)(rollCount + 1)) > 1030) {
                fontY = (short)(fontY + 2);
            } else if (rollCount > (rollEnd ? (short)40 : 15) && rollCount < 1000) {
                fontY = (short)(fontY - 2);
            }
            if (fontY < h - textHeight) {
                fontY = (short)(h - textHeight);
                rollCount = (short)1000;
            } else if (fontY > 0) {
                fontY = 0;
                rollCount = 0;
            }
        }
        if (fontY <= h - textHeight) {
            rollEnd = true;
        }
    }

    public static void drawRollText(String str, int x, int y, int w, int h, int anchor, int color) {
        KUtils.drawRollText(str, x, y, w, h, anchor, color, true, 2000);
    }

    public static final void drawText(String str, int x, int y, int w, int anchor, int color) {
        KUtils.drawRollText(str, x, y, w, BasicCanvas.screenHeight, anchor, color);
    }

    public static void drawNormalRect(int x, int y, int width, int height, int[] color, int bgColor) {
        Resource.addRect((byte)1, x + color.length, y + color.length, width - color.length, height - color.length, true, 20, bgColor, 2000);
        for (int i = 0; i < color.length; ++i) {
            Resource.addRect((byte)1, x + i, y + i, width - 1 - i * 2, height - 1 - i * 2, false, 20, color[i], 2000);
        }
    }

    public static void drawCrossRect(int x, int y, int w, int h, int color, int bgColor) {
        Resource.addRect((byte)1, x, y + 1, w - 1, h - 3, false, 20, color, 2000);
        Resource.addRect((byte)1, x + 1, y, w - 3, h - 1, false, 20, color, 2000);
        if (bgColor >= 0) {
            Resource.addRect((byte)1, x + 1, y + 1, w - 2, h - 2, true, 20, bgColor, 2000);
        }
    }

    public static final void testNewline(String str, int w, Vector list) {
        if (str == null || list == null) {
            return;
        }
        int length = str.length();
        int fontHeight = BasicCanvas.fontHeight + 1;
        int width = 0;
        int start = 0;
        int posY = 0;
        for (int i = 0; i < length && !str.endsWith("/n"); ++i) {
            if (i < length - 2 && str.substring(i, i + 2).equals("/n")) {
                list.addElement(str.substring(start, i));
                start = i += 2;
                posY += fontHeight;
                if (i + 3 >= length) break;
                width = BasicCanvas.fontStyle.stringWidth(str.substring(i + 2, i + 3));
            }
            if ((width += BasicCanvas.fontStyle.stringWidth(str.substring(i, i + 1))) >= w) {
                list.addElement(str.substring(start, i));
                start = i;
                posY += fontHeight;
                if (i >= length - 1) break;
                width = BasicCanvas.fontStyle.stringWidth(str.substring(i, i + 1));
            }
            if (i != length - 1) continue;
            list.addElement(str.substring(start, length));
            break;
        }
    }

    public static boolean hit(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        if (w1 == 0 || h1 == 0 || w2 == 0 || h2 == 0) {
            return false;
        }
        return x1 <= x2 + w2 && x2 <= x1 + w1 && y1 <= y2 + h2 && y2 <= y1 + h1;
    }

    public static boolean hit(KSpriteX hit1, KSpriteX hit2, int index, int index2) {
        short[] site = hit1.getCollision(index);
        short[] site2 = hit2.getCollision(index2);
        if (site == null || site2 == null || site[2] == 0 || site[3] == 0 || site2[2] == 0 || site2[3] == 0) {
            return false;
        }
        return KUtils.hit(site[0] + hit1.getX(), site[1] + hit1.getY(), site[2], site[3], site2[0] + hit2.getX(), site2[1] + hit2.getY(), site2[2], site2[3]);
    }

    public static final short[] IntValueOfSting(String[] str) {
        if (str != null) {
            short[] temp = new short[str.length];
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = (short)Integer.parseInt(str[i]);
            }
            return temp;
        }
        return null;
    }

    static void loadAngleValue() {
        angleValue = new int[]{0, 1745, 3490, 5236, 6976, 8716, 10453, 12187, 13917, 15643, 17365, 19081, 20791, 22495, 24192, 25882, 27564, 29237, 30902, 32557, 34202, 35837, 37461, 39073, 40674, 42262, 43837, 45400, 46947, 48481, 50000, 51504, 52992, 54464, 55919, 57357, 58779, 60181, 61566, 62932, 64279, 66913, 68200, 69466, 70711, 71934, 73135, 74314, 75471, 76604, 77715, 78801, 79864, 80902, 81915, 82904, 83867, 84805, 85717, 86603, 87462, 88295, 89101, 89879, 90631, 91355, 92050, 92718, 93358, 93969, 94552, 95106, 95630, 96126, 96593, 97030, 97437, 97815, 98163, 98480, 98769, 99027, 99255, 99452, 99619, 99756, 99863, 99939, 99985, 100000};
    }

    public static int getSinAngleValue(int angle) {
        tempAngle = angle > 90 ? 180 - angle : angle;
        tempValue = angleValue[tempAngle];
        return tempValue;
    }

    public static int getCosAngleValue(int angle) {
        tempAngle = angle > 90 ? angle - 90 : 90 - angle;
        tempValue = angleValue[tempAngle];
        return angle <= 90 ? tempValue : -tempValue;
    }

    static {
        textRow = 0;
        textHeight = 0;
    }
}

