/*
 * Decompiled with CFR 0.152.
 */
package Actor;

import Actor.GameObj;
import basic.KDBTable;
import basic.KSpriteX;
import basic.Resource;
import draw.GameMainDraw;

public class Prop
extends GameObj {
    public static KSpriteX goods = Resource.getKSpriteX("/goods.sprite", "/goods.png");
    public static final byte TYPE_TIME = 1;
    public static final byte TYPE_POWER = 2;
    public static final byte TYPE_NUM = 3;
    public static final byte TYPE_MAGNIFY = 4;
    public static final byte TYPE_ALL = 5;
    public static final byte STATE_DROP = 1;
    public static final byte STATE_NORMAL = 2;
    public static final byte STATE_USE = 3;
    public byte type = 0;
    public byte state;
    public String name;
    public byte value;
    public byte bout;
    public byte iconIndex;
    private static KDBTable physicdb;
    static byte dbindex;
    public static boolean isDemo;

    public int dbindex() {
        byte by = dbindex;
        dbindex = (byte)(by + 1);
        return by;
    }

    public Prop() {
        super(null);
        this.ownType = (byte)4;
    }

    public void init(int id) {
        String[] db = Resource.getDate(Prop.getPhysicDB(), "" + id);
        dbindex = (byte)2;
        this.type = (byte)Integer.parseInt(db[this.dbindex()]);
        this.value = (byte)Integer.parseInt(db[this.dbindex()]);
        this.bout = (byte)Integer.parseInt(db[this.dbindex()]);
        this.dbindex();
        this.dbindex();
        this.iconIndex = (byte)Integer.parseInt(db[this.dbindex()]);
        this.spriteX = Resource.getKSpriteX(goods);
        this.spriteX.setAction(this.iconIndex);
    }

    public static KDBTable getPhysicDB() {
        if (physicdb == null) {
            physicdb = Resource.getDBTable("/gamedb/physic.db");
        }
        return physicdb;
    }

    public static void clearDb() {
        physicdb = null;
    }

    public void setState(int s) {
        this.state = (byte)s;
    }

    public void logic() {
        this.spriteX.update();
        switch (this.state) {
            case 1: {
                this.spriteX.setAction(this.iconIndex + 12);
                if (!this.spriteX.ActionIsOver()) break;
                GameMainDraw.addShortcut(this);
                break;
            }
            case 2: {
                this.spriteX.setAction(this.iconIndex);
                break;
            }
            case 3: {
                this.spriteX.setAction(this.iconIndex + 6);
                break;
            }
        }
    }

    public void paint(int x, int y) {
        if (this.spriteX != null) {
            this.spriteX.paint(x, y, 2000);
        }
    }

    public static boolean copyProp(Prop p) {
        if (p == null) {
            return false;
        }
        Prop temp = new Prop();
        temp.init(p.ownId);
        return true;
    }

    public static Prop getProp(int ownId) {
        Prop temp = new Prop();
        temp.init(ownId);
        return temp;
    }
}

