/*
 * Decompiled with CFR 0.152.
 */
package Actor;

import Actor.GameObj;
import Actor.Prop;
import Actor.Skill;
import basic.KDBTable;
import basic.KSpriteX;
import basic.KUtils;
import basic.Resource;
import draw.GameMainDraw;
import java.util.Vector;

public final class Player
extends GameObj {
    public static final byte STATE_STAND = 0;
    public static final byte STATE_MOVE = 1;
    public static final byte STATE_ATTACK = 2;
    public static final byte STATE_SKILL = 3;
    public static final byte STATE_INJURE = 4;
    public static final byte STATE_DEAD = 5;
    public static final byte DIR_LEFT = 0;
    public static final byte DIR_RIGHT = 1;
    public static final byte ACTION_STAND_DOWN = 0;
    public static final byte ACTION_STAND_LEFT = 0;
    public static final byte ACTION_STAND_UP = 2;
    public static final byte ACTION_STAND_RIGHT = 1;
    public static final byte ACTION_WALK_DOWN = 4;
    public static final byte ACTION_WALK_LEFT = 2;
    public static final byte ACTION_WALK_UP = 6;
    public static final byte ACTION_WALK_RIGHT = 3;
    public short initX;
    public short initY;
    public short spxHeight = 0;
    public static final byte ACTION_ACT_DOWN = 8;
    public static final byte ACTION_ACT_LEFT = 4;
    public static final byte ACTION_ACT_UP = 10;
    public static final byte ACTION_ACT_RIGHT = 5;
    public static final byte ACTION_PREPARE_LEFT = 2;
    public static final byte ACTION_PREPARE_RIGHT = 3;
    public static final byte ACTION_INJURE_DOWN = 16;
    public static final byte ACTION_INJURE_LEFT = 6;
    public static final byte ACTION_INJURE_UP = 18;
    public static final byte ACTION_INJURE_RIGHT = 7;
    public static final byte ACTION_DEAD_DOWN = 20;
    public static final byte ACTION_DEAD_LEFT = 20;
    public static final byte ACTION_DEAD_UP = 20;
    public static final byte ACTION_DEAD_RIGHT = 20;
    public static final byte ENEMY_ACT_DOWN = 8;
    public static final byte ENEMY_ACT_LEFT = 4;
    public static final byte ENEMY_ACT_UP = 10;
    public static final byte ENEMY_ACT_RIGHT = 5;
    public static final byte ENEMY_INJURE_DOWN = 12;
    public static final byte ENEMY_INJURE_LEFT = 6;
    public static final byte ENEMY_INJURE_UP = 14;
    public static final byte ENEMY_INJURE_RIGHT = 7;
    public static final byte ENEMY_DEAD_DOWN = 16;
    public static final byte ENEMY_DEAD_LEFT = 6;
    public static final byte ENEMY_DEAD_UP = 18;
    public static final byte ENEMY_DEAD_RIGHT = 7;
    public static final byte STATE_BIRTH = 6;
    public static final byte STATE_PREPARE = 7;
    public static final byte STATE_RAGE = 8;
    public static final byte DEADING = 1;
    public static final byte DEAD = 2;
    public static final byte REVIVAL = 3;
    public byte deadState = 0;
    public short count;
    public byte isCanRevival = 0;
    public short crit = 0;
    public byte bulletNum = 0;
    public byte shootTime = 0;
    public int injure;
    public byte rageAction;
    public byte rageBout;
    public static final byte TYPE_FAR = 1;
    public static final byte TYPE_NEAR = 2;
    public static final byte TYPE_BOSS = 4;
    public boolean isHit;
    public byte type = 0;
    public short leisureCount = (short)20;
    public byte leisureStop = (byte)32;
    public byte attackCount = 0;
    public byte attackSpeed = (byte)7;
    public boolean isEvade = false;
    public boolean isAttack = false;
    private byte attackTime = 1;
    private byte attackNum = 1;
    public byte actionCount;
    public short angle = (short)45;
    public short oldVigor;
    public short vigor;
    public short attackSpace = (short)70;
    public short attackArea = (short)70;
    public byte aiLevel = 0;
    public String name = "\u7279\u6960\u79d1\u65af";
    public short level = 1;
    public int exercise;
    public int mostHp;
    public int hp;
    public short mp;
    public short mostMp;
    public short attack;
    public short recovery;
    public short shoot;
    public short subjoinSpeed;
    public short subjoinShoot;
    public short score;
    public Vector hurtV;
    public Vector hurtY = new Vector();
    public boolean[] isFury;
    public byte eventid;
    public Skill skill;
    public KSpriteX spx_dead;
    public boolean boutStart;
    public static KDBTable enemydb;
    static byte dbindex;
    public static short addHP;
    boolean isUse = false;
    public byte[] move = new byte[7];
    boolean isSpuer;

    public Player(GameMainDraw gameMain) {
        super(gameMain);
    }

    public int dbindex() {
        byte by = dbindex;
        dbindex = (byte)(by + 1);
        return by;
    }

    public void initEnemy(int id) {
        this.ownType = (byte)5;
        this.ownId = (short)id;
        this.speedX = (byte)4;
        this.speedY = (byte)4;
        dbindex = 0;
        if (enemydb == null) {
            enemydb = Resource.getDBTable("/gamedb/enemy.db");
        }
        String[] db = Resource.getDate(enemydb, "" + id);
        this.dbindex();
        this.name = db[this.dbindex()];
        this.type = (byte)Integer.parseInt(db[this.dbindex()]);
        this.hp = this.mostHp = Integer.parseInt(db[this.dbindex()]) + addHP;
        this.attack = (short)Integer.parseInt(db[this.dbindex()]);
        this.attackTime = (byte)Integer.parseInt(db[this.dbindex()]);
        this.aiLevel = (byte)Integer.parseInt(db[this.dbindex()]);
        this.shoot = (short)Integer.parseInt(db[this.dbindex()]);
        this.attackSpace = (short)Integer.parseInt(db[this.dbindex()]);
        this.spriteX = Resource.getKSpriteX(db[this.dbindex()], db[this.dbindex()]);
        this.score = (short)Integer.parseInt(db[this.dbindex()]);
        int ind = this.dbindex();
        this.speedX = (byte)Integer.parseInt(db[ind]);
        this.speedY = (byte)Integer.parseInt(db[ind]);
        if (this.type == 4) {
            this.npcW = (short)80;
            this.npcH = (short)30;
        } else {
            this.npcW = (short)35;
            this.npcH = (short)30;
        }
        this.isMove = true;
        this.spx_dead = Resource.getKSpriteX("/xiaoshi", "/xiaoshi");
    }

    public void initBout() {
        this.actionCount = 0;
        this.boutStart = true;
        this.isAttack = false;
    }

    public void setAction(int action) {
        if (this.spriteX == null) {
            System.out.println(" spriteX  null" + this.name);
            return;
        }
        if (action >= this.spriteX.getActionCount()) {
            System.out.println(this.name + " playeraction  " + action);
            return;
        }
        super.setAction(action);
    }

    public void logic() {
        if (this.deadOpinion()) {
            return;
        }
        this.count = (short)(this.count + 1);
        if (this.injure > 0) {
            --this.injure;
            this.isHit = false;
        } else {
            this.isHit = true;
        }
        super.logic();
        switch (this.stateNow) {
            case 2: {
                this.attackLogic();
                break;
            }
            case 1: {
                this.moveLogic();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                this.injureLogic();
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.deadLogic();
                break;
            }
            case 7: {
                this.prepareLogic();
            }
        }
    }

    public int getSpeedX() {
        return this.speedX + this.subjoinSpeed;
    }

    private void moveLogic() {
        switch (this.dir) {
            case 0: {
                this.setAction(2);
                this.siteX = (short)(this.siteX - this.getSpeedX());
                break;
            }
            case 1: {
                this.setAction(3);
                this.siteX = (short)(this.siteX + this.getSpeedX());
            }
        }
    }

    private void prepareLogic() {
        byte[] act = new byte[]{2, 3};
        byte[] eact = new byte[]{10, 8, 4, 5};
        this.setAction((this.type == 0 ? act[this.dir] : eact[this.dir]) + this.rageAction);
    }

    private boolean deadOpinion() {
        return this.deadState != 0;
    }

    public void revival() {
        this.hp = this.mostHp;
        this.siteX = this.initX;
        this.siteY = this.initY;
        this.stand(true);
        this.deadState = 0;
        this.count = 0;
    }

    private void deadLogic() {
        if (this.spx_dead != null) {
            this.spx_dead.update();
            if (this.spx_dead.ActionIsOver()) {
                this.count = 0;
                this.deadDrop();
                this.deadState = 1;
            }
        } else {
            this.deadState = 1;
        }
    }

    public void deadDrop() {
        if (this.type == 4) {
            return;
        }
        if (GameMainDraw.isDrop && GameMainDraw.dropPhysicNum < 5) {
            Prop temp = new Prop();
            int odds = KUtils.genRand(100);
            if (odds < GameMainDraw.dropOdds) {
                odds = KUtils.genRand(100);
                for (int i = 0; i < GameMainDraw.dropPhysicOdds.length; ++i) {
                    if (odds >= GameMainDraw.dropPhysicOdds[i]) continue;
                    temp = Prop.getProp(i);
                    temp.setSite(this.siteX, this.siteY);
                    temp.setState(1);
                    GameMainDraw.addGoods(temp);
                    break;
                }
            }
        }
    }

    public void paint(int x, int y) {
        if (this.deadState != 0) {
            return;
        }
        super.paint(x, y);
        if (this.ownType == 5 && this.hp > 0) {
            Resource.addImage(12, x - 15, y, 0);
            Resource.addRect((byte)1, x - 13, y + 2, this.hp * 28 / this.mostHp, 1, true, 0, 16484470, 2000);
            Resource.addRect((byte)1, x - 13, y + 3, this.hp * 28 / this.mostHp, 2, true, 0, 16460804, 2000);
        }
        if (this.stateNow == 5 && this.spx_dead != null) {
            this.spx_dead.paint(x, y, 1500);
        }
        this.drawHurt(x, y);
    }

    public void setHurtShow(int hurt, boolean is) {
        if (this.hurtV == null) {
            this.hurtV = new Vector();
            this.hurtY = new Vector();
        }
        this.hurtV.addElement("" + Math.abs(hurt));
        int y = Math.min(this.spriteX.getFrameHeight(), 85) + 15;
        short[] site = new short[]{this.siteX, (short)(this.siteY - y - KUtils.genRand(6) * 6), -12, 0, (short)(is ? 1 : 0)};
        this.hurtY.addElement(site);
    }

    private void drawHurt(int x, int y) {
        if (this.hurtV != null) {
            if (this.hurtV.size() != 0) {
                int lenght = this.hurtV.size();
                for (int i = lenght - 1; i >= 0; --i) {
                    short[] site = (short[])this.hurtY.elementAt(i);
                    String hurt = (String)this.hurtV.elementAt(i);
                    int himg = 4;
                    if (site[3] < 4) {
                        site[3] = (short)(site[3] + 1);
                        Player player = this;
                        Player player2 = this;
                        KUtils.paintNumber(himg, hurt, site[0] - (hurt.length() * 14 >> 1) - player.main.getViewX(), site[1] - player2.main.getViewY(), 2000);
                        this.hurtY.setElementAt(site, i);
                        continue;
                    }
                    if (site[3] < 7) {
                        site[1] = (short)(site[1] + site[2]);
                        site[2] = (short)(site[2] + 1);
                        site[3] = (short)(site[3] + 1);
                        Player player = this;
                        Player player3 = this;
                        KUtils.paintNumber(himg, hurt, site[0] - (hurt.length() * 14 >> 1) - player.main.getViewX(), site[1] - player3.main.getViewY(), 2000);
                        this.hurtY.setElementAt(site, i);
                        continue;
                    }
                    this.hurtV.removeElementAt(i);
                    this.hurtY.removeElementAt(i);
                }
            } else {
                this.hurtV = null;
                this.hurtY = null;
            }
        }
    }

    private void injureLogic() {
        if (this.dir == 0) {
            this.setAction(this.type == 0 ? 6 : 6);
        } else if (this.dir == 1) {
            this.setAction(this.type == 0 ? 7 : 7);
        }
        if (this.spriteX.ActionIsOver()) {
            if (this.hp <= 0) {
                this.stateNow = (byte)5;
                this.spriteX.visible = false;
                this.setLayout(1000);
            } else {
                this.stand(true);
            }
        }
    }

    public void setSkill(Skill sk) {
        this.skill = sk;
    }

    private void attackLogic() {
        byte[] act = new byte[]{4, 5};
        byte[] eact = new byte[]{4, 5};
        this.setAction((this.type == 0 ? act[this.dir] : eact[this.dir]) + this.rageAction);
        if (this.spriteX.getFrame() == (this.type == 0 ? 3 : 2)) {
            this.main.addSkill(this.skill);
        }
        if (this.spriteX.ActionIsOver()) {
            if (this.actionCount >= this.getShootTime()) {
                this.stand(true);
            } else {
                this.setState(7);
            }
        }
    }

    public void toSuper(boolean isto) {
        if (this.isSpuer != isto) {
            this.isSpuer = isto;
            int a = this.spriteX.getAction();
            this.spriteX = isto ? Resource.getKSpriteX("actor" + (this.ownId + 1) + "_s.sprite", "actor" + (this.ownId + 1)) : Resource.getKSpriteX("actor" + (this.ownId + 1) + ".sprite", "actor" + (this.ownId + 1));
            this.setAction(a);
        }
    }

    public void toRage() {
        this.rageAction = (byte)4;
        this.rageBout = (byte)2;
    }

    public void clearRage() {
        this.rageAction = 0;
        this.rageBout = 0;
    }

    public boolean isRage() {
        return this.rageAction != 0;
    }

    public void stand(boolean stand) {
        if (this.stateNow == 1 || stand) {
            this.setState(0);
            if (this.dir == 0) {
                this.setAction(0);
            } else if (this.dir == 1) {
                this.setAction(1);
            }
            this.spxHeight = (short)this.spriteX.getFrameHeight();
        }
    }

    public void setState(int state) {
        this.stateNow = (byte)state;
    }

    public boolean isOutArea(int x, int y, int w, int h) {
        return Math.abs(x - this.siteX) > w;
    }

    public void alterHp(int h) {
        this.hp += h;
        if (this.hp < 0) {
            this.hp = 0;
        } else if (this.hp > this.mostHp) {
            this.hp = this.mostHp;
        }
    }

    public void alterMp(int h) {
        this.mp = (short)(this.mp + h);
        if (this.mp < 0) {
            this.mp = 0;
        } else if (this.mp > this.mostMp) {
            this.mp = this.mostMp;
        }
    }

    public void addMostHp(int h) {
        int old = this.mostHp;
        this.mostHp += h;
        this.hp = this.mostHp * this.hp * 100 / (old * 100);
    }

    public void addMostMp(int m) {
        short old = this.mostMp;
        this.mostMp = (short)(this.mostMp + m);
        this.mp = (short)(this.mostMp * this.mp * 100 / (old * 100));
    }

    public int getSkillAttack() {
        return this.attack + this.attack * this.crit / 100;
    }

    public int getAngle() {
        return this.dir == 1 ? this.angle : 180 - this.angle;
    }

    public int getAttackNum() {
        return this.attackNum + this.bulletNum;
    }

    public int getShootTime() {
        return this.attackTime + this.shootTime;
    }

    public int getShoot() {
        return this.shoot + this.subjoinShoot;
    }

    public void clearAddState() {
        this.crit = 0;
        this.shootTime = 0;
        this.bulletNum = 0;
        this.attackArea = 0;
    }

    public void initPlayer(int id) {
        this.ownType = (byte)3;
        this.ownId = (short)id;
        this.level = 1;
        this.npcH = (short)13;
        this.npcW = (short)25;
        KDBTable actor = Resource.getDBTable("/gamedb/zhujue.db");
        String[] db = Resource.getDate(actor, "" + this.ownId);
        actor = null;
        this.attack = (short)Integer.parseInt(db[3]);
        this.attackNum = (byte)Integer.parseInt(db[4]);
        this.attackTime = 1;
        this.spriteX = Resource.getKSpriteX(db[7], db[8]);
        if (KUtils.isSuper) {
            this.attack = (short)500;
        }
    }
}

