/*
 * Decompiled with CFR 0.152.
 */
package basic;

import KScript.KScriptObjXTempManager;
import KScript.KScriptObjectX;
import KScript.KVMX;
import basic.BasicCanvas;
import basic.ImageInfo;
import basic.KConfig;
import basic.KDBTable;
import basic.KSpriteX;
import basic.KUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Resource
implements ImageInfo {
    static Hashtable spriteTable = new Hashtable();
    static Hashtable dbTable = new Hashtable();
    private static Image[][] imgs = new Image[ImageInfo.FILESNAME.length][10];
    public static final int MAX = 400;
    public static final short LAYOUT_BOT = -1;
    public static final short LAYOUT_TOP = 2000;
    public static final int TOP = 20;
    public static final int BOTTOM = 36;
    public static final int CENTER = 3;
    public static final int RIGHTTOP = 24;
    public static final int RIGHTBOTTOM = 40;
    public static final int TOPMID = 17;
    public static final int BOTTOMMID = 33;
    public static final byte TRANS_NONE = 0;
    public static final byte TRANS_VERTICAL = 1;
    public static final byte TRANS_HORIZONTAL = 2;
    public static final byte TRANS_CENTER = 3;
    public static final byte TRANS_MIRROR_ROT270 = 4;
    public static final byte TRANS_ROT90 = 5;
    public static final byte TRANS_ROT270 = 6;
    public static final byte TRANS_ROT180 = 3;
    public static final byte TRANS_MIRROR = 2;
    public static final byte TRANS_MIRROR_ROT90 = 7;
    public static final byte TRANS_MIRROR_ROT180 = 1;
    public static final byte TYPE_ROUND_RECT = 0;
    public static final byte TYPE_RECT = 1;
    public static final byte TYPE_ARC = 2;
    public static final byte TYPE_LINE = 3;
    public static final byte TYPE_STRING = 4;
    public static final byte TYPE_IMG = 5;
    public static final byte TYPE_GROUPIMG = 6;
    public static final byte TYPE_RGB_RECT = 8;
    static int curIndex = 0;
    public static int[] drawObj = new int[400];
    public static short max_obj = 0;
    static short[] clipX = new short[400];
    static short[] clipY = new short[400];
    static short[] clipW = new short[400];
    static short[] clipH = new short[400];
    static short[] x = new short[400];
    static short[] y = new short[400];
    static short[] w = new short[400];
    static short[] h = new short[400];
    static short[] rw = new short[400];
    static short[] rh = new short[400];
    static short[] drawLevel = new short[400];
    static short[] imgIndex = new short[400];
    static int[] anchor = new int[400];
    static int[] trans = new int[400];
    static boolean[] isFill = new boolean[400];
    static int[] color = new int[400];
    static String[] str = new String[400];
    static byte[] type = new byte[400];
    static int[][] rgbColor = new int[400][];
    static boolean isScreenClip;
    static short tempClipX;
    static short tempClipY;
    static short tempClipW;
    static short tempClipH;
    static short[] screenClipX;
    static short[] screenClipY;
    static short[] screenClipW;
    static short[] screenClipH;
    private static DataInputStream dis;
    private static String CurStreamName;
    private static int streamPos;
    private static Hashtable pkTemp;
    public static int[] Cos;

    public static KConfig getKConfig(String name) {
        KConfig config = new KConfig();
        config.open(name);
        return config;
    }

    public static KScriptObjectX getKSOX(String name) {
        KScriptObjectX k = null;
        try {
            k = KVMX.getInstance().createObject(name);
        }
        catch (Exception e) {
            BasicCanvas.Debug("\u8f7d\u5165\u811a\u672c\u9519\u8bef:" + name);
            e.printStackTrace();
        }
        return k;
    }

    public static void clearKScriptObjectXExcept(KScriptObjectX ksoj) {
        KScriptObjXTempManager.clear();
        if (ksoj == null) {
            return;
        }
        KVMX.releaseExcept(ksoj);
    }

    public static void clearKScriptObjectX(KScriptObjectX ksoj, boolean isclear) {
        KVMX.release(ksoj, isclear);
    }

    public static void clearAllKScript() {
        KScriptObjXTempManager.clear();
        KVMX.releaseAll();
    }

    public static KSpriteX getKSpriteX(KSpriteX kspx) {
        KSpriteX sp = null;
        if (kspx != null) {
            sp = new KSpriteX(kspx);
        }
        return sp;
    }

    public static KSpriteX getKSpriteX(String sprite, String png) {
        KSpriteX sp = null;
        if (spriteTable.containsKey(sprite)) {
            sp = new KSpriteX((KSpriteX)spriteTable.get(sprite));
            if (!sp.imageName.equals(png)) {
                sp.setImage(png);
                Resource.getImage(png);
            }
        } else {
            try {
                sp = new KSpriteX();
                sp.loadSpx(sprite, png);
                Resource.getImage(png);
                spriteTable.put(sprite, sp);
            }
            catch (Exception e) {
                BasicCanvas.Debug("Resource getKSprite wrong sprite : " + sprite + " png:" + png);
                e.printStackTrace();
            }
        }
        return sp;
    }

    public static void clearSpriteX() {
        spriteTable.clear();
    }

    public static KDBTable getDBTable(String name) {
        if (name == null) {
            return null;
        }
        if (dbTable.containsKey(name)) {
            return (KDBTable)dbTable.get(name);
        }
        try {
            KDBTable db = KDBTable.openDB(name);
            dbTable.put(name, db);
            return db;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getDate(KDBTable kdb, String name) {
        String[] row = null;
        if (kdb == null || name == null) {
            return null;
        }
        try {
            row = kdb.getRow(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return row;
    }

    public static String[] getListDate(KDBTable kdb, int index) {
        String[] list = null;
        if (kdb == null || index < 0) {
            return null;
        }
        try {
            int rowCount = kdb.getRowCount();
            list = new String[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String[] row = kdb.getRowFromIndex(i);
                if (row == null || index >= row.length) continue;
                list[i] = row[index];
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public static void clearDb() {
        dbTable.clear();
    }

    private static void analyze(byte[] data, int[] para) {
        int offset = 8;
        int chunkLen = 0;
        while (data[offset + 4] != 80 || data[offset + 5] != 76 || data[offset + 6] != 84 || data[offset + 7] != 69) {
            chunkLen = Resource.readInt(data, offset);
            offset += 8 + chunkLen + 4;
        }
        chunkLen = Resource.readInt(data, offset);
        para[2] = chunkLen / 3;
        para[0] = offset + 8;
        para[1] = offset + 8 + chunkLen;
    }

    private static void fillData(byte[] data, int[] para) {
        int checksum = Resource.update_crc(data, para[0] - 4, para[2] * 3 + 4);
        data[para[1]] = (byte)(checksum >> 24 & 0xFF);
        data[para[1] + 1] = (byte)(checksum >> 16 & 0xFF);
        data[para[1] + 2] = (byte)(checksum >> 8 & 0xFF);
        data[para[1] + 3] = (byte)(checksum & 0xFF);
    }

    public static Image getPalettedImage(byte[] data, int[] originalColors, int[] palettedColors) {
        byte[] tempData = new byte[data.length];
        System.arraycopy(data, 0, tempData, 0, data.length);
        Image img = null;
        int[] parameter = new int[]{0, 0, 0};
        Resource.analyze(tempData, parameter);
        for (int i = 0; i < originalColors.length; ++i) {
            Resource.replaceColor(tempData, parameter, originalColors[i], palettedColors[i]);
        }
        Resource.fillData(tempData, parameter);
        try {
            img = Image.createImage((byte[])tempData, (int)0, (int)data.length);
        }
        catch (Exception e) {
            System.out.println("getPalettedImage  &&  " + e.toString());
        }
        return img;
    }

    private static int readInt(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
    }

    private static void replaceColor(byte[] data, int[] para, int oldColor, int newColor) {
        byte rr = (byte)(oldColor >> 16 & 0xFF);
        byte gg = (byte)(oldColor >> 8 & 0xFF);
        byte bb = (byte)(oldColor & 0xFF);
        int i = 0;
        int offset = para[0];
        boolean temp = false;
        while (i < para[2]) {
            if (rr == data[offset] && gg == data[offset + 1] && bb == data[offset + 2]) {
                data[offset] = (byte)(newColor >> 16 & 0xFF);
                data[offset + 1] = (byte)(newColor >> 8 & 0xFF);
                data[offset + 2] = (byte)(newColor & 0xFF);
                break;
            }
            ++i;
            offset += 3;
        }
    }

    private static int update_crc(byte[] buf, int off, int len) {
        int n;
        int c = -1;
        int[] crc_table = new int[256];
        for (n = 0; n < 256; ++n) {
            int xx = n;
            for (int k = 0; k < 8; ++k) {
                if ((xx & 1) == 1) {
                    xx = 0xEDB88320 ^ xx >>> 1;
                    continue;
                }
                xx >>>= 1;
            }
            crc_table[n] = xx;
        }
        for (n = off; n < len + off; ++n) {
            c = crc_table[(c ^ buf[n]) & 0xFF] ^ c >>> 8;
        }
        return ~c;
    }

    public static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i &= 0xFF;
        }
        return i;
    }

    public static void setScreenClip(int clipX, int clipY, int clipW, int clipH) {
        isScreenClip = true;
        tempClipX = (short)clipX;
        tempClipY = (short)clipY;
        tempClipW = (short)clipW;
        tempClipH = (short)clipH;
    }

    public static void closeScreenClip() {
        isScreenClip = false;
    }

    private static void setScreenClip() {
        if (isScreenClip) {
            Resource.screenClipX[Resource.curIndex] = tempClipX;
            Resource.screenClipY[Resource.curIndex] = tempClipY;
            Resource.screenClipW[Resource.curIndex] = tempClipW;
            Resource.screenClipH[Resource.curIndex] = tempClipH;
        } else {
            Resource.screenClipX[Resource.curIndex] = 0;
            Resource.screenClipY[Resource.curIndex] = 0;
            Resource.screenClipW[Resource.curIndex] = BasicCanvas.screenWidth;
            Resource.screenClipH[Resource.curIndex] = BasicCanvas.screenHeight;
        }
    }

    public static void clearRgbColor() {
        rgbColor = null;
        rgbColor = new int[400][];
    }

    public static void addImage(int imgIndex, int x, int y, byte[] clip, int anchor, byte trans, int drawLevel) {
        Resource.addImage(imgIndex, x, y, clip[0], clip[1], clip[2], clip[3], anchor, trans, drawLevel);
    }

    public static void addImage(int imgIndex, int x, int y, int clipX, int clipY, int clipW, int clipH, int anchor) {
        Resource.addImage(imgIndex, x, y, clipX, clipY, clipW, clipH, anchor, 0, 2000);
    }

    public static void addImage(int imgIndex, int x, int y, int anchor) {
        int w = Resource.getImage(imgIndex).getWidth();
        int h = Resource.getImage(imgIndex).getHeight();
        Resource.addImage(imgIndex, x, y, 0, 0, w, h, anchor, 0, 2000);
    }

    public static void addImage(int imgIndex, int x, int y, int anchor, int trans, int drawLevel) {
        int w = Resource.getImage(imgIndex).getWidth();
        int h = Resource.getImage(imgIndex).getHeight();
        Resource.addImage(imgIndex, x, y, 0, 0, w, h, anchor, trans, drawLevel);
    }

    public static void addImage(int imgIndex, int x, int y, int clipX, int clipY, int clipW, int clipH, int anchor, int trans, int drawLevel) {
        if (Resource.isDrawImage(x, y, clipW, clipH, anchor, trans)) {
            Resource.imgIndex[Resource.curIndex] = (short)imgIndex;
            Resource.x[Resource.curIndex] = (short)x;
            Resource.y[Resource.curIndex] = (short)y;
            Resource.clipX[Resource.curIndex] = (short)clipX;
            Resource.clipY[Resource.curIndex] = (short)clipY;
            Resource.clipW[Resource.curIndex] = (short)clipW;
            Resource.clipH[Resource.curIndex] = (short)clipH;
            Resource.anchor[Resource.curIndex] = anchor;
            Resource.trans[Resource.curIndex] = trans;
            Resource.drawLevel[Resource.curIndex] = (short)drawLevel;
            Resource.type[Resource.curIndex] = 5;
            Resource.setIndex();
        }
    }

    private static boolean isDrawImage(int x, int y, int w, int h, int anchor, int trans) {
        int oldw = w;
        int oldh = h;
        if (trans > 3) {
            h = oldw;
            w = oldh;
        }
        return Resource.isDraw(x, y, w, h, anchor);
    }

    public static void addImage(int imgIndex, int x, int y, int[] clipRect, int anchor, byte trans, int drawLevel) {
        Resource.imgIndex[Resource.curIndex] = (short)imgIndex;
        Resource.x[Resource.curIndex] = (short)x;
        Resource.y[Resource.curIndex] = (short)y;
        Resource.clipX[Resource.curIndex] = (short)clipRect[0];
        Resource.clipY[Resource.curIndex] = (short)clipRect[1];
        Resource.clipW[Resource.curIndex] = (short)clipRect[2];
        Resource.clipH[Resource.curIndex] = (short)clipRect[3];
        Resource.anchor[Resource.curIndex] = anchor;
        Resource.trans[Resource.curIndex] = trans;
        Resource.drawLevel[Resource.curIndex] = (short)drawLevel;
        Resource.type[Resource.curIndex] = 5;
        Resource.setIndex();
    }

    public static void addImage(int imgIndex, int x, int y, short[] clip, int anchor, int trans, int drawLevel) {
        Resource.addImage(imgIndex, x, y, clip[0], clip[1], clip[2], clip[3], anchor, trans, drawLevel);
    }

    public static void addLine(int x1, int y1, int x2, int y2, int anchor, int color, int drawLevel) {
        if (Resource.isDraw(x1, y1, x2, x2, anchor)) {
            Resource.type[Resource.curIndex] = 3;
            Resource.x[Resource.curIndex] = (short)x1;
            Resource.y[Resource.curIndex] = (short)y1;
            Resource.w[Resource.curIndex] = (short)x2;
            Resource.h[Resource.curIndex] = (short)y2;
            Resource.anchor[Resource.curIndex] = anchor;
            Resource.color[Resource.curIndex] = color;
            Resource.drawLevel[Resource.curIndex] = (short)drawLevel;
            Resource.setIndex();
        }
    }

    public static void addRect(byte type, int x, int y, int w, int h, boolean isFill, int anchor, int color, int drawLevel) {
        if (Resource.isDraw(x, y, w, h, anchor)) {
            Resource.type[Resource.curIndex] = type;
            Resource.x[Resource.curIndex] = (short)x;
            Resource.y[Resource.curIndex] = (short)y;
            Resource.w[Resource.curIndex] = (short)w;
            Resource.h[Resource.curIndex] = (short)h;
            Resource.anchor[Resource.curIndex] = anchor;
            Resource.color[Resource.curIndex] = color;
            Resource.isFill[Resource.curIndex] = isFill;
            Resource.drawLevel[Resource.curIndex] = (short)drawLevel;
            if (type == 8) {
                if (rgbColor[curIndex] != null) {
                    if (rgbColor[curIndex].length != w * h) {
                        Resource.rgbColor[Resource.curIndex] = new int[w * h];
                    }
                } else {
                    Resource.rgbColor[Resource.curIndex] = new int[w * h];
                }
                if (rgbColor[curIndex][0] != color) {
                    for (int i = 0; i < rgbColor[curIndex].length; ++i) {
                        Resource.rgbColor[Resource.curIndex][i] = color;
                    }
                }
            }
            Resource.setIndex();
        }
    }

    public static void addString(String str, int x, int y, int anchor, int color, int drawLevel) {
        Resource.type[Resource.curIndex] = 4;
        Resource.str[Resource.curIndex] = str;
        Resource.x[Resource.curIndex] = (short)x;
        Resource.y[Resource.curIndex] = (short)y;
        Resource.clipX[Resource.curIndex] = 0;
        Resource.clipY[Resource.curIndex] = 0;
        Resource.clipW[Resource.curIndex] = 0;
        Resource.clipH[Resource.curIndex] = 0;
        Resource.anchor[Resource.curIndex] = anchor;
        Resource.color[Resource.curIndex] = color;
        Resource.drawLevel[Resource.curIndex] = (short)drawLevel;
        Resource.setIndex();
    }

    public static void addString(String str, int x, int y, int clipX, int clipY, int clipW, int clipH, int anchor, int color, int drawLevel) {
        Resource.type[Resource.curIndex] = 4;
        Resource.str[Resource.curIndex] = str;
        Resource.x[Resource.curIndex] = (short)x;
        Resource.y[Resource.curIndex] = (short)y;
        Resource.clipX[Resource.curIndex] = (short)clipX;
        Resource.clipY[Resource.curIndex] = (short)clipY;
        Resource.clipW[Resource.curIndex] = (short)clipW;
        Resource.clipH[Resource.curIndex] = (short)clipH;
        Resource.anchor[Resource.curIndex] = anchor;
        Resource.color[Resource.curIndex] = color;
        Resource.drawLevel[Resource.curIndex] = (short)drawLevel;
        Resource.setIndex();
    }

    public static void addArcRound(int type, int x, int y, int w, int h, int rw, int rh, boolean isFill, int anchor, int color, int drawLevel) {
        if (Resource.isDraw(x, y, w, h, anchor)) {
            Resource.type[Resource.curIndex] = (byte)type;
            Resource.x[Resource.curIndex] = (short)x;
            Resource.y[Resource.curIndex] = (short)y;
            Resource.w[Resource.curIndex] = (short)w;
            Resource.h[Resource.curIndex] = (short)h;
            Resource.rw[Resource.curIndex] = (short)rw;
            Resource.rh[Resource.curIndex] = (short)rh;
            Resource.isFill[Resource.curIndex] = isFill;
            Resource.anchor[Resource.curIndex] = anchor;
            Resource.color[Resource.curIndex] = color;
            Resource.drawLevel[Resource.curIndex] = (short)drawLevel;
            Resource.setIndex();
        }
    }

    private static Image createImage(String imgName) {
        try {
            return Image.createImage((String)("/" + imgName + ".png"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void readStream(String name) {
        if (dis == null || !CurStreamName.equals(name)) {
            dis = new DataInputStream("a".getClass().getResourceAsStream("/" + name));
            CurStreamName = name;
            streamPos = 0;
            Resource.readHead(dis);
            return;
        }
    }

    private static int readHead(DataInputStream dis) {
        int[] offset = null;
        try {
            int num = dis.readByte();
            short head = dis.readShort();
            if (!pkTemp.containsKey(CurStreamName)) {
                offset = new int[num];
                for (int i = 0; i < num; ++i) {
                    dis.readUTF();
                    offset[i] = dis.readInt();
                }
                pkTemp.put(CurStreamName, offset);
            } else {
                dis.skip(head - 3);
            }
            return head;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static Image crateOtherFromPK(String name) {
        String[] Temp = KUtils.splitString(name, '|');
        String fileName = ImageInfo.PKNAME[Integer.parseInt(Temp[1])];
        int index = Integer.parseInt(Temp[2]);
        int oldImgindex = Integer.parseInt(Temp[3]);
        dis = null;
        Resource.readStream(fileName);
        try {
            int[] offset = (int[])pkTemp.get(CurStreamName);
            if (index > 0 && streamPos < offset[index - 1]) {
                dis.skip(offset[index - 1] - 0);
            }
            int imgLength = 0;
            imgLength = index != 0 ? offset[index] - offset[index - 1] : offset[index];
            String imgName = dis.readUTF();
            int bufflen = dis.readInt();
            int pltelen = dis.readInt();
            byte[] plte = new byte[pltelen];
            dis.read(plte, 0, plte.length);
            streamPos = offset[index];
            Temp = KUtils.splitString(ImageInfo.FILESNAME[oldImgindex], '|');
            index = Integer.parseInt(Temp[2]);
            Temp = null;
            imgLength = index != 0 ? offset[index] - offset[index - 1] : offset[index];
            byte[] data = new byte[ImageInfo.imageHeadData.length + ImageInfo.imageEndData.length + imgLength];
            if (index > 0 && streamPos < offset[index - 1]) {
                streamPos = (int)((long)streamPos + dis.skip(offset[index - 1] - streamPos));
            }
            dis.read(data, ImageInfo.imageHeadData.length, imgLength);
            dis = null;
            System.arraycopy(ImageInfo.imageHeadData, 0, data, 0, ImageInfo.imageHeadData.length);
            System.arraycopy(ImageInfo.imageEndData, 0, data, ImageInfo.imageHeadData.length + imgLength, ImageInfo.imageEndData.length);
            int p = 41;
            System.arraycopy(plte, 0, data, p, plte.length);
            return Image.createImage((byte[])data, (int)0, (int)data.length);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Image createImageFromPK(String name, boolean destroy) {
        String[] Temp = KUtils.splitString(name, '|');
        String fileName = ImageInfo.PKNAME[Integer.parseInt(Temp[1])];
        int index = Integer.parseInt(Temp[2]);
        try {
            Resource.readStream(fileName);
            int[] offset = (int[])pkTemp.get(CurStreamName);
            int imgLength = 0;
            imgLength = index != 0 ? offset[index] - offset[index - 1] : offset[index];
            byte[] data = new byte[ImageInfo.imageHeadData.length + ImageInfo.imageEndData.length + imgLength];
            if (index > 0 && streamPos < offset[index - 1]) {
                dis.skip(offset[index - 1] - streamPos);
            }
            dis.read(data, ImageInfo.imageHeadData.length, imgLength);
            streamPos = offset[index];
            System.arraycopy(ImageInfo.imageHeadData, 0, data, 0, ImageInfo.imageHeadData.length);
            System.arraycopy(ImageInfo.imageEndData, 0, data, ImageInfo.imageHeadData.length + imgLength, ImageInfo.imageEndData.length);
            Image image = Image.createImage((byte[])data, (int)0, (int)data.length);
            if (destroy) {
                dis.close();
                dis = null;
            }
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void drawAll(Graphics g) {
        Resource.sort();
        int srceenX = 0;
        int srceenY = 0;
        for (int i = 0; i < max_obj; ++i) {
            Resource.drawMe(g, drawObj[i], srceenX, srceenY);
            if (type[drawObj[i]] == 8) continue;
            Resource.rgbColor[Resource.drawObj[i]] = null;
        }
        Resource.reset();
    }

    private static void reset() {
        curIndex = 0;
        max_obj = 0;
    }

    public static void drawClipImage(Graphics g, Image img, int x, int y, int clipX, int clipY, int clipW, int clipH, int anchor, int trans, boolean userote) {
        if (clipW <= 0 || clipH <= 0 || clipX < 0 || clipY < 0) {
            return;
        }
        if (clipX + clipW > img.getWidth()) {
            clipW = img.getWidth() - clipX;
        }
        if (clipY + clipH > img.getHeight()) {
            clipH = img.getHeight() - clipY;
        }
        if (!userote) {
            trans = 0;
        }
        g.drawRegion(img, clipX, clipY, clipW, clipH, trans, x, y, anchor);
    }

    public static void drawClipImage(Graphics g, int index, int imgIndex, int x, int y, int clipX, int clipY, int clipW, int clipH, int anchor, int trans) {
        Image img = Resource.getImage(imgIndex);
        Resource.drawClipImage(g, img, x, y, clipX, clipY, clipW, clipH, anchor, trans, true);
    }

    public static void drawMe(Graphics g, int index, int viewX, int viewY) {
        int y = Resource.y[index] - viewY;
        int x = Resource.x[index] - viewX;
        g.setClip((int)screenClipX[index], (int)screenClipY[index], (int)screenClipW[index], (int)screenClipH[index]);
        switch (type[index]) {
            case 2: {
                if (anchor[index] != 20) {
                    y -= h[index];
                }
                g.setColor(color[index]);
                if (isFill[index]) {
                    g.fillArc(x, y, (int)w[index], (int)h[index], (int)rw[index], (int)rh[index]);
                    break;
                }
                g.drawArc(x, y, (int)w[index], (int)h[index], (int)rw[index], (int)rh[index]);
                break;
            }
            case 5: {
                Resource.drawClipImage(g, index, (int)imgIndex[index], x, y, (int)clipX[index], (int)clipY[index], (int)clipW[index], (int)clipH[index], anchor[index], trans[index]);
                break;
            }
            case 6: {
                Resource.drawClipImage(g, Resource.getGroupImage(imgIndex[index], clipX[index], trans[index], isFill[index]), x, y, 0, 0, (int)clipW[index], (int)clipH[index], anchor[index], trans[index], isFill[index]);
                break;
            }
            case 3: {
                g.setColor(color[index]);
                g.drawLine(x, y, w[index] - viewX, h[index] - viewY);
                break;
            }
            case 1: {
                if (anchor[index] == 36) {
                    y -= h[index];
                } else if (anchor[index] == 33) {
                    y -= h[index];
                    x -= w[index] / 2;
                } else if (anchor[index] == 17) {
                    x -= w[index] / 2;
                }
                g.setColor(color[index]);
                if (isFill[index]) {
                    g.fillRect(x, y, (int)w[index], (int)h[index]);
                    break;
                }
                g.drawRect(x, y, (int)w[index], (int)h[index]);
                break;
            }
            case 8: {
                if (anchor[index] == 36) {
                    y -= h[index];
                } else if (anchor[index] == 33) {
                    y -= h[index];
                    x -= w[index] / 2;
                } else if (anchor[index] == 17) {
                    x -= w[index] / 2;
                }
                g.drawRGB(rgbColor[index], 0, (int)w[index], x, y, (int)w[index], (int)h[index], true);
                break;
            }
            case 0: {
                if (anchor[index] != 20) {
                    y -= h[index];
                }
                g.setColor(color[index]);
                if (isFill[index]) {
                    g.fillRoundRect(x, y, (int)w[index], (int)h[index], (int)rw[index], (int)rh[index]);
                    break;
                }
                g.drawRoundRect(x, y, (int)w[index], (int)h[index], (int)rw[index], (int)rh[index]);
                break;
            }
            case 4: {
                int clipX = g.getClipX();
                int clipY = g.getClipY();
                int clipW = g.getClipWidth();
                int clipH = g.getClipHeight();
                if (Resource.clipW[index] != 0 && Resource.clipH[index] != 0) {
                    g.setClip((int)Resource.clipX[index], (int)Resource.clipY[index], (int)Resource.clipW[index], (int)Resource.clipH[index]);
                }
                int other = 0;
                g.setColor(color[index]);
                g.drawString(str[index], x, y + other, anchor[index]);
                g.setClip(clipX, clipY, clipW, clipH);
            }
        }
    }

    public static short findImgIndex(String str) {
        if (str.endsWith(".plte")) {
            str = str.substring(0, str.length() - 5);
        }
        if (str.endsWith(".png")) {
            str = str.substring(0, str.length() - 4);
        }
        if (str.startsWith("/")) {
            str = str.substring(1, str.length());
        }
        str = str.trim();
        for (int i = 0; i < ImageInfo.FILESNAME.length; ++i) {
            int index;
            if (ImageInfo.FILESNAME[i].equals(str)) {
                return (short)i;
            }
            if (!(ImageInfo.FILESNAME[i].startsWith(str) ? (index = ImageInfo.FILESNAME[i].indexOf("|")) == str.length() : ImageInfo.FILESNAME[i].endsWith("/" + str))) continue;
            return (short)i;
        }
        System.out.println("[Cant Find String in Array] " + str + "len" + str.length());
        return -1;
    }

    public static Image getImage(String imageName) {
        return Resource.getImage(Resource.findImgIndex(imageName));
    }

    public static Image getImage(int index, boolean closeStream) {
        Image img = imgs[index][0];
        if (img == null) {
            if (ImageInfo.resTeyp[index] == 1) {
                Resource.imgs[index][0] = Resource.createImage(ImageInfo.FILESNAME[index]);
            } else if (ImageInfo.resTeyp[index] == 2) {
                Resource.imgs[index][0] = Resource.crateOtherColorImage(ImageInfo.FILESNAME[index]);
            } else if (ImageInfo.resTeyp[index] == 4) {
                Resource.imgs[index][0] = Resource.createImageFromPK(ImageInfo.FILESNAME[index], closeStream);
            } else if (ImageInfo.resTeyp[index] == 5) {
                Resource.imgs[index][0] = Resource.crateOtherFromPK(ImageInfo.FILESNAME[index]);
            }
            img = imgs[index][0];
        }
        return img;
    }

    public static Image getImage(int index) {
        return Resource.getImage(index, true);
    }

    public static Image crateOtherColorImage(String palletteFile) {
        Image img = null;
        try {
            int p = 0;
            InputStream isp = "a".getClass().getResourceAsStream("/" + palletteFile + ".plte");
            DataInputStream dis = new DataInputStream(isp);
            String name = dis.readUTF();
            int bufflen = dis.readInt();
            int pltelen = dis.readInt();
            byte[] plte = new byte[pltelen];
            dis.read(plte, 0, plte.length);
            isp.close();
            InputStream is = "a".getClass().getResourceAsStream("/" + ImageInfo.FILESNAME[Resource.findImgIndex(name)] + ".png");
            byte[] buff = new byte[bufflen];
            is.read(buff);
            p = 41;
            System.arraycopy(plte, 0, buff, p, plte.length);
            plte = null;
            img = Image.createImage((byte[])buff, (int)0, (int)buff.length);
            is.close();
            buff = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return img;
    }

    public static int getImageHeight(int index) {
        return Resource.getImage(index).getHeight();
    }

    public static int getImageWidth(int index) {
        return Resource.getImage(index).getWidth();
    }

    public static void removeAllImage() {
        imgs = null;
        imgs = new Image[ImageInfo.FILESNAME.length][10];
        System.gc();
    }

    public static void removeOneImage(int index) {
        Resource.imgs[index] = null;
        Resource.imgs[index] = new Image[10];
    }

    public static boolean hit(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return x1 <= x2 + w2 && x2 <= x1 + w1 && y1 <= y2 + h2 && y2 <= y1 + h1;
    }

    public static final boolean isDraw(int x, int y, int w, int h, int anchor) {
        short srceenW = BasicCanvas.screenWidth;
        short srceenH = BasicCanvas.screenHeight;
        short srceenX = 0;
        short srceenY = 0;
        if (isScreenClip) {
            srceenX = tempClipX;
            srceenY = tempClipY;
            srceenW = tempClipW;
            srceenH = tempClipH;
        }
        switch (anchor) {
            case 20: {
                break;
            }
            case 36: {
                y -= h;
                break;
            }
            case 3: {
                y -= h / 2;
                x -= w / 2;
                break;
            }
            case 17: {
                x -= w / 2;
                break;
            }
            case 33: {
                y -= h;
                x -= w / 2;
                break;
            }
            case 24: {
                x -= w;
                break;
            }
            case 40: {
                x -= w;
                y -= h;
            }
        }
        return Resource.hit(x, y, w, h, srceenX, srceenY, srceenW, srceenH);
    }

    private static void setIndex() {
        Resource.setScreenClip();
        short s = max_obj;
        max_obj = (short)(s + 1);
        Resource.drawObj[s] = curIndex++;
        if (curIndex == 400) {
            curIndex = 0;
        }
    }

    public static void sort() {
        for (int i = 1; i < max_obj; ++i) {
            if (drawLevel[drawObj[i]] >= drawLevel[drawObj[i - 1]]) continue;
            int temp = drawObj[i];
            int j = i - 1;
            do {
                Resource.drawObj[j + 1] = drawObj[j];
            } while (--j >= 0 && drawLevel[temp] < drawLevel[drawObj[j]]);
            Resource.drawObj[j + 1] = temp;
        }
    }

    public static void drawWaveImage(int image, int x, int y, int clipX, int clipY, int clipW, int clipH, int blend) {
        if (Cos == null) {
            Resource.InitMathFunc();
        }
        int imgW = clipW;
        int imgH = clipH;
        for (int i = 0; i < imgH; ++i) {
            Resource.addImage(image, x + (2000 - blend) * Resource.Cos((blend * 360 / 1000 + i * 10) % 360) / 2000, y + i, 0, i, imgW, 1, 20, 0, 2000);
        }
    }

    public static void drawWaveImage(Graphics g, Image image, int x, int y, int clipX, int clipY, int clipW, int clipH, int blend) {
        if (Cos == null) {
            Resource.InitMathFunc();
        }
        int imgW = clipW;
        int imgH = clipH;
        for (int i = 0; i < imgH; ++i) {
            Resource.drawClipImage(g, image, x + (2000 - blend) * Resource.Cos((blend * 360 / 1000 + i * 10) % 360) / 2000, y + i, 0, i, imgW, 1, 20, 0, true);
        }
    }

    public static void InitMathFunc() {
        Cos = new int[361];
        Resource.Cos[0] = 100;
        Resource.Cos[22] = 92;
        Resource.Cos[45] = 70;
        Resource.Cos[68] = 37;
        Resource.Cos[90] = 0;
        Resource.Cos[112] = -37;
        Resource.Cos[135] = -70;
        Resource.Cos[158] = -92;
        Resource.Cos[180] = -100;
        Resource.Cos[202] = -92;
        Resource.Cos[225] = -70;
        Resource.Cos[248] = -37;
        Resource.Cos[270] = 0;
        Resource.Cos[292] = 37;
        Resource.Cos[315] = 70;
        Resource.Cos[338] = 92;
        Resource.Cos[360] = 100;
        Resource.GenerateSinCos(0, 22);
        Resource.GenerateSinCos(22, 45);
        Resource.GenerateSinCos(45, 68);
        Resource.GenerateSinCos(68, 90);
        Resource.GenerateSinCos(90, 112);
        Resource.GenerateSinCos(112, 135);
        Resource.GenerateSinCos(135, 158);
        Resource.GenerateSinCos(158, 180);
        Resource.GenerateSinCos(180, 202);
        Resource.GenerateSinCos(202, 225);
        Resource.GenerateSinCos(225, 248);
        Resource.GenerateSinCos(248, 270);
        Resource.GenerateSinCos(270, 292);
        Resource.GenerateSinCos(292, 315);
        Resource.GenerateSinCos(315, 338);
        Resource.GenerateSinCos(338, 360);
    }

    private static void GenerateSinCos(int MinAngle, int MaxAngle) {
        int iAngle = 0;
        int MinCos = Cos[MinAngle];
        int MaxCos = Cos[MaxAngle];
        int DAngle = MaxAngle - MinAngle;
        for (iAngle = MinAngle + 1; iAngle < MaxAngle; ++iAngle) {
            Resource.Cos[iAngle] = MinCos + (MaxCos - MinCos) * (iAngle - MinAngle) / DAngle;
        }
    }

    public static int Cos(int angle) {
        if (angle < 360 && angle >= 0) {
            return Cos[angle];
        }
        return 0;
    }

    public static Image getGroupImage(int imgIndex, int index, int trans, boolean rote) {
        if (rote || trans == 0) {
            return imgs[imgIndex][index];
        }
        int len = imgs[imgIndex].length / 8;
        Image img = imgs[imgIndex][index + len * trans];
        if (img != null) {
            return img;
        }
        if (trans <= 6) {
            img = Resource.CreateRoteImage(imgs[imgIndex][index], trans);
        }
        if (img == null) {
            return imgs[imgIndex][index];
        }
        Resource.imgs[imgIndex][index + len * trans] = img;
        return img;
    }

    public static Image CreateRoteImage(Image res, int trans) {
        return Image.createImage((Image)res, (int)0, (int)0, (int)res.getWidth(), (int)res.getHeight(), (int)trans);
    }

    static {
        screenClipX = new short[400];
        screenClipY = new short[400];
        screenClipW = new short[400];
        screenClipH = new short[400];
        CurStreamName = "";
        streamPos = 0;
        pkTemp = new Hashtable();
        Cos = null;
    }
}

