/*
 * Decompiled with CFR 0.152.
 */
package basic;

import basic.KUtils;
import basic.Resource;
import java.io.DataInputStream;
import java.io.InputStream;

public class KSpriteX {
    private short x;
    private short y;
    public boolean visible;
    public static final int SPX_HEADER = 1397772888;
    public static final byte SPX_VERSION = 34;
    public static final byte SPX_BYTE_SEQUENCE_JAVA = 1;
    public static final byte TRANS_NONE = 0;
    public static final byte TRANS_ROT90 = 5;
    public static final byte TRANS_ROT180 = 3;
    public static final byte TRANS_ROT270 = 6;
    public static final byte TRANS_MIRROR = 2;
    public static final byte TRANS_MIRROR_ROT90 = 7;
    public static final byte TRANS_MIRROR_ROT180 = 1;
    public static final byte TRANS_MIRROR_ROT270 = 4;
    public static final byte ANTICLOCKWISE_90 = 0;
    public static final byte DEASIL_90 = 1;
    public static final byte HORIZONTAL = 2;
    public static final byte VERTICAL = 3;
    public static final byte DIRECTION_NONE = 0;
    public static final byte DIRECTION_UP = 1;
    public static final byte DIRECTION_DOWN = 2;
    public static final byte DIRECTION_LEFT = 3;
    public static final byte DIRECTION_RIGHT = 4;
    public static final byte FRAME_HEADER_SIZE = 8;
    public static final byte FRAME_TILE_COUNT_BIT = 1;
    public static final byte FRAME_COLLISION_COUNT_BIT = 2;
    public static final byte FRAME_REFERENCE_POINT_COUNT_BIT = 3;
    public static final byte FRAME_TOP_POS_BIT = 4;
    public static final byte FRAME_BOTTOM_POS_BIT = 5;
    public static final byte FRAME_LEFT_POS_BIT = 6;
    public static final byte FRAME_RIGHT_POS_BIT = 7;
    public static final byte ACTION_HEADER_SIZE = 4;
    public static final byte ACTION_SEQUENCE_LENGTH_BIT = 1;
    public static final byte ACTION_SEQUENCE_DELAY_BIT = 2;
    public static final byte ACTION_TRANSFORM_BIT = 3;
    public static final byte COLLISION_INTERSECT = 1;
    public static final byte COLLISION_INCLUSION = 2;
    public static final int INVERTED_AXES = 4;
    public static final byte[][] TRANSFORM_TABLE = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {1, 0, 3, 2, 5, 4, 7, 6}, {2, 3, 0, 1, 6, 7, 4, 5}, {3, 2, 1, 0, 7, 6, 5, 4}, {4, 6, 5, 7, 0, 2, 1, 3}, {5, 7, 4, 6, 1, 3, 0, 2}, {6, 4, 7, 5, 2, 0, 3, 1}, {7, 5, 6, 4, 3, 1, 2, 0}};
    public static final byte[][] ROTATE_TABLE = new byte[][]{{6, 5, 2, 1}, {7, 4, 3, 0}, {4, 7, 0, 3}, {5, 6, 1, 2}, {1, 2, 5, 6}, {0, 3, 4, 7}, {3, 0, 7, 4}, {2, 1, 6, 5}};
    public String spxName;
    public String imageName;
    public short imageIndex;
    short[][] actionData;
    short actionCount;
    short[][] frameData;
    short frameCount;
    public short[][] tileData;
    short tileCount;
    short actionIndex;
    short sequenceIndex;
    public short[] clip;
    long lastTime;
    boolean firstUpdate;
    boolean toJudgeAnimationStop;
    boolean oneFrameIsPlay;
    public byte actionTime;
    public byte palyerCount;

    public KSpriteX() {
        this.palyerCount = this.actionTime = 1;
    }

    public KSpriteX(KSpriteX spx) {
        this.palyerCount = this.actionTime = 1;
        this.tileCount = spx.tileCount;
        this.tileData = spx.tileData;
        this.frameCount = spx.frameCount;
        this.frameData = spx.frameData;
        this.actionCount = spx.actionCount;
        this.actionData = spx.actionData;
        this.spxName = spx.spxName;
        this.imageName = spx.imageName;
        this.imageIndex = spx.imageIndex;
        this.visible = true;
    }

    public void setPosition(int x, int y) {
        this.x = (short)x;
        this.y = (short)y;
    }

    public void move(int dx, int dy) {
        this.x = (short)(this.x + dx);
        this.y = (short)(this.y + dy);
    }

    public void setClip(short[] c) {
        this.clip = c;
    }

    public void loadSpx(String spxName, String image) {
        try {
            int j;
            int offset;
            int length;
            int i;
            if (!spxName.endsWith(".sprite")) {
                spxName = spxName + ".sprite";
            }
            if (!spxName.startsWith("/")) {
                spxName = "/" + spxName;
            }
            this.spxName = spxName;
            this.imageName = image;
            this.imageIndex = Resource.findImgIndex(this.imageName);
            InputStream is = "a".getClass().getResourceAsStream(spxName);
            DataInputStream data = new DataInputStream(is);
            int header = data.readInt();
            if (header != 1397772888) {
                throw new Exception("invalid SpriteX format\n");
            }
            byte version = data.readByte();
            if (version != 34) {
                throw new Exception("version no matching\n");
            }
            byte byteSequence = data.readByte();
            if ((byteSequence & 1) != 1) {
                throw new Exception("byte sequence error\n");
            }
            this.tileCount = (short)data.readInt();
            this.tileData = new short[this.tileCount][4];
            for (i = 0; i < this.tileCount; ++i) {
                this.tileData[i][0] = data.readShort();
                this.tileData[i][1] = data.readShort();
                this.tileData[i][2] = data.readShort();
                this.tileData[i][3] = data.readShort();
            }
            this.frameCount = (short)data.readInt();
            this.frameData = new short[this.frameCount][];
            for (i = 0; i < this.frameCount; ++i) {
                int frameTileCount = data.readInt();
                int collisionCount = data.readInt();
                int referencePointCount = data.readInt();
                length = 8 + frameTileCount * 4 + collisionCount * 4 + referencePointCount * 2;
                this.frameData[i] = new short[length];
                this.frameData[i][0] = (short)length;
                this.frameData[i][1] = (short)frameTileCount;
                this.frameData[i][2] = (short)collisionCount;
                this.frameData[i][3] = (short)referencePointCount;
                this.frameData[i][4] = data.readShort();
                this.frameData[i][5] = data.readShort();
                this.frameData[i][6] = data.readShort();
                this.frameData[i][7] = data.readShort();
                offset = 8;
                for (j = 0; j < frameTileCount; ++j) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    this.frameData[i][2 + offset] = data.readShort();
                    this.frameData[i][3 + offset] = data.readShort();
                    offset += 4;
                }
                for (j = 0; j < collisionCount; ++j) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    this.frameData[i][2 + offset] = data.readShort();
                    this.frameData[i][3 + offset] = data.readShort();
                    offset += 4;
                }
                for (j = 0; j < referencePointCount; ++j) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    offset += 2;
                }
            }
            this.actionCount = (short)data.readInt();
            this.actionData = new short[this.actionCount][];
            for (i = 0; i < this.actionCount; ++i) {
                int sequenceLength = data.readInt();
                byte delay = data.readByte();
                length = delay == 1 ? 4 + sequenceLength * 2 : 4 + sequenceLength;
                this.actionData[i] = new short[length];
                this.actionData[i][0] = (short)length;
                this.actionData[i][1] = (short)sequenceLength;
                this.actionData[i][2] = delay;
                this.actionData[i][3] = (short)data.readInt();
                offset = 4;
                if (delay == 1) {
                    for (j = 0; j < sequenceLength; ++j) {
                        this.actionData[i][offset] = data.readShort();
                        this.actionData[i][offset + 1] = data.readShort();
                        offset += 2;
                    }
                    continue;
                }
                for (j = 0; j < sequenceLength; ++j) {
                    this.actionData[i][offset] = data.readShort();
                    ++offset;
                }
            }
            this.visible = true;
            is.close();
        }
        catch (Exception ex) {
            System.out.println("Resource getKSprite wrong sprite : " + spxName + " png:" + image);
            ex.printStackTrace();
        }
    }

    public void setX(int x) {
        this.x = (short)x;
    }

    public void setY(int y) {
        this.y = (short)y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setAction(int actionIndex) {
        if (actionIndex == this.actionIndex) {
            return;
        }
        if (actionIndex < 0 || actionIndex >= this.actionCount) {
            throw new IndexOutOfBoundsException();
        }
        this.actionIndex = (short)actionIndex;
        this.sequenceIndex = 0;
        this.firstUpdate = false;
        this.toJudgeAnimationStop = false;
        this.oneFrameIsPlay = false;
        this.palyerCount = this.actionTime;
        this.lastTime = this.getDelayTime();
    }

    public int getAction() {
        return this.actionIndex;
    }

    public int getActionCount() {
        return this.actionCount;
    }

    public void setFrame(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.getSequenceLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.sequenceIndex = (short)sequenceIndex;
        this.firstUpdate = false;
        this.lastTime = this.getDelayTime();
    }

    public int getFrame() {
        return this.sequenceIndex;
    }

    public void setTransform(int transform) {
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException();
        }
        this.actionData[this.actionIndex][3] = (short)transform;
    }

    private int getTransform() {
        return this.actionData[this.actionIndex][3];
    }

    public void deasilRotate90() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][1]);
    }

    void anticlockwiseRotate90() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][0]);
    }

    void horizontalMirror() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][2]);
    }

    void verticalMirror() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][3]);
    }

    private void nextFrame() {
        this.sequenceIndex = (short)((this.sequenceIndex + 1) % this.getSequenceLength());
        this.lastTime = this.getDelayTime();
    }

    public boolean ActionEnd() {
        return this.sequenceIndex == this.getSequenceLength() - 1;
    }

    public boolean ActionIsOver() {
        if (this.palyerCount > 0) {
            if (this.getSequenceLength() == 1) {
                if (this.oneFrameIsPlay) {
                    this.toJudgeAnimationStop = true;
                    this.oneFrameIsPlay = false;
                } else {
                    this.oneFrameIsPlay = true;
                }
            } else if (this.sequenceIndex >= this.getSequenceLength() - 1) {
                this.toJudgeAnimationStop = true;
            }
        }
        if (this.toJudgeAnimationStop && this.sequenceIndex == 0) {
            this.toJudgeAnimationStop = false;
            this.palyerCount = (byte)(this.palyerCount - 1);
            if (this.palyerCount <= 0) {
                this.palyerCount = this.actionTime;
                return true;
            }
        }
        return false;
    }

    public void update() {
        if (!this.visible || this.getSequenceLength() == 0) {
            return;
        }
        if (this.isDelay()) {
            if (!this.firstUpdate) {
                this.firstUpdate = true;
            } else if (--this.lastTime <= 0L) {
                this.nextFrame();
            }
        } else if (!this.firstUpdate) {
            this.firstUpdate = true;
        } else {
            this.nextFrame();
        }
    }

    public int getSequenceFrame(int sequenceIndex) {
        if (this.isDelay()) {
            return this.actionData[this.actionIndex][4 + sequenceIndex * 2];
        }
        return this.actionData[this.actionIndex][4 + sequenceIndex];
    }

    public int getSequenceFrame() {
        if (this.isDelay()) {
            return this.actionData[this.actionIndex][4 + this.sequenceIndex * 2];
        }
        return this.actionData[this.actionIndex][4 + this.sequenceIndex];
    }

    public int getSequenceLength() {
        return this.actionData[this.actionIndex][1];
    }

    public short[] getCollision() {
        return this.getCollision(0);
    }

    public short[] getCollision(int num) {
        if (this.getSequenceLength() == 0) {
            return null;
        }
        short[] rect = new short[4];
        int frame = this.getSequenceFrame();
        short collision = this.frameData[frame][2];
        short frameTileCount = this.frameData[frame][1];
        if (num >= collision) {
            return null;
        }
        if (collision != 0) {
            int offset = 8 + frameTileCount * 4 + num * 4;
            System.arraycopy(this.frameData[frame], offset, rect, 0, rect.length);
            if (this.getTransform() == 2) {
                rect[0] = (short)(-rect[0] - rect[2]);
            }
        }
        return rect;
    }

    public int getCollisionLength() {
        return this.frameData[this.getSequenceFrame()][2];
    }

    private boolean isDelay() {
        return this.actionData[this.actionIndex][2] == 1;
    }

    public int getDelayTime() {
        int time = this.isDelay() ? this.actionData[this.actionIndex][4 + this.sequenceIndex * 2 + 1] : 0;
        return time;
    }

    public int getFrameTopPos() {
        return this.frameData[this.getSequenceFrame()][4] + this.y;
    }

    public int getFrameBottomPos() {
        return this.frameData[this.getSequenceFrame()][5] + this.y;
    }

    public int getFrameLeftPos() {
        return this.frameData[this.getSequenceFrame()][6] + this.x;
    }

    public int getFrameRightPos() {
        return this.frameData[this.getSequenceFrame()][7] + this.x;
    }

    public int getFrameWidth() {
        return this.getFrameRightPos() - this.getFrameLeftPos();
    }

    public int getFrameHeight() {
        return this.getFrameBottomPos() - this.getFrameTopPos();
    }

    public void paint(int x, int y) {
        this.paint(x, y, y);
    }

    public void paintSite(int x, int y, int layout) {
        short tempx = this.x;
        short tempy = this.y;
        this.paint(x, y, layout);
        this.x = tempx;
        this.y = tempy;
    }

    public void paint(int x, int y, int layout) {
        this.x = (short)x;
        this.y = (short)y;
        if (this.visible) {
            if (this.getSequenceLength() == 0) {
                return;
            }
            if (!this.firstUpdate) {
                this.firstUpdate = true;
            }
            int frameIndex = this.getSequenceFrame();
            int tileCount = this.frameData[frameIndex][1];
            int offset = 8;
            for (int i = 0; i < tileCount; ++i) {
                short dh;
                short dw;
                short tileIndex = this.frameData[frameIndex][0 + offset];
                int dx = this.frameData[frameIndex][1 + offset] + x;
                int dy = this.frameData[frameIndex][2 + offset] + y;
                short transform = this.frameData[frameIndex][3 + offset];
                short tx = this.tileData[tileIndex][0];
                short ty = this.tileData[tileIndex][1];
                short tw = this.tileData[tileIndex][2];
                int th = this.tileData[tileIndex][3];
                if ((transform & 4) != 0) {
                    dw = (short)th;
                    dh = tw;
                } else {
                    dw = tw;
                    dh = (short)th;
                }
                short cx = (short)(x - dx);
                short cy = (short)(y - dy);
                transform = TRANSFORM_TABLE[transform][this.getTransform()];
                switch (this.getTransform()) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        dx = x - (dh - cy);
                        dy = y - cx;
                        break;
                    }
                    case 3: {
                        dx = x - (dw - cx);
                        dy = y - (dh - cy);
                        break;
                    }
                    case 6: {
                        dx = x - cy;
                        dy = y - (dw - cx);
                        break;
                    }
                    case 2: {
                        dx = x - (dw - cx);
                        break;
                    }
                    case 7: {
                        dx = x - (dh - cy);
                        dy = y - (dw - cx);
                        break;
                    }
                    case 1: {
                        dy = y - (dh - cy);
                        break;
                    }
                    case 4: {
                        dx = x - cy;
                        dy = y - cx;
                    }
                }
                if (this.clip != null) {
                    int clipH = dy + th > this.clip[3] ? this.clip[3] - dy : th;
                    Resource.addImage(this.imageIndex, dx, dy, tx, ty, tw, clipH, 20, transform, layout);
                } else {
                    Resource.addImage(this.imageIndex, dx, dy, tx, ty, tw, th, 20, transform, layout);
                }
                offset += 4;
            }
        }
    }

    public void paint() {
        this.paint(this.x, this.y);
    }

    public void paint(int layout) {
        this.paint(this.x, this.y, layout);
    }

    public void setImage(String name) {
        this.imageName = name;
        this.imageIndex = Resource.findImgIndex(name);
    }

    public boolean hitNPC(KSpriteX ksx) {
        short[] rect1 = this.getCollision();
        short[] rect2 = ksx.getCollision();
        if (rect1 == null || rect2 == null || rect1[2] == 0 || rect1[3] == 0 || rect2[2] == 0 || rect2[3] == 0) {
            return false;
        }
        return KUtils.hit(this.x + rect1[0], this.y + rect1[1], rect1[2], rect1[3], ksx.x + rect2[0], ksx.y + rect2[1], rect2[2], rect2[3]);
    }

    public boolean hit(int index, int x2, int y2, int w2, int h2) {
        short[] rect1 = this.getCollision(index);
        if (rect1 == null || rect1[2] == 0 || rect1[3] == 0 || w2 == 0 || h2 == 0) {
            return false;
        }
        return KUtils.hit(this.x + rect1[0], this.y + rect1[1], rect1[2], rect1[3], x2, y2, w2, h2);
    }
}

