/*
 * Decompiled with CFR 0.152.
 */
package basic;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class KResPackage {
    public static boolean FROM_PACK = true;
    public static String resName = "";
    public static final int HEADER_ID = 21059;
    public static final int VERSION = 1;
    public static final int ASCII_STRING = 0;
    public static final int UNICODE_STRING = 1;
    public static final int UTF8_STRING = 2;
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    private static final int HEADER_SIZE = 16;
    private static boolean SUPPORT_RESET = true;
    protected int headerID;
    protected int version;
    protected int flags;
    protected int packSize;
    protected int passVerify;
    protected int fileCount;
    protected int[] fileHashs;
    protected int[] fileOffsets;
    protected int[] filePackeds;
    protected int[] fileSizes;
    protected boolean isEncrypt;
    protected String packName;
    protected InputStream is;
    protected int filepos;

    private KResPackage() {
    }

    public static KResPackage openPack(String name) throws Exception {
        if (name == null || name.length() < 2) {
            return null;
        }
        InputStream is = null;
        is = name.getClass().getResourceAsStream(name);
        if (is == null) {
            return null;
        }
        try {
            int i;
            int headerID = KResPackage.readWord(is, 0);
            int version = KResPackage.readByte(is);
            int flags = KResPackage.readByte(is);
            int byteEndian = (flags & 0x80) >> 7;
            int encrypt = (flags & 0x40) >> 6;
            int stringFormat = flags & 0xF;
            int packSize = KResPackage.readDWord(is, byteEndian);
            int passVerify = KResPackage.readDWord(is, byteEndian);
            int fileCount = KResPackage.readDWord(is, byteEndian);
            if (headerID != 21059) {
                return null;
            }
            if (stringFormat != 1) {
                return null;
            }
            if (version != 1) {
                return null;
            }
            int[] fileHashs = new int[fileCount];
            int[] fileOffsets = new int[fileCount];
            int[] filePackeds = new int[fileCount];
            int[] fileSizes = new int[fileCount];
            for (i = 0; i < fileCount; ++i) {
                fileHashs[i] = KResPackage.readDWord(is, byteEndian);
            }
            for (i = 0; i < fileCount; ++i) {
                fileOffsets[i] = KResPackage.readDWord(is, byteEndian);
                filePackeds[i] = KResPackage.readDWord(is, byteEndian);
                fileSizes[i] = KResPackage.readDWord(is, byteEndian);
            }
            KResPackage res = new KResPackage();
            if (res != null) {
                res.headerID = headerID;
                res.version = version;
                res.flags = flags;
                res.packSize = packSize;
                res.passVerify = passVerify;
                res.fileCount = fileCount;
                res.fileHashs = fileHashs;
                res.fileOffsets = fileOffsets;
                res.filePackeds = filePackeds;
                res.fileSizes = fileSizes;
                res.isEncrypt = encrypt == 1;
                res.packName = name;
                res.is = is;
                res.filepos = 0;
                return res;
            }
        }
        catch (Exception ex) {
            is.close();
            throw ex;
        }
        return null;
    }

    public void close() throws Exception {
        if (this.packName == null) {
            return;
        }
        this.fileHashs = null;
        this.fileOffsets = null;
        this.filePackeds = null;
        this.fileSizes = null;
        this.packName = null;
        this.filepos = 0;
        if (this.is != null) {
            this.is.close();
        }
        this.is = null;
    }

    /*
     * Unable to fully structure code
     */
    public void reset() throws Exception {
        if (this.packName == null) {
            return;
        }
        if (this.is == null) {
            return;
        }
        if (KResPackage.SUPPORT_RESET) {
            try {
                this.is.reset();
            }
            catch (IOException ex) {
                KResPackage.SUPPORT_RESET = false;
                this.is.close();
                this.is = this.packName.getClass().getResourceAsStream(this.packName);
                if (this.is != null) ** GOTO lbl21
                throw new IOException();
            }
        } else {
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
            this.is = this.packName.getClass().getResourceAsStream(this.packName);
            if (this.is == null) {
                throw new IOException();
            }
        }
lbl21:
        // 4 sources

        this.is.skip(16 + this.fileCount * 16);
        this.filepos = 0;
    }

    public int getFileIndex(String name) {
        int start;
        name = name.toUpperCase();
        int hash = name.hashCode();
        int index = start = (hash & Integer.MAX_VALUE) % this.fileCount;
        while (this.fileHashs[index] != hash && this.fileHashs[index = (index + 1) % this.fileCount] != hash) {
            if (index != start) continue;
            return -1;
        }
        return index;
    }

    public byte[] getFile(String name) throws IOException {
        return this.getFile(name, FROM_PACK);
    }

    public byte[] getFile(String name, boolean pack) throws IOException {
        if (pack) {
            int index = this.getFileIndex(name);
            System.out.println("name     " + name);
            System.out.println("index     " + index);
            if (index == -1) {
                return null;
            }
            int offset = this.fileOffsets[index];
            int packed = this.filePackeds[index];
            int size = this.fileSizes[index];
            int seek = offset - this.filepos;
            if (seek < 0) {
                try {
                    this.reset();
                    this.is.skip(offset);
                    this.filepos = offset;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                this.filepos += seek;
                this.is.skip(seek);
            }
            byte[] buf = new byte[packed];
            if (buf == null) {
                return null;
            }
            this.filepos += packed;
            if (this.is.read(buf, 0, buf.length) != packed) {
                return null;
            }
            return buf;
        }
        InputStream stream = name.getClass().getResourceAsStream(name);
        if (stream == null) {
            return null;
        }
        byte[] data = new byte[stream.available()];
        stream.read(data, 0, data.length);
        stream.close();
        return data;
    }

    public static int readByte(InputStream is) throws IOException {
        int ch = is.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public static int readWord(InputStream is, int mode) throws IOException {
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read())) < 0) {
            throw new EOFException();
        }
        if (mode == 0) {
            return (ch1 & 0xFF) << 8 | (ch2 & 0xFF) << 0;
        }
        return (ch1 & 0xFF) << 0 | (ch2 & 0xFF) << 8;
    }

    public static int readDWord(InputStream is, int mode) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read()) | (ch3 = is.read()) | (ch4 = is.read())) < 0) {
            throw new EOFException();
        }
        if (mode == 0) {
            return (ch1 & 0xFF) << 24 | (ch2 & 0xFF) << 16 | (ch3 & 0xFF) << 8 | (ch4 & 0xFF) << 0;
        }
        return (ch1 & 0xFF) << 0 | (ch2 & 0xFF) << 8 | (ch3 & 0xFF) << 16 | (ch4 & 0xFF) << 24;
    }

    public static String readString(InputStream is, int mode, int format) throws Exception {
        if (format != 0 && format == 1) {
            int size = KResPackage.readWord(is, mode);
            int length = size / 2;
            char[] ch = new char[length];
            for (int i = 0; i < length; ++i) {
                ch[i] = (char)KResPackage.readWord(is, mode);
            }
            return new String(ch);
        }
        throw new IllegalArgumentException();
    }
}

