/*
 * Decompiled with CFR 0.152.
 */
package basic;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class KDBTable {
    public static final int HEADER_ID = 17474;
    public static final byte VERSION = 1;
    public static final byte ASCII_STRING = 0;
    public static final byte UNICODE_STRING = 1;
    public static final byte LITTLE_ENDIAN = 0;
    public static final byte BIG_ENDIAN = 1;
    public static final byte TYPE_BYTE = 1;
    public static final byte TYPE_WORD = 2;
    public static final byte TYPE_DWORD = 3;
    public static final byte TYPE_STRING = 4;
    protected int fieldCount;
    protected int rowCount;
    protected byte[] fieldType;
    protected Hashtable hashtable;
    protected Object[] rows;

    private KDBTable() {
    }

    public static KDBTable openDB(String name, byte[] obj) throws Exception {
        if (obj == null || obj.length < 1) {
            return KDBTable.openDB(name);
        }
        return null;
    }

    public static KDBTable openDB(String name) throws Exception {
        InputStream is = name.getClass().getResourceAsStream(name);
        if (is == null) {
            return null;
        }
        try {
            int headerID = KDBTable.readWord(is, 0);
            int version = KDBTable.readByte(is);
            int flags = KDBTable.readByte(is);
            int byteEndian = (flags & 0x80) >> 7;
            int stringFormat = flags & 0xF;
            int fileSize = KDBTable.readDWord(is, byteEndian);
            int indexKey = KDBTable.readByte(is);
            int fieldCount = KDBTable.readByte(is);
            int rowCount = KDBTable.readWord(is, byteEndian);
            if (headerID != 17474) {
                KDBTable kDBTable = null;
                return kDBTable;
            }
            if (stringFormat != 1) {
                KDBTable kDBTable = null;
                return kDBTable;
            }
            if (version != 1) {
                KDBTable kDBTable = null;
                return kDBTable;
            }
            if (indexKey < 0 || indexKey >= fieldCount) {
                KDBTable kDBTable = null;
                return kDBTable;
            }
            byte[] fieldType = new byte[fieldCount];
            String[] fieldName = new String[fieldCount];
            Object[] rows = new Object[fieldCount];
            block22: for (int i = 0; i < fieldCount; ++i) {
                fieldType[i] = (byte)KDBTable.readByte(is);
                fieldName[i] = KDBTable.readString(is, byteEndian, stringFormat);
                switch (fieldType[i]) {
                    case 1: {
                        rows[i] = new byte[rowCount];
                        continue block22;
                    }
                    case 2: {
                        rows[i] = new short[rowCount];
                        continue block22;
                    }
                    case 3: {
                        rows[i] = new int[rowCount];
                        continue block22;
                    }
                    case 4: {
                        rows[i] = new String[rowCount];
                        continue block22;
                    }
                    default: {
                        KDBTable kDBTable = null;
                        return kDBTable;
                    }
                }
            }
            Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>(rowCount);
            String key = null;
            Integer value = null;
            for (int i = 0; i < rowCount; ++i) {
                block24: for (int j = 0; j < fieldCount; ++j) {
                    Object row = rows[j];
                    switch (fieldType[j]) {
                        case 1: {
                            Object[] val = (byte[])row;
                            val[i] = (byte)KDBTable.readByte(is);
                            if (j != indexKey) continue block24;
                            key = "" + val[i];
                            value = new Integer(i);
                            continue block24;
                        }
                        case 2: {
                            Object[] val = (short[])row;
                            val[i] = (short)KDBTable.readWord(is, byteEndian);
                            if (j != indexKey) continue block24;
                            key = "" + val[i];
                            value = new Integer(i);
                            continue block24;
                        }
                        case 3: {
                            Object[] val = (int[])row;
                            val[i] = KDBTable.readDWord(is, byteEndian);
                            if (j != indexKey) continue block24;
                            key = "" + val[i];
                            value = new Integer(i);
                            continue block24;
                        }
                        case 4: {
                            Object[] val = (String[])row;
                            val[i] = (byte)KDBTable.readString(is, byteEndian, stringFormat);
                            if (j != indexKey) continue block24;
                            key = (String)val[i];
                            value = new Integer(i);
                            continue block24;
                        }
                    }
                }
                hashtable.put(key, value);
            }
            KDBTable db = new KDBTable();
            if (db != null) {
                db.fieldCount = fieldCount;
                db.rowCount = rowCount;
                db.fieldType = fieldType;
                db.hashtable = hashtable;
                db.rows = rows;
                KDBTable kDBTable = db;
                return kDBTable;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            is.close();
        }
        return null;
    }

    public void close() {
        this.fieldType = null;
        this.hashtable.clear();
        this.rows = null;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getFieldType(int index) {
        return this.fieldType[index];
    }

    public String[] getRowFromIndex(int index) {
        String[] rowList = new String[this.fieldCount];
        block6: for (int i = 0; i < this.fieldCount; ++i) {
            Object row = this.rows[i];
            switch (this.fieldType[i]) {
                case 1: {
                    Object[] values = (byte[])row;
                    rowList[i] = "" + (values[index] & 0xFF);
                    continue block6;
                }
                case 2: {
                    Object[] values = (short[])row;
                    rowList[i] = "" + (values[index] & 0xFFFF);
                    continue block6;
                }
                case 3: {
                    Object[] values = (int[])row;
                    rowList[i] = "" + (values[index] & 0xFFFFFFFF);
                    continue block6;
                }
                case 4: {
                    Object[] values = (String[])row;
                    rowList[i] = (String)values[index];
                }
            }
        }
        return rowList;
    }

    public String[] getRow(String keyName) {
        Integer value = (Integer)this.hashtable.get(keyName);
        if (value != null) {
            int index = value;
            return this.getRowFromIndex(index);
        }
        return null;
    }

    public static int readByte(InputStream is) throws IOException {
        int ch = is.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public static int readWord(InputStream is, int mode) throws IOException {
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read())) < 0) {
            throw new EOFException();
        }
        if (mode == 0) {
            return (ch1 & 0xFF) << 8 | (ch2 & 0xFF) << 0;
        }
        return (ch1 & 0xFF) << 0 | (ch2 & 0xFF) << 8;
    }

    public static int readDWord(InputStream is, int mode) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read()) | (ch3 = is.read()) | (ch4 = is.read())) < 0) {
            throw new EOFException();
        }
        if (mode == 0) {
            return (ch1 & 0xFF) << 24 | (ch2 & 0xFF) << 16 | (ch3 & 0xFF) << 8 | (ch4 & 0xFF) << 0;
        }
        return (ch1 & 0xFF) << 0 | (ch2 & 0xFF) << 8 | (ch3 & 0xFF) << 16 | (ch4 & 0xFF) << 24;
    }

    public static String readString(InputStream is, int mode, int format) throws Exception {
        if (format != 0 && format == 1) {
            int size = KDBTable.readWord(is, mode);
            int length = size / 2;
            char[] ch = new char[length];
            for (int i = 0; i < length; ++i) {
                ch[i] = (char)KDBTable.readWord(is, mode);
            }
            return new String(ch);
        }
        throw new IllegalArgumentException();
    }
}

