/*
 * Decompiled with CFR 0.152.
 */
package basic;

import basic.BasicCanvas;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class KConfig {
    private static final byte ASCII = 0;
    private static final byte UNICODE = 1;
    private static final byte UTF8 = 2;
    private static final byte UNKNOWN = -1;
    Hashtable hashtable = new Hashtable();
    byte characterset = (byte)-1;

    public KConfig() {
    }

    public KConfig(String name, byte[] a) {
        this();
        if (a == null || a.length < 1) {
            this.open(name);
        } else {
            this.open(a);
        }
    }

    public void close() {
        this.hashtable.clear();
        this.characterset = (byte)-1;
    }

    public boolean open(InputStream is) {
        this.close();
        if (is == null) {
            return false;
        }
        try {
            String line;
            while ((line = this.getLine(is)) != null) {
                int split;
                if (line.equals("") || line.charAt(0) == ';' || (split = line.indexOf("=")) == -1) continue;
                String key = line.substring(0, split);
                String value = line.substring(split + 1, line.length());
                key = key.trim();
                value = value.trim();
                this.hashtable.put(key, value);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean open(byte[] data) {
        if (data == null) {
            return false;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        if (bis == null) {
            return false;
        }
        boolean ret = this.open(bis);
        try {
            bis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public boolean open(String name) {
        InputStream is = this.getClass().getResourceAsStream(name);
        if (is == null) {
            BasicCanvas.Debug("KConfig open() can not found !" + name);
            return false;
        }
        boolean ret = this.open(is);
        try {
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    private String getLine(InputStream is) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int ch1 = is.read();
        int ch2 = 0;
        if (ch1 == -1) {
            return null;
        }
        if (this.characterset == -1) {
            if (ch1 == 255) {
                is.skip(1L);
                ch1 = is.read();
                ch2 = is.read();
                this.characterset = 1;
            } else {
                this.characterset = 0;
            }
        } else if (this.characterset == 1) {
            ch2 = is.read();
        }
        block0 : switch (this.characterset) {
            case 0: {
                while (ch1 != -1) {
                    if (ch1 == 13) {
                        is.skip(1L);
                        break block0;
                    }
                    buffer.append((char)ch1);
                    ch1 = is.read();
                }
                break;
            }
            case 1: {
                while (ch1 != -1 && ch2 != -1) {
                    if (ch1 == 13 && ch2 == 0) {
                        is.skip(2L);
                        break block0;
                    }
                    buffer.append((char)(ch1 & 0xFF | (ch2 & 0xFF) << 8));
                    ch1 = is.read();
                    ch2 = is.read();
                }
                break;
            }
            case 2: {
                break;
            }
            default: {
                return null;
            }
        }
        return buffer.toString();
    }

    public int getIntProp(String key, int defval) {
        String val = (String)this.hashtable.get(key);
        if (val == null) {
            return defval;
        }
        return Integer.parseInt(val);
    }

    public String getStringProp(String key, String defval) {
        String val = (String)this.hashtable.get(key);
        if (val == null) {
            return defval;
        }
        return val;
    }
}

