/*
 * Decompiled with CFR 0.152.
 */
package basic;

import KScript.INativeAPI;
import KScript.KScriptObjXTempManager;
import KScript.KScriptObjectX;
import KScript.KVMX;
import basic.BeginMidlet;
import basic.Draw;
import basic.IMessage;
import basic.KConfig;
import basic.KSpriteX;
import basic.KUtils;
import basic.Resource;
import draw.DialogueDraw;
import draw.GameMainDraw;
import draw.MenuDraw;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class BasicCanvas
extends Canvas
implements Runnable,
IMessage,
INativeAPI {
    private final int LOGO;
    private final int LOGOEND;
    private final int MAP_DRAW;
    private final int DIALOGUE;
    private final int EFFECT_DRAW;
    private final int MENU_DRAW;
    public static short eachFrameTime = (short)80;
    private static long frameTime;
    private static long sleepTime;
    public static final Font fontStyle;
    public static final byte fontHeight;
    public static final byte fontWidth;
    private static Thread thread;
    public static short screenWidth;
    public static short screenHeight;
    private static BasicCanvas canvas;
    private static Vector drawVector;
    private static DialogueDraw dialogueDraw;
    public static GameMainDraw mapDraw;
    public static MenuDraw menuDraw;
    private static KVMX kvmx;
    public static KScriptObjectX dialogueKsox;
    private static KScriptObjectX effectKsox;
    private static KScriptObjectX logoKsox;
    private static KScriptObjXTempManager tempManager;
    public static short selectIndex;
    public static int count;
    public static boolean isRefurbish;
    boolean isInit = false;
    public static boolean showDebug;
    public static int startLine;
    public static Vector debugV;
    private static Player sound;
    public static String musicName;
    private static boolean isPlay;
    public static byte volume;
    private static VolumeControl volumecontrol;
    private static byte loop;
    public static final int ANY_KEY = 1;
    public static final int KEY_NUM0 = 2;
    public static final int KEY_NUM1 = 4;
    public static final int KEY_NUM2 = 8;
    public static final int KEY_NUM3 = 16;
    public static final int KEY_NUM4 = 32;
    public static final int KEY_NUM5 = 64;
    public static final int KEY_NUM6 = 128;
    public static final int KEY_NUM7 = 256;
    public static final int KEY_NUM8 = 512;
    public static final int KEY_NUM9 = 1024;
    public static final int KEY_STAR = 2048;
    public static final int KEY_POUND = 4096;
    public static final int KEY_UP = 8192;
    public static final int KEY_DOWN = 16384;
    public static final int KEY_LEFT = 32768;
    public static final int KEY_RIGHT = 65536;
    public static final int KEY_OK = 131072;
    public static final int KEY_SELECT = 262144;
    public static final int KEY_BACK = 524288;
    public static final int KEY_GAME_UP = 8200;
    public static final int KEY_GAME_DOWN = 16896;
    public static final int KEY_GAME_LEFT = 32800;
    public static final int KEY_GAME_RIGHT = 65664;
    public static final int KEY_GAME_OK = 131136;
    public static int[] keyCodeArray;
    public static int pressKeyInfo;
    public static boolean oldisRun;
    public static boolean isLook;
    public static short lookNpc;
    public static KScriptObjectX cueksox;
    public static Vector cueStrs;
    public static byte cueIndex;
    public static boolean isCue;
    private static short cueWidth;
    static short cueY;
    static short cueX;
    int cueColor = 0xFFFFFF;
    static long time;
    static int defer;
    static int compelDefer;
    static byte[] eachCueColor;
    static byte eachLinesCueNum;
    static boolean isColorCue;
    public static boolean isSelectCue;
    static String selectStr;
    public static byte selectId;
    static short selectNum;
    public static boolean isDrawEffect;
    public byte effectSpeed = (byte)8;
    public boolean open;
    boolean isLeft;
    public static final byte LOGO_IMAGE = 1;
    public static final byte LOGO_SPRITE = 2;
    public static final byte LOGO_MUSIC = 3;
    boolean isLogo;
    private static int logoID;
    private static byte logostate;
    public static short image;
    private static short imageTime;
    public static KSpriteX sprite;
    private int logoBgColor;

    public BasicCanvas() {
        this.LOGO = 1001;
        this.LOGOEND = 1002;
        this.MAP_DRAW = 1201;
        this.DIALOGUE = 1301;
        this.EFFECT_DRAW = 1501;
        this.MENU_DRAW = 1701;
        this.setFullScreenMode(true);
        screenWidth = (short)240;
        screenHeight = (short)320;
    }

    public void initConfig() {
        KConfig conf = Resource.getKConfig("/config.ini");
        int length = conf.getIntProp("0", 20);
        length = length == 0 ? 20 : length;
        keyCodeArray = new int[length];
        for (int i = length - 1; i > -1; --i) {
            BasicCanvas.keyCodeArray[i] = conf.getIntProp("" + i, 0);
        }
        KUtils.isSay = conf.getIntProp("isSay", 1) == 1;
        KUtils.isDead = conf.getIntProp("isDead", 1) == 1;
        KUtils.isMinus = conf.getIntProp("isMinus", 1) == 1;
        KUtils.isSuper = conf.getIntProp("super", 0) == 1;
        KUtils.isDrawTest = conf.getIntProp("test", 1) == 1;
        KUtils.loadSprictRc = true;
        int rc = conf.getIntProp("isRC", -1);
        if (rc != -1) {
            KUtils.loadSprictRc = conf.getIntProp("isRC", 1) == 1;
        }
    }

    private void init() {
        this.initConfig();
        kvmx = KVMX.getInstance();
        kvmx.registerClass(this, "main");
        tempManager = new KScriptObjXTempManager();
        kvmx.registerClass(tempManager, "temp");
        mapDraw = new GameMainDraw(screenWidth, screenWidth);
        kvmx.registerClass(mapDraw, "map");
        mapDraw.setId(1201);
        mapDraw.setIM(this);
        menuDraw = new MenuDraw(screenWidth, screenHeight, this);
        menuDraw.initSite(screenWidth, screenHeight);
        menuDraw.setId(1701);
        menuDraw.setIM(this);
        kvmx.registerClass(menuDraw, "menu");
        dialogueDraw = new DialogueDraw(screenWidth, screenHeight);
        dialogueDraw.setId(1301);
        dialogueDraw.setIM(this);
        drawVector = new Vector();
        canvas = this;
        this.initRes();
        GameMainDraw.loadMainRms();
        MenuDraw.loadNoteRms();
        KScriptObjectX tempKsox = Resource.getKSOX("/gamess/begin.s");
        tempKsox.runMethods("main");
    }

    private void initRes() {
        KUtils.numPng = new short[]{64, 64, 65, 64, 64, 23, 64};
        KUtils.numWidth = new byte[]{10, 10, 7, 10, 10, 20, 10};
        KUtils.numHeight = new byte[]{12, 12, 9, 12, 12, 21, 12};
        KUtils.loadAngleValue();
        cueWidth = (short)Math.max(176, screenWidth - 20);
        cueY = (short)(screenHeight / 2 - 24);
        cueX = (short)((screenWidth - cueWidth) / 2);
    }

    public static void kvmxRun() {
        kvmx.run();
    }

    public static BasicCanvas getCanvas() {
        return canvas;
    }

    public void beginRun() {
        if (!this.isInit) {
            this.init();
            this.isInit = true;
        }
        if (thread == null) {
            thread = new Thread(this);
            thread.start();
        }
    }

    public static void Debug(String info) {
        KUtils.testNewline(info, screenWidth, debugV);
    }

    private void drawDebug(Graphics g) {
        int size = debugV.size();
        g.setClip(0, 0, (int)screenWidth, (int)screenHeight);
        for (int i = 0; i < size; ++i) {
            if (showDebug) {
                g.setColor(0xFFFFFF);
                g.drawString(debugV.elementAt(i + startLine).toString(), 0, i * (fontHeight + 2), 20);
            }
            if (i * (fontHeight + 2) < screenHeight) continue;
            ++startLine;
            break;
        }
        if (startLine > 0) {
            this.resetDebug();
        }
    }

    public void resetDebug() {
        startLine = 0;
        debugV.removeAllElements();
    }

    protected void paint(Graphics g) {
        int size;
        if (!this.isInit) {
            return;
        }
        if (isRefurbish) {
            g.setColor(0);
            g.fillRect(0, 0, (int)screenWidth, (int)screenHeight);
        }
        g.setFont(fontStyle);
        for (int i = size = drawVector.size() - 1; i >= 0; --i) {
            Draw draw = (Draw)drawVector.elementAt(i);
            if (!draw.show) continue;
            draw.paint(g);
        }
        this.drawCue(g);
        BasicCanvas.drawSelectCue(g);
        Resource.drawAll(g);
        if (DialogueDraw.isDialogue) {
            dialogueDraw.paint(g);
        }
        if (this.isLogo) {
            this.drawLogo(g);
        }
        if (isDrawEffect && BasicCanvas.mapDraw.drawStatus == 1) {
            this.drawEffect(g);
            if (!isDrawEffect && effectKsox != null) {
                effectKsox.setWait(true);
                effectKsox = null;
            }
        }
    }

    private void drawCue(Graphics g) {
        if (isCue) {
            if (cueStrs.size() <= 0) {
                return;
            }
            int num = Integer.parseInt((String)cueStrs.elementAt(cueIndex * 2 + 1));
            BasicCanvas.drawCueSkin(cueX, cueY, cueWidth, num + 10);
            KUtils.drawText((String)cueStrs.elementAt(cueIndex * 2), screenWidth >> 1, cueY + 5, cueWidth - 11, 17, this.cueColor);
        }
    }

    public static void drawCueSkin(int x, int y, int w, int h) {
        Resource.addRect((byte)1, x + 1, y + 1, w - 2, h - 2, true, 0, 0x212121, 2000);
        KUtils.drawCrossRect(x, y, w, h, 0xFFFFFF, -1);
    }

    public static void loadMusicFrome(String fileName, int inloop) {
        if (fileName == null || fileName.equals("")) {
            return;
        }
        if (sound != null) {
            try {
                if (sound.getState() == 400) {
                    sound.stop();
                }
                if (sound.getState() == 300) {
                    sound.deallocate();
                }
                sound.close();
                sound = null;
            }
            catch (MediaException e) {
                e.printStackTrace();
            }
        }
        musicName = fileName;
        loop = (byte)inloop;
        isPlay = true;
    }

    public static void startMusic() {
        try {
            if (sound != null) {
                sound.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setMusicVolume(int level) {
        if (level != 0) {
            volume = (byte)level;
            if (volumecontrol != null) {
                volumecontrol.setLevel(level);
            } else {
                isPlay = true;
            }
        } else {
            BasicCanvas.stopMusic(true);
        }
    }

    public static void stopMusic(boolean isClear) {
        try {
            if (sound != null) {
                if (isClear) {
                    if (sound.getState() == 400) {
                        sound.stop();
                    }
                    if (sound.getState() == 300) {
                        sound.deallocate();
                    }
                    sound.close();
                    sound = null;
                    volumecontrol = null;
                    volume = 0;
                } else {
                    sound.stop();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        isPlay = false;
    }

    public void run() {
        while (true) {
            long startTime = System.currentTimeMillis();
            try {
                if (isPlay && volume != 0) {
                    InputStream inputstream = this.getClass().getResourceAsStream(musicName);
                    sound = Manager.createPlayer((InputStream)inputstream, (String)"audio/midi");
                    sound.setLoopCount((int)loop);
                    sound.start();
                    volumecontrol = (VolumeControl)sound.getControl("VolumeControl");
                    volumecontrol.setLevel((int)volume);
                    isPlay = false;
                }
            }
            catch (MediaException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.logic();
            this.repaint();
            frameTime = System.currentTimeMillis() - startTime;
            if (frameTime < (long)eachFrameTime) {
                try {
                    sleepTime = (long)eachFrameTime - frameTime;
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else if (frameTime > (long)eachFrameTime) {
                // empty if block
            }
            if (BeginMidlet.isUrl) {
                if (BeginMidlet.isQuit) {
                    this.quit();
                }
                BeginMidlet.getMidlet().Url();
                if (!BeginMidlet.isQuit) continue;
                BasicCanvas.stopMusic(true);
                BeginMidlet.getMidlet().exit();
                continue;
            }
            if (!BeginMidlet.isQuit) continue;
            BasicCanvas.stopMusic(true);
            this.quit();
            BeginMidlet.getMidlet().exit();
        }
    }

    public static boolean pressKey(int key) {
        return (pressKeyInfo & key) != 0;
    }

    public static boolean hitKey(int key) {
        boolean ret = (pressKeyInfo & key) != 0;
        pressKeyInfo &= ~key;
        return ret;
    }

    public static boolean anyPressKey() {
        return (pressKeyInfo & 1) == 0;
    }

    public static boolean anyHitKey() {
        return pressKeyInfo != 1 && pressKeyInfo != 0;
    }

    public static boolean anyKeyUp() {
        return pressKeyInfo == 1;
    }

    public void keyPressed(int keyCode) {
        pressKeyInfo &= 0xFFFFFFFE;
        for (int i = keyCodeArray.length - 1; i > 0; --i) {
            if (keyCodeArray[i] != keyCode) continue;
            pressKeyInfo |= 1 << i % 20;
            break;
        }
    }

    public void keyReleased(int keyCode) {
        pressKeyInfo |= 1;
        for (int i = keyCodeArray.length - 1; i > 0; --i) {
            if (keyCodeArray[i] != keyCode) continue;
            pressKeyInfo &= ~(1 << i % 20);
            break;
        }
    }

    public void logic() {
        if (BeginMidlet.isPause) {
            if (--compelDefer < 0 && BasicCanvas.anyHitKey()) {
                BeginMidlet.isPause = false;
                BasicCanvas.startMusic();
                BasicCanvas.closeCue();
                pressKeyInfo = 0;
            }
            return;
        }
        BasicCanvas.kvmxRun();
        if (!isDrawEffect) {
            for (int i = drawVector.size() - 1; i >= 0; --i) {
                Draw draw = (Draw)drawVector.elementAt(i);
                if (draw.run) {
                    draw.logic();
                }
                if (i != 0 || !draw.keyResponse || DialogueDraw.isDialogue || isCue) continue;
                draw.key();
            }
        }
        ++count;
        if (isCue) {
            BasicCanvas.cueKey();
        }
        if (DialogueDraw.isDialogue) {
            dialogueDraw.logicMain();
            dialogueDraw.key();
        }
        if (this.isLogo) {
            this.logoLogic();
        }
    }

    public static void cueKey() {
        if (defer != 0 && System.currentTimeMillis() - time >= (long)defer) {
            time = System.currentTimeMillis();
            BasicCanvas.closeCue();
        }
        if (System.currentTimeMillis() - time >= (long)compelDefer && BasicCanvas.hitKey(131136)) {
            time = System.currentTimeMillis();
            BasicCanvas.closeCue();
        }
    }

    public static void addCanvas(Draw draw) {
        drawVector.addElement(draw);
    }

    public static void removeCanvas(Draw draw) {
        drawVector.removeElement(draw);
    }

    public static void addDrawToTop(Draw draw) {
        if (drawVector.contains(draw)) {
            drawVector.removeElement(draw);
        }
        drawVector.insertElementAt(draw, 0);
    }

    public static boolean containsDraw(Draw draw) {
        return drawVector.contains(draw);
    }

    public void quit() {
        Thread.yield();
    }

    public void toEffectDraw(int obj) {
        this.setEffect(obj);
    }

    public static void toMenu() {
        menuDraw.init();
        BasicCanvas.addDrawToTop(menuDraw);
    }

    public static void removeAllCanvas() {
        drawVector = new Vector();
    }

    public void toDialogueDraw(String obj, int id, int look, int site) {
        dialogueDraw.init(1, obj, site);
    }

    public static void toMapDraw(KScriptObjectX obj) {
        GameMainDraw.isLoadEnd = true;
        GameMainDraw.mapKsox = obj;
        GameMainDraw.mapKsox.setWait(false);
        GameMainDraw.resetNpcArray(GameMainDraw.showEnemy);
        BasicCanvas.addDrawToTop(mapDraw);
        eachFrameTime = (short)80;
    }

    public void toMainMenuDraw() {
        menuDraw.initMain();
        BasicCanvas.removeAllCanvas();
        BasicCanvas.addDrawToTop(menuDraw);
        mapDraw.clearMemory();
    }

    public void receiveMessage(int id, int a, int b) {
        if (id == 1001) {
            if (logoKsox != null) {
                logoKsox.setWait(true);
            }
        } else if (id == 1002) {
            if (logoKsox != null) {
                logoKsox.setWait(true);
                logoKsox = null;
            }
            this.clearLogo();
        } else if (id == 1301) {
            if (dialogueKsox != null) {
                dialogueKsox.setWait(true);
                dialogueKsox = null;
            }
            if (a == 1) {
                if (isLook) {
                    isLook = false;
                }
            } else {
                selectIndex = (short)b;
            }
        } else if (id == 1501) {
            if (effectKsox != null) {
                effectKsox.setWait(true);
            }
            isDrawEffect = false;
        } else if (id == 1701) {
            BasicCanvas.removeCanvas(menuDraw);
            menuDraw.clear();
            if (a == 1) {
                this.toMainMenuDraw();
            } else if (a != 30) {
                BasicCanvas.addDrawToTop(mapDraw);
                BasicCanvas.mapDraw.run = true;
            }
        }
    }

    public void newGame() {
        GameMainDraw.newGame();
    }

    public void callAPI(KScriptObjectX obj, String method) {
        if (!this.callGameAPI(obj, method)) {
            if (method.indexOf("Logo") != -1) {
                this.callLogoAPI(obj, method);
            } else if (method.indexOf("Menu") != -1) {
                this.callMenuAPI(obj, method);
            }
        }
    }

    private boolean callGameAPI(KScriptObjectX obj, String method) {
        if (method.equals("say")) {
            if (!KUtils.isSay) {
                return true;
            }
            dialogueKsox = obj;
            dialogueKsox.setWait(false);
            int site = obj.getInt();
            String aS = obj.getString();
            this.toDialogueDraw(aS, -1, 0, site);
        } else if (method.equals("showMap")) {
            BasicCanvas.toMapDraw(obj);
        } else if (method.equals("toSelect")) {
            dialogueKsox = obj;
            dialogueKsox.setWait(false);
            String words = obj.getString();
            dialogueDraw.initSelect(words, 2);
        } else if (method.equals("toSelectSay")) {
            dialogueKsox = obj;
            dialogueKsox.setWait(false);
            String words = obj.getString();
            String aS = obj.getString();
            this.toDialogueDraw(aS, -1, 0, 0);
            dialogueDraw.initSelect(words, 3);
        } else if (method.equals("getSelect")) {
            obj.setRetVal(selectIndex);
        } else if (method.equals("toEffect")) {
            effectKsox = obj;
            effectKsox.setWait(false);
            int index = obj.getInt();
            this.toEffectDraw(index);
        } else if (method.equals("clearScript")) {
            Resource.clearKScriptObjectXExcept(obj);
        } else if (method.equals("initGame")) {
            this.newGame();
        } else if (method.equals("loadMusic")) {
            BasicCanvas.loadMusicFrome(obj.getString(), -1);
        } else if (method.equals("gameExit")) {
            BeginMidlet.getMidlet();
            BeginMidlet.quit();
        } else if (method.equals("toHint")) {
            boolean is = obj.getBoolean();
            int t = obj.getInt();
            int n = obj.getInt();
            String str = obj.getString();
            BasicCanvas.initCue(str, n, t);
            if (!is) {
                obj.setWait(false);
                cueksox = obj;
            }
        } else if (method.equals("toCue")) {
            String str = obj.getString();
            BasicCanvas.initCue(str, 2000, 500);
            obj.setWait(false);
            if (cueksox != null) {
                cueksox.setWait(true);
            }
            cueksox = obj;
        } else if (method.equals("toColorCue")) {
            int t = obj.getInt();
            int n = obj.getInt();
            String str = obj.getString();
            BasicCanvas.initColorCue(str, n, t);
            obj.setWait(false);
            cueksox = obj;
        } else if (method.equals("gameKey")) {
            int key = obj.getInt();
            pressKeyInfo = 1;
            this.keyPressed(keyCodeArray[key]);
            mapDraw.playerControl();
            pressKeyInfo = 1;
        } else if (method.equals("randomNum")) {
            int max = obj.getInt();
            int min = obj.getInt();
            obj.setRetVal(KUtils.genRand(min, max));
        } else if (method.equals("isbbx")) {
            obj.setRetVal(true);
        } else if (method.equals("isS_MID")) {
            obj.setRetVal(false);
        } else if (method.equals("isM_MID")) {
            obj.setRetVal(true);
        } else if (method.equals("isQQ")) {
            obj.setRetVal(false);
        } else if (method.equals("isDX")) {
            obj.setRetVal(false);
        } else if (method.equals("isTouch")) {
            obj.setRetVal(false);
        } else if (method.equals("isURL")) {
            obj.setRetVal(true);
        } else if (method.equals("isMuisc")) {
            obj.setRetVal(true);
        } else if (method.equals("getModel")) {
            obj.setRetVal(0);
        } else if (method.equals("print")) {
            System.out.println("\u6807\u7b7e---   " + obj.getString());
        } else if (method.equals("screenWidth")) {
            obj.setRetVal(screenWidth);
        } else if (method.equals("screenHeight")) {
            obj.setRetVal(screenHeight);
        } else {
            return false;
        }
        return true;
    }

    private boolean callMenuAPI(KScriptObjectX obj, String method) {
        if (method.equals("toMenu")) {
            this.toMainMenuDraw();
        } else if (method.equals("toNoteMenu")) {
            BasicCanvas.toNoteMenu();
        } else if (method.equals("removeMenu")) {
            BasicCanvas.removeCanvas(menuDraw);
            menuDraw.clear();
        } else if (method.equals("setMenuKey")) {
            int key = obj.getInt();
            pressKeyInfo = 1;
            MenuDraw.menuIsBack = true;
            this.keyPressed(keyCodeArray[key]);
            BasicCanvas.menuDraw.keyCount = 0;
            menuDraw.menuDrawKey();
            pressKeyInfo = 1;
        } else if (method.equals("isMenuBack")) {
            MenuDraw.menuIsBack = obj.getBoolean();
        } else {
            return false;
        }
        return true;
    }

    private boolean callLogoAPI(KScriptObjectX obj, String method) {
        if (method.equals("addSpriteLogo")) {
            logoID = obj.getInt();
            String png = obj.getString();
            String spr = obj.getString();
            this.addKSpriteX(Resource.getKSpriteX(spr, png));
            obj.setWait(false);
            logoKsox = obj;
        } else if (method.equals("addImageLogo")) {
            logoID = obj.getInt();
            int time = obj.getInt();
            String png = obj.getString();
            this.addImage(Resource.findImgIndex(png), time);
            obj.setWait(false);
            logoKsox = obj;
        } else if (method.equals("addMusicLogo")) {
            logoID = obj.getInt();
            this.toSMusic();
            obj.setWait(false);
            logoKsox = obj;
        } else if (method.equals("setLogoBgColor")) {
            int b = obj.getInt();
            int g = obj.getInt();
            int r = obj.getInt();
            this.setLogoColor(r, g, b);
        } else {
            return false;
        }
        return true;
    }

    public static void toNoteMenu() {
        menuDraw.init();
        menuDraw.initNote();
        BasicCanvas.addDrawToTop(menuDraw);
    }

    public static void initCue(String str, int a, int t) {
        String old;
        if (cueStrs.size() > 1 && (old = (String)cueStrs.elementAt(cueStrs.size() - 2)).equals(str)) {
            return;
        }
        isCue = true;
        isColorCue = false;
        cueStrs.addElement(str);
        int w = fontWidth * str.length();
        cueStrs.addElement("" + (w / (cueWidth - 6) + (w % (cueWidth - 6) == 0 ? 0 : 1)) * (fontHeight + 1));
        time = System.currentTimeMillis();
        defer = a;
        compelDefer = t;
    }

    public static void initColorCue(String str, int a, int t) {
        Vector v = new Vector();
        StringBuffer sb = DialogueDraw.getColorVector(str, v);
        eachCueColor = new byte[v.size()];
        int temp = -1;
        for (int i = 0; i < eachCueColor.length; ++i) {
            BasicCanvas.eachCueColor[i] = ((Integer)v.elementAt(i)).byteValue();
            if (eachCueColor[i] != -1) {
                temp = eachCueColor[i];
                continue;
            }
            BasicCanvas.eachCueColor[i] = temp;
        }
        char[] cueArray = sb.toString().toCharArray();
        cueStrs.addElement(cueArray);
        int w = fontWidth * cueArray.length;
        cueStrs.addElement("" + (w / (cueWidth - 6) + (w % (cueWidth - 6) == 0 ? 0 : 1)) * (fontHeight + 1));
        eachLinesCueNum = (byte)((cueWidth - 6) / fontWidth);
        isColorCue = true;
        isCue = true;
        time = System.currentTimeMillis();
        defer = a;
        compelDefer = t;
    }

    public static void closeCue() {
        isColorCue = false;
        if ((cueIndex = (byte)(cueIndex + 1)) >= cueStrs.size() / 2) {
            isCue = false;
            cueIndex = 0;
            cueStrs.removeAllElements();
        }
        if (cueksox != null) {
            cueksox.setWait(true);
            cueksox = null;
        }
    }

    public static void initSelectCue(String str, int id) {
        selectId = (byte)id;
        selectStr = str;
        int w = fontWidth * str.length();
        selectNum = (short)((w / 170 + (w % 170 == 0 ? 0 : 1)) * (fontHeight + 1));
        isSelectCue = true;
    }

    public static void closeSelectCue() {
        isSelectCue = false;
        selectId = 0;
        selectStr = null;
    }

    public static void drawSelectCue(Graphics g) {
        if (!isSelectCue) {
            return;
        }
        int h = selectNum + 10 + fontHeight + 4;
        BasicCanvas.drawCueSkin(cueX, cueY, cueWidth, h);
        KUtils.drawText(selectStr, screenWidth / 2, cueY + 5, 170, 17, 0xFFFFFF);
        Resource.addString("\u786e\u5b9a", cueX + 5, cueY + h - 3, 36, 0xFFFFFF, 2000);
        Resource.addString("\u53d6\u6d88", cueX + cueWidth - 5, cueY + h - 3, 40, 0xFFFFFF, 2000);
    }

    public void setEffect(int type) {
        this.open = type % 2 == 0;
        this.isLeft = type < 2;
        isDrawEffect = true;
        count = this.open && this.isLeft || !this.open && !this.isLeft ? (int)screenWidth : 0;
    }

    public void drawEffect(Graphics g) {
        if (isDrawEffect) {
            if (this.open && this.isLeft || !this.open && !this.isLeft) {
                if ((count = Math.max(0, count - this.effectSpeed)) <= 0) {
                    this.receiveMessage(1501, 0, 0);
                }
            } else if ((count = Math.min(count + this.effectSpeed, screenWidth)) >= screenWidth) {
                this.receiveMessage(1501, 0, 0);
            }
            g.setColor(0);
            if (this.isLeft) {
                g.fillRect(0, 0, count, (int)screenHeight);
                g.fillRect(count + 5, 0, 7, (int)screenHeight);
                g.fillRect(count + 15, 0, 3, (int)screenHeight);
            } else {
                g.fillRect(count, 0, (int)screenWidth, (int)screenHeight);
                g.fillRect(count - 10, 0, 7, (int)screenHeight);
                g.fillRect(count - 15, 0, 3, (int)screenHeight);
            }
        }
    }

    public void addImage(int imageApp, int time) {
        logostate = 1;
        image = (short)imageApp;
        imageTime = (short)time;
        this.isLogo = true;
    }

    public void addKSpriteX(KSpriteX obj) {
        sprite = obj;
        logostate = (byte)2;
        this.isLogo = true;
    }

    public void toSMusic() {
        logostate = (byte)3;
        this.isLogo = true;
    }

    public void setLogoColor(int r, int g, int b) {
        this.logoBgColor = r << 16 | g << 8 | b;
    }

    public void clearLogo() {
        this.isLogo = false;
        Resource.removeAllImage();
        sprite = null;
    }

    public void logoLogic() {
        boolean isEnd = false;
        if (logostate == 3) {
            if (BasicCanvas.hitKey(262144)) {
                volume = 0;
                isEnd = true;
            } else if (BasicCanvas.hitKey(524288)) {
                volume = (byte)50;
                isEnd = true;
            }
        } else if (logostate == 1) {
            if ((imageTime = (short)(imageTime - 1)) < 0) {
                isEnd = true;
            }
        } else if (logostate == 2) {
            if (!sprite.ActionEnd()) {
                sprite.update();
            } else {
                isEnd = true;
            }
        }
        if (isEnd) {
            this.receiveMessage(logoID, 0, 0);
        }
    }

    public void drawLogo(Graphics g) {
        Resource.addRect((byte)1, 0, 0, screenWidth, screenHeight, true, 0, this.logoBgColor, 2000);
        if (logostate == 1) {
            int h = Math.min(screenHeight / 2 - Resource.getImageHeight(60), 40);
            h = Math.max(h, 0);
            Resource.addImage(60, screenWidth / 2, screenHeight / 2 - h, 33);
            Resource.addImage(image, screenWidth / 2 - 20, screenHeight / 2 - 20, 0);
        } else if (logostate == 2) {
            sprite.paint(screenWidth >> 1, (screenHeight >> 1) + 25, 2000);
        } else if (logostate == 3) {
            int h = Math.min(screenHeight / 2 - Resource.getImageHeight(60), 40);
            h = Math.max(h, 0);
            Resource.addImage(60, screenWidth / 2, screenHeight / 2 - h, 33);
            Resource.addImage(image, screenWidth / 2 - 20, screenHeight / 2 - 20, 0);
            Resource.addString("\u662f\u5426\u5f00\u542f\u97f3\u4e50", screenWidth / 2, screenHeight * 3 / 4, 33, 0xFFFFFF, 2000);
            Resource.addString("\u5426", 5, screenHeight - 5, 36, 0xFFFFFF, 2000);
            Resource.addString("\u662f", screenWidth - 5, screenHeight - 5, 40, 0xFFFFFF, 2000);
        }
    }

    public void startGame() {
    }

    public void stopGame() {
        if (MenuDraw.noteKsox == null && !BeginMidlet.isPause) {
            BeginMidlet.isPause = true;
            cueksox = null;
            cueIndex = 0;
            cueStrs.removeAllElements();
            pressKeyInfo = 0;
            BasicCanvas.initCue("\u6682\u505c", 0, 5);
            BasicCanvas.stopMusic(false);
            GameMainDraw.beginVigor = false;
        }
    }

    public void showNotify() {
        this.startGame();
    }

    public void hideNotify() {
        this.stopGame();
    }

    static {
        fontStyle = Font.getFont((int)0, (int)0, (int)8);
        fontHeight = (byte)fontStyle.getHeight();
        fontWidth = (byte)fontStyle.stringWidth("\u5bbd");
        showDebug = true;
        startLine = 0;
        debugV = new Vector();
        musicName = "";
        isPlay = false;
        cueStrs = new Vector();
        cueWidth = (short)176;
        cueY = 0;
        cueX = 0;
        isDrawEffect = true;
    }
}

