/*
 * Decompiled with CFR 0.152.
 */
package KScript;

import KScript.KVMX;
import basic.BasicCanvas;
import basic.KResPackage;
import basic.KUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;

public class KScriptObjectX {
    public static final byte MOV = 0;
    public static final byte ADD = 1;
    public static final byte SUB = 2;
    public static final byte MUL = 3;
    public static final byte DIV = 4;
    public static final byte MOD = 5;
    public static final byte EXP = 6;
    public static final byte NEG = 7;
    public static final byte INC = 8;
    public static final byte DEC = 9;
    public static final byte AND = 10;
    public static final byte OR = 11;
    public static final byte XOR = 12;
    public static final byte NOT = 13;
    public static final byte SHL = 14;
    public static final byte SHR = 15;
    public static final byte CONCAT = 16;
    public static final byte GETCHAR = 17;
    public static final byte SETCHAR = 18;
    public static final byte JMP = 19;
    public static final byte JE = 20;
    public static final byte JNE = 21;
    public static final byte JG = 22;
    public static final byte JL = 23;
    public static final byte JGE = 24;
    public static final byte JLE = 25;
    public static final byte PUSH = 26;
    public static final byte POP = 27;
    public static final byte CALL = 28;
    public static final byte RET = 29;
    public static final byte CALLHOST = 30;
    public static final byte PAUSE = 31;
    public static final byte EXIT = 32;
    public static final byte CALLEXPORT = 38;
    public static final byte OP_INT = 1;
    public static final byte OP_F = 2;
    public static final byte OP_STRING = 3;
    public static final byte OP_FUNC_INDENT = 8;
    public static final byte OP_FUNC_ARRAY_INDENT = 9;
    public static final byte OP_IMPORT_NOT_ARRAY = 10;
    public static final byte OP_IMPORT_ARRAY_INDENT = 11;
    public static final byte OP_FUNC_METHODS = 12;
    public static final byte OP_EXPORT_METHODS = 13;
    public static final byte OP_T0 = 15;
    public static final byte OP_T1 = 16;
    public static final byte OP_RETVAL = 17;
    public static final byte OP_HOST_API = 18;
    public static final byte OP_LABEL = 19;
    public static final byte OP_PARAM = 20;
    public static final byte VAR_INT = 0;
    public static final byte VAR_F = 1;
    public static final byte VAR_STRING = 2;
    private KSVariable varFirst = new KSVariable();
    private KSVariable varSecond = new KSVariable();
    private OP opFirst = new OP();
    private OP opSecond = new OP();
    private OP opThird = new OP();
    private boolean isNotWait;
    private boolean isReturn;
    private byte stackSize = (byte)50;
    public static final byte STATE_PAUSE = 1;
    public static final byte STATE_RUN = 2;
    public static final byte STATE_STOP = 3;
    public byte ownState;
    public int runTime;
    public long pauseTimeCount;
    public int pauseTime;
    public long timeCount;
    public byte objIndex;
    public KSVariable[] stackArray;
    public int stackPoint;
    public int currentMethodsIndex;
    public int currentCommandLine;
    public int currentCommandLength;
    public int currentTotalMethods;
    public KSVariable g_T0 = new KSVariable();
    public KSVariable g_T1 = new KSVariable();
    public KSVariable g_RetVal = new KSVariable();
    public KSMethods methodsNow;
    public byte[] codeArray;
    public int codeBeginIndex;
    public Vector stackVector = new Vector();
    public String scriptName;
    public KSMethods[] methodsArray;
    public String[] stringList;

    public KScriptObjectX() {
        this.init();
    }

    public void setWait(boolean b) {
        this.isNotWait = b;
    }

    public void runScript() {
        switch (this.ownState) {
            case 1: {
                this.runPause();
                break;
            }
            case 2: {
                this.isReturn = false;
                while (this.isNotWait && this.ownState == 2) {
                    this.runCommand();
                    if (!this.isReturn) continue;
                    return;
                }
                break;
            }
        }
    }

    public void runPause() {
        if (this.pauseTime < 100) {
            --this.pauseTime;
            if (this.pauseTime == 0) {
                this.ownState = (byte)2;
            }
        } else if (System.currentTimeMillis() - this.pauseTimeCount > (long)this.pauseTime) {
            this.ownState = (byte)2;
        }
    }

    public void toPauseState(int timeApp) {
        this.ownState = 1;
        this.pauseTimeCount = System.currentTimeMillis();
        this.pauseTime = timeApp;
    }

    public void runCommand() {
        if (this.currentCommandLine < this.currentCommandLength) {
            this.runCommand(this.currentCommandLine);
            ++this.currentCommandLine;
        } else {
            this.ownState = (byte)3;
        }
    }

    public void runCommand(int index) {
        this.codeArray = this.methodsNow.codeArray[index];
        this.codeBeginIndex = 0;
        byte commandId = this.readByte();
        this.println(commandId);
        switch (commandId) {
            case 0: {
                this.println("MOV");
                this.writeOpFirst();
                this.writeOpSecond();
                this.createVarSecond();
                this.moveVarSecondToVarFirst();
                break;
            }
            case 1: {
                this.println("ADD");
                this.writeOpFirst();
                this.writeOpSecond();
                this.createVarFirst();
                this.createVarSecond();
                if (this.varFirst.ownType == 2) {
                    this.varSecond.ownString = this.returnString(this.varFirst) + this.returnString(this.varSecond);
                } else if (this.varSecond.ownType == 2) {
                    this.varSecond.ownString = this.returnString(this.varFirst) + this.returnString(this.varSecond);
                } else {
                    this.varSecond.ownInt += this.varFirst.ownInt;
                }
                this.moveVarSecondToVarFirst();
                break;
            }
            case 2: {
                this.println("SUB");
                this.writeOpFirst();
                this.writeOpSecond();
                this.createVarFirst();
                this.createVarSecond();
                this.varSecond.ownInt = this.varFirst.ownInt - this.varSecond.ownInt;
                this.moveVarSecondToVarFirst();
                break;
            }
            case 3: {
                this.println("MUL");
                this.writeOpFirst();
                this.writeOpSecond();
                this.createVarFirst();
                this.createVarSecond();
                this.varSecond.ownInt *= this.varFirst.ownInt;
                this.moveVarSecondToVarFirst();
                break;
            }
            case 4: {
                this.println("DIV");
                this.writeOpFirst();
                this.writeOpSecond();
                this.createVarFirst();
                this.createVarSecond();
                this.varSecond.ownInt = this.varFirst.ownInt / this.varSecond.ownInt;
                this.moveVarSecondToVarFirst();
                break;
            }
            case 5: {
                this.println("MOD");
                this.writeOpFirst();
                this.writeOpSecond();
                this.createVarFirst();
                this.createVarSecond();
                this.varSecond.ownInt = this.varFirst.ownInt % this.varSecond.ownInt;
                this.moveVarSecondToVarFirst();
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.println("NEG");
                this.writeOpFirst();
                this.opSecond = this.opFirst;
                this.createVarSecond();
                this.opSecond = new OP();
                this.varSecond.ownInt ^= 0xFFFFFFFF;
                this.moveVarSecondToVarFirst();
                break;
            }
            case 8: {
                this.println("INC");
                this.writeOpFirst();
                this.opSecond = this.opFirst;
                this.createVarSecond();
                this.opSecond = new OP();
                ++this.varSecond.ownInt;
                this.moveVarSecondToVarFirst();
                break;
            }
            case 9: {
                this.println("DEC");
                this.writeOpFirst();
                this.opSecond = this.opFirst;
                this.createVarSecond();
                this.opSecond = new OP();
                --this.varSecond.ownInt;
                this.moveVarSecondToVarFirst();
                break;
            }
            case 10: {
                this.println("AND");
                this.writeOpFirst();
                this.writeOpSecond();
                this.createVarFirst();
                this.createVarSecond();
                this.varSecond.ownInt = this.varFirst.ownInt & this.varSecond.ownInt;
                this.moveVarSecondToVarFirst();
                break;
            }
            case 11: {
                this.println("OR");
                this.writeOpFirst();
                this.writeOpSecond();
                this.createVarFirst();
                this.createVarSecond();
                this.varSecond.ownInt = this.varFirst.ownInt | this.varSecond.ownInt;
                this.moveVarSecondToVarFirst();
                break;
            }
            case 12: {
                this.println("XOR");
                this.writeOpFirst();
                this.writeOpSecond();
                this.createVarFirst();
                this.createVarSecond();
                this.varSecond.ownInt = this.varFirst.ownInt ^ this.varSecond.ownInt;
                this.moveVarSecondToVarFirst();
                break;
            }
            case 13: {
                this.println("NOT");
                this.writeOpFirst();
                this.createVarFirst();
                this.varFirst.ownInt ^= 0xFFFFFFFF;
                break;
            }
            case 14: {
                this.println("SHL");
                this.writeOpFirst();
                this.writeOpSecond();
                this.createVarFirst();
                this.createVarSecond();
                this.varSecond.ownInt = this.varFirst.ownInt << this.varSecond.ownInt;
                this.moveVarSecondToVarFirst();
                break;
            }
            case 15: {
                this.println("SHR");
                this.writeOpFirst();
                this.writeOpSecond();
                this.createVarFirst();
                this.createVarSecond();
                this.varSecond.ownInt = this.varFirst.ownInt >> this.varSecond.ownInt;
                this.moveVarSecondToVarFirst();
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                this.println("JMP");
                this.writeOpFirst();
                this.createVarFirst();
                this.jmpTo(this.varFirst.ownInt);
                --this.currentCommandLine;
                break;
            }
            case 20: {
                this.println("JE");
                this.writeOpFirst();
                this.writeOpSecond();
                this.writeOpThird();
                this.createVarFirst();
                this.createVarSecond();
                if (this.varFirst.ownInt != this.varSecond.ownInt) break;
                this.jmpTo(this.opThird.opLabel);
                --this.currentCommandLine;
                break;
            }
            case 21: {
                this.println("JNE");
                this.writeOpFirst();
                this.writeOpSecond();
                this.writeOpThird();
                this.createVarFirst();
                this.createVarSecond();
                if (this.varFirst.ownInt == this.varSecond.ownInt) break;
                this.jmpTo(this.opThird.opLabel);
                --this.currentCommandLine;
                break;
            }
            case 22: {
                this.println("JG");
                this.writeOpFirst();
                this.writeOpSecond();
                this.writeOpThird();
                this.createVarFirst();
                this.createVarSecond();
                if (this.varFirst.ownInt <= this.varSecond.ownInt) break;
                this.jmpTo(this.opThird.opLabel);
                --this.currentCommandLine;
                break;
            }
            case 23: {
                this.println("JL");
                this.writeOpFirst();
                this.writeOpSecond();
                this.writeOpThird();
                this.createVarFirst();
                this.createVarSecond();
                if (this.varFirst.ownInt >= this.varSecond.ownInt) break;
                this.jmpTo(this.opThird.opLabel);
                --this.currentCommandLine;
                break;
            }
            case 24: {
                this.println("JGE");
                this.writeOpFirst();
                this.writeOpSecond();
                this.writeOpThird();
                this.createVarFirst();
                this.createVarSecond();
                if (this.varFirst.ownInt < this.varSecond.ownInt) break;
                this.jmpTo(this.opThird.opLabel);
                --this.currentCommandLine;
                break;
            }
            case 25: {
                this.println("JLE");
                this.writeOpFirst();
                this.writeOpSecond();
                this.writeOpThird();
                this.createVarFirst();
                this.createVarSecond();
                if (this.varFirst.ownInt > this.varSecond.ownInt) break;
                this.jmpTo(this.opThird.opLabel);
                --this.currentCommandLine;
                break;
            }
            case 26: {
                this.println("Push");
                this.writeOpFirst();
                this.createVarFirst();
                this.println("------   " + this.varFirst.ownType);
                this.println("------   " + this.varFirst.ownInt);
                this.println("------   " + this.varFirst.ownF);
                this.println("------   " + this.varFirst.ownString);
                this.pushStack(this.varFirst);
                break;
            }
            case 27: {
                this.println("POP");
                this.writeOpFirst();
                this.varSecond = this.popStack();
                this.moveVarSecondToVarFirst();
                break;
            }
            case 28: {
                this.println("CALL");
                this.writeOpFirst();
                this.runMethods(this.opFirst.opFuncMethods);
                --this.currentCommandLine;
                break;
            }
            case 29: {
                this.println("RET");
                this.toRet();
                --this.currentCommandLine;
                break;
            }
            case 30: {
                this.println("CallHost--------------------");
                this.writeOpFirst();
                this.println("----    " + this.opFirst.ownType);
                this.println("----    " + this.opFirst.opHostApi);
                this.println("----    " + this.varSecond.ownType);
                this.println("----    " + this.varSecond.ownInt);
                this.println("----    " + this.varSecond.ownF);
                this.println("----    " + this.varSecond.ownString);
                int idx = this.opFirst.opHostApi.indexOf("_");
                if (idx == -1) {
                    System.out.println("-------   \u7f3a\u5c11\u524d\u7f00");
                    break;
                }
                String cls = this.opFirst.opHostApi.substring(0, idx);
                String met = this.opFirst.opHostApi.substring(idx + 1, this.opFirst.opHostApi.length());
                KVMX.getInstance().callAPI(this, cls, met);
                break;
            }
            case 31: {
                this.println("PAUSE");
                this.writeOpFirst();
                this.createVarFirst();
                this.toPauseState(this.varFirst.ownInt);
                break;
            }
            case 32: {
                break;
            }
            case 38: {
                this.println("CallExport");
                System.out.println("------asdjsaldjskaldj   CallExport");
                break;
            }
            default: {
                BasicCanvas.Debug("\u6ca1\u6709\u6b64\u547d\u4ee4");
            }
        }
    }

    public byte readByte() {
        byte ch = this.codeArray[this.codeBeginIndex];
        ++this.codeBeginIndex;
        return ch;
    }

    public int readInt() {
        byte ch1 = this.codeArray[this.codeBeginIndex];
        byte ch2 = this.codeArray[this.codeBeginIndex + 1];
        this.codeBeginIndex += 2;
        return ((ch1 & 0xFF) << 8) + ((ch2 & 0xFF) << 0);
    }

    public void setStackSize(int size) {
        if (size < 1) {
            return;
        }
        this.stackSize = (byte)size;
    }

    public void setRunTime(int timeApp) {
        if (timeApp < 1) {
            return;
        }
        this.runTime = timeApp;
    }

    public void init() {
        this.stackArray = new KSVariable[this.stackSize];
        for (int i = 0; i < this.stackSize; ++i) {
            this.stackArray[i] = new KSVariable();
        }
        this.ownState = (byte)3;
        this.runTime = 1;
        this.currentTotalMethods = 0;
        this.isNotWait = true;
    }

    public void createVarSecond() {
        switch (this.opSecond.ownType) {
            case 1: {
                this.varSecond.ownType = 0;
                this.varSecond.ownInt = this.opSecond.opInt;
                break;
            }
            case 2: {
                this.varSecond.ownType = 1;
                this.varSecond.ownF = this.opSecond.opF;
                break;
            }
            case 3: {
                this.varSecond.ownType = (byte)2;
                this.varSecond.ownString = this.opSecond.opString;
                break;
            }
            case 8: 
            case 20: {
                this.varSecond.ownType = this.stackArray[this.stackPoint - this.opSecond.opFuncIndent].ownType;
                this.varSecond.ownInt = this.stackArray[this.stackPoint - this.opSecond.opFuncIndent].ownInt;
                this.varSecond.ownF = this.stackArray[this.stackPoint - this.opSecond.opFuncIndent].ownF;
                this.varSecond.ownString = this.stackArray[this.stackPoint - this.opSecond.opFuncIndent].ownString;
                break;
            }
            case 9: {
                this.varSecond.ownType = this.stackArray[this.stackPoint - this.opSecond.opFuncArrayIndent].ownType;
                this.varSecond.ownInt = this.stackArray[this.stackPoint - this.opSecond.opFuncArrayIndent].ownInt;
                this.varSecond.ownF = this.stackArray[this.stackPoint - this.opSecond.opFuncArrayIndent].ownF;
                this.varSecond.ownString = this.stackArray[this.stackPoint - this.opSecond.opFuncArrayIndent].ownString;
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 15: {
                this.varSecond.ownType = this.g_T0.ownType;
                this.varSecond.ownInt = this.g_T0.ownInt;
                this.varSecond.ownF = this.g_T0.ownF;
                this.varSecond.ownString = this.g_T0.ownString;
                break;
            }
            case 16: {
                this.varSecond.ownType = this.g_T1.ownType;
                this.varSecond.ownInt = this.g_T1.ownInt;
                this.varSecond.ownF = this.g_T1.ownF;
                this.varSecond.ownString = this.g_T1.ownString;
                break;
            }
            case 17: {
                this.varSecond.ownType = this.g_RetVal.ownType;
                this.varSecond.ownInt = this.g_RetVal.ownInt;
                this.varSecond.ownF = this.g_RetVal.ownF;
                this.varSecond.ownString = this.g_RetVal.ownString;
            }
        }
    }

    public void createVarFirst() {
        switch (this.opFirst.ownType) {
            case 1: {
                this.varFirst.ownType = 0;
                this.varFirst.ownInt = this.opFirst.opInt;
                break;
            }
            case 2: {
                this.varFirst.ownType = 1;
                this.varFirst.ownF = this.opFirst.opF;
                break;
            }
            case 3: {
                this.varFirst.ownType = (byte)2;
                this.varFirst.ownString = this.opFirst.opString;
                break;
            }
            case 8: 
            case 20: {
                this.varFirst.ownType = this.stackArray[this.stackPoint - this.opFirst.opFuncIndent].ownType;
                this.varFirst.ownInt = this.stackArray[this.stackPoint - this.opFirst.opFuncIndent].ownInt;
                this.varFirst.ownF = this.stackArray[this.stackPoint - this.opFirst.opFuncIndent].ownF;
                this.varFirst.ownString = this.stackArray[this.stackPoint - this.opFirst.opFuncIndent].ownString;
                break;
            }
            case 9: {
                this.varFirst.ownType = this.stackArray[this.stackPoint - this.opFirst.opFuncArrayIndent].ownType;
                this.varFirst.ownInt = this.stackArray[this.stackPoint - this.opFirst.opFuncArrayIndent].ownInt;
                this.varFirst.ownF = this.stackArray[this.stackPoint - this.opFirst.opFuncArrayIndent].ownF;
                this.varFirst.ownString = this.stackArray[this.stackPoint - this.opFirst.opFuncArrayIndent].ownString;
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 15: {
                this.varFirst.ownType = this.g_T0.ownType;
                this.varFirst.ownInt = this.g_T0.ownInt;
                this.varFirst.ownF = this.g_T0.ownF;
                this.varFirst.ownString = this.g_T0.ownString;
                break;
            }
            case 16: {
                this.varFirst.ownType = this.g_T1.ownType;
                this.varFirst.ownInt = this.g_T1.ownInt;
                this.varFirst.ownF = this.g_T1.ownF;
                this.varFirst.ownString = this.g_T1.ownString;
                break;
            }
            case 17: {
                this.varFirst.ownType = this.g_RetVal.ownType;
                this.varFirst.ownInt = this.g_RetVal.ownInt;
                this.varFirst.ownF = this.g_RetVal.ownF;
                this.varFirst.ownString = this.g_RetVal.ownString;
                break;
            }
            case 19: {
                this.varFirst.ownType = 0;
                this.varFirst.ownInt = this.opFirst.opLabel;
                break;
            }
            default: {
                BasicCanvas.Debug("createVarFirst()" + this.opFirst.ownType);
            }
        }
    }

    public void moveVarSecondToVarFirst() {
        switch (this.opFirst.ownType) {
            case 8: 
            case 20: {
                this.stackArray[this.stackPoint - this.opFirst.opFuncIndent].ownType = this.varSecond.ownType;
                this.stackArray[this.stackPoint - this.opFirst.opFuncIndent].ownInt = this.varSecond.ownInt;
                this.stackArray[this.stackPoint - this.opFirst.opFuncIndent].ownF = this.varSecond.ownF;
                this.stackArray[this.stackPoint - this.opFirst.opFuncIndent].ownString = this.varSecond.ownString;
                break;
            }
            case 9: {
                this.stackArray[this.stackPoint - this.opFirst.opFuncArrayIndent].ownType = this.varSecond.ownType;
                this.stackArray[this.stackPoint - this.opFirst.opFuncArrayIndent].ownInt = this.varSecond.ownInt;
                this.stackArray[this.stackPoint - this.opFirst.opFuncArrayIndent].ownF = this.varSecond.ownF;
                this.stackArray[this.stackPoint - this.opFirst.opFuncArrayIndent].ownString = this.varSecond.ownString;
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 15: {
                this.g_T0.ownType = this.varSecond.ownType;
                this.g_T0.ownInt = this.varSecond.ownInt;
                this.g_T0.ownF = this.varSecond.ownF;
                this.g_T0.ownString = this.varSecond.ownString;
                break;
            }
            case 16: {
                this.g_T1.ownType = this.varSecond.ownType;
                this.g_T1.ownInt = this.varSecond.ownInt;
                this.g_T1.ownF = this.varSecond.ownF;
                this.g_T1.ownString = this.varSecond.ownString;
                break;
            }
            case 17: {
                this.g_RetVal.ownType = this.varSecond.ownType;
                this.g_RetVal.ownInt = this.varSecond.ownInt;
                this.g_RetVal.ownF = this.varSecond.ownF;
                this.g_RetVal.ownString = this.varSecond.ownString;
                break;
            }
            default: {
                BasicCanvas.Debug("moveVarSecondToVarFirst()" + this.opFirst.ownType);
            }
        }
    }

    public void writeOpFirst() {
        this.opFirst.ownType = this.readByte();
        this.println("opFirst.ownType :" + this.opFirst.ownType);
        switch (this.opFirst.ownType) {
            case 8: 
            case 20: {
                this.opFirst.opFuncIndent = this.readInt();
                break;
            }
            case 9: {
                this.opFirst.opFuncArrayIndent = this.readInt();
                this.opFirst.opFuncArrayIndent += this.getNextInt();
                break;
            }
            case 10: {
                System.out.println("------asdjsaldjskaldj   CallExport");
                break;
            }
            case 11: {
                break;
            }
            case 19: {
                this.opFirst.opLabel = this.readInt();
                break;
            }
            case 18: {
                int index = this.readInt();
                this.opFirst.opHostApi = this.stringList[index];
                break;
            }
            case 1: {
                this.opFirst.opInt = this.readInt();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int index = this.readInt();
                this.opFirst.opString = this.stringList[index];
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 12: {
                this.opFirst.opFuncMethods = this.readInt();
                break;
            }
            default: {
                BasicCanvas.Debug("OPFIRST TYPE UNKONW");
            }
        }
    }

    public void writeOpSecond() {
        this.opSecond.ownType = this.readByte();
        this.println("opSecond.ownType :" + this.opSecond.ownType);
        switch (this.opSecond.ownType) {
            case 1: {
                this.opSecond.opInt = this.readInt();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int index = this.readInt();
                this.opSecond.opString = this.stringList[index];
                break;
            }
            case 8: 
            case 20: {
                this.opSecond.opFuncIndent = this.readInt();
                break;
            }
            case 9: {
                this.opSecond.opFuncArrayIndent = this.readInt();
                this.opSecond.opFuncArrayIndent += this.getNextInt();
                break;
            }
            case 12: {
                this.opSecond.opFuncMethods = this.readInt();
                break;
            }
            case 10: {
                System.out.println("------asdjsaldjskaldj   CallExport");
                break;
            }
            case 11: {
                break;
            }
            case 19: {
                this.opSecond.opLabel = this.readInt();
                break;
            }
            case 18: {
                int index = this.readInt();
                this.opSecond.opHostApi = this.stringList[index];
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            default: {
                BasicCanvas.Debug("OPSECOND TYPE UNKONW");
            }
        }
    }

    public void writeOpThird() {
        this.opThird.ownType = this.readByte();
        switch (this.opThird.ownType) {
            case 19: {
                this.opThird.opLabel = this.readInt();
                break;
            }
            default: {
                BasicCanvas.Debug("OPTHIRD TYPE UNKONW");
            }
        }
    }

    public int getNextInt() {
        byte nextByte = this.readByte();
        switch (nextByte) {
            case 15: {
                return this.g_T0.ownInt;
            }
            case 16: {
                return this.g_T1.ownInt;
            }
            case 17: {
                return this.g_RetVal.ownInt;
            }
        }
        int nextIndex = this.readInt();
        int nextInt = this.getNextInt(nextByte, nextIndex);
        return nextInt;
    }

    public int getNextInt(int type, int index) {
        if (type == 1) {
            return index;
        }
        if (type == 8) {
            return this.stackArray[this.stackPoint - index].ownInt;
        }
        return -1;
    }

    private void runMethods(int index) {
        if (this.currentTotalMethods > 0) {
            this.stackPoint += 3;
            this.stackArray[this.stackPoint - 1].ownInt = this.currentMethodsIndex;
            this.stackArray[this.stackPoint - 2].ownInt = this.currentCommandLine;
        }
        this.methodsNow = this.methodsArray[index];
        this.stackPoint += this.methodsNow.stackSize;
        ++this.currentTotalMethods;
        this.currentMethodsIndex = index;
        this.currentCommandLine = 0;
        this.currentCommandLength = this.methodsArray[index].codeArray.length;
        this.ownState = (byte)2;
    }

    public void runMethods(String obj) {
        int methodsId = this.getMethodsIndex(obj);
        if (methodsId == -1) {
            BasicCanvas.Debug("\u811a\u672c\u6ca1\u6709\u8fd9\u4e2a\u65b9\u6cd5" + obj);
            return;
        }
        this.runMethods(methodsId);
    }

    public void toRet() {
        --this.currentTotalMethods;
        if (this.currentTotalMethods < 1) {
            this.ownState = (byte)3;
            this.currentCommandLine = 0;
            this.currentCommandLength = 0;
            this.stackPoint = 3;
            return;
        }
        this.stackPoint -= this.methodsNow.stackSize;
        int methodsIndex = this.stackArray[this.stackPoint - 1].ownInt;
        int lineIndex = this.stackArray[this.stackPoint - 2].ownInt;
        this.stackPoint -= 3;
        this.methodsNow = this.methodsArray[methodsIndex];
        this.currentMethodsIndex = methodsIndex;
        this.currentCommandLine = lineIndex + 1;
        this.currentCommandLength = this.methodsArray[methodsIndex].codeArray.length;
        this.ownState = (byte)2;
    }

    public int getMethodsIndex(String obj) {
        int length = this.methodsArray.length;
        for (int i = 0; i < length; ++i) {
            if (!this.methodsArray[i].ownName.equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public void pushStack(KSVariable obj) {
        KSVariable obj2 = new KSVariable();
        obj2.ownType = obj.ownType;
        obj2.ownInt = obj.ownInt;
        obj2.ownF = obj.ownF;
        obj2.ownString = obj.ownString;
        this.stackVector.addElement(obj2);
    }

    public KSVariable popStack() {
        int index = this.stackVector.size() - 1;
        KSVariable obj = (KSVariable)this.stackVector.elementAt(index);
        this.stackVector.removeElementAt(index);
        KSVariable newObj = new KSVariable();
        newObj.ownType = obj.ownType;
        newObj.ownInt = obj.ownInt;
        newObj.ownF = obj.ownF;
        newObj.ownString = obj.ownString;
        return newObj;
    }

    public int getInt() {
        this.varSecond = this.popStack();
        return this.varSecond.ownInt;
    }

    public boolean getBoolean() {
        this.varSecond = this.popStack();
        return this.varSecond.ownInt != 0;
    }

    public String getString() {
        this.varSecond = this.popStack();
        if (this.varSecond.ownType == 0) {
            this.varSecond.ownString = this.varSecond.ownInt + "";
        } else if (this.varSecond.ownType == 1) {
            this.varSecond.ownString = this.varSecond.ownF + "";
        }
        return this.varSecond.ownString;
    }

    public void jmpTo(int lineNum) {
        this.currentCommandLine = lineNum;
    }

    public void setRetVal(int varInt) {
        this.g_RetVal.ownType = 0;
        this.g_RetVal.ownInt = varInt;
    }

    public void setRetVal(boolean b) {
        this.g_RetVal.ownType = 0;
        this.g_RetVal.ownInt = b ? 1 : 0;
    }

    public void setRetVal(String varString) {
        this.g_RetVal.ownType = (byte)2;
        this.g_RetVal.ownString = varString;
    }

    public void loadScript(String obj) {
        if (KUtils.loadSprictRc) {
            this.loadScriptFromRc(obj);
            return;
        }
        System.out.println("[script] " + obj);
        this.scriptName = obj;
        try {
            InputStream fileIn = this.getClass().getResourceAsStream(obj);
            DataInputStream dis = new DataInputStream(fileIn);
            if (dis == null) {
                BasicCanvas.Debug("\u811a\u672c" + obj + "\u6ca1\u6709\u627e\u5230");
                return;
            }
            this.loadInfo(dis);
            fileIn.close();
            dis = null;
            fileIn = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadInfo(DataInputStream dis) {
        try {
            int i;
            int length = dis.readInt();
            this.println("stringListlength:" + length);
            this.stringList = new String[length];
            for (i = 0; i < length; ++i) {
                this.stringList[i] = dis.readUTF();
                this.println("stringList      " + this.stringList[i]);
            }
            length = dis.readInt();
            this.println("methodsArray length:" + length);
            this.methodsArray = new KSMethods[length];
            for (i = 0; i < length; ++i) {
                this.methodsArray[i] = new KSMethods();
                this.methodsArray[i].ownName = dis.readUTF();
                this.methodsArray[i].stackSize = dis.readInt();
                this.println("methodsArray:ownName " + this.methodsArray[i].ownName);
                this.println("methodsArray:stackSize " + this.methodsArray[i].stackSize);
                int jLength = dis.readInt();
                this.methodsArray[i].codeArray = new byte[jLength][];
                for (int k = 0; k < jLength; ++k) {
                    int kLength = dis.readByte();
                    this.methodsArray[i].codeArray[k] = new byte[kLength];
                    for (int m = 0; m < kLength; ++m) {
                        this.methodsArray[i].codeArray[k][m] = dis.readByte();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadScriptFromRc(String obj) {
        this.scriptName = obj;
        try {
            ByteArrayInputStream fileIn = null;
            try {
                int index = obj.indexOf(47, 1);
                String rcPackName = null;
                if (index == -1) {
                    rcPackName = "/ss.rc";
                } else {
                    String[] rcArray = KUtils.splitString(obj, '/');
                    rcPackName = "/" + rcArray[0] + ".rc";
                }
                KResPackage pack = null;
                try {
                    pack = KResPackage.openPack(rcPackName);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (pack != null) {
                    byte[] res = pack.getFile(obj);
                    fileIn = new ByteArrayInputStream(res);
                    pack.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DataInputStream dis = new DataInputStream(fileIn);
            if (dis == null) {
                System.out.println("\u811a\u672c" + obj + "\u6ca1\u6709\u627e\u5230");
                return;
            }
            this.loadInfo(dis);
            dis = null;
            fileIn = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String returnString(KSVariable ks) {
        String a = "";
        if (ks.ownType == 0) {
            a = a + ks.ownInt;
        } else if (ks.ownType == 1) {
            a = a + ks.ownF;
        } else if (ks.ownType == 2) {
            a = a + ks.ownString;
        }
        ks.ownType = (byte)2;
        ks.ownString = a;
        return a;
    }

    public void println(int s) {
        this.println("" + s);
    }

    public void println(String s) {
    }

    public class OP {
        public byte ownType;
        public int opInt;
        public int opF;
        public String opString;
        public int opFuncIndent;
        public int opFuncArrayIndent;
        public int opFuncMethods;
        public String opHostApi;
        public int opLabel;
    }

    public class KSVariable {
        byte ownType;
        volatile int ownInt;
        volatile int ownF;
        volatile String ownString;
    }

    public class KSMethods {
        String ownName;
        int stackSize;
        byte[][] codeArray;
    }
}

