/*
 * Decompiled with CFR 0.152.
 */
package Actor;

import basic.KSpriteX;
import basic.Resource;
import draw.GameMainDraw;

public class GameObj {
    public static final byte OBJ_TYPE_NPC = 1;
    public static final byte OBJ_TYPE_BOX = 2;
    public static final byte OBJ_TYPE_PALYER = 3;
    public static final byte OBJ_TYPE_PROP = 4;
    public static final byte OBJ_TYPE_ENEMY = 5;
    public static final byte OBJ_TYPE_ELEMENT = 6;
    public static final byte OBJ_TYPE_SKILL = 7;
    public boolean isMapLoad;
    public short siteX;
    public short siteY;
    public short npcW;
    public short npcH;
    public short ownId;
    public byte dir;
    public byte stateNow;
    public boolean isAir = false;
    public short targetX;
    public short targetY;
    public GameMainDraw main;
    public KSpriteX spriteX;
    public short imageIndex = (short)-1;
    public byte ownType;
    public short attack;
    public boolean isMove;
    public boolean isAlive = true;
    public byte speedX = (byte)6;
    public byte speedY = (byte)15;
    public boolean isLayout;
    public short layout = (short)-1;
    private byte nextAction = (byte)-1;
    public byte aliveTime;
    public byte vertical;
    public short count;

    public GameObj(GameMainDraw gameMain) {
        this.main = gameMain;
    }

    public void setSite(int x, int y) {
        this.siteX = (short)x;
        this.siteY = (short)y;
    }

    public void setTarget(int x, int y) {
        this.targetX = (short)x;
        this.targetY = (short)y;
    }

    public void setLayout(int la) {
        this.isLayout = true;
        this.layout = (short)la;
    }

    public int getMapArrayX() {
        return this.siteX / 16;
    }

    public int getMapArrayY() {
        return this.siteY / 16;
    }

    public void setKSpriteX(KSpriteX obj) {
        this.spriteX = obj;
    }

    public void setImageIndex(short index) {
        this.imageIndex = index;
    }

    public int getAction() {
        return this.spriteX.getAction();
    }

    public void setAction(int action) {
        if (action >= this.spriteX.getActionCount()) {
            System.out.println("\u52a8\u4f5c\u8bbe\u7f6e\u9519\u8bef  " + this + " " + action);
            return;
        }
        this.spriteX.setAction(action);
    }

    public void setNextAction(int one, int two) {
        this.setAction(one);
        this.nextAction = (byte)two;
    }

    public void logic() {
        if (this.spriteX != null) {
            this.spriteX.update();
            if (this.nextAction != -1 && this.spriteX.ActionIsOver()) {
                this.spriteX.setAction(this.nextAction);
                this.nextAction = (byte)-1;
            }
        }
    }

    public void paint(int x, int y) {
        if (this.spriteX != null) {
            if (this.isLayout) {
                this.spriteX.paint(x, y + this.vertical, this.layout);
            } else {
                this.spriteX.paint(x, y + this.vertical, y);
            }
        } else if (this.imageIndex > 0) {
            if (this.isLayout) {
                Resource.addImage(this.imageIndex, x, y + this.vertical, 36, 0, this.layout);
            } else {
                Resource.addImage(this.imageIndex, x, y + this.vertical, 36, 0, y);
            }
        }
    }

    public void paint(int x, int y, int layout) {
        if (this.spriteX != null) {
            this.spriteX.paint(x, y, layout);
        }
    }
}

